/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.parsers.PDBFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class SturmMethod {
    private static final Logger logger = Logger.getLogger(SturmMethod.class.getName());
    final int MAXPOW = 32;
    private final double RELERROR;
    private final int MAXIT;
    private final int MAX_ITER_SECANT;
    private final double[][] xyz_o = new double[5][3];
    private double[] roots;

    public SturmMethod() {
        this.RELERROR = 1.0E-15;
        this.MAXIT = 100;
        this.MAX_ITER_SECANT = 20;
    }

    private static boolean modp(Polynomial u, Polynomial v, Polynomial r) {
        int k;
        double[] nr = r.coefficients;
        int end = u.order;
        double[] uc = u.coefficients;
        if (end + 1 >= 0) {
            System.arraycopy(uc, 0, nr, 0, end + 1);
        }
        if (v.coefficients[v.order] < 0.0) {
            for (k = u.order - v.order - 1; k >= 0; k -= 2) {
                r.coefficients[k] = -r.coefficients[k];
            }
            for (k = u.order - v.order; k >= 0; --k) {
                for (j = v.order + k - 1; j >= k; --j) {
                    r.coefficients[j] = -r.coefficients[j] - r.coefficients[v.order + k] * v.coefficients[j - k];
                }
            }
        } else {
            for (k = u.order - v.order; k >= 0; --k) {
                for (j = v.order + k - 1; j >= k; --j) {
                    int n = j;
                    r.coefficients[n] = r.coefficients[n] - r.coefficients[v.order + k] * v.coefficients[j - k];
                }
            }
        }
        for (k = v.order - 1; k >= 0 && FastMath.abs((double)r.coefficients[k]) < 1.0E-18; --k) {
            r.coefficients[k] = 0.0;
        }
        r.order = FastMath.max((int)k, (int)0);
        if (r.order > 0) {
            return true;
        }
        if (r.order == 0) {
            return false;
        }
        return false;
    }

    public double[][] getr_o() {
        return this.xyz_o;
    }

    public int solveSturm(int order, double[] poly_coeffs, double[] roots) {
        int i;
        int i2;
        Polynomial[] sseq = new Polynomial[32];
        int[] atmin = new int[1];
        int[] atmax = new int[1];
        this.roots = roots;
        for (i2 = 0; i2 < 32; ++i2) {
            sseq[i2] = new Polynomial();
        }
        if (order + 1 >= 0) {
            System.arraycopy(poly_coeffs, 0, sseq[0].coefficients, 0, order + 1);
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder string = new StringBuilder();
            for (i = order; i >= 0; --i) {
                string.append(" Coefficients in Sturm solver\n");
                string.append(String.format("%d %f\n", i, sseq[0].coefficients[i]));
            }
            logger.fine(string.toString());
        }
        int np = this.buildSturm(order, sseq);
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder string1 = new StringBuilder();
            string1.append(" Sturm sequence for:\n");
            for (i = order; i >= 0; --i) {
                string1.append(String.format("%f ", sseq[0].coefficients[i]));
                string1.append("\n");
            }
            for (i = 0; i <= np; ++i) {
                for (int j = sseq[i].order; j >= 0; --j) {
                    string1.append(String.format("%f ", sseq[i].coefficients[j]));
                    string1.append("\n");
                }
            }
            logger.fine(string1.toString());
        }
        int nroots = this.numRoots(np, sseq, atmin, atmax);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Number of real roots: %d\n", nroots));
        }
        double min = -1.0;
        int nchanges = this.numChanges(np, sseq, min);
        for (i2 = 0; nchanges != atmin[0] && i2 != 32; ++i2) {
            nchanges = this.numChanges(np, sseq, min *= 10.0);
        }
        if (nchanges != atmin[0]) {
            logger.fine(" Solve: unable to bracket all negative roots\n");
            atmin[0] = nchanges;
        }
        double max = 1.0;
        nchanges = this.numChanges(np, sseq, max);
        for (i2 = 0; nchanges != atmax[0] && i2 != 32; ++i2) {
            nchanges = this.numChanges(np, sseq, max *= 10.0);
        }
        if (nchanges != atmax[0]) {
            logger.fine(" Solve: unable to bracket all positive roots\n");
            atmax[0] = nchanges;
        }
        nroots = atmin[0] - atmax[0];
        this.sturmBisection(np, sseq, min, max, atmin[0], atmax[0], this.roots);
        if (logger.isLoggable(Level.FINE)) {
            if (nroots == 1) {
                logger.fine(String.format("\n One distinct real root at x = %f\n", this.roots[0]));
            } else {
                StringBuilder string2 = new StringBuilder();
                string2.append(String.format("\n %d distinct real roots for x: \n", nroots));
                for (i = 0; i != nroots; ++i) {
                    string2.append(String.format("%f\n", this.roots[i]));
                }
                logger.fine(string2.toString());
            }
        }
        return nroots;
    }

    /*
     * WARNING - void declaration
     */
    public File writePDBBackbone(double[][] r_n, double[][] r_a, double[][] r_c, int stt_res, int end_res, MolecularAssembly molAss, int counter, boolean writeFile) {
        List<Atom> backBoneAtoms;
        Polymer[] newChain = molAss.getChains();
        double[] xyz_n = new double[3];
        double[] xyz_a = new double[3];
        double[] xyz_c = new double[3];
        this.xyz_o[0][0] = 0.0;
        this.xyz_o[0][1] = 0.0;
        this.xyz_o[0][2] = 0.0;
        this.xyz_o[4][0] = 0.0;
        this.xyz_o[4][1] = 0.0;
        this.xyz_o[4][2] = 0.0;
        ArrayList<Atom> OAtoms = new ArrayList<Atom>();
        for (int i = stt_res + 1; i < end_res; ++i) {
            Residue newResidue = newChain[0].getResidue(i);
            backBoneAtoms = newResidue.getBackboneAtoms();
            block23: for (Atom atom : backBoneAtoms) {
                switch (atom.getAtomType().name) {
                    case "C": {
                        xyz_c[0] = r_c[i - stt_res][0];
                        xyz_c[1] = r_c[i - stt_res][1];
                        xyz_c[2] = r_c[i - stt_res][2];
                        atom.moveTo(xyz_c);
                        continue block23;
                    }
                    case "N": {
                        xyz_n[0] = r_n[i - stt_res][0];
                        xyz_n[1] = r_n[i - stt_res][1];
                        xyz_n[2] = r_n[i - stt_res][2];
                        atom.moveTo(xyz_n);
                        continue block23;
                    }
                    case "CA": {
                        xyz_a[0] = r_a[i - stt_res][0];
                        xyz_a[1] = r_a[i - stt_res][1];
                        xyz_a[2] = r_a[i - stt_res][2];
                        atom.moveTo(xyz_a);
                        continue block23;
                    }
                    case "O": {
                        OAtoms.add(atom);
                        continue block23;
                    }
                }
                newResidue.deleteAtom(atom);
            }
            List<Atom> sideChainAtoms = newResidue.getSideChainAtoms();
            for (Atom sideChainAtom : sideChainAtoms) {
                newResidue.deleteAtom(sideChainAtom);
            }
        }
        int oCount = 0;
        for (int i = stt_res + 1; i < end_res; ++i) {
            void var18_25;
            Residue newResidue = newChain[0].getResidue(i);
            backBoneAtoms = newResidue.getBackboneAtoms();
            Atom atom = new Atom("CA");
            Atom N = new Atom("N");
            Atom C = new Atom("C");
            Atom O = (Atom)OAtoms.get(oCount);
            for (Atom backBoneAtom : backBoneAtoms) {
                switch (backBoneAtom.getAtomType().name) {
                    case "C": {
                        C = backBoneAtom;
                        break;
                    }
                    case "N": {
                        N = backBoneAtom;
                        break;
                    }
                    case "CA": {
                        Atom atom2 = backBoneAtom;
                        break;
                    }
                }
            }
            BondedUtils.intxyz(O, C, 1.2255, (Atom)var18_25, 122.4, N, 180.0, 0);
            this.xyz_o[i - stt_res][0] = O.getX();
            this.xyz_o[i - stt_res][1] = O.getY();
            this.xyz_o[i - stt_res][2] = O.getZ();
            ++oCount;
        }
        File file = molAss.getFile();
        Object filename = FilenameUtils.removeExtension((String)file.getAbsolutePath());
        if (!((String)filename).contains("_loop")) {
            filename = (String)filename + "_loop";
        }
        File file2 = new File((String)filename + ".pdb_" + counter);
        PDBFilter modFilter = new PDBFilter(file2, molAss, null, null);
        if (writeFile) {
            modFilter.writeFile(file2, true);
        }
        return file2;
    }

    private double hyperTan(double a, double x) {
        double ax = a * x;
        if (ax > 100.0) {
            return 1.0;
        }
        if (ax < -100.0) {
            return -1.0;
        }
        double exp_x1 = FastMath.exp((double)ax);
        double exp_x2 = FastMath.exp((double)(-ax));
        return (exp_x1 - exp_x2) / (exp_x1 + exp_x2);
    }

    private int buildSturm(int ord, Polynomial[] sseq) {
        int i;
        sseq[0].order = ord;
        sseq[1].order = ord - 1;
        double f = FastMath.abs((double)(sseq[0].coefficients[ord] * (double)ord));
        double[] fp = sseq[1].coefficients;
        double[] fc = Arrays.copyOfRange(sseq[0].coefficients, 1, sseq[0].coefficients.length);
        int j = 0;
        for (i = 1; i <= ord; ++i) {
            fp[j] = fc[j] * (double)i / f;
            ++j;
        }
        for (i = 0; i < sseq[0].coefficients.length - 2 && SturmMethod.modp(sseq[i], sseq[i + 1], sseq[i + 2]); ++i) {
            f = -Math.abs(sseq[i + 2].coefficients[sseq[i + 2].order]);
            j = sseq[i + 2].order;
            while (j >= 0) {
                int n = j--;
                sseq[i + 2].coefficients[n] = sseq[i + 2].coefficients[n] / f;
            }
        }
        sseq[i + 2].coefficients[0] = -sseq[i + 2].coefficients[0];
        return sseq[0].order - sseq[i + 2].order;
    }

    private int numRoots(int np, Polynomial[] sseq, int[] atneg, int[] atpos) {
        double f;
        int i;
        int atposinf = 0;
        int atneginf = 0;
        double lf = sseq[0].coefficients[sseq[0].order];
        for (i = 1; i <= np; ++i) {
            f = sseq[i].coefficients[sseq[i].order];
            if (lf == 0.0 || lf * f < 0.0) {
                ++atposinf;
            }
            lf = f;
        }
        lf = (sseq[0].order & 1) != 0 ? -sseq[0].coefficients[sseq[0].order] : sseq[0].coefficients[sseq[0].order];
        for (i = 1; i <= np; ++i) {
            f = (sseq[i].order & 1) != 0 ? -sseq[i].coefficients[sseq[i].order] : sseq[i].coefficients[sseq[i].order];
            if (lf == 0.0 || lf * f < 0.0) {
                ++atneginf;
            }
            lf = f;
        }
        atneg[0] = atneginf;
        atpos[0] = atposinf;
        return atneginf - atposinf;
    }

    private int numChanges(int np, Polynomial[] sseq, double a) {
        int changes = 0;
        double lf = this.evalPoly(sseq[0].order, sseq[0].coefficients, a);
        for (int i = 1; i <= np; ++i) {
            double f = this.evalPoly(sseq[i].order, sseq[i].coefficients, a);
            if (lf == 0.0 || lf * f < 0.0) {
                ++changes;
            }
            lf = f;
        }
        return changes;
    }

    private void sturmBisection(int np, Polynomial[] sseq, double min, double max, int atmin, int atmax, double[] roots) {
        int its;
        double mid = 0.0;
        int n1 = 0;
        int n2 = 0;
        int nroot = atmin - atmax;
        if (nroot == 1) {
            int its2;
            if (this.modifiedRegulaFalsi(sseq[0].order, sseq[0].coefficients, min, max, roots)) {
                this.fillArray(roots, this.roots);
                return;
            }
            for (its2 = 0; its2 < this.MAXIT; ++its2) {
                mid = (min + max) / 2.0;
                int atmid = this.numChanges(np, sseq, mid);
                if (FastMath.abs((double)mid) > this.RELERROR) {
                    if (FastMath.abs((double)((max - min) / mid)) < this.RELERROR) {
                        roots[0] = mid;
                        this.fillArray(roots, this.roots);
                        return;
                    }
                } else if (FastMath.abs((double)(max - min)) < this.RELERROR) {
                    roots[0] = mid;
                    this.fillArray(roots, this.roots);
                    return;
                }
                if (atmin - atmid == 0) {
                    min = mid;
                    continue;
                }
                max = mid;
            }
            if (its2 == this.MAXIT) {
                logger.info(String.format(" sbisect: overflow min %f max %f diff %f nroot %d n1 %d n2 %d\n", min, max, max - min, nroot, n1, n2));
                roots[0] = mid;
            }
            this.fillArray(roots, this.roots);
            return;
        }
        for (its = 0; its < this.MAXIT; ++its) {
            mid = (min + max) / 2.0;
            int atmid = this.numChanges(np, sseq, mid);
            n1 = atmin - atmid;
            n2 = atmid - atmax;
            if (n1 != 0 && n2 != 0) {
                this.sturmBisection(np, sseq, min, mid, atmin, atmid, roots);
                double[] rootsSection = Arrays.copyOfRange(roots, n1, roots.length);
                this.sturmBisection(np, sseq, mid, max, atmid, atmax, rootsSection);
                this.fillArray(rootsSection, roots);
                break;
            }
            if (n1 == 0) {
                min = mid;
                continue;
            }
            max = mid;
        }
        if (its == this.MAXIT) {
            for (n1 = atmax; n1 < atmin; ++n1) {
                roots[n1 - atmax] = mid;
            }
        }
    }

    private void fillArray(double[] valuesArray, double[] targetArray) {
        int tarLen = targetArray.length;
        int valLen = valuesArray.length;
        if (tarLen >= valLen) {
            int tarIndex = tarLen - valLen;
            int valIndex = 0;
            while (tarIndex < tarLen) {
                targetArray[tarIndex] = valuesArray[valIndex];
                ++tarIndex;
                ++valIndex;
            }
        } else {
            logger.info(" sbisect: length of values array is too long for the target array; not filling");
        }
    }

    private double evalPoly(int ord, double[] coef, double x) {
        double[] fp = coef;
        double f = fp[ord];
        int i = ord;
        --i;
        while (i >= 0) {
            f = x * f + fp[i];
            --i;
        }
        return f;
    }

    private boolean modifiedRegulaFalsi(int ord, double[] coef, double a, double b, double[] val) {
        double fa;
        double fb = fa = coef[ord];
        for (int i = ord - 1; i >= 0; --i) {
            fa = a * fa + coef[i];
            fb = b * fb + coef[i];
        }
        if (fa * fb > 0.0) {
            return false;
        }
        double lfx = fa;
        for (int its = 0; its < this.MAX_ITER_SECANT; ++its) {
            double x = (fb * a - fa * b) / (fb - fa);
            if (x < a || x > b) {
                x = 0.5 * (a + b);
            }
            double fx = coef[ord];
            for (int i = ord - 1; i >= 0; --i) {
                fx = x * fx + coef[i];
            }
            if (FastMath.abs((double)x) > this.RELERROR) {
                if (FastMath.abs((double)(fx / x)) < this.RELERROR) {
                    val[0] = x;
                    return true;
                }
            } else if (FastMath.abs((double)fx) < this.RELERROR) {
                val[0] = x;
                return true;
            }
            if (fa * fx < 0.0) {
                b = x;
                fb = fx;
                if (lfx * fx > 0.0) {
                    fa /= 2.0;
                }
            } else {
                a = x;
                fa = fx;
                if (lfx * fx > 0.0) {
                    fb /= 2.0;
                }
            }
            lfx = fx;
        }
        return false;
    }

    private static class Polynomial {
        static final int MAX_ORDER = 16;
        public final double[] coefficients = new double[17];
        public int order;

        private Polynomial() {
        }
    }
}

