/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.StretchTorsionType;
import ffx.potential.parameters.TorsionType;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class StretchTorsion
extends BondedTerm
implements LambdaInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(StretchTorsion.class.getName());
    private static final String mathForm;
    private final double[] constants = new double[9];
    public BondType bondType1 = null;
    public BondType bondType2 = null;
    public BondType bondType3 = null;
    private double lambda = 1.0;
    private double dEdL = 0.0;
    private boolean lambdaTerm = false;
    private StretchTorsionType stretchTorsionType = null;
    private double[] tsin = new double[]{0.0, 0.0, 0.0};
    private double[] tcos = new double[]{1.0, 1.0, 1.0};
    private TorsionType torsionType = null;

    private StretchTorsion(Bond b1, Bond b2, Bond b3) {
        this.bonds = new Bond[3];
        this.bonds[0] = b1;
        this.bonds[1] = b2;
        this.bonds[2] = b3;
        this.initialize();
    }

    private StretchTorsion(String n) {
        super(n);
    }

    public static StretchTorsion stretchTorsionFactory(Torsion torsion, ForceField forceField) {
        TorsionType torsionType = torsion.torsionType;
        String key = torsionType.getKey();
        StretchTorsionType stretchTorsionType = forceField.getStretchTorsionType(key);
        if (stretchTorsionType != null) {
            Bond bond1 = torsion.bonds[0];
            Bond middleBond = torsion.bonds[1];
            Bond bond3 = torsion.bonds[2];
            StretchTorsion stretchTorsion = new StretchTorsion(bond1, middleBond, bond3);
            stretchTorsion.stretchTorsionType = stretchTorsionType;
            stretchTorsion.torsionType = torsion.torsionType;
            stretchTorsion.bondType1 = bond1.bondType;
            stretchTorsion.bondType2 = middleBond.bondType;
            stretchTorsion.bondType3 = bond3.bondType;
            Atom atom1 = torsion.atoms[0];
            Atom atom2 = torsion.atoms[1];
            Atom atom3 = torsion.atoms[2];
            Atom atom4 = torsion.atoms[3];
            stretchTorsion.setFlipped(atom1.getAtomType().atomClass != stretchTorsionType.atomClasses[0] || atom2.getAtomType().atomClass != stretchTorsionType.atomClasses[1] || atom3.getAtomType().atomClass != stretchTorsionType.atomClasses[2] || atom4.getAtomType().atomClass != stretchTorsionType.atomClasses[3]);
            return stretchTorsion;
        }
        return null;
    }

    public static String stretchTorsionForm() {
        return mathForm;
    }

    public boolean compare(Atom a0, Atom a1, Atom a2, Atom a3) {
        if (a0 == this.atoms[0] && a1 == this.atoms[1] && a2 == this.atoms[2] && a3 == this.atoms[3]) {
            return true;
        }
        return a0 == this.atoms[3] && a1 == this.atoms[2] && a2 == this.atoms[1] && a3 == this.atoms[0];
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.energy = 0.0;
        this.value = 0.0;
        this.dEdL = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        Atom atomD = this.atoms[3];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vd = atomD.getXYZ();
        Double3 vba = vb.sub(va);
        Double3 vcb = vc.sub(vb);
        Double3 vdc = vd.sub(vc);
        double rba2 = vba.length2();
        double rcb2 = vcb.length2();
        double rdc2 = vdc.length2();
        if (FastMath.min((double)FastMath.min((double)rba2, (double)rcb2), (double)rdc2) == 0.0) {
            return 0.0;
        }
        double rcb = FastMath.sqrt((double)rcb2);
        Double3 t = vba.X(vcb);
        Double3 u = vcb.X(vdc);
        double rt2 = FastMath.max((double)t.length2(), (double)1.0E-6);
        double ru2 = FastMath.max((double)u.length2(), (double)1.0E-6);
        double rtru = FastMath.sqrt((double)(rt2 * ru2));
        Double3 vca = vc.sub(va);
        Double3 vdb = vd.sub(vb);
        double cosine = t.dot(u) / rtru;
        double sine = vcb.dot(t.X(u)) / (rcb * rtru);
        this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
        if (sine < 0.0) {
            this.value = -this.value;
        }
        double phi1 = 1.0 + (cosine * this.tcos[0] + sine * this.tsin[0]);
        double dphi1 = cosine * this.tsin[0] - sine * this.tcos[0];
        double cosine2 = cosine * cosine - sine * sine;
        double sine2 = 2.0 * cosine * sine;
        double phi2 = 1.0 + (cosine2 * this.tcos[1] + sine2 * this.tsin[1]);
        double dphi2 = 2.0 * (cosine2 * this.tsin[1] - sine2 * this.tcos[1]);
        double sine3 = cosine * sine2 + sine * cosine2;
        double cosine3 = cosine * cosine2 - sine * sine2;
        double phi3 = 1.0 + (cosine3 * this.tcos[2] + sine3 * this.tsin[2]);
        double dphi3 = 3.0 * (cosine3 * this.tsin[2] - sine3 * this.tcos[2]);
        double c1 = this.constants[0];
        double c2 = this.constants[1];
        double c3 = this.constants[2];
        double rba = FastMath.sqrt((double)rba2);
        double dr1 = rba - this.bondType1.distance;
        double units = this.stretchTorsionType.strTorUnit;
        double s1 = c1 * phi1 + c2 * phi2 + c3 * phi3;
        double e1 = units * dr1 * s1;
        double c4 = this.constants[3];
        double c5 = this.constants[4];
        double c6 = this.constants[5];
        double dr2 = rcb - this.bondType2.distance;
        double s2 = c4 * phi1 + c5 * phi2 + c6 * phi3;
        double e2 = units * dr2 * s2;
        double c7 = this.constants[6];
        double c8 = this.constants[7];
        double c9 = this.constants[8];
        double rdc = FastMath.sqrt((double)rdc2);
        double dr3 = rdc - this.bondType3.distance;
        double s3 = c7 * phi1 + c8 * phi2 + c9 * phi3;
        double e3 = units * dr3 * s3;
        this.energy = e1 + e2 + e3;
        this.energy *= this.lambda;
        this.dEdL = this.energy;
        if (gradient || this.lambdaTerm) {
            double dedphi = units * dr1 * (c1 * dphi1 + c2 * dphi2 + c3 * dphi3);
            Double3 ddrd = vba.scale(units * s1 / rba);
            Double3 dedt = t.X(vcb).scaleI(dedphi / (rt2 * rcb));
            Double3 dedu = u.X(vcb).scaleI(-dedphi / (ru2 * rcb));
            Double3 ga = dedt.X(vcb).subI(ddrd);
            Double3 gb = vca.X(dedt).addI(dedu.X(vdc)).addI(ddrd);
            Double3 gc = dedt.X(vba).addI(vdb.X(dedu));
            Double3 gd = dedu.X(vcb);
            dedphi = units * dr2 * (c4 * dphi1 + c5 * dphi2 + c6 * dphi3);
            ddrd = vcb.scale(units * s2 / rcb);
            dedt = t.X(vcb).scaleI(dedphi / (rt2 * rcb));
            dedu = u.X(vcb).scaleI(-dedphi / (ru2 * rcb));
            ga.addI(dedt.X(vcb));
            gb.addI(vca.X(dedt).addI(dedu.X(vdc)).subI(ddrd));
            gc.addI(dedt.X(vba).addI(vdb.X(dedu)).addI(ddrd));
            gd.addI(dedu.X(vcb));
            dedphi = units * dr3 * (c7 * dphi1 + c8 * dphi2 + c9 * dphi3);
            ddrd = vdc.scale(units * s3 / rdc);
            dedt = t.X(vcb).scaleI(dedphi / (rt2 * rcb));
            dedu = u.X(vcb).scaleI(-dedphi / (ru2 * rcb));
            ga.addI(dedt.X(vcb));
            gb.addI(vca.X(dedt).addI(dedu.X(vdc)));
            gc.addI(dedt.X(vba).addI(vdb.X(dedu)).subI(ddrd));
            gd.addI(dedu.X(vcb).addI(ddrd));
            int ia = atomA.getIndex() - 1;
            int ib = atomB.getIndex() - 1;
            int ic = atomC.getIndex() - 1;
            int id = atomD.getIndex() - 1;
            if (this.lambdaTerm) {
                lambdaGrad.add(threadID, ia, ga);
                lambdaGrad.add(threadID, ib, gb);
                lambdaGrad.add(threadID, ic, gc);
                lambdaGrad.add(threadID, id, gd);
            }
            if (gradient) {
                grad.add(threadID, ia, ga.scaleI(this.lambda));
                grad.add(threadID, ib, gb.scaleI(this.lambda));
                grad.add(threadID, ic, gc.scaleI(this.lambda));
                grad.add(threadID, id, gd.scaleI(this.lambda));
            }
        }
        return this.energy;
    }

    public Atom get1_4(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[3];
        }
        if (a == this.atoms[3]) {
            return this.atoms[0];
        }
        return null;
    }

    public double[] getConstants() {
        return Arrays.copyOf(this.constants, this.constants.length);
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.applyAllLambda()) {
            this.lambda = lambda;
            this.lambdaTerm = true;
        } else {
            this.lambda = 1.0;
        }
    }

    @Override
    public double getd2EdL2() {
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
    }

    public void log() {
        logger.info(String.format(" %-8s %6d-%s %6d-%s %6d-%s %6d-%s %10.4f %10.4f", "Stretch-Torsion", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.atoms[3].getIndex(), this.atoms[3].getAtomType().name, this.value, this.energy));
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.1f,%7.2f)", this.id, this.value, this.energy);
    }

    private void initialize() {
        this.atoms = new Atom[4];
        this.atoms[1] = this.bonds[0].getCommonAtom(this.bonds[1]);
        this.atoms[0] = this.bonds[0].get1_2(this.atoms[1]);
        this.atoms[2] = this.bonds[1].get1_2(this.atoms[1]);
        this.atoms[3] = this.bonds[2].get1_2(this.atoms[2]);
        this.setID_Key(false);
        this.value = DoubleMath.dihedralAngle((double[])this.atoms[0].getXYZ(null), (double[])this.atoms[1].getXYZ(null), (double[])this.atoms[2].getXYZ(null), (double[])this.atoms[3].getXYZ(null));
    }

    private void setFlipped(boolean flipped) {
        if (flipped) {
            this.constants[0] = this.stretchTorsionType.forceConstants[6];
            this.constants[1] = this.stretchTorsionType.forceConstants[7];
            this.constants[2] = this.stretchTorsionType.forceConstants[8];
            this.constants[3] = this.stretchTorsionType.forceConstants[3];
            this.constants[4] = this.stretchTorsionType.forceConstants[4];
            this.constants[5] = this.stretchTorsionType.forceConstants[5];
            this.constants[6] = this.stretchTorsionType.forceConstants[0];
            this.constants[7] = this.stretchTorsionType.forceConstants[1];
            this.constants[8] = this.stretchTorsionType.forceConstants[2];
        } else {
            System.arraycopy(this.stretchTorsionType.forceConstants, 0, this.constants, 0, 9);
        }
        this.tsin = new double[]{0.0, 0.0, 0.0};
        this.tcos = new double[]{1.0, 1.0, 1.0};
        System.arraycopy(this.torsionType.sine, 0, this.tsin, 0, FastMath.min((int)this.torsionType.sine.length, (int)3));
        System.arraycopy(this.torsionType.cosine, 0, this.tcos, 0, FastMath.min((int)this.torsionType.cosine.length, (int)3));
    }

    static {
        StringBuilder mathFormBuilder = new StringBuilder();
        for (int m = 1; m < 4; ++m) {
            for (int n = 1; n < 4; ++n) {
                mathFormBuilder.append(String.format("k%d%d*(bVal%d-b%d)*(1+cos(%d*tVal+phi%d))+", m, n, m, m, n, n));
            }
        }
        int lenStr = mathFormBuilder.length();
        mathFormBuilder.replace(lenStr - 1, lenStr, ";");
        for (int m = 1; m < 4; ++m) {
            mathFormBuilder.append(String.format("bVal%d=distance(p%d,p%d);", m, m, m + 1));
        }
        mathFormBuilder.append("tVal=dihedral(p1,p2,p3,p4)");
        mathForm = mathFormBuilder.toString();
    }
}

