/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.StretchBendType;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class StretchBend
extends BondedTerm
implements Comparable<BondedTerm> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(StretchBend.class.getName());
    public double angleEq;
    public double bond0Eq;
    public double bond1Eq;
    protected final Angle angle;
    public double force0;
    public double force1;
    private StretchBendType stretchBendType = null;
    private double rigidScale = 1.0;

    public StretchBend(Angle a) {
        this.angle = a;
        this.atoms = a.atoms;
        this.bonds = a.bonds;
        this.angleEq = this.angle.angleType.angle[this.angle.nh];
        this.bond0Eq = this.bonds[0].bondType.distance;
        this.bond1Eq = this.bonds[1].bondType.distance;
        this.setID_Key(false);
    }

    static StretchBend stretchBendFactory(Angle angle, ForceField forceField) {
        StretchBendType stretchBendType = forceField.getStretchBendType(angle.getAngleType().getKey());
        if (stretchBendType == null) {
            return null;
        }
        StretchBend stretchBend = new StretchBend(angle);
        stretchBend.setStretchBendType(stretchBendType);
        return stretchBend;
    }

    @Override
    public int compareTo(BondedTerm sb) {
        if (!sb.getClass().isInstance(this)) {
            return super.compareTo(sb);
        }
        return this.angle.compareTo(((StretchBend)sb).angle);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.energy = 0.0;
        this.value = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        int ia = atomA.getIndex() - 1;
        int ib = atomB.getIndex() - 1;
        int ic = atomC.getIndex() - 1;
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vab = va.sub(vb);
        Double3 vcb = vc.sub(vb);
        double rab2 = vab.length2();
        double rcb2 = vcb.length2();
        if (rab2 != 0.0 && rcb2 != 0.0) {
            double rab = FastMath.sqrt((double)rab2);
            double rcb = FastMath.sqrt((double)rcb2);
            Double3 vp = vcb.X(vab);
            double rp = FastMath.max((double)vp.length(), (double)1.0E-6);
            this.value = FastMath.toDegrees((double)FastMath.acos((double)FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)(vab.dot(vcb) / (rab * rcb))))));
            double e0 = rab - this.bond0Eq;
            double e1 = rcb - this.bond1Eq;
            double dt = this.value - this.angleEq;
            double dr = this.force0 * e0 + this.force1 * e1;
            double prefactor = this.rigidScale;
            this.energy = prefactor * dr * dt;
            if (gradient) {
                Double3 vdta = vab.X(vp).scaleI(-prefactor * dr * FastMath.toDegrees((double)(1.0 / (rab2 * rp))));
                Double3 vdtc = vcb.X(vp).scaleI(prefactor * dr * FastMath.toDegrees((double)(1.0 / (rcb2 * rp))));
                Double3 ga = vdta.addI(vab.scaleI(prefactor * this.force0 * dt / rab));
                Double3 gc = vdtc.addI(vcb.scaleI(prefactor * this.force1 * dt / rcb));
                grad.add(threadID, ia, ga);
                grad.sub(threadID, ib, ga.add(gc));
                grad.add(threadID, ic, gc);
            }
        }
        return this.energy;
    }

    public void log() {
        logger.info(String.format(" %s %6d-%s %6d-%s %6d-%s%7.4f %10.4f", "Stretch-Bend", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.value, this.energy));
    }

    public void setRigidScale(double rigidScale) {
        this.rigidScale = rigidScale;
    }

    public void setStretchBendType(StretchBendType stretchBendType) {
        this.stretchBendType = stretchBendType;
        if (this.atoms[0].getAtomType().atomClass == stretchBendType.atomClasses[0]) {
            this.force0 = stretchBendType.strbndunit * stretchBendType.forceConstants[0];
            this.force1 = stretchBendType.strbndunit * stretchBendType.forceConstants[1];
        } else {
            this.force0 = stretchBendType.strbndunit * stretchBendType.forceConstants[1];
            this.force1 = stretchBendType.strbndunit * stretchBendType.forceConstants[0];
        }
        this.atoms = this.angle.atoms;
        this.bonds = this.angle.bonds;
        this.angleEq = this.angle.angleType.angle[this.angle.nh];
        this.bond0Eq = this.bonds[0].bondType.distance;
        this.bond1Eq = this.bonds[1].bondType.distance;
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.2f,%7.2f,%7.1f,%7.2f)", this.id, this.bonds[0].value, this.bonds[1].value, this.angle.value, this.energy);
    }
}

