/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.parameters.TitrationUtils;
import org.apache.commons.math3.util.FastMath;

public class Rotamer {
    public final double chi1;
    public final double chi2;
    public final double chi3;
    public final double chi4;
    public final double chi5;
    final double chi6;
    final double chi7;
    public final double[] angles;
    public final double[] sigmas;
    public final int length;
    public ResidueState originalState;
    public boolean isState;
    public AminoAcidUtils.AminoAcid3 aminoAcid3;
    public NucleicAcidUtils.NucleicAcid3 nucleicAcid3;
    public boolean isTitrating;
    private TitrationUtils titrationUtils = null;

    public Rotamer(double ... values) {
        this.length = values.length / 2;
        this.angles = new double[FastMath.max((int)this.length, (int)7)];
        this.sigmas = new double[FastMath.max((int)this.length, (int)7)];
        this.nucleicAcid3 = null;
        this.aminoAcid3 = null;
        for (int i = 0; i < values.length / 2; ++i) {
            int ii = 2 * i;
            this.angles[i] = values[ii];
            this.sigmas[i] = values[ii + 1];
        }
        this.chi1 = this.angles[0];
        this.chi2 = this.angles[1];
        this.chi3 = this.angles[2];
        this.chi4 = this.angles[3];
        this.chi5 = this.angles[4];
        this.chi6 = this.angles[5];
        this.chi7 = this.angles[6];
        this.originalState = null;
        this.isState = false;
        this.isTitrating = false;
    }

    public Rotamer(AminoAcidUtils.AminoAcid3 aminoAcid3, double ... values) {
        this(values);
        this.aminoAcid3 = aminoAcid3;
    }

    public Rotamer(NucleicAcidUtils.NucleicAcid3 nucleicAcid3, double ... values) {
        this(values);
        this.nucleicAcid3 = nucleicAcid3;
    }

    public Rotamer(AminoAcidUtils.AminoAcid3 aminoAcid3, TitrationUtils titrationUtils, double ... values) {
        this(aminoAcid3, values);
        if (titrationUtils != null) {
            this.isTitrating = true;
            this.titrationUtils = titrationUtils;
        } else {
            this.isTitrating = false;
        }
    }

    public Rotamer(ResidueState residueState, double ... values) {
        this(values);
        this.isState = true;
        this.originalState = residueState;
    }

    public Rotamer(ResidueState residueState, TitrationUtils titrationUtils, double ... values) {
        this(residueState, values);
        if (titrationUtils != null) {
            this.titrationUtils = titrationUtils;
            this.isTitrating = true;
        }
    }

    public Rotamer(AminoAcidUtils.AminoAcid3 aminoAcid3, ResidueState residueState, double ... values) {
        this(residueState, values);
        this.aminoAcid3 = aminoAcid3;
    }

    public Rotamer(AminoAcidUtils.AminoAcid3 aminoAcid3, ResidueState residueState, TitrationUtils titrationUtils, double ... values) {
        this(aminoAcid3, residueState, values);
        if (titrationUtils != null) {
            this.titrationUtils = titrationUtils;
            this.isTitrating = true;
        }
    }

    public Rotamer(NucleicAcidUtils.NucleicAcid3 nucleicAcid3, ResidueState residueState, double ... values) {
        this(residueState, values);
        this.nucleicAcid3 = nucleicAcid3;
    }

    public Rotamer(NucleicAcidUtils.NucleicAcid3 nucleicAcid3, ResidueState residueState, TitrationUtils titrationUtils, double ... values) {
        this(nucleicAcid3, residueState, values);
        if (titrationUtils != null) {
            this.titrationUtils = titrationUtils;
            this.isTitrating = true;
        }
    }

    public void updateParameters(Residue residue) {
        this.titrationUtils.updateResidueParameters(residue, this);
    }

    public static Rotamer[] defaultRotamerFactory(Residue residue) {
        return Rotamer.defaultRotamerFactory(residue, null);
    }

    public static Rotamer[] defaultRotamerFactory(Residue residue, TitrationUtils titrationUtils) {
        ResidueState resState = residue.storeState();
        double[] chi = RotamerLibrary.measureRotamer(residue, false);
        double[] values = new double[chi.length * 2];
        for (int i = 0; i < chi.length; ++i) {
            int index = i * 2;
            values[index] = chi[i];
            values[index + 1] = 0.0;
        }
        switch (residue.getResidueType()) {
            case AA: {
                if (titrationUtils == null) {
                    Rotamer[] rotamers = new Rotamer[]{new Rotamer(residue.getAminoAcid3(), resState, titrationUtils, values)};
                    return rotamers;
                }
                switch (residue.getAminoAcid3()) {
                    case ASH: {
                        Rotamer[] rotamers = new Rotamer[]{new Rotamer(AminoAcidUtils.AminoAcid3.ASP, resState, titrationUtils, values), new Rotamer(AminoAcidUtils.AminoAcid3.ASH, resState, titrationUtils, values)};
                        return rotamers;
                    }
                    case GLH: {
                        Rotamer[] rotamers = new Rotamer[]{new Rotamer(AminoAcidUtils.AminoAcid3.GLU, resState, titrationUtils, values), new Rotamer(AminoAcidUtils.AminoAcid3.GLH, resState, titrationUtils, values)};
                        return rotamers;
                    }
                    case HIS: {
                        Rotamer[] rotamers = new Rotamer[]{new Rotamer(AminoAcidUtils.AminoAcid3.HIS, resState, titrationUtils, values), new Rotamer(AminoAcidUtils.AminoAcid3.HID, resState, titrationUtils, values), new Rotamer(AminoAcidUtils.AminoAcid3.HIE, resState, titrationUtils, values)};
                        return rotamers;
                    }
                    case LYS: {
                        Rotamer[] rotamers = new Rotamer[]{new Rotamer(AminoAcidUtils.AminoAcid3.LYS, resState, titrationUtils, values), new Rotamer(AminoAcidUtils.AminoAcid3.LYD, resState, titrationUtils, values)};
                        return rotamers;
                    }
                    case CYS: {
                        Rotamer[] rotamers = new Rotamer[]{new Rotamer(AminoAcidUtils.AminoAcid3.CYS, resState, titrationUtils, values), new Rotamer(AminoAcidUtils.AminoAcid3.CYD, resState, titrationUtils, values)};
                        return rotamers;
                    }
                }
                Rotamer[] rotamers = new Rotamer[]{new Rotamer(residue.getAminoAcid3(), resState, null, values)};
                return rotamers;
            }
            case NA: {
                Rotamer[] rotamers = new Rotamer[]{new Rotamer(residue.getNucleicAcid3(), resState, null, values)};
                return rotamers;
            }
        }
        Rotamer[] rotamers = new Rotamer[]{new Rotamer(resState, null, values)};
        return rotamers;
    }

    public String toAngleString() {
        StringBuilder sb = new StringBuilder();
        int n = FastMath.max((int)4, (int)this.length);
        for (int i = 0; i < n; ++i) {
            sb.append(String.format(" %6.1f %4.1f", this.angles[i], this.sigmas[i]));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        int n = FastMath.max((int)4, (int)this.length);
        for (int i = 0; i < n; ++i) {
            sb.append(String.format(" %6.1f %4.1f", this.angles[i], this.sigmas[i]));
        }
        return sb.toString();
    }

    public String getName() {
        if (this.aminoAcid3 != null) {
            return this.aminoAcid3.toString();
        }
        if (this.nucleicAcid3 != null) {
            return this.nucleicAcid3.toString();
        }
        return "";
    }

    public double getRotamerPhBias() {
        return this.titrationUtils.getRotamerPhBias(this.aminoAcid3);
    }

    public double[] getAngles() {
        return this.angles;
    }
}

