/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class RestrainPosition
extends BondedTerm
implements LambdaInterface {
    private static final Logger logger = Logger.getLogger(RestrainPosition.class.getName());
    private final double[][] equilibriumCoordinates;
    private final double forceConstant;
    private final double flatBottom;
    private final double[] a1 = new double[3];
    private final double[] dx = new double[3];
    private final double lambdaExp = 1.0;
    private final double[] lambdaGradient;
    private final int nAtoms;
    private final boolean lambdaTerm;
    private double lambda = 1.0;
    private double lambdaPow = FastMath.pow((double)this.lambda, (double)1.0);
    private double dLambdaPow = 1.0 * FastMath.pow((double)this.lambda, (double)0.0);
    private double d2LambdaPow = 0.0;
    private double dEdL = 0.0;
    private double d2EdL2 = 0.0;

    public RestrainPosition(Atom[] atoms, double[][] equilibriumCoordinates, double forceConst, double flatBottom, boolean lambdaTerm) {
        this.atoms = atoms;
        this.equilibriumCoordinates = equilibriumCoordinates;
        this.forceConstant = forceConst;
        this.flatBottom = flatBottom;
        this.nAtoms = atoms.length;
        this.lambdaTerm = lambdaTerm;
        if (lambdaTerm) {
            this.lambdaGradient = new double[this.nAtoms * 3];
        } else {
            this.lambdaGradient = null;
            this.lambda = 1.0;
            this.lambdaPow = 1.0;
            this.dLambdaPow = 0.0;
            this.d2LambdaPow = 0.0;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.info(" RestrainPosition: " + lambdaTerm);
            for (Atom atom : atoms) {
                logger.fine(atom.toString());
            }
        }
    }

    @Override
    public Atom[] getAtoms() {
        Atom[] retArray = new Atom[this.nAtoms];
        System.arraycopy(this.atoms, 0, retArray, 0, this.nAtoms);
        return retArray;
    }

    public double getForceConstant() {
        return this.forceConstant;
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.lambdaTerm) {
            this.lambda = lambda;
            double lambdaWindow = 1.0;
            if (this.lambda <= lambdaWindow) {
                double dldgl = 1.0 / lambdaWindow;
                double l = dldgl * this.lambda;
                double l2 = l * l;
                double l3 = l2 * l;
                double l4 = l2 * l2;
                double l5 = l4 * l;
                double c3 = 10.0;
                double c4 = -15.0;
                double c5 = 6.0;
                double threeC3 = 3.0 * c3;
                double sixC3 = 6.0 * c3;
                double fourC4 = 4.0 * c4;
                double twelveC4 = 12.0 * c4;
                double fiveC5 = 5.0 * c5;
                double twentyC5 = 20.0 * c5;
                this.lambdaPow = c3 * l3 + c4 * l4 + c5 * l5;
                this.dLambdaPow = (threeC3 * l2 + fourC4 * l3 + fiveC5 * l4) * dldgl;
                this.d2LambdaPow = (sixC3 * l + twelveC4 * l2 + twentyC5 * l3) * dldgl * dldgl;
            } else {
                this.lambdaPow = 1.0;
                this.dLambdaPow = 0.0;
                this.d2LambdaPow = 0.0;
            }
        } else {
            this.lambda = 1.0;
            this.lambdaPow = 1.0;
            this.dLambdaPow = 0.0;
            this.d2LambdaPow = 0.0;
        }
    }

    public int getNumAtoms() {
        return this.nAtoms;
    }

    public double[][] getEquilibriumCoordinates() {
        double[][] equilibriumCoords = new double[this.nAtoms][3];
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < 3; ++j) {
                equilibriumCoords[i][j] = this.equilibriumCoordinates[j][i];
            }
        }
        return equilibriumCoords;
    }

    @Override
    public double getd2EdL2() {
        if (this.lambdaTerm) {
            return this.d2EdL2;
        }
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
        if (this.lambdaTerm) {
            int n3 = this.nAtoms * 3;
            for (int i = 0; i < n3; ++i) {
                int n = i;
                gradient[n] = gradient[n] + this.lambdaGradient[i];
            }
        }
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        double e = 0.0;
        this.dEdL = 0.0;
        this.d2EdL2 = 0.0;
        double fx2 = this.forceConstant * 2.0;
        for (int i = 0; i < this.nAtoms; ++i) {
            double r;
            Atom atom = this.atoms[i];
            atom.getXYZ(this.a1);
            this.dx[0] = this.a1[0] - this.equilibriumCoordinates[0][i];
            this.dx[1] = this.a1[1] - this.equilibriumCoordinates[1][i];
            this.dx[2] = this.a1[2] - this.equilibriumCoordinates[2][i];
            double dr = r = DoubleMath.length((double[])this.dx);
            if (this.flatBottom > 0.0) {
                dr = Math.max(0.0, r - this.flatBottom);
            }
            this.value = dr;
            double dr2 = dr * dr;
            e += dr2;
            if (!gradient && !this.lambdaTerm) continue;
            double scale = fx2 * dr;
            if (r > 0.0) {
                scale /= r;
            }
            double dedx = this.dx[0] * scale;
            double dedy = this.dx[1] * scale;
            double dedz = this.dx[2] * scale;
            int index = atom.getIndex() - 1;
            if (gradient) {
                grad.add(threadID, index, this.lambdaPow * dedx, this.lambdaPow * dedy, this.lambdaPow * dedz);
            }
            if (!this.lambdaTerm) continue;
            lambdaGrad.add(threadID, index, this.dLambdaPow * dedx, this.dLambdaPow * dedy, this.dLambdaPow * dedz);
        }
        if (this.lambdaTerm) {
            this.dEdL = this.dLambdaPow * this.forceConstant * e;
            this.d2EdL2 = this.d2LambdaPow * this.forceConstant * e;
        }
        this.energy = this.forceConstant * e * this.lambdaPow;
        return this.energy;
    }

    public static RestrainPosition[] parseRestrainPositions(MolecularAssembly molecularAssembly) {
        RestrainPosition restrain;
        String[] lines;
        Atom[] atoms;
        ArrayList<RestrainPosition> restrainPositionList = new ArrayList<RestrainPosition>();
        ForceField forceField = molecularAssembly.getForceField();
        CompositeConfiguration properties = forceField.getProperties();
        if (properties.containsKey("restrain-position")) {
            atoms = molecularAssembly.getAtomArray();
            for (String line : lines = properties.getStringArray("restrain-position")) {
                restrain = RestrainPosition.parseRestrainPosition(line, atoms, false);
                if (restrain == null) continue;
                restrainPositionList.add(restrain);
            }
        }
        if (properties.containsKey("restrain-position-lambda")) {
            atoms = molecularAssembly.getAtomArray();
            for (String line : lines = properties.getStringArray("restrain-position-lambda")) {
                restrain = RestrainPosition.parseRestrainPosition(line, atoms, true);
                if (restrain == null) continue;
                restrainPositionList.add(restrain);
            }
        }
        if (restrainPositionList.isEmpty()) {
            return null;
        }
        return restrainPositionList.toArray(new RestrainPosition[0]);
    }

    public static RestrainPosition parseRestrainPosition(String line, Atom[] atoms, boolean useLambda) {
        double[][] coordinates;
        Atom[] atomArray;
        String[] tokens = line.split("\\s+");
        if (tokens.length < 1) {
            throw new IllegalArgumentException("Invalid restraint line: " + line);
        }
        int nAtoms = atoms.length;
        double forceConstant = 50.0;
        double flatBottom = 0.0;
        int start = Integer.parseInt(tokens[0]);
        if (start < 0) {
            start = -start - 1;
            int end = Integer.parseInt(tokens[1]) - 1;
            if (start >= nAtoms || end < start || end >= nAtoms) {
                logger.severe(String.format(" Property restrain-position could not be parsed:\n %s.", line));
                return null;
            }
            int n = end - start + 1;
            atomArray = new Atom[n];
            coordinates = new double[3][n];
            int j = start;
            int index = 0;
            while (j <= end) {
                atomArray[index] = atoms[j];
                coordinates[0][index] = atoms[j].getX();
                coordinates[1][index] = atoms[j].getY();
                coordinates[2][index] = atoms[j].getZ();
                ++j;
                ++index;
            }
            if (tokens.length > 2) {
                forceConstant = Double.parseDouble(tokens[2]);
            }
            if (tokens.length > 3) {
                flatBottom = Double.parseDouble(tokens[3]);
            }
            logger.fine(String.format(" Restrain-Position of Atoms %d to %d (K=%8.4f, D=%8.4f)", start + 1, end + 1, forceConstant, flatBottom));
        } else {
            Atom atom = atoms[start - 1];
            atomArray = new Atom[]{atom};
            double x = atom.getX();
            double y = atom.getY();
            double z = atom.getZ();
            if (tokens.length > 1) {
                x = Double.parseDouble(tokens[1]);
            }
            if (tokens.length > 2) {
                y = Double.parseDouble(tokens[2]);
            }
            if (tokens.length > 3) {
                z = Double.parseDouble(tokens[3]);
            }
            if (tokens.length > 4) {
                forceConstant = Double.parseDouble(tokens[4]);
            }
            if (tokens.length > 5) {
                flatBottom = Double.parseDouble(tokens[5]);
            }
            logger.fine(String.format(" Restrain-Position of %s to (%12.6f, %12.6f, %12.6f) with K=%8.4f and D=%8.4f", atom, x, y, z, forceConstant, flatBottom));
            coordinates = new double[3][1];
            coordinates[0][0] = x;
            coordinates[1][0] = y;
            coordinates[2][0] = z;
        }
        return new RestrainPosition(atomArray, coordinates, forceConstant, flatBottom, useLambda);
    }
}

