/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.crystal.Crystal;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.DoubleMath;
import ffx.numerics.switching.ConstantSwitch;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.BondType;
import java.util.logging.Logger;

public class RestrainDistance
extends BondedTerm
implements LambdaInterface {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_RB_LAM_START = 0.75;
    public static final double DEFAULT_RB_LAM_END = 1.0;
    private static final Logger logger = Logger.getLogger(RestrainDistance.class.getName());
    private final double restraintLambdaStart;
    private final double restraintLambdaStop;
    private final double restraintLambdaWindow;
    private final double rlwInv;
    private final UnivariateSwitchingFunction switchingFunction;
    public BondType bondType = null;
    private final boolean lambdaTerm;
    private double lambda = 1.0;
    private double switchVal = 1.0;
    private double switchdUdL = 1.0;
    private double switchd2UdL2 = 1.0;
    private double dEdL = 0.0;
    private double d2EdL2 = 0.0;
    private final double[][] dEdXdL = new double[2][3];
    private final Crystal crystal;

    public RestrainDistance(Atom a1, Atom a2, Crystal crystal, boolean lambdaTerm, double lamStart, double lamEnd, UnivariateSwitchingFunction sf) {
        int i2;
        this.restraintLambdaStart = lamStart;
        this.restraintLambdaStop = lamEnd;
        assert (lamEnd > lamStart);
        this.restraintLambdaWindow = lamEnd - lamStart;
        this.rlwInv = 1.0 / this.restraintLambdaWindow;
        this.atoms = new Atom[2];
        this.crystal = crystal;
        int i1 = a1.getIndex();
        if (i1 < (i2 = a2.getIndex())) {
            this.atoms[0] = a1;
            this.atoms[1] = a2;
        } else {
            this.atoms[0] = a2;
            this.atoms[1] = a1;
        }
        this.setID_Key(false);
        this.switchingFunction = sf == null ? new ConstantSwitch() : sf;
        this.lambdaTerm = lambdaTerm;
        this.setLambda(1.0);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.value = 0.0;
        this.energy = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        double[] a0 = new double[3];
        double[] a1 = new double[3];
        double[] v10 = new double[3];
        double[] g0 = new double[3];
        double[] g1 = new double[3];
        atomA.getXYZ(a0);
        atomB.getXYZ(a1);
        DoubleMath.sub((double[])a0, (double[])a1, (double[])v10);
        if (this.crystal != null) {
            this.crystal.image(v10);
        }
        this.value = DoubleMath.length((double[])v10);
        double dv = this.value - this.bondType.distance;
        if (this.bondType.bondFunction.hasFlatBottom()) {
            if (dv > 0.0) {
                dv = Math.max(0.0, dv - this.bondType.flatBottomRadius);
            } else if (dv < 0.0) {
                dv = Math.min(0.0, dv + this.bondType.flatBottomRadius);
            }
        }
        double dv2 = dv * dv;
        double kx2 = this.bondType.bondUnit * this.bondType.forceConstant * dv2;
        this.energy = this.switchVal * kx2;
        this.dEdL = this.switchdUdL * kx2;
        this.d2EdL2 = this.switchd2UdL2 * kx2;
        double deddt = 2.0 * this.bondType.bondUnit * this.bondType.forceConstant * dv;
        double de = 0.0;
        if (this.value > 0.0) {
            de = deddt / this.value;
        }
        DoubleMath.scale((double[])v10, (double)(this.switchVal * de), (double[])g0);
        DoubleMath.scale((double[])v10, (double)(-this.switchVal * de), (double[])g1);
        if (gradient) {
            grad.add(threadID, this.atoms[0].getIndex() - 1, g0[0], g0[1], g0[2]);
            grad.add(threadID, this.atoms[1].getIndex() - 1, g1[0], g1[1], g1[2]);
        }
        DoubleMath.scale((double[])v10, (double)(this.switchdUdL * de), (double[])g0);
        DoubleMath.scale((double[])v10, (double)(-this.switchdUdL * de), (double[])g1);
        this.dEdXdL[0][0] = g0[0];
        this.dEdXdL[0][1] = g0[1];
        this.dEdXdL[0][2] = g0[2];
        this.dEdXdL[1][0] = g1[0];
        this.dEdXdL[1][1] = g1[1];
        this.dEdXdL[1][2] = g1[2];
        this.value = dv;
        return this.energy;
    }

    public Atom get1_2(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[1];
        }
        if (a == this.atoms[1]) {
            return this.atoms[0];
        }
        return null;
    }

    public BondType getBondType() {
        return this.bondType;
    }

    public void setBondType(BondType bondType) {
        this.bondType = bondType;
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        this.lambda = lambda;
        if (this.lambdaTerm) {
            if (lambda < this.restraintLambdaStart) {
                this.switchVal = 0.0;
                this.switchdUdL = 0.0;
                this.switchd2UdL2 = 0.0;
            } else if (lambda > this.restraintLambdaStop) {
                this.switchVal = 1.0;
                this.switchdUdL = 0.0;
                this.switchd2UdL2 = 0.0;
            } else {
                double restraintLambda = (lambda - this.restraintLambdaStart) / this.restraintLambdaWindow;
                this.switchVal = this.switchingFunction.valueAt(restraintLambda);
                this.switchdUdL = this.rlwInv * this.switchingFunction.firstDerivative(restraintLambda);
                this.switchd2UdL2 = this.rlwInv * this.rlwInv * this.switchingFunction.secondDerivative(restraintLambda);
            }
        } else {
            this.switchVal = 1.0;
            this.switchdUdL = 0.0;
            this.switchd2UdL2 = 0.0;
        }
    }

    @Override
    public double getd2EdL2() {
        return this.d2EdL2;
    }

    @Override
    public double getdEdL() {
        return this.dEdL;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
        int i1 = this.atoms[0].getIndex() - 1;
        int index = i1 * 3;
        int n = index++;
        gradient[n] = gradient[n] + this.dEdXdL[0][0];
        int n2 = index++;
        gradient[n2] = gradient[n2] + this.dEdXdL[0][1];
        int n3 = index;
        gradient[n3] = gradient[n3] + this.dEdXdL[0][2];
        int i2 = this.atoms[1].getIndex() - 1;
        index = i2 * 3;
        int n4 = index++;
        gradient[n4] = gradient[n4] + this.dEdXdL[1][0];
        int n5 = index++;
        gradient[n5] = gradient[n5] + this.dEdXdL[1][1];
        int n6 = index;
        gradient[n6] = gradient[n6] + this.dEdXdL[1][2];
    }

    @Override
    public boolean isLambdaScaled() {
        return this.lambdaTerm;
    }

    public void log() {
        logger.info(String.format(" %s %6d-%s %6d-%s %6.4f  %6.4f  %10.4f", "Restraint-Bond", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.bondType.distance, this.value, this.energy));
        if (!(this.switchingFunction instanceof ConstantSwitch)) {
            logger.info(String.format(" Switching function (lambda dependence): %s", this.switchingFunction.toString()));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(String.format(" Distance restraint between atoms %s-%d %s-%d, current distance %10.4g, optimum %10.4g with a %10.4g Angstrom flat bottom, with force constant %10.4g.", this.atoms[0], this.atoms[0].getIndex(), this.atoms[1], this.atoms[1].getIndex(), this.value, this.bondType.distance, this.bondType.flatBottomRadius, this.bondType.forceConstant));
        if (!(this.switchingFunction instanceof ConstantSwitch)) {
            sb.append(String.format("\n Switching function (lambda dependence): %s", this.switchingFunction.toString()));
        }
        return sb.toString();
    }
}

