/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TitrationUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;

public class Residue
extends MSGroup
implements Comparable<Residue> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Residue.class.getName());
    private static final Comparator<Residue> resComparator = Comparator.comparing(Residue::getSegID).thenComparingInt(Residue::getResidueNumber).thenComparing(Residue::getResidueType).thenComparing(MSNode::getName);
    private static final HashMap<NucleicAcidUtils.NucleicAcid3, Color3f> NA3Color = new HashMap();
    private static final HashMap<AminoAcidUtils.AminoAcid3, Color3f> AA3Color = new HashMap();
    private static final HashMap<SSType, Color3f> SSTypeColor = new HashMap();
    public static String[] Ramachandran = new String[17];
    private static final Point3d point3d = new Point3d();
    private static final Point2d point2d = new Point2d();
    ResidueType residueType;
    private int resNumber;
    private Character chainID;
    private String segID;
    private Rotamer[] rotamers = null;
    private Rotamer currentRotamer = null;
    private String shortString = null;
    private AminoAcidUtils.AminoAcid3 aa;
    private NucleicAcidUtils.NucleicAcid3 na;
    private TitrationUtils titrationUtils = null;
    private boolean titrateConformers = false;
    private Atom atomInitial;
    private double[] O3sNorthCoords;
    private double[] O3sSouthCoords;
    private double[] C1sCoords;
    private double[] O4sCoords;
    private double[] C4sCoords;

    public boolean isTitrateConformers() {
        return this.titrateConformers;
    }

    public void setTitrateConformers(boolean titrateConformers) {
        this.titrateConformers = titrateConformers;
    }

    public Atom getAtomInitial() {
        return this.atomInitial;
    }

    public void setAtomInitial(Atom atomInitial) {
        this.atomInitial = atomInitial;
    }

    public Residue(int num, ResidueType residueType) {
        this.resNumber = num;
        this.residueType = residueType;
        this.assignResidueType();
    }

    public Residue(String name, ResidueType residueType) {
        super(name);
        this.residueType = residueType;
        this.assignResidueType();
    }

    public Residue(String name, int num, ResidueType residueType) {
        this(name, residueType);
        this.resNumber = num;
    }

    public Residue(String name, int resNumber, ResidueType residueType, Character chainID, String segID) {
        this(name, residueType);
        this.resNumber = resNumber;
        this.chainID = chainID;
        this.segID = segID;
    }

    public Residue(String name, int resNumber, MSNode atoms, ResidueType residueType, ForceField forceField) {
        super(name, atoms);
        this.resNumber = resNumber;
        this.residueType = residueType;
        this.assignResidueType();
        this.finalize(true, forceField);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.residueType != null) {
            this.assignResidueType();
        }
        for (Atom atom : this.getAtomList()) {
            atom.setResName(name);
        }
    }

    @Override
    public MSNode addMSNode(MSNode o) {
        Atom currentAtom = null;
        if (o instanceof Atom) {
            Atom newAtom = (Atom)o;
            Character newAlt = newAtom.getAltLoc();
            String newName = newAtom.getName().toUpperCase();
            MSNode atoms = this.getAtomNode();
            currentAtom = (Atom)atoms.contains(newAtom);
            if (currentAtom == null) {
                if (newName.startsWith("H")) {
                    newAtom.setName(newName.replaceFirst("H", "D"));
                    currentAtom = (Atom)atoms.contains(newAtom);
                    newAtom.setName(newName);
                } else if (newName.startsWith("D")) {
                    newAtom.setName(newName.replaceFirst("D", "H"));
                    currentAtom = (Atom)atoms.contains(newAtom);
                    newAtom.setName(newName);
                }
            }
            if (this.titrateConformers) {
                currentAtom = this.atomInitial;
                newAtom.setXyzIndex(currentAtom.getXyzIndex());
                atoms.remove(currentAtom);
                currentAtom = newAtom;
                currentAtom.setResName(newAtom.getResidueName());
                currentAtom.setResidueNumber(this.resNumber);
                atoms.add(currentAtom);
                this.setFinalized(false);
            } else if (currentAtom == null) {
                currentAtom = newAtom;
                currentAtom.setResName(this.getName());
                currentAtom.setResidueNumber(this.resNumber);
                atoms.add(newAtom);
                this.setFinalized(false);
            } else {
                Character currentAlt = currentAtom.getAltLoc();
                if ((currentAlt.equals(Character.valueOf(' ')) || currentAlt.equals(Character.valueOf('A'))) && !newAlt.equals(Character.valueOf(' ')) && !newAlt.equals(Character.valueOf('A'))) {
                    newAtom.setXyzIndex(currentAtom.getXyzIndex());
                    atoms.remove(currentAtom);
                    currentAtom = newAtom;
                    currentAtom.setResName(this.getName());
                    currentAtom.setResidueNumber(this.resNumber);
                    atoms.add(currentAtom);
                    this.setFinalized(false);
                }
            }
        } else {
            logger.warning(" Only an Atom can be added to a Residue.");
        }
        return currentAtom;
    }

    @Override
    public int compareTo(Residue o) {
        if (this.equals(o)) {
            return 0;
        }
        return resComparator.compare(this, o);
    }

    @Override
    public void drawLabel(Canvas3D canvas, J3DGraphics2D g2d, Node node) {
        if (RendererCache.labelResidues) {
            double[] d = this.getCenter();
            Residue.point3d.x = d[0];
            Residue.point3d.y = d[1];
            Residue.point3d.z = d[2];
            RendererCache.getScreenCoordinate(canvas, node, point3d, point2d);
            g2d.drawString(this.getName(), (float)Residue.point2d.x, (float)Residue.point2d.y);
        }
        if (RendererCache.labelAtoms) {
            super.drawLabel(canvas, g2d, node);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Residue residue = (Residue)o;
        return Objects.equals(this.segID, residue.segID) && Objects.equals(this.getResidueNumber(), residue.getResidueNumber()) && this.residueType == residue.residueType && Objects.equals(this.getName(), residue.getName());
    }

    @Override
    public void finalize(boolean finalizeGeometry, ForceField forceField) {
        this.setFinalized(false);
        this.getAtomNode().setName("Atoms (" + this.getAtomList().size() + ")");
        if (finalizeGeometry) {
            this.assignBondedTerms(forceField);
            this.removeLeaves();
        }
        this.setCenter(this.getMultiScaleCenter(false));
        this.setFinalized(true);
    }

    public void setTitrationUtils(TitrationUtils titrationUtils) {
        this.titrationUtils = titrationUtils;
    }

    public TitrationUtils getTitrationUtils() {
        return this.titrationUtils;
    }

    public AminoAcidUtils.AminoAcid3 getAminoAcid3() {
        if (this.residueType != ResidueType.AA) {
            throw new IllegalArgumentException(String.format(" This residue is not an amino acid: %s", this));
        }
        return this.aa;
    }

    public List<Atom> getBackboneAtoms() {
        List<Atom> atoms = this.getAtomList();
        switch (this.residueType.ordinal()) {
            case 0: {
                ArrayList<Atom> ret = new ArrayList<Atom>(atoms);
                for (Atom atom : atoms) {
                    String name = atom.getName().toUpperCase();
                    if (!name.contains("'") && !name.equals("P") && !name.startsWith("OP") && !name.equals("H5T") && !name.equals("H3T")) continue;
                    ret.remove(atom);
                }
                return ret;
            }
            case 1: {
                ArrayList<Atom> ret = new ArrayList<Atom>();
                this.tryAddAtom(ret, "N");
                this.tryAddAtom(ret, "CA");
                this.tryAddAtom(ret, "C");
                this.tryAddAtom(ret, "O");
                this.tryAddAtom(ret, "OXT");
                this.tryAddAtom(ret, "OT2");
                this.tryAddAtom(ret, "H1");
                this.tryAddAtom(ret, "H2");
                this.tryAddAtom(ret, "H3");
                this.tryAddAtom(ret, "H");
                this.tryAddAtom(ret, "HA");
                this.tryAddAtom(ret, "HA2");
                this.tryAddAtom(ret, "HA3");
                return ret;
            }
        }
        return new ArrayList<Atom>(1);
    }

    public Character getChainID() {
        return this.chainID;
    }

    public void setChainID(Character c) {
        this.chainID = c;
        for (Atom atom : this.getAtomList()) {
            atom.setChainID(c);
        }
    }

    public void setSegID(String segID) {
        this.segID = segID;
        for (Atom atom : this.getAtomList()) {
            atom.setSegID(segID);
        }
    }

    public Residue getNextResidue() {
        switch (this.residueType.ordinal()) {
            case 1: {
                Atom carbon = (Atom)this.getAtomNode("C");
                if (carbon == null) {
                    return null;
                }
                List<Bond> bonds = carbon.getBonds();
                for (Bond b : bonds) {
                    Atom other = b.get1_2(carbon);
                    if (!other.getName().equalsIgnoreCase("N")) continue;
                    return (Residue)other.getParent().getParent();
                }
                break;
            }
            case 0: {
                Atom oxygen = (Atom)this.getAtomNode("O3'");
                if (oxygen == null) {
                    return null;
                }
                List<Bond> bonds = oxygen.getBonds();
                for (Bond b : bonds) {
                    Atom other = b.get1_2(oxygen);
                    if (!other.getName().equalsIgnoreCase("P")) continue;
                    return (Residue)other.getParent().getParent();
                }
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public NucleicAcidUtils.NucleicAcid3 getNucleicAcid3() {
        if (this.residueType != ResidueType.NA) {
            throw new IllegalArgumentException(String.format(" This residue is not a nucleic acid: %s", this));
        }
        return this.na;
    }

    public NucleicAcidUtils.NucleicAcid3 getNucleicAcid3(boolean matchShortName) {
        NucleicAcidUtils.NucleicAcid3 na3 = this.getNucleicAcid3();
        if (na3 == NucleicAcidUtils.NucleicAcid3.UNK && matchShortName) {
            switch (this.getName()) {
                case "A": {
                    return NucleicAcidUtils.NucleicAcid3.ADE;
                }
                case "C": {
                    return NucleicAcidUtils.NucleicAcid3.CYT;
                }
                case "G": {
                    return NucleicAcidUtils.NucleicAcid3.GUA;
                }
                case "T": {
                    return NucleicAcidUtils.NucleicAcid3.THY;
                }
                case "U": {
                    return NucleicAcidUtils.NucleicAcid3.URI;
                }
                case "DA": {
                    return NucleicAcidUtils.NucleicAcid3.DAD;
                }
                case "DC": {
                    return NucleicAcidUtils.NucleicAcid3.DCY;
                }
                case "DG": {
                    return NucleicAcidUtils.NucleicAcid3.DGU;
                }
                case "DT": {
                    return NucleicAcidUtils.NucleicAcid3.DTY;
                }
                case "DU": {
                    throw new IllegalArgumentException(" No NucleicAcid3 enum exists for DU (presumed to be deoxy-uracil)!");
                }
            }
        }
        return na3;
    }

    public Residue getPreviousResidue() {
        switch (this.residueType.ordinal()) {
            case 1: {
                Atom nitrogen = (Atom)this.getAtomNode("N");
                if (nitrogen == null) {
                    return null;
                }
                List<Bond> bonds = nitrogen.getBonds();
                for (Bond b : bonds) {
                    Atom other = b.get1_2(nitrogen);
                    if (!other.getName().equalsIgnoreCase("C")) continue;
                    return (Residue)other.getParent().getParent();
                }
                break;
            }
            case 0: {
                Atom phosphate = (Atom)this.getAtomNode("P");
                if (phosphate == null) {
                    return null;
                }
                List<Bond> bonds = phosphate.getBonds();
                for (Bond b : bonds) {
                    Atom other = b.get1_2(phosphate);
                    if (!other.getName().equalsIgnoreCase("O3'")) continue;
                    return (Residue)other.getParent().getParent();
                }
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Atom getReferenceAtom() {
        Atom atom = null;
        switch (this.getResidueType().ordinal()) {
            case 1: {
                atom = (Atom)this.getAtomNode("CA");
                break;
            }
            case 0: {
                atom = (Atom)this.getAtomNode("N1");
                if (atom != null) break;
                atom = (Atom)this.getAtomNode("N9");
                break;
            }
        }
        if (atom == null) {
            atom = (Atom)this.getAtomNode(0);
        }
        return atom;
    }

    public int getResidueNumber() {
        return this.resNumber;
    }

    public ResidueType getResidueType() {
        return this.residueType;
    }

    public Rotamer getRotamer() {
        return this.currentRotamer;
    }

    public void setRotamer(Rotamer rotamer) {
        this.currentRotamer = rotamer;
    }

    public Rotamer[] getRotamers() {
        return this.rotamers;
    }

    public Rotamer[] setRotamers(RotamerLibrary library) {
        Rotamer[] libRotamers = library.getRotamers(this, this.titrationUtils);
        this.rotamers = libRotamers;
        if (library.getUsingOrigCoordsRotamer() && this.rotamers != null) {
            Rotamer[] originalRotamers = Rotamer.defaultRotamerFactory(this, this.titrationUtils);
            int nOrig = originalRotamers.length;
            int libRots = libRotamers.length;
            this.rotamers = new Rotamer[libRots + nOrig];
            System.arraycopy(originalRotamers, 0, this.rotamers, 0, nOrig);
            System.arraycopy(libRotamers, 0, this.rotamers, nOrig, libRots);
        }
        return this.rotamers;
    }

    public Rotamer[] setRotamers() {
        Rotamer[] originalRotamers = Rotamer.defaultRotamerFactory(this, this.titrationUtils);
        int nOrig = originalRotamers.length;
        this.rotamers = new Rotamer[nOrig];
        System.arraycopy(originalRotamers, 0, this.rotamers, 0, nOrig);
        return this.rotamers;
    }

    public String getSegID() {
        return this.segID;
    }

    public List<Atom> getSideChainAtoms() {
        List<Atom> atoms = this.getAtomList();
        switch (this.residueType.ordinal()) {
            case 0: {
                ArrayList<Atom> ret = new ArrayList<Atom>();
                for (Atom atom : atoms) {
                    String name = atom.getName().toUpperCase();
                    if (!name.contains("'") && !name.equals("P") && !name.startsWith("OP")) continue;
                    ret.add(atom);
                }
                return ret;
            }
            case 1: {
                ArrayList<Atom> ret = new ArrayList<Atom>(atoms);
                for (Atom atom : atoms) {
                    String name = atom.getName().toUpperCase();
                    if (!name.equals("N") && !name.equals("H") && !name.equals("H1") && !name.equals("H2") && !name.equals("H3") && !name.equals("CA") && !name.startsWith("HA") && !name.equals("C") && !name.equals("O") && !name.equals("OXT") && !name.equals("OT2")) continue;
                    ret.remove(atom);
                }
                return ret;
            }
        }
        return null;
    }

    public List<Atom> getVariableAtoms() {
        return this.getSideChainAtoms();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.segID, this.getResidueNumber(), this.residueType, this.getName()});
    }

    public void initializeDefaultAtomicCoordinates() {
        if (this.residueType != ResidueType.NA) {
            return;
        }
        try {
            boolean isDeoxy = switch (NucleicAcidUtils.NucleicAcid3.valueOf(this.getName())) {
                case NucleicAcidUtils.NucleicAcid3.DAD, NucleicAcidUtils.NucleicAcid3.DCY, NucleicAcidUtils.NucleicAcid3.DGU, NucleicAcidUtils.NucleicAcid3.DTY -> true;
                default -> false;
            };
            this.C1sCoords = new double[3];
            ((Atom)this.getAtomNode("C1'")).getXYZ(this.C1sCoords);
            this.O4sCoords = new double[3];
            ((Atom)this.getAtomNode("O4'")).getXYZ(this.O4sCoords);
            this.C4sCoords = new double[3];
            ((Atom)this.getAtomNode("C4'")).getXYZ(this.C4sCoords);
            this.O3sNorthCoords = RotamerLibrary.applySugarPucker(this, RotamerLibrary.NucleicSugarPucker.C3_ENDO, isDeoxy, false);
            this.O3sSouthCoords = RotamerLibrary.applySugarPucker(this, RotamerLibrary.NucleicSugarPucker.C2_ENDO, isDeoxy, false);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.toString(), e);
        }
    }

    @Override
    public void print() {
        logger.info(" " + String.valueOf(this));
        for (Atom a : this.getAtomNode().getAtomList()) {
            a.print();
        }
    }

    public void revertState(ResidueState state) {
        List<Atom> atomList = this.getAtomList();
        for (Atom atom : atomList) {
            atom.moveTo(state.getAtomCoords(atom));
        }
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (newColorModel == RendererCache.ColorModel.RESIDUE) {
            switch (this.residueType.ordinal()) {
                case 1: {
                    color = AA3Color.get((Object)this.aa);
                    break;
                }
                case 0: {
                    color = NA3Color.get((Object)this.na);
                    break;
                }
                default: {
                    color = null;
                }
            }
            if (color == null) {
                return;
            }
            mat = RendererCache.materialFactory(color);
        } else if (newColorModel == RendererCache.ColorModel.STRUCTURE) {
            color = SSTypeColor.get((Object)SSType.NONE);
            mat = RendererCache.materialFactory(color);
        }
        super.setColor(newColorModel, color, mat);
    }

    public void setNumber(int n) {
        this.resNumber = n;
        for (Atom atom : this.getAtomList()) {
            atom.setResidueNumber(n);
        }
    }

    public double[][] storeCoordinateArray() {
        List<Atom> atomList = this.getAtomList();
        int nAtoms = atomList.size();
        double[][] coords = new double[nAtoms][3];
        int i = 0;
        for (Atom atom : atomList) {
            atom.getXYZ(coords[i++]);
        }
        return coords;
    }

    public ResidueState storeState() {
        return new ResidueState(this, this);
    }

    public String toFormattedString(boolean addResType, boolean addChainID) {
        StringBuilder sb = new StringBuilder();
        if (addResType) {
            sb.append(this.residueType.toString()).append("-");
        }
        if (addChainID) {
            sb.append(this.chainID);
        }
        sb.append(this);
        return sb.toString();
    }

    public String toString(Rotamer rotamer) {
        return "" + this.chainID + this.resNumber + "-" + rotamer.getName();
    }

    @Override
    public String toString() {
        if (this.shortString == null) {
            this.shortString = this.resNumber + "-" + this.getName();
        }
        return this.shortString;
    }

    void addRotamers(Rotamer[] rotamers) {
        for (Rotamer rotamer : rotamers) {
            this.addRotamer(rotamer);
        }
    }

    void addRotamer(Rotamer rotamer) {
        if (this.rotamers != null) {
            Rotamer[] libRotamers = this.rotamers;
            int nRots = libRotamers.length;
            this.rotamers = new Rotamer[nRots + 1];
            System.arraycopy(libRotamers, 0, this.rotamers, 0, nRots);
            this.rotamers[this.rotamers.length - 1] = rotamer;
        } else {
            this.rotamers = new Rotamer[1];
            this.rotamers[0] = rotamer;
        }
    }

    void deleteAtom(Atom atomToDelete) {
        MSNode atoms = this.getAtomNode();
        if (atoms.contains(atomToDelete) != null) {
            logger.info(" The following atom is being deleted from the model:\n" + String.valueOf(atomToDelete));
            atoms.remove(atomToDelete);
        }
    }

    double[] getO3sNorth() {
        double[] ret = new double[3];
        System.arraycopy(this.O3sNorthCoords, 0, ret, 0, ret.length);
        return ret;
    }

    double[] getO3sSouth() {
        double[] ret = new double[3];
        System.arraycopy(this.O3sSouthCoords, 0, ret, 0, ret.length);
        return ret;
    }

    double[] getC1sCoords() {
        double[] ret = new double[3];
        System.arraycopy(this.C1sCoords, 0, ret, 0, ret.length);
        return ret;
    }

    double[] getO4sCoords() {
        double[] ret = new double[3];
        System.arraycopy(this.O4sCoords, 0, ret, 0, ret.length);
        return ret;
    }

    double[] getC4sCoords() {
        double[] ret = new double[3];
        System.arraycopy(this.C4sCoords, 0, ret, 0, ret.length);
        return ret;
    }

    private boolean tryAddAtom(List<Atom> atList, String name) {
        try {
            Atom at = (Atom)this.getAtomNode(name);
            if (at != null) {
                atList.add(at);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void assignResidueType() {
        String name = this.getName().toUpperCase();
        switch (this.residueType.ordinal()) {
            case 1: {
                this.aa = null;
                try {
                    if (name.length() >= 2) {
                        this.aa = AminoAcidUtils.AminoAcid3.valueOf(name);
                        break;
                    }
                    if (name.length() != 1) break;
                    AminoAcidUtils.AminoAcid1 aa1 = AminoAcidUtils.AminoAcid1.valueOf(name);
                    this.aa = AminoAcidUtils.AA1toAA3.get((Object)aa1);
                }
                catch (Exception e) {
                    logger.fine(String.format("Exception assigning AA3 for residue: %s", name));
                    this.aa = AminoAcidUtils.AminoAcid3.UNK;
                }
                break;
            }
            case 0: {
                this.na = null;
                try {
                    if (name.length() >= 2) {
                        this.na = NucleicAcidUtils.NucleicAcid3.parse(name);
                        break;
                    }
                    if (name.length() != 1) break;
                    NucleicAcidUtils.NucleicAcid1 na1 = NucleicAcidUtils.NucleicAcid1.valueOf(name);
                    this.na = NucleicAcidUtils.NA1toNA3.get((Object)na1);
                    break;
                }
                catch (Exception e) {
                    this.na = NucleicAcidUtils.NucleicAcid3.UNK;
                }
            }
        }
    }

    static {
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.ADE, RendererCache.RED);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.CYT, RendererCache.MAGENTA);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.GUA, RendererCache.BLUE);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.URI, RendererCache.YELLOW);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.DAD, RendererCache.RED);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.DCY, RendererCache.MAGENTA);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.DGU, RendererCache.BLUE);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.DTY, RendererCache.ORANGE);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.MP1, RendererCache.GREEN);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.DP2, RendererCache.GREEN);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.TP3, RendererCache.GREEN);
        NA3Color.put(NucleicAcidUtils.NucleicAcid3.UNK, RendererCache.CYAN);
        AA3Color.put(AminoAcidUtils.AminoAcid3.ALA, RendererCache.GRAY);
        AA3Color.put(AminoAcidUtils.AminoAcid3.ARG, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.ASN, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.ASP, RendererCache.RED);
        AA3Color.put(AminoAcidUtils.AminoAcid3.CYS, RendererCache.YELLOW);
        AA3Color.put(AminoAcidUtils.AminoAcid3.GLN, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.GLU, RendererCache.RED);
        AA3Color.put(AminoAcidUtils.AminoAcid3.GLH, RendererCache.RED);
        AA3Color.put(AminoAcidUtils.AminoAcid3.GLD, RendererCache.RED);
        AA3Color.put(AminoAcidUtils.AminoAcid3.GLY, RendererCache.GRAY);
        AA3Color.put(AminoAcidUtils.AminoAcid3.ILE, RendererCache.GRAY);
        AA3Color.put(AminoAcidUtils.AminoAcid3.LEU, RendererCache.GRAY);
        AA3Color.put(AminoAcidUtils.AminoAcid3.LYS, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.MET, RendererCache.YELLOW);
        AA3Color.put(AminoAcidUtils.AminoAcid3.PHE, RendererCache.GREEN);
        AA3Color.put(AminoAcidUtils.AminoAcid3.PRO, RendererCache.ORANGE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.SER, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.THR, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.TRP, RendererCache.GREEN);
        AA3Color.put(AminoAcidUtils.AminoAcid3.TYR, RendererCache.GREEN);
        AA3Color.put(AminoAcidUtils.AminoAcid3.VAL, RendererCache.GRAY);
        AA3Color.put(AminoAcidUtils.AminoAcid3.HIS, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.HIE, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.HID, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.ORN, RendererCache.ORANGE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.AIB, RendererCache.ORANGE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.PCA, RendererCache.ORANGE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.FOR, RendererCache.RED);
        AA3Color.put(AminoAcidUtils.AminoAcid3.ACE, RendererCache.RED);
        AA3Color.put(AminoAcidUtils.AminoAcid3.NH2, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.NME, RendererCache.BLUE);
        AA3Color.put(AminoAcidUtils.AminoAcid3.UNK, RendererCache.MAGENTA);
        SSTypeColor.put(SSType.NONE, RendererCache.WHITE);
        SSTypeColor.put(SSType.SHEET, RendererCache.PINK);
        SSTypeColor.put(SSType.HELIX, RendererCache.BLUE);
        SSTypeColor.put(SSType.TURN, RendererCache.YELLOW);
        Residue.Ramachandran[0] = "Default (Extended)       [-135.0  135.0]";
        Residue.Ramachandran[1] = "Alpha Helix (R)          [ -57.0  -47.0]";
        Residue.Ramachandran[2] = "Alpha Helix (L)          [  57.0   47.0]";
        Residue.Ramachandran[3] = "3-10 Helix               [ -49.0  -26.0]";
        Residue.Ramachandran[4] = "Pi Helix                 [ -57.0  -70.0]";
        Residue.Ramachandran[5] = "Polyproline II Helix     [ -79.0  149.0]";
        Residue.Ramachandran[6] = "Parallel Beta Strand     [-119.0  113.0]";
        Residue.Ramachandran[7] = "Antiparallel Beta Strand [-139.0  135.0]";
        Residue.Ramachandran[8] = "Beta-Hairpin 2' (i+1)    [  90.0 -170.0]";
        Residue.Ramachandran[9] = "Beta-Hairpin 2' (i+2)    [ -80.0  -10.0]";
        Residue.Ramachandran[10] = "Beta-Hairpin 1' (i+1)    [  57.0   47.0]";
        Residue.Ramachandran[11] = "Beta-Hairpin 1' (i+2)    [  57.0   47.0]";
        Residue.Ramachandran[12] = "Beta-Hairpin 1  (i+1)    [ -57.0  -47.0]";
        Residue.Ramachandran[13] = "Beta-Hairpin 1  (i+2)    [ -57.0  -47.0]";
        Residue.Ramachandran[14] = "Beta-Hairpin 1  (i+3)    [  90.0 -170.0]";
        Residue.Ramachandran[15] = "Beta-Hairpin 3' (i+1)    [  57.0   47.0]";
        Residue.Ramachandran[16] = "Beta-Hairpin 3' (i+2)    [ -80.0  -10.0]";
    }

    public static enum ResidueType {
        NA,
        AA,
        UNK;

    }

    public static enum SSType {
        NONE,
        HELIX,
        SHEET,
        TURN;

    }
}

