/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.Atom;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.ShaderAppearance;
import org.jogamp.java3d.ShaderProgram;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.geometry.Cone;
import org.jogamp.java3d.utils.geometry.Cylinder;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class RendererCache {
    public static final Color3f BLACK;
    public static final Hashtable<String, ViewModel> viewModelHash;
    public static final Hashtable<String, ColorModel> colorModelHash;
    static final Color3f ORANGE;
    static final Color3f RED;
    static final Color3f BLUE;
    static final Color3f GRAY;
    static final Color3f YELLOW;
    static final Color3f CYAN;
    static final Color3f GREEN;
    static final Color3f WHITE;
    static final Color3f PINK;
    static final Color3f MAGENTA;
    static final Appearance nullAp;
    private static final Transform3D localToVworld;
    private static final Transform3D worldToImagePlate;
    private static final Hashtable<Color3f, Material> materials;
    private static final Geometry[] sphereGeom;
    private static final Geometry[][] cylgeom;
    private static final Geometry[][] conegeom;
    private static final Hashtable<Color3f, Appearance> pointAppearances;
    private static final Hashtable<Color3f, Appearance> lineAppearances;
    private static final Hashtable<Color3f, Appearance> fillAppearances;
    private static final Color3f[] negCharge;
    private static final Color3f[] posCharge;
    private static final Color3f NULLColor;
    private static final LineAttributes lineAttributes;
    private static final PointAttributes pointAttributes;
    private static final ColoringAttributes coloringAttributes;
    private static final RenderingAttributes renderingAttributes;
    private static final TransparencyAttributes transparencyAttributes;
    private static final PolygonAttributes fillPolygonAttributes;
    private static final PolygonAttributes pointPolygonAttributes;
    private static final PolygonAttributes linePolygonAttributes;
    public static int detail;
    public static double radius;
    public static int bondwidth;
    public static boolean highlightSelections;
    public static boolean labelAtoms;
    public static boolean labelResidues;
    public static Color3f pickingColor;
    public static Color3f selectionColor;
    public static Color3f userColor;
    private static final List<Transform3D> transform3DPool;
    private static final List<BranchGroup> spherePool;
    private static final List<BranchGroup> doubleCylinderPool;
    private static ShaderProgram shaderProgram;

    static Appearance appearanceFactory(Color3f col, ViewModel polygonType) {
        if (col == null) {
            return null;
        }
        Appearance ap = polygonType == ViewModel.FILL ? fillAppearances.get(col) : (polygonType == ViewModel.POINTS ? pointAppearances.get(col) : lineAppearances.get(col));
        if (ap == null) {
            ap = RendererCache.createAppearance(col, polygonType);
        }
        return ap;
    }

    protected static Shape3D coneFactory(Appearance ap, int res) {
        if (res > 3) {
            res = 3;
        }
        Shape3D cone = new Shape3D();
        cone.setAppearance(ap);
        cone.setCapability(12);
        cone.setCapability(13);
        cone.setCapability(15);
        cone.setCapability(6);
        cone.addGeometry(RendererCache.getConeGeom(0, res));
        cone.addGeometry(RendererCache.getConeGeom(1, res));
        return cone;
    }

    private static Appearance createAppearance(Color3f col, ViewModel polygonType) {
        Appearance ap = null;
        if (shaderProgram != null) {
            ShaderAppearance sap = new ShaderAppearance();
            sap.setShaderProgram(shaderProgram);
            ap = sap;
        }
        if (ap == null) {
            ap = new Appearance();
        }
        Material mat = RendererCache.materialFactory(col);
        ap.setMaterial(mat);
        ap.setRenderingAttributes(renderingAttributes);
        ap.setColoringAttributes(coloringAttributes);
        ap.setLineAttributes(lineAttributes);
        ap.setPointAttributes(pointAttributes);
        if (polygonType == ViewModel.FILL) {
            ap.setPolygonAttributes(fillPolygonAttributes);
            fillAppearances.put(col, ap);
        } else if (polygonType == ViewModel.POINTS) {
            ap.setPolygonAttributes(pointPolygonAttributes);
            pointAppearances.put(col, ap);
        } else {
            ap.setPolygonAttributes(linePolygonAttributes);
            lineAppearances.put(col, ap);
        }
        return ap;
    }

    private static Shape3D createCylinder(Appearance ap, int res) {
        if (res < 0) {
            res = 0;
        }
        if (res > 10) {
            res = 10;
        }
        Shape3D cyl = new Shape3D();
        cyl.setAppearance(ap);
        cyl.addGeometry(RendererCache.getCylinderGeom(0, res));
        cyl.addGeometry(RendererCache.getCylinderGeom(1, res));
        cyl.addGeometry(RendererCache.getCylinderGeom(2, res));
        cyl.setCapability(12);
        cyl.setCapability(13);
        cyl.setCapability(15);
        cyl.setCapability(14);
        cyl.setCapability(1);
        cyl.setCapability(6);
        return cyl;
    }

    private static Shape3D createSphere(Appearance ap, int div) {
        Shape3D shape3d = new Shape3D();
        shape3d.setAppearance(ap);
        shape3d.addGeometry(RendererCache.getSphereGeom(div));
        shape3d.setCapability(12);
        shape3d.setCapability(13);
        shape3d.setCapability(15);
        shape3d.setCapability(14);
        shape3d.setCapability(1);
        shape3d.setCapability(6);
        return shape3d;
    }

    private static TransformGroup createTransformGroup(Transform3D transform3D) {
        TransformGroup transformGroup = transform3D == null ? new TransformGroup() : new TransformGroup(transform3D);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        transformGroup.setCapability(12);
        return transformGroup;
    }

    static BranchGroup doubleCylinderFactory(Atom a1, Atom a2, int div) {
        BranchGroup branchGroup;
        if (!doubleCylinderPool.isEmpty() && (branchGroup = doubleCylinderPool.remove(0)) != null) {
            TransformGroup cy1tg = (TransformGroup)branchGroup.getChild(0);
            Shape3D cy1 = (Shape3D)cy1tg.getChild(0);
            cy1.setAppearance(a1.getAtomAppearance());
            cy1.setUserData((Object)a1);
            TransformGroup cy2tg = (TransformGroup)branchGroup.getChild(1);
            Shape3D cy2 = (Shape3D)cy2tg.getChild(0);
            cy2.setUserData((Object)a2);
            cy2.setAppearance(a2.getAtomAppearance());
            return branchGroup;
        }
        branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.setCapability(1);
        TransformGroup cy1tg = RendererCache.createTransformGroup(null);
        Shape3D cy1 = RendererCache.createCylinder(a1.getAtomAppearance(), div);
        cy1.setUserData((Object)a1);
        cy1tg.addChild((Node)cy1);
        branchGroup.addChild((Node)cy1tg);
        TransformGroup cy2tg = RendererCache.createTransformGroup(null);
        Shape3D cy2 = RendererCache.createCylinder(a2.getAtomAppearance(), div);
        cy2.setUserData((Object)a2);
        cy2tg.addChild((Node)cy2);
        branchGroup.addChild((Node)cy2tg);
        branchGroup.compile();
        return branchGroup;
    }

    static Color3f getColor(Atom a, ColorModel mode) {
        switch (mode.ordinal()) {
            case 0: {
                return Atom.AtomColor.get(a.getAtomicNumber());
            }
            case 8: {
                return pickingColor;
            }
            case 9: {
                return selectionColor;
            }
            case 7: {
                double charge = a.getCharge();
                if (charge < 0.0) {
                    float c = (float)(charge * 1000.0);
                    int index = -1 * Math.round(c);
                    if (index > 999) {
                        index = 999;
                    }
                    if (negCharge[index] == null) {
                        float value = (float)index * 0.001f;
                        RendererCache.negCharge[index] = new Color3f(1.0f, 1.0f - value, 1.0f - value);
                    }
                    return negCharge[index];
                }
                if (charge == 0.0) {
                    return WHITE;
                }
                float c = (float)(charge * 1000.0);
                int index = Math.round(c);
                if (index > 999) {
                    index = 999;
                }
                if (posCharge[index] == null) {
                    float value = (float)index * 0.001f;
                    RendererCache.posCharge[index] = new Color3f(1.0f - value, 1.0f - value, 1.0f);
                }
                return posCharge[index];
            }
        }
        return NULLColor;
    }

    private static Geometry getConeGeom(int num, int res) {
        if (res > 3) {
            res = 3;
        }
        if (conegeom[num][res] == null) {
            RendererCache.initConeGeom(res);
        }
        return conegeom[num][res];
    }

    static Geometry getCylinderGeom(int num, int res) {
        if (res < 0) {
            res = 0;
        }
        if (res > 10) {
            res = 10;
        }
        if (cylgeom[num][res] == null) {
            RendererCache.initCylinderGeom(res);
        }
        return cylgeom[num][res];
    }

    protected static Geometry getPolarGeom(int res) {
        return RendererCache.getSphereGeom(res);
    }

    static void getScreenCoordinate(Canvas3D canvas, Node node, Point3d point3d, Point2d point) {
        if (point == null) {
            return;
        }
        node.getLocalToVworld(localToVworld);
        canvas.getVworldToImagePlate(worldToImagePlate);
        localToVworld.transform(point3d);
        worldToImagePlate.transform(point3d);
        canvas.getPixelLocationFromImagePlate(point3d, point);
    }

    static Geometry getSphereGeom(int res) {
        if (res < 0) {
            res = 0;
        }
        if (res > 10) {
            res = 10;
        }
        if (sphereGeom[res] == null) {
            RendererCache.initSphereGeom(res);
        }
        return sphereGeom[res];
    }

    private static void initConeGeom(int res) {
        Cone cone = new Cone(1.0f, 1.0f, 97, (res + 1) * 4, 1, nullAp);
        for (int i = 0; i < 2; ++i) {
            RendererCache.conegeom[i][res] = cone.getShape(i).getGeometry();
        }
    }

    private static void initCylinderGeom(int res) {
        Appearance ap = new Appearance();
        Cylinder cyl = new Cylinder(1.0f, 1.0f, 97, 2 + res, 1, ap);
        for (int i = 0; i < 3; ++i) {
            RendererCache.cylgeom[i][res] = cyl.getShape(i).getGeometry();
            try {
                cylgeom[i][res].setCapability(18);
                cylgeom[i][res].setCapability(17);
                cylgeom[i][res].setCapability(8);
                cylgeom[i][res].setCapability(0);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private static void initSphereGeom(int res) {
        Appearance ap = new Appearance();
        Sphere sphere = new Sphere(1.0f, 97, 4 + 3 * res, ap);
        RendererCache.sphereGeom[res] = sphere.getShape().getGeometry();
    }

    static Material materialFactory(Color3f col) {
        if (col == null) {
            return null;
        }
        Material mat = materials.get(col);
        if (mat == null) {
            mat = new Material(col, BLACK, col, WHITE, 75.0f);
            mat.setLightingEnable(true);
            materials.put(col, mat);
        }
        return mat;
    }

    static void poolDoubleCylinder(BranchGroup branchGroup) {
        if (branchGroup != null) {
            doubleCylinderPool.add(branchGroup);
        }
    }

    static void poolSphere(BranchGroup tg) {
        if (tg != null) {
            spherePool.add(tg);
        }
    }

    static void poolTransform3D(Transform3D transform3D) {
        if (transform3D != null) {
            transform3DPool.add(transform3D);
        }
    }

    static BranchGroup sphereFactory(Appearance ap, int div, Transform3D transform3D) {
        BranchGroup branchGroup;
        if (!spherePool.isEmpty() && (branchGroup = spherePool.remove(0)) != null) {
            TransformGroup transformGroup = (TransformGroup)branchGroup.getChild(0);
            transformGroup.setTransform(transform3D);
            Shape3D sphere = (Shape3D)transformGroup.getChild(0);
            sphere.setAppearance(ap);
            return branchGroup;
        }
        branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.setCapability(14);
        TransformGroup transformGroup = RendererCache.createTransformGroup(transform3D);
        Shape3D sphere = RendererCache.createSphere(ap, div);
        transformGroup.addChild((Node)sphere);
        branchGroup.addChild((Node)transformGroup);
        branchGroup.compile();
        return branchGroup;
    }

    static Color3f toAtomColor(String s) {
        String c = s.toLowerCase();
        if (c.startsWith("h")) {
            return WHITE;
        }
        if (c.startsWith("c")) {
            return GRAY;
        }
        if (c.startsWith("n")) {
            return BLUE;
        }
        if (c.startsWith("o")) {
            return RED;
        }
        if (c.startsWith("p")) {
            return GREEN;
        }
        if (c.startsWith("s")) {
            return YELLOW;
        }
        return NULLColor;
    }

    static Transform3D transform3DFactory() {
        Transform3D transform3D;
        if (!transform3DPool.isEmpty() && (transform3D = transform3DPool.get(0)) != null) {
            return transform3D;
        }
        transform3D = new Transform3D();
        return transform3D;
    }

    static Transform3D transform3DFactory(Vector3d position, double scale) {
        Transform3D transform3D;
        if (!transform3DPool.isEmpty() && (transform3D = transform3DPool.get(0)) != null) {
            transform3D.setTranslation(position);
            transform3D.setScale(scale);
            return transform3D;
        }
        transform3D = new Transform3D();
        transform3D.setTranslation(position);
        transform3D.setScale(scale);
        return transform3D;
    }

    static {
        ColorModel[] colorModelValues;
        ViewModel[] values;
        BLACK = new Color3f(Color.black.getRGBColorComponents(new float[3]));
        viewModelHash = new Hashtable();
        colorModelHash = new Hashtable();
        ORANGE = new Color3f(Color.orange.getRGBColorComponents(new float[3]));
        RED = new Color3f(Color.red.getRGBColorComponents(new float[3]));
        BLUE = new Color3f(Color.blue.getRGBColorComponents(new float[3]));
        GRAY = new Color3f(Color.lightGray.getRGBColorComponents(new float[3]));
        YELLOW = new Color3f(Color.yellow.getRGBColorComponents(new float[3]));
        CYAN = new Color3f(Color.cyan.getRGBColorComponents(new float[3]));
        GREEN = new Color3f(Color.green.getRGBColorComponents(new float[3]));
        WHITE = new Color3f(Color.white.getRGBColorComponents(new float[3]));
        PINK = new Color3f(Color.pink.getRGBColorComponents(new float[3]));
        MAGENTA = new Color3f(Color.magenta.getRGBColorComponents(new float[3]));
        localToVworld = new Transform3D();
        worldToImagePlate = new Transform3D();
        materials = new Hashtable();
        sphereGeom = new Geometry[11];
        cylgeom = new Geometry[3][11];
        conegeom = new Geometry[2][4];
        pointAppearances = new Hashtable();
        lineAppearances = new Hashtable();
        fillAppearances = new Hashtable();
        negCharge = new Color3f[1000];
        posCharge = new Color3f[1000];
        NULLColor = new Color3f(Color.darkGray.getRGBColorComponents(new float[3]));
        lineAttributes = new LineAttributes();
        pointAttributes = new PointAttributes();
        coloringAttributes = new ColoringAttributes();
        renderingAttributes = new RenderingAttributes();
        transparencyAttributes = new TransparencyAttributes();
        fillPolygonAttributes = new PolygonAttributes();
        pointPolygonAttributes = new PolygonAttributes();
        linePolygonAttributes = new PolygonAttributes();
        detail = 3;
        radius = 1.0;
        bondwidth = 3;
        highlightSelections = false;
        labelAtoms = false;
        labelResidues = false;
        pickingColor = MAGENTA;
        selectionColor = YELLOW;
        userColor = WHITE;
        transform3DPool = Collections.synchronizedList(new ArrayList());
        spherePool = Collections.synchronizedList(new ArrayList());
        doubleCylinderPool = Collections.synchronizedList(new ArrayList());
        shaderProgram = null;
        coloringAttributes.setShadeModel(1);
        coloringAttributes.setColor(new Color3f(0.0f, 0.0f, 0.0f));
        lineAttributes.setLineAntialiasingEnable(true);
        lineAttributes.setLinePattern(0);
        lineAttributes.setLineWidth(1.0f);
        pointAttributes.setPointAntialiasingEnable(true);
        pointAttributes.setPointSize(1.0f);
        fillPolygonAttributes.setPolygonMode(2);
        fillPolygonAttributes.setCullFace(1);
        linePolygonAttributes.setPolygonMode(1);
        pointPolygonAttributes.setPolygonMode(0);
        renderingAttributes.setVisible(true);
        renderingAttributes.setDepthBufferEnable(true);
        renderingAttributes.setDepthBufferWriteEnable(true);
        renderingAttributes.setIgnoreVertexColors(true);
        transparencyAttributes.setTransparencyMode(4);
        for (ViewModel value : values = ViewModel.values()) {
            viewModelHash.put(value.toString(), value);
        }
        for (ColorModel value : colorModelValues = ColorModel.values()) {
            colorModelHash.put(value.toString(), value);
        }
        nullAp = new Appearance();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setVisible(false);
        nullAp.setRenderingAttributes(ra);
    }

    public static enum ViewModel {
        WIREFRAME,
        BALLANDSTICK,
        SPACEFILL,
        RMIN,
        TUBE,
        INVISIBLE,
        RESTRICT,
        SHOWHYDROGEN,
        HIDEHYDROGEN,
        DETAIL,
        RIBBON,
        SHOWVRML,
        HIDEVRML,
        INDUCEDDIPOLE,
        FORCE,
        VELOCITY,
        ACCELERATION,
        HIDEVECTORS,
        UNIT,
        RELATIVE,
        ABSOLUTE,
        POINTS,
        LINES,
        FILL,
        DESTROY;

    }

    public static enum ColorModel {
        CPK,
        GROUP,
        RESIDUE,
        POLYMER,
        MOLECULE,
        MONOCHROME,
        USERCOLOR,
        PARTIALCHARGE,
        PICK,
        SELECT,
        REVERT,
        STRUCTURE,
        APPLYUSERCOLOR;

    }
}

