/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.MultiResidue;
import ffx.potential.bonded.Residue;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.RelativeSolvationType;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RelativeSolvation {
    private static final Logger logger = Logger.getLogger(RelativeSolvation.class.getName());
    private final Map<String, Double> nonStdEnergies;
    private final SolvationLibrary solvationLibrary;

    public RelativeSolvation(SolvationLibrary solvationLibrary, ForceField forceField) {
        this.solvationLibrary = solvationLibrary;
        this.nonStdEnergies = new HashMap<String, Double>();
        for (RelativeSolvationType rsType : forceField.getRelativeSolvationTypes().values()) {
            double e;
            String resName = rsType.getResName();
            if (this.nonStdEnergies.put(resName, e = rsType.getSolvEnergy()) == null) continue;
            logger.warning(String.format(" Repeat relative solvation for %s", resName));
        }
    }

    public double getSolvationEnergy(Residue residue, boolean checkZeroes) throws IllegalArgumentException {
        String resName = "";
        Residue theRes = residue instanceof MultiResidue ? ((MultiResidue)residue).getActive() : residue;
        double energy = switch (theRes.getResidueType()) {
            case Residue.ResidueType.AA -> {
                resName = theRes instanceof MultiResidue ? ((MultiResidue)theRes).getActive().getName() : theRes.getName();
                yield this.getAASolvationEnergy(theRes);
            }
            case Residue.ResidueType.NA -> {
                resName = theRes instanceof MultiResidue ? ((MultiResidue)theRes).getActive().getName() : theRes.getName();
                yield this.getNASolvationEnergy(theRes);
            }
            default -> 0.0;
        };
        if (checkZeroes && energy == 0.0) {
            throw new IllegalArgumentException(String.format(" Zero de-solvation energy for residue %s: likely not in solvation library.", resName));
        }
        return energy;
    }

    public String toString() {
        return "Relative solvation library: " + this.solvationLibrary.toString();
    }

    private double getAASolvationEnergy(Residue residue) {
        return switch (this.solvationLibrary.ordinal()) {
            case 0 -> this.getWolfendenSolvationEnergy(residue);
            case 1 -> this.getCabaniSolvationEnergy(residue);
            case 2 -> this.getExplicitSolvationEnergy(residue);
            case 3 -> this.getGKSolvationEnergy(residue);
            case 4 -> this.getMacCallumSPCSolvationEnergy(residue);
            case 5 -> this.getMacCallumTIP4PSolvationEnergy(residue);
            default -> 0.0;
        };
    }

    private double getNASolvationEnergy(Residue residue) {
        return 0.0;
    }

    private double getGKSolvationEnergy(Residue residue) {
        return this.getExplicitSolvationEnergy(residue);
    }

    private double getExplicitSolvationEnergy(Residue residue) {
        AminoAcidUtils.AminoAcid3 name = residue.getAminoAcid3();
        return switch (name) {
            case AminoAcidUtils.AminoAcid3.ALA -> 0.58;
            case AminoAcidUtils.AminoAcid3.CYS -> -0.85;
            case AminoAcidUtils.AminoAcid3.CYD -> -69.82;
            case AminoAcidUtils.AminoAcid3.ASP -> -69.45;
            case AminoAcidUtils.AminoAcid3.ASH -> -4.0;
            case AminoAcidUtils.AminoAcid3.GLU -> -71.4;
            case AminoAcidUtils.AminoAcid3.GLH -> -3.61;
            case AminoAcidUtils.AminoAcid3.PHE -> -1.59;
            case AminoAcidUtils.AminoAcid3.GLY -> 0.67;
            case AminoAcidUtils.AminoAcid3.HIS -> -45.36;
            case AminoAcidUtils.AminoAcid3.HID -> -8.42;
            case AminoAcidUtils.AminoAcid3.HIE -> -7.53;
            case AminoAcidUtils.AminoAcid3.ILE -> 0.14;
            case AminoAcidUtils.AminoAcid3.LYS -> -43.98;
            case AminoAcidUtils.AminoAcid3.LYD -> 0.35;
            case AminoAcidUtils.AminoAcid3.MET -> -3.48;
            case AminoAcidUtils.AminoAcid3.ASN -> -5.89;
            case AminoAcidUtils.AminoAcid3.PRO -> 7.82;
            case AminoAcidUtils.AminoAcid3.GLN -> -6.89;
            case AminoAcidUtils.AminoAcid3.ARG -> -42.57;
            case AminoAcidUtils.AminoAcid3.SER -> -2.14;
            case AminoAcidUtils.AminoAcid3.THR -> 0.58;
            case AminoAcidUtils.AminoAcid3.VAL -> 0.1;
            case AminoAcidUtils.AminoAcid3.TRP -> -4.64;
            case AminoAcidUtils.AminoAcid3.TYR -> 1.76;
            case AminoAcidUtils.AminoAcid3.TYD -> -41.71;
            case AminoAcidUtils.AminoAcid3.UNK -> this.nonStdEnergies.getOrDefault(residue.getName().toUpperCase(), 0.0);
            default -> 0.0;
        };
    }

    private double getMacCallumTIP4PSolvationEnergy(Residue residue) {
        AminoAcidUtils.AminoAcid3 name = residue.getAminoAcid3();
        return switch (name) {
            case AminoAcidUtils.AminoAcid3.ALA -> 9.8;
            case AminoAcidUtils.AminoAcid3.CYS -> -0.5;
            case AminoAcidUtils.AminoAcid3.ASP -> -30.5;
            case AminoAcidUtils.AminoAcid3.GLU -> -19.0;
            case AminoAcidUtils.AminoAcid3.PHE -> -1.2;
            case AminoAcidUtils.AminoAcid3.HIS -> -28.0;
            case AminoAcidUtils.AminoAcid3.ILE -> 12.2;
            case AminoAcidUtils.AminoAcid3.LYS -> -13.6;
            case AminoAcidUtils.AminoAcid3.LEU -> 13.7;
            case AminoAcidUtils.AminoAcid3.MET -> -7.1;
            case AminoAcidUtils.AminoAcid3.ASN -> -34.5;
            case AminoAcidUtils.AminoAcid3.GLN -> -31.4;
            case AminoAcidUtils.AminoAcid3.ARG -> -43.9;
            case AminoAcidUtils.AminoAcid3.SER -> -20.2;
            case AminoAcidUtils.AminoAcid3.THR -> -20.3;
            case AminoAcidUtils.AminoAcid3.VAL -> 12.0;
            case AminoAcidUtils.AminoAcid3.TRP -> -16.2;
            case AminoAcidUtils.AminoAcid3.TYR -> -18.8;
            case AminoAcidUtils.AminoAcid3.UNK -> this.nonStdEnergies.getOrDefault(residue.getName().toUpperCase(), 0.0);
            default -> 0.0;
        };
    }

    private double getMacCallumSPCSolvationEnergy(Residue residue) {
        AminoAcidUtils.AminoAcid3 name = residue.getAminoAcid3();
        return switch (name) {
            case AminoAcidUtils.AminoAcid3.ALA -> 9.3;
            case AminoAcidUtils.AminoAcid3.CYS -> -1.1;
            case AminoAcidUtils.AminoAcid3.ASP -> -30.1;
            case AminoAcidUtils.AminoAcid3.GLU -> -18.8;
            case AminoAcidUtils.AminoAcid3.PHE -> -1.4;
            case AminoAcidUtils.AminoAcid3.HIS -> -27.2;
            case AminoAcidUtils.AminoAcid3.ILE -> 11.9;
            case AminoAcidUtils.AminoAcid3.LYS -> -8.6;
            case AminoAcidUtils.AminoAcid3.LEU -> 12.6;
            case AminoAcidUtils.AminoAcid3.MET -> -5.1;
            case AminoAcidUtils.AminoAcid3.ASN -> -34.3;
            case AminoAcidUtils.AminoAcid3.GLN -> -30.8;
            case AminoAcidUtils.AminoAcid3.ARG -> -46.3;
            case AminoAcidUtils.AminoAcid3.SER -> -18.5;
            case AminoAcidUtils.AminoAcid3.THR -> -19.3;
            case AminoAcidUtils.AminoAcid3.VAL -> 11.3;
            case AminoAcidUtils.AminoAcid3.TRP -> -15.1;
            case AminoAcidUtils.AminoAcid3.TYR -> -18.2;
            case AminoAcidUtils.AminoAcid3.UNK -> this.nonStdEnergies.getOrDefault(residue.getName().toUpperCase(), 0.0);
            default -> 0.0;
        };
    }

    private double getCabaniSolvationEnergy(Residue residue) {
        AminoAcidUtils.AminoAcid3 name = residue.getAminoAcid3();
        switch (name) {
            case ALA: {
                return 8.4;
            }
            case CYS: {
                return -5.2;
            }
            case ASP: {
                return -28.1;
            }
            case GLU: {
                return -27.1;
            }
            case PHE: {
                return -3.7;
            }
            case HIS: {
                return -27.4;
            }
            case ILE: {
                return 8.7;
            }
            case LYS: {
                return -15.5;
            }
            case LEU: {
                return 9.7;
            }
            case MET: {
                return 9.0;
            }
            case ASN: {
                return -40.6;
            }
            case GLN: {
                return -18.7;
            }
            case ARG: {
                return -30.1;
            }
            case SER: {
                return -21.4;
            }
            case THR: {
                return -21.0;
            }
            case VAL: {
                return 8.2;
            }
            case TRP: {
                return -12.3;
            }
            case TYR: {
                return -25.7;
            }
            case UNK: {
                return this.nonStdEnergies.getOrDefault(residue.getName().toUpperCase(), 0.0);
            }
        }
        return 0.0;
    }

    private double getWolfendenSolvationEnergy(Residue residue) {
        AminoAcidUtils.AminoAcid3 name = residue.getAminoAcid3();
        switch (name) {
            case ALA: {
                return 8.1;
            }
            case CYS: {
                return -5.1;
            }
            case ASP: {
                return -27.5;
            }
            case GLU: {
                return -26.6;
            }
            case PHE: {
                return -3.1;
            }
            case HIS: {
                return -42.1;
            }
            case ILE: {
                return 8.8;
            }
            case LYS: {
                return -18.0;
            }
            case LEU: {
                return 9.4;
            }
            case MET: {
                return -6.1;
            }
            case ASN: {
                return -39.9;
            }
            case GLN: {
                return -38.7;
            }
            case ARG: {
                return -44.8;
            }
            case SER: {
                return -20.8;
            }
            case THR: {
                return -20.1;
            }
            case VAL: {
                return 8.2;
            }
            case TRP: {
                return -24.3;
            }
            case TYR: {
                return -25.2;
            }
            case UNK: {
                return this.nonStdEnergies.getOrDefault(residue.getName().toUpperCase(), 0.0);
            }
        }
        return 0.0;
    }

    public static enum SolvationLibrary {
        WOLFENDEN,
        CABANI,
        EXPLICIT,
        GK,
        MACCALLUM_SPC,
        MACCALLUM_TIP4P,
        OPLS_EXPLICIT,
        OPLS_GK,
        AUTO,
        NONE;

    }
}

