/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.PiOrbitalTorsionType;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class PiOrbitalTorsion
extends BondedTerm
implements LambdaInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PiOrbitalTorsion.class.getName());
    public PiOrbitalTorsionType piOrbitalTorsionType = null;
    private double lambda = 1.0;
    private double dEdL = 0.0;
    private boolean lambdaTerm = false;

    public PiOrbitalTorsion(Bond middleBond) {
        this.atoms = new Atom[6];
        this.atoms[2] = middleBond.atoms[0];
        this.atoms[3] = middleBond.atoms[1];
        this.bonds = new Bond[5];
        this.bonds[2] = middleBond;
        int i = 0;
        for (Bond b : this.atoms[2].getBonds()) {
            if (b == middleBond) continue;
            this.atoms[i] = b.get1_2(this.atoms[2]);
            this.bonds[i] = b;
            ++i;
        }
        i = 4;
        for (Bond b : this.atoms[3].getBonds()) {
            if (b == middleBond) continue;
            this.atoms[i] = b.get1_2(this.atoms[3]);
            this.bonds[i - 1] = b;
            ++i;
        }
        this.setID_Key(false);
    }

    public Bond getMiddleBond() {
        return this.bonds[2];
    }

    public void setPiOrbitalTorsionType(PiOrbitalTorsionType piOrbitalTorsionType) {
        this.piOrbitalTorsionType = piOrbitalTorsionType;
    }

    public static PiOrbitalTorsion piOrbitalTorsionFactory(Bond bond, ForceField forceField) {
        Atom atom1 = bond.getAtom(0);
        Atom atom2 = bond.getAtom(1);
        if (!atom1.isTrigonal() || !atom2.isTrigonal()) {
            return null;
        }
        PiOrbitalTorsionType piOrbitalTorsionType = forceField.getPiOrbitalTorsionType(atom1.getAtomType(), atom2.getAtomType());
        if (piOrbitalTorsionType == null) {
            return null;
        }
        PiOrbitalTorsion piOrbitalTorsion = new PiOrbitalTorsion(bond);
        piOrbitalTorsion.setPiOrbitalTorsionType(piOrbitalTorsionType);
        return piOrbitalTorsion;
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        double ru2;
        this.energy = 0.0;
        this.value = 0.0;
        this.dEdL = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        Atom atomD = this.atoms[3];
        Atom atomE = this.atoms[4];
        Atom atomF = this.atoms[5];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vd = atomD.getXYZ();
        Double3 ve = atomE.getXYZ();
        Double3 vf = atomF.getXYZ();
        Double3 vad = va.sub(vd);
        Double3 vbd = vb.sub(vd);
        Double3 vdc = vd.sub(vc);
        Double3 vec = ve.sub(vc);
        Double3 vfc = vf.sub(vc);
        Double3 vp = vad.X(vbd).addI(vc);
        Double3 vq = vec.X(vfc).addI(vd);
        Double3 vpc = vc.sub(vp);
        Double3 vdq = vq.sub(vd);
        Double3 vt = vpc.X(vdc);
        Double3 vu = vdc.X(vdq);
        double rt2 = vt.length2();
        double rtru2 = rt2 * (ru2 = vu.length2());
        if (rtru2 != 0.0) {
            double rr = FastMath.sqrt((double)rtru2);
            double rdc = vdc.length();
            double sine = vdc.dot(vt.X(vu)) / (rdc * rr);
            double cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)(vt.dot(vu) / rr)));
            this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
            if (sine < 0.0) {
                this.value = -this.value;
            }
            if (this.value > 90.0) {
                this.value -= 180.0;
            }
            if (this.value < -90.0) {
                this.value += 180.0;
            }
            double cosine2 = cosine * cosine - sine * sine;
            double phi2 = 1.0 - cosine2;
            this.dEdL = this.energy = this.piOrbitalTorsionType.piTorsUnit * this.piOrbitalTorsionType.forceConstant * phi2;
            this.energy = this.lambda * this.energy;
            if (gradient || this.lambdaTerm) {
                double sine2 = 2.0 * cosine * sine;
                double dphi2 = 2.0 * sine2;
                double dedphi = this.piOrbitalTorsionType.piTorsUnit * this.piOrbitalTorsionType.forceConstant * dphi2;
                Double3 vdp = vd.sub(vp);
                Double3 vqc = vq.sub(vc);
                Double3 vdt = vt.X(vdc).scaleI(dedphi / (rt2 * rdc));
                Double3 vdu = vu.X(vdc).scaleI(-dedphi / (ru2 * rdc));
                Double3 dedp = vdt.X(vdc);
                Double3 dedc = vdp.X(vdt).addI(vdu.X(vdq));
                Double3 dedd = vdt.X(vpc).addI(vqc.X(vdu));
                Double3 dedq = vdu.X(vdc);
                Double3 ga = vbd.X(dedp);
                Double3 gb = dedp.X(vad);
                Double3 ge = vfc.X(dedq);
                Double3 gf = dedq.X(vec);
                Double3 gc = dedc.add(dedp).subI(ge).subI(gf);
                Double3 gd = dedd.add(dedq).subI(ga).subI(gb);
                int iA = atomA.getIndex() - 1;
                int iB = atomB.getIndex() - 1;
                int iC = atomC.getIndex() - 1;
                int iD = atomD.getIndex() - 1;
                int iE = atomE.getIndex() - 1;
                int iF = atomF.getIndex() - 1;
                if (this.lambdaTerm) {
                    lambdaGrad.add(threadID, iA, ga);
                    lambdaGrad.add(threadID, iB, gb);
                    lambdaGrad.add(threadID, iC, gc);
                    lambdaGrad.add(threadID, iD, gd);
                    lambdaGrad.add(threadID, iE, ge);
                    lambdaGrad.add(threadID, iF, gf);
                }
                if (gradient) {
                    grad.add(threadID, iA, ga.scaleI(this.lambda));
                    grad.add(threadID, iB, gb.scaleI(this.lambda));
                    grad.add(threadID, iC, gc.scaleI(this.lambda));
                    grad.add(threadID, iD, gd.scaleI(this.lambda));
                    grad.add(threadID, iE, ge.scaleI(this.lambda));
                    grad.add(threadID, iF, gf.scaleI(this.lambda));
                }
            }
        }
        return this.energy;
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.applyAllLambda()) {
            this.lambda = lambda;
            this.lambdaTerm = true;
        } else {
            this.lambda = 1.0;
        }
    }

    @Override
    public double getd2EdL2() {
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
    }

    public void log() {
        logger.info(String.format(" %s %6d-%s %6d-%s %10.4f %10.4f", "Pi-Orbital Torsion", this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.atoms[3].getIndex(), this.atoms[3].getAtomType().name, this.value, this.energy));
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.1f,%7.2f)", this.id, this.value, this.energy);
    }
}

