/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Residue;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class NucleicAcidUtils {
    private static final Logger logger = Logger.getLogger(NucleicAcidUtils.class.getName());
    public static final int[] NA_O5 = new int[]{1001, 1031, 1062, 1090, 1117, 1146, 1176, 1203, 0, 0, 0, 0, 1300, 1334, 1363, 1400, 1431, 1465, 1492, 1523, 1559, 1589, 1624};
    public static final int[] NA_C5 = new int[]{1002, 1032, 1063, 1091, 1118, 1147, 1177, 1204, 0, 0, 0, 0, 1301, 1335, 1364, 1401, 1432, 1466, 1493, 1524, 1560, 1590, 1625};
    public static final int[] NA_H51 = new int[]{1003, 1033, 1064, 1092, 1119, 1148, 1178, 1205, 0, 0, 0, 0, 1302, 1336, 1365, 1402, 1433, 1467, 1494, 1525, 1561, 1591, 1626};
    public static final int[] NA_H52 = new int[]{1004, 1034, 1065, 1093, 1120, 1149, 1179, 1206, 0, 0, 0, 0, 1303, 1337, 1366, 1403, 1434, 1468, 1495, 1526, 1562, 1592, 1627};
    public static final int[] NA_C4 = new int[]{1005, 1035, 1066, 1094, 1121, 1150, 1180, 1207, 0, 0, 0, 0, 1304, 1338, 1367, 1404, 1435, 1469, 1496, 1527, 1563, 1593, 1628};
    public static final int[] NA_H4 = new int[]{1006, 1036, 1067, 1095, 1122, 1151, 1181, 1208, 0, 0, 0, 0, 1305, 1339, 1368, 1405, 1436, 1470, 1497, 1528, 1564, 1594, 1629};
    public static final int[] NA_O4 = new int[]{1007, 1037, 1068, 1096, 1123, 1152, 1182, 1209, 0, 0, 0, 0, 1306, 1340, 1369, 1406, 1437, 1471, 1498, 1529, 1565, 1595, 1630};
    public static final int[] NA_C1 = new int[]{1008, 1038, 1069, 1097, 1124, 1153, 1183, 1210, 0, 0, 0, 0, 1307, 1341, 1370, 1407, 1438, 1472, 1499, 1530, 1566, 1596, 1631};
    public static final int[] NA_H1 = new int[]{1009, 1039, 1070, 1098, 1125, 1154, 1184, 1211, 0, 0, 0, 0, 1308, 1342, 1371, 1408, 1439, 1473, 1500, 1531, 1567, 1597, 1632};
    public static final int[] NA_C3 = new int[]{1010, 1040, 1071, 1099, 1126, 1155, 1185, 1212, 0, 0, 0, 0, 1309, 1343, 1372, 1409, 1440, 1474, 1501, 1532, 1568, 1598, 1633};
    public static final int[] NA_H3 = new int[]{1011, 1041, 1072, 1100, 1127, 1156, 1186, 1213, 0, 0, 0, 0, 1310, 1344, 1373, 1410, 1441, 1475, 1502, 1533, 1569, 1599, 1634};
    public static final int[] NA_C2 = new int[]{1012, 1042, 1073, 1101, 1128, 1157, 1187, 1214, 0, 0, 0, 0, 1311, 1345, 1374, 1411, 1442, 1476, 1503, 1534, 1570, 1600, 1635};
    public static final int[] NA_H21 = new int[]{1013, 1043, 1074, 1102, 1129, 1158, 1188, 1215, 0, 0, 0, 0, 1312, 1346, 1375, 1412, 1443, 1477, 1504, 1535, 1571, 1601, 1636};
    public static final int[] NA_O2 = new int[]{1014, 1044, 1075, 1103, 0, 0, 0, 0, 0, 0, 0, 0, 1313, 1347, 1376, 1413, 1444, 1478, 1505, 1536, 1572, 1602, 1637};
    public static final int[] NA_H22 = new int[]{1015, 1045, 1076, 1104, 1130, 1159, 1189, 1216, 0, 0, 0, 0, 1314, 1348, 1377, 0, 0, 1479, 1506, 1537, 1573, 1603, 1638};
    public static final int[] NA_O3 = new int[]{1016, 1046, 1077, 1105, 1131, 1160, 1190, 1217, 0, 0, 0, 0, 1315, 1349, 1378, 1414, 1445, 1480, 1507, 1538, 1574, 1604, 1639};
    public static final int[] NA_P = new int[]{1230, 1230, 1230, 1230, 1242, 1242, 1242, 1242, 0, 0, 0, 0, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230};
    public static final int[] NA_OP = new int[]{1231, 1231, 1231, 1231, 1243, 1243, 1243, 1243, 0, 0, 0, 0, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231};
    public static final int[] NA_HO5T = new int[]{1233, 1233, 1233, 1233, 1245, 1245, 1245, 1245, 0, 0, 0, 0, 1233, 1233, 1233, 1233, 1233, 1233, 1233, 1233, 1233, 1233, 1233};
    public static final int[] NA_HO3T = new int[]{1238, 1238, 1238, 1238, 1250, 1250, 1250, 1250, 0, 0, 0, 0, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 1238};
    public static final List<NucleicAcid3> nucleicAcidList = Arrays.asList(NucleicAcid3.values());
    public static final HashMap<NucleicAcid1, NucleicAcid3> NA1toNA3 = new HashMap();
    private static final Map<String, String> newNucleicAcidAtomNames;
    public static final int[] NAPATTERN;

    public static void assignNucleicAcidAtomTypes(List<Residue> residues, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom pSugarO3 = null;
        int numberOfResidues = residues.size();
        for (int residueNumber = 0; residueNumber < numberOfResidues; ++residueNumber) {
            Residue residue = residues.get(residueNumber);
            String residueName = residue.getName().toUpperCase();
            NucleicAcid3 nucleicAcid = null;
            int naNumber = -1;
            for (NucleicAcid3 nucleic : nucleicAcidList) {
                ++naNumber;
                Object nuc3 = nucleic.toString();
                if (!((String)(nuc3 = ((String)nuc3).substring(((String)nuc3).length() - 3))).equalsIgnoreCase(residueName)) continue;
                nucleicAcid = nucleic;
                break;
            }
            List<Atom> resAtoms = residue.getAtomList();
            int nAtoms = resAtoms.size();
            for (Atom atom : resAtoms) {
                String name = atom.getName();
                name = name.replace('*', '\'');
                name = newNucleicAcidAtomNames.getOrDefault(name, name);
                atom.setName(name);
            }
            AminoAcidUtils.ResiduePosition position = AminoAcidUtils.ResiduePosition.MIDDLE_RESIDUE;
            boolean lastRes = false;
            if (residueNumber == 0) {
                position = AminoAcidUtils.ResiduePosition.FIRST_RESIDUE;
            }
            if (residueNumber == numberOfResidues - 1) {
                lastRes = true;
                if (position != AminoAcidUtils.ResiduePosition.FIRST_RESIDUE) {
                    position = AminoAcidUtils.ResiduePosition.LAST_RESIDUE;
                }
            }
            boolean threePrimeCap = NucleicAcidUtils.isThreePrimeCap(nAtoms, resAtoms);
            boolean isDNA = false;
            Residue resToCheck = threePrimeCap ? residues.get(residueNumber - 1) : residue;
            Atom sugarO2 = (Atom)resToCheck.getAtomNode("O2'");
            if (sugarO2 == null) {
                isDNA = true;
                if (!residueName.startsWith("D")) {
                    switch (nucleicAcid.ordinal()) {
                        case 0: {
                            nucleicAcid = NucleicAcid3.DAD;
                            residueName = "DAD";
                            residue.setName(residueName);
                            break;
                        }
                        case 2: {
                            nucleicAcid = NucleicAcid3.DCY;
                            residueName = "DCY";
                            residue.setName(residueName);
                            break;
                        }
                        case 1: {
                            nucleicAcid = NucleicAcid3.DGU;
                            residueName = "DGU";
                            residue.setName(residueName);
                            break;
                        }
                        case 8: {
                            nucleicAcid = NucleicAcid3.DTY;
                            residueName = "DTY";
                            residue.setName(residueName);
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (residueName.startsWith("D")) {
                switch (nucleicAcid.ordinal()) {
                    case 4: {
                        nucleicAcid = NucleicAcid3.ADE;
                        residueName = "ADE";
                        residue.setName(residueName);
                        break;
                    }
                    case 6: {
                        nucleicAcid = NucleicAcid3.CYT;
                        residueName = "CYT";
                        residue.setName(residueName);
                        break;
                    }
                    case 5: {
                        nucleicAcid = NucleicAcid3.GUA;
                        residueName = "GUA";
                        residue.setName(residueName);
                        break;
                    }
                    case 7: {
                        nucleicAcid = NucleicAcid3.THY;
                        residueName = "THY";
                        residue.setName(residueName);
                        break;
                    }
                }
            }
            Atom phosphate = null;
            Atom sugarO5 = null;
            Atom sugarO3 = null;
            if (threePrimeCap) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" EXPERIMENTAL: Adding 3'-terminal phosphate cap %s", residue));
                }
                Residue priorResidue = residues.get(residueNumber - 1);
                int phosType = isDNA ? 1252 : 1240;
                int oxygenType = isDNA ? 1253 : 1241;
                phosphate = BondedUtils.buildHeavy(residue, "P", pSugarO3, phosType, forceField, bondList);
                BondedUtils.buildHeavy(residue, "OP1", phosphate, oxygenType, forceField, bondList);
                BondedUtils.buildHeavy(residue, "OP2", phosphate, oxygenType, forceField, bondList);
                switch (nAtoms) {
                    case 3: {
                        NucleicAcidUtils.buildOP3(residue, phosphate, oxygenType, forceField, bondList, priorResidue, false);
                        break;
                    }
                    case 4: {
                        MSNode bogusO5s = residue.getAtomNode("O5'");
                        if (bogusO5s != null) {
                            bogusO5s.setName("OP3");
                        }
                        BondedUtils.buildHeavy(residue, "OP3", phosphate, oxygenType, forceField, bondList);
                        break;
                    }
                    case 5: 
                    case 6: {
                        logger.severe(" Currently, FFX does not support partially-protonated 3'-terminal phosphate caps from PDB files!");
                    }
                }
            } else {
                if (position == AminoAcidUtils.ResiduePosition.FIRST_RESIDUE) {
                    phosphate = (Atom)residue.getAtomNode("P");
                    if (phosphate != null) {
                        Residue nextRes;
                        Residue residue2 = nextRes = lastRes ? null : residues.get(residueNumber + 1);
                        if (isDNA) {
                            phosphate = BondedUtils.buildHeavy(residue, "P", null, 1247, forceField, bondList);
                            BondedUtils.buildHeavy(residue, "OP1", phosphate, 1248, forceField, bondList);
                            BondedUtils.buildHeavy(residue, "OP2", phosphate, 1248, forceField, bondList);
                            NucleicAcidUtils.buildOP3(residue, phosphate, 1248, forceField, bondList, nextRes, true);
                            sugarO5 = BondedUtils.buildHeavy(residue, "O5'", phosphate, 1246, forceField, bondList);
                        } else {
                            phosphate = BondedUtils.buildHeavy(residue, "P", null, 1235, forceField, bondList);
                            BondedUtils.buildHeavy(residue, "OP1", phosphate, 1236, forceField, bondList);
                            BondedUtils.buildHeavy(residue, "OP2", phosphate, 1236, forceField, bondList);
                            NucleicAcidUtils.buildOP3(residue, phosphate, 1236, forceField, bondList, nextRes, true);
                            sugarO5 = BondedUtils.buildHeavy(residue, "O5'", phosphate, 1234, forceField, bondList);
                        }
                    } else {
                        Atom O5;
                        sugarO5 = isDNA ? ((O5 = residue.getAtomByName("O5'", true)) == null ? NucleicAcidUtils.buildSugarO5(residue, 1244, forceField) : BondedUtils.buildHeavy(residue, "O5'", null, 1244, forceField, bondList)) : ((O5 = residue.getAtomByName("O5'", true)) == null ? NucleicAcidUtils.buildSugarO5(residue, 1232, forceField) : BondedUtils.buildHeavy(residue, "O5'", null, 1232, forceField, bondList));
                    }
                } else {
                    phosphate = BondedUtils.buildHeavy(residue, "P", pSugarO3, NA_P[naNumber], forceField, bondList);
                    BondedUtils.buildHeavy(residue, "OP1", phosphate, NA_OP[naNumber], forceField, bondList);
                    BondedUtils.buildHeavy(residue, "OP2", phosphate, NA_OP[naNumber], forceField, bondList);
                    sugarO5 = BondedUtils.buildHeavy(residue, "O5'", phosphate, NA_O5[naNumber], forceField, bondList);
                }
                Atom sugarC5 = BondedUtils.buildHeavy(residue, "C5'", sugarO5, NA_C5[naNumber], forceField, bondList);
                Atom sugarC4 = BondedUtils.buildHeavy(residue, "C4'", sugarC5, NA_C4[naNumber], forceField, bondList);
                Atom sugarO4 = BondedUtils.buildHeavy(residue, "O4'", sugarC4, NA_O4[naNumber], forceField, bondList);
                Atom sugarC1 = BondedUtils.buildHeavy(residue, "C1'", sugarO4, NA_C1[naNumber], forceField, bondList);
                Atom sugarC3 = BondedUtils.buildHeavy(residue, "C3'", sugarC4, NA_C3[naNumber], forceField, bondList);
                Atom sugarC2 = BondedUtils.buildHeavy(residue, "C2'", sugarC3, NA_C2[naNumber], forceField, bondList);
                BondedUtils.buildBond(sugarC2, sugarC1, forceField, bondList);
                if (position == AminoAcidUtils.ResiduePosition.LAST_RESIDUE || numberOfResidues == 1) {
                    sugarO3 = isDNA ? BondedUtils.buildHeavy(residue, "O3'", sugarC3, 1249, forceField, bondList) : BondedUtils.buildHeavy(residue, "O3'", sugarC3, 1237, forceField, bondList);
                } else {
                    boolean nextResIsCap = residues.get(residueNumber + 1).getAtomList().size() < 7;
                    int o3Type = NA_O3[naNumber];
                    if (nextResIsCap) {
                        logger.fine(" Applying a 3'-terminal-phos-cap O3' atom type to residue " + String.valueOf(residue));
                        o3Type = isDNA ? 1251 : 1239;
                    }
                    sugarO3 = BondedUtils.buildHeavy(residue, "O3'", sugarC3, o3Type, forceField, bondList);
                }
                if (!isDNA) {
                    sugarO2 = BondedUtils.buildHeavy(residue, "O2'", sugarC2, NA_O2[naNumber], forceField, bondList);
                }
                if (position == AminoAcidUtils.ResiduePosition.FIRST_RESIDUE && phosphate == null) {
                    BondedUtils.buildH(residue, "HO5'", sugarO5, 1.0, sugarC5, 109.5, sugarC4, 180.0, 0, NA_HO5T[naNumber], forceField, bondList);
                }
                BondedUtils.buildH(residue, "H5'", sugarC5, 1.09, sugarO5, 109.5, sugarC4, 109.5, 1, NA_H51[naNumber], forceField, bondList);
                BondedUtils.buildH(residue, "H5''", sugarC5, 1.09, sugarO5, 109.5, sugarC4, 109.5, -1, NA_H52[naNumber], forceField, bondList);
                BondedUtils.buildH(residue, "H4'", sugarC4, 1.09, sugarC5, 109.5, sugarC3, 109.5, -1, NA_H4[naNumber], forceField, bondList);
                BondedUtils.buildH(residue, "H3'", sugarC3, 1.09, sugarC4, 109.5, sugarC2, 109.5, -1, NA_H3[naNumber], forceField, bondList);
                if (isDNA) {
                    BondedUtils.buildH(residue, "H2'", sugarC2, 1.09, sugarC3, 109.5, sugarC1, 109.5, -1, NA_H21[naNumber], forceField, bondList);
                    BondedUtils.buildH(residue, "H2''", sugarC2, 1.09, sugarC3, 109.5, sugarC1, 109.5, 1, NA_H22[naNumber], forceField, bondList);
                } else {
                    BondedUtils.buildH(residue, "H2'", sugarC2, 1.09, sugarC3, 109.5, sugarC1, 109.5, -1, NA_H21[naNumber], forceField, bondList);
                    if (nucleicAcid == NucleicAcid3.OMC || nucleicAcid == NucleicAcid3.OMG) {
                        Atom CM2 = BondedUtils.buildHeavy(residue, "CM2", sugarO2, 1427, forceField, bondList);
                        Atom HM21 = BondedUtils.buildH(residue, "HM21", CM2, 1.08, sugarO2, 109.5, sugarC2, 0.0, 0, 1428, forceField, bondList);
                        BondedUtils.buildH(residue, "HM22", CM2, 1.08, sugarO2, 109.5, HM21, 109.5, 1, 1429, forceField, bondList);
                        BondedUtils.buildH(residue, "HM23", CM2, 1.08, sugarO2, 109.5, HM21, 109.5, -1, 1430, forceField, bondList);
                    } else {
                        BondedUtils.buildH(residue, "HO2'", sugarO2, 1.0, sugarC2, 109.5, sugarC3, 180.0, 0, NA_H22[naNumber], forceField, bondList);
                    }
                }
                BondedUtils.buildH(residue, "H1'", sugarC1, 1.09, sugarO4, 109.5, sugarC2, 109.5, -1, NA_H1[naNumber], forceField, bondList);
                if (position == AminoAcidUtils.ResiduePosition.LAST_RESIDUE || numberOfResidues == 1) {
                    BondedUtils.buildH(residue, "HO3'", sugarO3, 1.0, sugarC3, 109.5, sugarC4, 180.0, 0, NA_HO3T[naNumber], forceField, bondList);
                }
                NucleicAcidUtils.assignNucleicAcidBaseAtomTypes(nucleicAcid, residue, sugarC1, sugarO4, sugarC2, forceField, bondList);
            }
            resAtoms = residue.getAtomList();
            for (Atom atom : resAtoms) {
                AtomType atomType = atom.getAtomType();
                if (atomType == null) {
                    throw new BondedUtils.MissingAtomTypeException(residue, atom);
                }
                int numberOfBonds = atom.getNumBonds();
                if (numberOfBonds == atomType.valence || atom == sugarO3 && numberOfBonds == atomType.valence - 1 && position != AminoAcidUtils.ResiduePosition.LAST_RESIDUE && numberOfResidues != 1) continue;
                logger.warning(String.format(" An atom for residue %s has the wrong number of bonds:\n %s", residueName, atom));
                logger.info(String.format(" Expected: %d Actual: %d.", atomType.valence, numberOfBonds));
                for (Bond bond : atom.getBonds()) {
                    logger.info(" " + bond.toString());
                }
            }
            pSugarO3 = sugarO3;
        }
    }

    private static boolean isThreePrimeCap(int nAtoms, List<Atom> resAtoms) {
        boolean threePrimeCap = false;
        if (nAtoms < 7) {
            boolean unrecognized = false;
            for (Atom atom : resAtoms) {
                String atomName = atom.getName();
                if (atomName.equals("P") || atomName.matches("[HD]?OP[1-3]") || atomName.matches("O5'")) continue;
                unrecognized = true;
                break;
            }
            threePrimeCap = !unrecognized;
        }
        return threePrimeCap;
    }

    private static void assignNucleicAcidBaseAtomTypes(NucleicAcid3 nucleicAcid, Residue residue, Atom C1s, Atom O4s, Atom C2s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        double glyco = 0.0;
        Atom o4p = residue.getAtomByName("O4'", true);
        Atom c1p = residue.getAtomByName("C1'", true);
        Atom baseN = null;
        Atom baseC = null;
        if (nucleicAcid == NucleicAcid3.DAD || nucleicAcid == NucleicAcid3.DGU) {
            baseN = residue.getAtomByName("N9", true);
            baseC = residue.getAtomByName("C4", true);
        } else if (nucleicAcid == NucleicAcid3.DCY || nucleicAcid == NucleicAcid3.DTY) {
            baseN = residue.getAtomByName("N1", true);
            baseC = residue.getAtomByName("C2", true);
        }
        if (o4p != null && c1p != null && baseN != null && baseC != null) {
            double angle = DoubleMath.dihedralAngle((double[])o4p.getXYZ(null), (double[])c1p.getXYZ(null), (double[])baseN.getXYZ(null), (double[])baseC.getXYZ(null));
            glyco = FastMath.toDegrees((double)angle);
        }
        switch (nucleicAcid.ordinal()) {
            case 0: {
                NucleicAcidUtils.buildADE(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 22: {
                NucleicAcidUtils.buildM1MA(residue, C1s, forceField, bondList);
                break;
            }
            case 2: {
                NucleicAcidUtils.buildCYT(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 16: {
                NucleicAcidUtils.buildOMC(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 19: {
                NucleicAcidUtils.buildM5MC(residue, C1s, forceField, bondList);
                break;
            }
            case 1: {
                NucleicAcidUtils.buildGUA(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 17: {
                NucleicAcidUtils.buildOMG(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 23: {
                NucleicAcidUtils.buildYYG(residue, C1s, forceField, bondList);
                break;
            }
            case 13: {
                NucleicAcidUtils.buildM2MG(residue, C1s, forceField, bondList);
                break;
            }
            case 15: {
                NucleicAcidUtils.buildM2G(residue, C1s, forceField, bondList);
                break;
            }
            case 20: {
                NucleicAcidUtils.buildM7MG(residue, C1s, forceField, bondList);
                break;
            }
            case 3: {
                NucleicAcidUtils.buildURI(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 18: {
                NucleicAcidUtils.buildPSU(residue, C1s, forceField, bondList);
                break;
            }
            case 14: {
                NucleicAcidUtils.buildH2U(residue, C1s, forceField, bondList);
                break;
            }
            case 21: {
                NucleicAcidUtils.buildM5MU(residue, C1s, forceField, bondList);
                break;
            }
            case 4: {
                NucleicAcidUtils.buildDAD(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 6: {
                NucleicAcidUtils.buildDCY(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 5: {
                NucleicAcidUtils.buildDGU(residue, C1s, O4s, C2s, glyco, forceField, bondList);
                break;
            }
            case 7: {
                NucleicAcidUtils.buildDTY(residue, C1s, O4s, C2s, glyco, forceField, bondList);
            }
        }
    }

    private static Residue buildADE(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1017, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1.37, C1s, 128.4, O4s, glyco + 180.0, 0, 1021, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1.3, N9, 113.8, C1s, 180.0, 0, 1020, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1.39, C8, 104.0, N9, 0.0, 0, 1019, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.4, N7, 132.4, C8, 180.0, 0, 1025, forceField, bondList);
        Atom N6 = BondedUtils.buildHeavy(residue, "N6", C6, 1.34, C5, 123.5, N7, 0.0, 0, 1027, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1.35, C5, 117.4, N7, 180.0, 0, 1024, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.33, C6, 118.8, C5, 0.0, 0, 1023, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.32, N1, 129.2, C6, 0.0, 0, 1022, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.35, C2, 110.9, N1, 0.0, 0, 1018, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.1, C5, 180.0, 0, 1030, forceField, bondList);
        BondedUtils.buildH(residue, "H61", N6, 1.0, C6, 120.0, N7, 180.0, 0, 1028, forceField, bondList);
        BondedUtils.buildH(residue, "H62", N6, 1.0, C6, 120.0, N7, 0.0, 0, 1029, forceField, bondList);
        BondedUtils.buildH(residue, "H2", C2, 1.08, N3, 115.4, C4, 180.0, 0, 1026, forceField, bondList);
        return residue;
    }

    private static Residue buildCYT(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1078, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.37, C1s, 117.8, O4s, glyco + 180.0, 0, 1079, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1.24, N1, 118.9, C1s, 0.0, 0, 1084, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.38, N1, 118.7, C1s, 180.0, 0, 1080, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.34, C2, 120.6, N1, 0.0, 0, 1081, forceField, bondList);
        Atom N4 = BondedUtils.buildHeavy(residue, "N4", C4, 1.32, N3, 118.3, O2, 180.0, 0, 1085, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C4, 1.43, N3, 121.6, C2, 0.0, 0, 1082, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.36, C4, 116.9, N3, 0.0, 0, 1083, forceField, bondList);
        BondedUtils.buildBond(C6, N1, forceField, bondList);
        BondedUtils.buildH(residue, "H41", N4, 1.0, C4, 120.0, N3, 0.0, 0, 1086, forceField, bondList);
        BondedUtils.buildH(residue, "H42", N4, 1.0, C4, 120.0, N3, 180.0, 0, 1087, forceField, bondList);
        BondedUtils.buildH(residue, "H5", C5, 1.08, C4, 121.6, N3, 180.0, 0, 1088, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 119.4, C4, 180.0, 0, 1089, forceField, bondList);
        return residue;
    }

    private static Residue buildDAD(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1132, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1.37, C1s, 128.4, O4s, glyco + 180.0, 0, 1136, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1.3, N9, 113.8, C1s, 180.0, 0, 1135, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1.39, C8, 104.0, N9, 0.0, 0, 1134, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.4, N7, 132.4, C8, 180.0, 0, 1140, forceField, bondList);
        Atom N6 = BondedUtils.buildHeavy(residue, "N6", C6, 1.34, C5, 123.5, N7, 0.0, 0, 1142, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1.35, C5, 117.4, N7, 180.0, 0, 1139, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.33, C6, 118.8, C5, 0.0, 0, 1138, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.32, N1, 129.2, C6, 0.0, 0, 1137, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.35, C2, 110.9, N1, 0.0, 0, 1133, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.1, C5, 180.0, 0, 1145, forceField, bondList);
        BondedUtils.buildH(residue, "H61", N6, 1.0, C6, 120.0, N7, 180.0, 0, 1143, forceField, bondList);
        BondedUtils.buildH(residue, "H62", N6, 1.0, C6, 120.0, N7, 0.0, 0, 1144, forceField, bondList);
        BondedUtils.buildH(residue, "H2", C2, 1.08, N3, 115.4, C4, 180.0, 0, 1141, forceField, bondList);
        return residue;
    }

    private static Residue buildDCY(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1191, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.37, C1s, 117.8, O4s, glyco, 0, 1192, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1.24, N1, 118.9, C1s, 0.0, 0, 1197, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.38, N1, 118.7, C1s, 180.0, 0, 1193, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.34, C2, 120.6, N1, 0.0, 0, 1194, forceField, bondList);
        Atom N4 = BondedUtils.buildHeavy(residue, "N4", C4, 1.32, N3, 118.3, C2, 180.0, 0, 1198, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C4, 1.43, N3, 121.6, C2, 0.0, 0, 1195, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.36, C4, 116.9, N3, 0.0, 0, 1196, forceField, bondList);
        BondedUtils.buildBond(C6, N1, forceField, bondList);
        BondedUtils.buildH(residue, "H41", N4, 1.0, C4, 120.0, N3, 0.0, 0, 1199, forceField, bondList);
        BondedUtils.buildH(residue, "H42", N4, 1.0, C4, 120.0, N3, 180.0, 0, 1200, forceField, bondList);
        BondedUtils.buildH(residue, "H5", C5, 1.08, C4, 121.6, N3, 180.0, 0, 1201, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 119.4, C4, 180.0, 0, 1202, forceField, bondList);
        return residue;
    }

    private static Residue buildDGU(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1161, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1.38, C1s, 128.4, O4s, glyco + 180.0, 0, 1165, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1.31, N9, 114.0, C1s, 180.0, 0, 1164, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1.39, C8, 103.8, N9, 0.0, 0, 1163, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.4, N7, 130.1, C8, 180.0, 0, 1169, forceField, bondList);
        Atom O6 = BondedUtils.buildHeavy(residue, "O6", C6, 1.23, C5, 128.8, N7, 0.0, 0, 1174, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1.4, C5, 111.4, N7, 180.0, 0, 1168, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.38, C6, 125.2, C5, 0.0, 0, 1167, forceField, bondList);
        Atom N2 = BondedUtils.buildHeavy(residue, "N2", C2, 1.34, N1, 116.1, C6, 180.0, 0, 1171, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.33, N1, 123.3, O6, 0.0, 0, 1166, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.36, C2, 112.3, N1, 0.0, 0, 1162, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.0, C5, 180.0, 0, 1175, forceField, bondList);
        BondedUtils.buildH(residue, "H1", N1, 1.0, C6, 117.4, C5, 180.0, 0, 1170, forceField, bondList);
        BondedUtils.buildH(residue, "H21", N2, 1.0, C2, 120.0, N1, 0.0, 0, 1172, forceField, bondList);
        BondedUtils.buildH(residue, "H22", N2, 1.0, C2, 120.0, N1, 180.0, 0, 1173, forceField, bondList);
        return residue;
    }

    private static Residue buildDTY(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1218, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.37, C1s, 117.1, O4s, glyco, 0, 1219, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1.22, N1, 122.9, C1s, 0.0, 0, 1224, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.38, N1, 115.4, C1s, 180.0, 0, 1220, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.38, C2, 126.4, N1, 0.0, 0, 1221, forceField, bondList);
        Atom O4 = BondedUtils.buildHeavy(residue, "O4", C4, 1.23, N3, 120.5, C2, 180.0, 0, 1226, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C4, 1.44, N3, 114.1, C2, 0.0, 0, 1222, forceField, bondList);
        Atom C7 = BondedUtils.buildHeavy(residue, "C7", C5, 1.5, C4, 117.5, N3, 180.0, 0, 1227, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.34, C4, 120.8, N3, 0.0, 0, 1223, forceField, bondList);
        BondedUtils.buildBond(C6, N1, forceField, bondList);
        BondedUtils.buildH(residue, "H3", N3, 1.0, C2, 116.8, N1, 180.0, 0, 1225, forceField, bondList);
        Atom H = BondedUtils.buildH(residue, "H71", C7, 1.09, C5, 109.5, C4, 0.0, 0, 1228, forceField, bondList);
        BondedUtils.buildH(residue, "H72", C7, 1.09, C5, 109.5, H, 109.5, 1, 1228, forceField, bondList);
        BondedUtils.buildH(residue, "H73", C7, 1.09, C5, 109.5, H, 109.5, -1, 1228, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 119.4, C4, 180.0, 0, 1229, forceField, bondList);
        return residue;
    }

    private static Residue buildGUA(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1047, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1.38, C1s, 128.4, O4s, glyco + 180.0, 0, 1051, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1.31, N9, 114.0, C1s, 180.0, 0, 1050, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1.39, C8, 103.8, N9, 0.0, 0, 1049, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.4, N7, 130.1, C8, 180.0, 0, 1055, forceField, bondList);
        Atom O6 = BondedUtils.buildHeavy(residue, "O6", C6, 1.23, C5, 128.8, N7, 0.0, 0, 1060, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1.4, C5, 111.4, N7, 180.0, 0, 1054, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.38, C6, 125.2, C5, 0.0, 0, 1053, forceField, bondList);
        Atom N2 = BondedUtils.buildHeavy(residue, "N2", C2, 1.34, N1, 116.1, C6, 180.0, 0, 1057, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.33, N1, 123.3, O6, 0.0, 0, 1052, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.36, C2, 112.3, N1, 0.0, 0, 1048, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.0, C5, 180.0, 0, 1061, forceField, bondList);
        BondedUtils.buildH(residue, "H1", N1, 1.0, C6, 117.4, C5, 180.0, 0, 1056, forceField, bondList);
        BondedUtils.buildH(residue, "H21", N2, 1.0, C2, 120.0, N1, 0.0, 0, 1058, forceField, bondList);
        BondedUtils.buildH(residue, "H22", N2, 1.0, C2, 120.0, N1, 180.0, 0, 1059, forceField, bondList);
        return residue;
    }

    private static Residue buildH2U(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C1s, 1350, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1351, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1356, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1352, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1353, forceField, bondList);
        Atom O4 = BondedUtils.buildHeavy(residue, "O4", C4, 1358, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C4, 1354, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1355, forceField, bondList);
        BondedUtils.buildBond(C6, N1, forceField, bondList);
        BondedUtils.buildH(residue, "H3", N3, 1.0, C2, 116.5, N1, 180.0, 0, 1357, forceField, bondList);
        BondedUtils.buildH(residue, "H51", C5, 1.08, C4, 109.5, C6, 109.5, 1, 1359, forceField, bondList);
        BondedUtils.buildH(residue, "H52", C5, 1.08, C4, 109.5, C6, 109.5, -1, 1360, forceField, bondList);
        BondedUtils.buildH(residue, "H61", C6, 1.08, C5, 109.5, N1, 109.5, 1, 1361, forceField, bondList);
        BondedUtils.buildH(residue, "H62", C6, 1.08, C5, 109.5, N1, 109.5, -1, 1362, forceField, bondList);
        return residue;
    }

    private static Residue buildM1MA(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1605, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1609, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1608, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1607, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1613, forceField, bondList);
        Atom N6 = BondedUtils.buildHeavy(residue, "N6", C6, 1615, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1612, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1611, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1610, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1606, forceField, bondList);
        Atom CM1 = BondedUtils.buildHeavy(residue, "CM1", N1, 1619, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H2", C2, 1.08, N3, 115.4, C4, 180.0, 0, 1614, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 109.5, C4, 180.0, 0, 1623, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.1, C5, 180.0, 0, 1618, forceField, bondList);
        BondedUtils.buildH(residue, "HN61", N6, 1.0, C6, 109.5, C5, 0.0, 0, 1616, forceField, bondList);
        BondedUtils.buildH(residue, "HN62", N6, 1.0, C6, 109.5, C5, 109.5, 0, 1617, forceField, bondList);
        Atom HM11 = BondedUtils.buildH(residue, "HM11", CM1, 1.08, N1, 109.5, C2, 0.0, 0, 1620, forceField, bondList);
        BondedUtils.buildH(residue, "HM12", CM1, 1.08, N1, 109.5, HM11, 109.5, 1, 1621, forceField, bondList);
        BondedUtils.buildH(residue, "HM13", CM1, 1.08, N1, 109.5, HM11, 109.5, -1, 1622, forceField, bondList);
        return residue;
    }

    private static Residue buildM2G(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1379, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1383, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1382, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1381, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1387, forceField, bondList);
        Atom O6 = BondedUtils.buildHeavy(residue, "O6", C6, 1390, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1386, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1385, forceField, bondList);
        Atom N2 = BondedUtils.buildHeavy(residue, "N2", C2, 1389, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1384, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1380, forceField, bondList);
        Atom CM1 = BondedUtils.buildHeavy(residue, "CM1", N2, 1392, forceField, bondList);
        Atom CM2 = BondedUtils.buildHeavy(residue, "CM2", N2, 1396, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.0, C5, 180.0, 0, 1391, forceField, bondList);
        BondedUtils.buildH(residue, "H1", N1, 1.0, C6, 117.4, C5, 180.0, 0, 1388, forceField, bondList);
        Atom HM11 = BondedUtils.buildH(residue, "HM11", CM1, 1.08, N2, 109.5, C2, 0.0, 0, 1393, forceField, bondList);
        BondedUtils.buildH(residue, "HM12", CM1, 1.08, N2, 109.5, HM11, 109.5, 1, 1394, forceField, bondList);
        BondedUtils.buildH(residue, "HM13", CM1, 1.08, N2, 109.5, HM11, 109.5, -1, 1395, forceField, bondList);
        Atom HM21 = BondedUtils.buildH(residue, "HM21", CM2, 1.08, N2, 109.5, C2, 0.0, 0, 1397, forceField, bondList);
        BondedUtils.buildH(residue, "HM22", CM2, 1.08, N2, 109.5, HM21, 109.5, 1, 1398, forceField, bondList);
        BondedUtils.buildH(residue, "HM23", CM2, 1.08, N2, 109.5, HM21, 109.5, -1, 1399, forceField, bondList);
        return residue;
    }

    private static Residue buildM2MG(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1316, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1320, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1319, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1318, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1324, forceField, bondList);
        Atom O6 = BondedUtils.buildHeavy(residue, "O6", C6, 1328, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1323, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1322, forceField, bondList);
        Atom N2 = BondedUtils.buildHeavy(residue, "N2", C2, 1326, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1321, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1317, forceField, bondList);
        Atom CM2 = BondedUtils.buildHeavy(residue, "CM2", N2, 1330, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.0, C5, 180.0, 0, 1329, forceField, bondList);
        BondedUtils.buildH(residue, "H1", N1, 1.0, C6, 117.4, C5, 180.0, 0, 1325, forceField, bondList);
        BondedUtils.buildH(residue, "H2", N2, 1.0, C2, 120.0, N1, 0.0, 0, 1327, forceField, bondList);
        Atom HM21 = BondedUtils.buildH(residue, "HM21", CM2, 1.08, N2, 109.5, C2, 0.0, 0, 1331, forceField, bondList);
        BondedUtils.buildH(residue, "HM22", CM2, 1.08, N2, 109.5, HM21, 109.5, 1, 1332, forceField, bondList);
        BondedUtils.buildH(residue, "HM23", CM2, 1.08, N2, 109.5, HM21, 109.5, -1, 1333, forceField, bondList);
        return residue;
    }

    private static Residue buildM5MC(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C1s, 1508, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1509, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1514, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1510, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1511, forceField, bondList);
        Atom N4 = BondedUtils.buildHeavy(residue, "N4", C4, 1515, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C4, 1512, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1513, forceField, bondList);
        Atom CM5 = BondedUtils.buildHeavy(residue, "CM5", C5, 1519, forceField, bondList);
        BondedUtils.buildBond(C6, N1, forceField, bondList);
        BondedUtils.buildH(residue, "H41", N4, 1.0, C4, 120.0, N3, 0.0, 0, 1516, forceField, bondList);
        BondedUtils.buildH(residue, "H42", N4, 1.0, C4, 120.0, C5, 0.0, 0, 1517, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 119.4, C4, 180.0, 0, 1518, forceField, bondList);
        Atom HM51 = BondedUtils.buildH(residue, "HM51", CM5, 1.08, C5, 109.5, C4, 0.0, 0, 1520, forceField, bondList);
        BondedUtils.buildH(residue, "HM52", CM5, 1.08, C5, 109.5, HM51, 109.5, 1, 1521, forceField, bondList);
        BondedUtils.buildH(residue, "HM53", CM5, 1.08, C5, 109.5, HM51, 109.5, -1, 1522, forceField, bondList);
        return residue;
    }

    private static Residue buildM5MU(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C1s, 1575, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1576, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1581, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1577, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1578, forceField, bondList);
        Atom O4 = BondedUtils.buildHeavy(residue, "O4", C4, 1583, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C4, 1579, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1580, forceField, bondList);
        Atom C5M = BondedUtils.buildHeavy(residue, "C5M", C5, 1585, forceField, bondList);
        BondedUtils.buildBond(C6, N1, forceField, bondList);
        BondedUtils.buildH(residue, "H3", N3, 1.0, C2, 116.5, N1, 180.0, 0, 1582, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 118.6, C4, 180.0, 0, 1584, forceField, bondList);
        Atom H5M1 = BondedUtils.buildH(residue, "H5M1", C5M, 1.08, C5, 109.5, C6, 0.0, 0, 1586, forceField, bondList);
        BondedUtils.buildH(residue, "H5M2", C5M, 1.08, C5, 109.5, H5M1, 109.5, 1, 1587, forceField, bondList);
        BondedUtils.buildH(residue, "H5M3", C5M, 1.08, C5, 109.5, H5M1, 109.5, -1, 1588, forceField, bondList);
        return residue;
    }

    private static Residue buildM7MG(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1539, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1543, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1542, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1541, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1547, forceField, bondList);
        Atom O6 = BondedUtils.buildHeavy(residue, "O6", C6, 1552, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1546, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1545, forceField, bondList);
        Atom N2 = BondedUtils.buildHeavy(residue, "N2", C2, 1549, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1544, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1540, forceField, bondList);
        Atom CM7 = BondedUtils.buildHeavy(residue, "CM7", N7, 1555, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildH(residue, "H81", C8, 1.08, N7, 109.5, N9, 109.5, 1, 1553, forceField, bondList);
        BondedUtils.buildH(residue, "H82", C8, 1.08, N7, 109.5, N9, 109.5, -1, 1554, forceField, bondList);
        BondedUtils.buildH(residue, "H1", N1, 1.0, C6, 117.4, C5, 180.0, 0, 1548, forceField, bondList);
        BondedUtils.buildH(residue, "H21", N2, 1.0, C2, 120.0, N1, 0.0, 0, 1550, forceField, bondList);
        BondedUtils.buildH(residue, "H22", N2, 1.0, C2, 120.0, N3, 0.0, 0, 1551, forceField, bondList);
        Atom HM71 = BondedUtils.buildH(residue, "HM71", CM7, 1.08, N7, 109.5, C8, 0.0, 0, 1556, forceField, bondList);
        BondedUtils.buildH(residue, "HM72", CM7, 1.08, N7, 109.5, HM71, 109.5, 1, 1557, forceField, bondList);
        BondedUtils.buildH(residue, "HM73", CM7, 1.08, N7, 109.5, HM71, 109.5, -1, 1558, forceField, bondList);
        return residue;
    }

    private static Residue buildOMC(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        return NucleicAcidUtils.buildCYT(residue, C1s, O4s, C2s, glyco, forceField, bondList);
    }

    private static Residue buildOMG(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        return NucleicAcidUtils.buildGUA(residue, C1s, O4s, C2s, glyco, forceField, bondList);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void buildOP3(Residue residue, Atom phosphate, int aType, ForceField forceField, List<Bond> bondList, Residue adjacentResidue, boolean at5prime) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom P = null;
        Atom OP1 = null;
        Atom OP2 = null;
        Atom riboOxygen = null;
        Atom riboCarbon = null;
        boolean foundOP3 = false;
        List<Atom> residueAtoms = residue.getAtomList();
        block16: for (Atom at : residueAtoms) {
            String atName;
            switch (atName = at.getName().toUpperCase()) {
                case "OP3": {
                    BondedUtils.buildHeavy(residue, "OP3", phosphate, aType, forceField, bondList);
                    foundOP3 = true;
                    break block16;
                }
                case "OP1": {
                    OP1 = at;
                    break;
                }
                case "OP2": {
                    OP2 = at;
                    break;
                }
                case "P": {
                    P = at;
                    break;
                }
                case "O5'": {
                    riboOxygen = at;
                    break;
                }
                case "C5'": {
                    riboCarbon = at;
                }
            }
        }
        if (!at5prime) {
            riboOxygen = (Atom)adjacentResidue.getAtomNode("O3'");
            riboCarbon = (Atom)adjacentResidue.getAtomNode("C3'");
            if (riboCarbon == null || riboOxygen == null) {
                logger.severe(String.format(" Could not find either O3' or C3' in residue %s prior to presumed 3' phosphate cap %s", adjacentResidue, residue));
            }
        }
        if (foundOP3) return;
        logger.fine(String.format(" EXPERIMENTAL: OP3 of residue %s not found, being rebuilt based on ideal geometry", residue));
        if (P == null || OP1 == null || OP2 == null) {
            throw new IllegalArgumentException(String.format(" Attempted to build OP3 for residue %s, but one of P, OP1, OP2, O5', or C5' were null", residue));
        }
        if (at5prime) {
            if (riboOxygen == null) {
                logger.fine(" Attempting to find O5' of subsequent residue");
                riboOxygen = NucleicAcidUtils.getNextResAtom(residue, adjacentResidue, "O5'");
            }
            if (riboCarbon == null) {
                logger.fine(" Attempting to find C5' of subsequent residue");
                riboCarbon = NucleicAcidUtils.getNextResAtom(residue, adjacentResidue, "C5'");
            }
        }
        double[] xyzOP1 = new double[3];
        double[] xyzP = new double[3];
        xyzOP1 = OP1.getXYZ(xyzOP1);
        xyzP = P.getXYZ(xyzP);
        double distance = DoubleMath.dist((double[])xyzP, (double[])xyzOP1);
        double[] xyzRiboO = new double[3];
        xyzRiboO = riboOxygen.getXYZ(xyzRiboO);
        double angle = FastMath.toDegrees((double)DoubleMath.bondAngle((double[])xyzRiboO, (double[])xyzP, (double[])xyzOP1));
        double[] xyzRiboC = new double[3];
        xyzRiboC = riboCarbon.getXYZ(xyzRiboC);
        double dihedralOP1 = FastMath.toDegrees((double)DoubleMath.dihedralAngle((double[])xyzRiboC, (double[])xyzRiboO, (double[])xyzP, (double[])xyzOP1));
        Atom OP3 = BondedUtils.buildH(residue, "OP3", P, distance, riboOxygen, angle, riboCarbon, dihedralOP1 + 120.0, 0, aType, forceField, bondList);
        double[] xyzOP2 = new double[3];
        xyzOP2 = OP2.getXYZ(xyzOP2);
        double[] xyzChiral1 = new double[3];
        xyzChiral1 = OP3.getXYZ(xyzChiral1);
        double distChiral1 = DoubleMath.dist((double[])xyzChiral1, (double[])xyzOP2);
        BondedUtils.intxyz(OP3, P, distance, riboOxygen, angle, riboCarbon, dihedralOP1 + 240.0, 0);
        double[] xyzChiral2 = new double[3];
        xyzChiral2 = OP3.getXYZ(xyzChiral2);
        double distChiral2 = DoubleMath.dist((double[])xyzChiral2, (double[])xyzOP2);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Bond: %10.5f Angle: %10.5f Dihedral: %10.5f", distance, angle, dihedralOP1));
            logger.fine(String.format(" OP2 position: %s", Arrays.toString(xyzOP2)));
            logger.fine(String.format(" Position 1: %10.6g %10.6g %10.6g with distance %10.6g", xyzChiral1[0], xyzChiral1[1], xyzChiral1[2], distChiral1));
            logger.fine(String.format(" Position 2: %10.6g %10.6g %10.6g with distance %10.6g", xyzChiral2[0], xyzChiral2[1], xyzChiral2[2], distChiral2));
        }
        if (distChiral1 > distChiral2) {
            logger.fine(" Picked dihedral +120");
            OP3.setXYZ(xyzChiral1);
            return;
        }
        logger.fine(" Picked dihedral +240");
        OP3.setXYZ(xyzChiral2);
    }

    private static Residue buildPSU(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C1s, 1485, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1486, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1481, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1482, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1487, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1483, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1484, forceField, bondList);
        Atom O4 = BondedUtils.buildHeavy(residue, "O4", C4, 1489, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildH(residue, "H1", N1, 1.0, C2, 120.0, O2, 0.0, 0, 1491, forceField, bondList);
        BondedUtils.buildH(residue, "H3", N3, 1.0, C2, 120.0, O2, 0.0, 0, 1488, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 120.0, C1s, 0.0, 0, 1490, forceField, bondList);
        return residue;
    }

    private static Atom buildSugarO5(Residue residue, int lookUp, ForceField forceField) {
        Atom C5 = residue.getAtomByName("C5'", true);
        Atom C4 = residue.getAtomByName("C4'", true);
        Atom C3 = residue.getAtomByName("C3'", true);
        return BondedUtils.buildHeavy((MSGroup)residue, "O5'", C5, 1.43, C4, 109.5, C3, 180.0, 0, 1244, forceField);
    }

    private static Residue buildURI(Residue residue, Atom C1s, Atom O4s, Atom C2s, double glyco, ForceField forceField, List<Bond> bondList) {
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C1s, 1.48, O4s, 108.1, C2s, 113.7, 1, 1106, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1.38, C1s, 117.1, O4s, glyco, 0, 1107, forceField, bondList);
        Atom O2 = BondedUtils.buildHeavy(residue, "O2", C2, 1.22, N1, 123.2, C1s, 0.0, 0, 1112, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1.37, N1, 114.8, C1s, 180.0, 0, 1108, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1.38, C2, 127.0, N1, 0.0, 0, 1109, forceField, bondList);
        Atom O4 = BondedUtils.buildHeavy(residue, "O4", C4, 1.23, N3, 119.8, C2, 180.0, 0, 1114, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", C4, 1.44, N3, 114.7, C2, 0.0, 0, 1110, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1.34, O4, 119.2, C4, 0.0, 0, 1111, forceField, bondList);
        BondedUtils.buildBond(C6, N1, forceField, bondList);
        BondedUtils.buildH(residue, "H3", N3, 1.0, C2, 116.5, N1, 180.0, 0, 1113, forceField, bondList);
        BondedUtils.buildH(residue, "H5", C5, 1.08, C4, 120.4, N3, 180.0, 0, 1115, forceField, bondList);
        BondedUtils.buildH(residue, "H6", C6, 1.08, C5, 118.6, C4, 180.0, 0, 1116, forceField, bondList);
        return residue;
    }

    private static Residue buildYYG(Residue residue, Atom C1s, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        Atom N9 = BondedUtils.buildHeavy(residue, "N9", C1s, 1640, forceField, bondList);
        Atom C8 = BondedUtils.buildHeavy(residue, "C8", N9, 1644, forceField, bondList);
        Atom N7 = BondedUtils.buildHeavy(residue, "N7", C8, 1643, forceField, bondList);
        Atom C5 = BondedUtils.buildHeavy(residue, "C5", N7, 1642, forceField, bondList);
        Atom C6 = BondedUtils.buildHeavy(residue, "C6", C5, 1648, forceField, bondList);
        Atom O6 = BondedUtils.buildHeavy(residue, "O6", C6, 1650, forceField, bondList);
        Atom N1 = BondedUtils.buildHeavy(residue, "N1", C6, 1647, forceField, bondList);
        Atom C2 = BondedUtils.buildHeavy(residue, "C2", N1, 1646, forceField, bondList);
        Atom N2 = BondedUtils.buildHeavy(residue, "N2", C2, 1649, forceField, bondList);
        Atom N3 = BondedUtils.buildHeavy(residue, "N3", C2, 1645, forceField, bondList);
        Atom C3 = BondedUtils.buildHeavy(residue, "C3", N3, 1652, forceField, bondList);
        Atom C4 = BondedUtils.buildHeavy(residue, "C4", N3, 1641, forceField, bondList);
        Atom C11 = BondedUtils.buildHeavy(residue, "C11", N2, 1657, forceField, bondList);
        Atom C10 = BondedUtils.buildHeavy(residue, "C10", C11, 1658, forceField, bondList);
        Atom C12 = BondedUtils.buildHeavy(residue, "C12", C11, 1656, forceField, bondList);
        Atom C13 = BondedUtils.buildHeavy(residue, "C13", C12, 1662, forceField, bondList);
        Atom C14 = BondedUtils.buildHeavy(residue, "C14", C13, 1665, forceField, bondList);
        Atom C15 = BondedUtils.buildHeavy(residue, "C15", C14, 1668, forceField, bondList);
        Atom C16 = BondedUtils.buildHeavy(residue, "C16", C15, 1675, forceField, bondList);
        Atom O17 = BondedUtils.buildHeavy(residue, "O17", C16, 1676, forceField, bondList);
        Atom O18 = BondedUtils.buildHeavy(residue, "O18", C16, 1674, forceField, bondList);
        Atom C19 = BondedUtils.buildHeavy(residue, "C19", O18, 1670, forceField, bondList);
        Atom N20 = BondedUtils.buildHeavy(residue, "N20", C15, 1677, forceField, bondList);
        Atom C21 = BondedUtils.buildHeavy(residue, "C21", N20, 1679, forceField, bondList);
        Atom O22 = BondedUtils.buildHeavy(residue, "O22", C21, 1680, forceField, bondList);
        Atom O23 = BondedUtils.buildHeavy(residue, "O23", C21, 1681, forceField, bondList);
        Atom C24 = BondedUtils.buildHeavy(residue, "C24", O23, 1682, forceField, bondList);
        BondedUtils.buildBond(C4, C5, forceField, bondList);
        BondedUtils.buildBond(C4, N9, forceField, bondList);
        BondedUtils.buildBond(N1, C12, forceField, bondList);
        BondedUtils.buildH(residue, "H8", C8, 1.08, N7, 123.0, C5, 180.0, 0, 1651, forceField, bondList);
        Atom H31 = BondedUtils.buildH(residue, "H31", C3, 1.08, N3, 109.5, C4, 0.0, 0, 1653, forceField, bondList);
        BondedUtils.buildH(residue, "H32", C3, 1.08, N3, 109.5, H31, 109.5, 1, 1654, forceField, bondList);
        BondedUtils.buildH(residue, "H33", C3, 1.08, N3, 109.5, H31, 109.5, -1, 1655, forceField, bondList);
        Atom H101 = BondedUtils.buildH(residue, "H101", C10, 1.08, C11, 109.5, N2, 0.0, 0, 1659, forceField, bondList);
        BondedUtils.buildH(residue, "H102", C10, 1.08, C11, 109.5, H101, 109.5, 1, 1660, forceField, bondList);
        BondedUtils.buildH(residue, "H103", C10, 1.08, C11, 109.5, H101, 109.5, -1, 1661, forceField, bondList);
        BondedUtils.buildH(residue, "H131", C13, 1.08, C12, 109.5, C14, 109.5, 1, 1663, forceField, bondList);
        BondedUtils.buildH(residue, "H132", C13, 1.08, C12, 109.5, C14, 109.5, -1, 1664, forceField, bondList);
        BondedUtils.buildH(residue, "H141", C14, 1.08, C13, 109.5, C15, 109.5, 1, 1666, forceField, bondList);
        BondedUtils.buildH(residue, "H142", C14, 1.08, C13, 109.5, C15, 109.5, -1, 1667, forceField, bondList);
        BondedUtils.buildH(residue, "H15", C15, 1.08, C14, 109.5, O18, 180.0, 0, 1669, forceField, bondList);
        Atom H191 = BondedUtils.buildH(residue, "H191", C19, 1.08, O18, 109.5, C16, 0.0, 0, 1671, forceField, bondList);
        BondedUtils.buildH(residue, "H192", C19, 1.08, O18, 109.5, H191, 109.5, 1, 1672, forceField, bondList);
        BondedUtils.buildH(residue, "H193", C19, 1.08, O18, 109.5, H191, 109.5, -1, 1673, forceField, bondList);
        BondedUtils.buildH(residue, "HN2", N20, 1.0, C15, 109.5, O22, 180.0, 0, 1678, forceField, bondList);
        Atom H241 = BondedUtils.buildH(residue, "H241", C24, 1.08, O23, 109.5, C21, 0.0, 0, 1683, forceField, bondList);
        BondedUtils.buildH(residue, "H242", C24, 1.08, O23, 109.5, H241, 109.5, 1, 1684, forceField, bondList);
        BondedUtils.buildH(residue, "H243", C24, 1.08, O23, 109.5, H241, 109.5, -1, 1685, forceField, bondList);
        return residue;
    }

    private static Atom getNextResAtom(Residue residue, Residue nextResidue, String atomName) {
        if (nextResidue == null) {
            throw new IllegalArgumentException(String.format(" Residue %s: No subsequent residue to find atom %s in!", residue, atomName));
        }
        List<Atom> nrAtoms = nextResidue.getAtomList();
        for (Atom atom : nrAtoms) {
            if (!atom.getName().equalsIgnoreCase(atomName)) continue;
            return atom;
        }
        throw new IllegalArgumentException(String.format(" Residue %s: Subsequent residue %s did not contain an atom %s", residue, nextResidue, atomName));
    }

    public static int getNucleicAcidNumber(String residueName) {
        int nucleicAcidNumber = -1;
        for (NucleicAcid3 nucleicAcid : nucleicAcidList) {
            ++nucleicAcidNumber;
            if (!nucleicAcid.toString().equalsIgnoreCase(residueName)) continue;
            break;
        }
        return nucleicAcidNumber;
    }

    static {
        NAPATTERN = new int[]{8, 6, 6, 6, 8};
        newNucleicAcidAtomNames = Map.of("HO'", "HO2'", "H3T", "HO3'", "H5'1", "H5'", "H5'2", "H5''", "H5T", "HO5'", "H2'1", "H2'", "H2'2", "H2''");
        NucleicAcid1[] na1 = NucleicAcid1.values();
        NucleicAcid3[] na3 = NucleicAcid3.values();
        for (int i = 0; i < NucleicAcid1.values().length; ++i) {
            NA1toNA3.put(na1[i], na3[i]);
        }
    }

    public static enum NucleicAcid3 {
        ADE,
        GUA,
        CYT,
        URI,
        DAD,
        DGU,
        DCY,
        DTY,
        THY,
        MP1,
        DP2,
        TP3,
        UNK,
        M2MG,
        H2U,
        M2G,
        OMC,
        OMG,
        PSU,
        M5MC,
        M7MG,
        M5MU,
        M1MA,
        YYG;


        public static NucleicAcid3 parse(String name) throws IllegalArgumentException {
            return switch (name.toUpperCase()) {
                case "ADE", "A" -> ADE;
                case "CYT", "C" -> CYT;
                case "GUA", "G" -> GUA;
                case "URI", "U" -> URI;
                case "DAD", "DA" -> DAD;
                case "DCY", "DC" -> DCY;
                case "DGU", "DG" -> DGU;
                case "DTY", "THY", "DT" -> DTY;
                case "MPO" -> MP1;
                case "DPO" -> DP2;
                case "TPO" -> TP3;
                case "DU" -> throw new IllegalArgumentException(" No NA3 value exists for deoxy-uracil!");
                default -> UNK;
            };
        }
    }

    public static enum NucleicAcid1 {
        A,
        G,
        C,
        U,
        D,
        B,
        I,
        T,
        O,
        W,
        H,
        X;

    }

    public static enum NA {
        ADENINE,
        CYTOSINE,
        GUANINE,
        URACIL,
        DEOXYADENINE,
        DEOXYCYTOSINE,
        DEOXYGUANINE,
        THYMINE,
        MONOPHOSPHATE,
        DIPHOSPHATE,
        TRIPHOSPHATE;

    }
}

