/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.math.DoubleMath;
import ffx.numerics.math.ScalarMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.parsers.PDBFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamingUtils {
    private static final Logger logger = Logger.getLogger(NamingUtils.class.getName());

    public static void checkHydrogenAtomNames(Residue residue, PDBFilter.PDBFileStandard fileStandard) {
        switch (fileStandard) {
            case VERSION3_3: {
                return;
            }
        }
        String residueType = residue.getName().toUpperCase();
        List<Atom> resAtoms = residue.getAtomList();
        for (Atom atom : resAtoms) {
            String atomName;
            if (atom == null || !(atomName = atom.getName().toUpperCase()).contains("H")) continue;
            try {
                String firstChar = atomName.substring(0, 1);
                Integer.parseInt(firstChar);
                atomName = atomName.substring(1);
                atomName = atomName.concat(firstChar);
                atom.setName(atomName);
            }
            catch (NumberFormatException firstChar) {}
        }
        block4 : switch (AminoAcidUtils.getAminoAcid(residueType)) {
            case GLY: {
                ArrayList<Atom> alphas = new ArrayList<Atom>();
                for (Atom atom : resAtoms) {
                    if (!atom.getName().toUpperCase().contains("HA")) continue;
                    alphas.add(atom);
                }
                NamingUtils.renameGlycineAlphaHydrogen(residue, alphas);
                break;
            }
            case ALA: {
                break;
            }
            case VAL: {
                break;
            }
            case LEU: 
            case SER: 
            case CYD: 
            case ASP: {
                ArrayList<Atom> betas = new ArrayList<Atom>();
                for (Atom atom : resAtoms) {
                    if (!atom.getName().toUpperCase().contains("HB")) continue;
                    betas.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                break;
            }
            case ILE: {
                ArrayList<Atom> ileAtoms = new ArrayList<Atom>();
                for (Atom atom : resAtoms) {
                    if (!atom.getName().toUpperCase().contains("HG1")) continue;
                    ileAtoms.add(atom);
                }
                NamingUtils.renameIsoleucineHydrogen(residue, ileAtoms);
                break;
            }
            case THR: {
                Atom HG1 = (Atom)residue.getAtomNode("HG1");
                if (HG1 != null) break;
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.length() >= 4 || !atomName.contains("HG")) continue;
                    atom.setName("HG1");
                    break block4;
                }
                break;
            }
            case CYS: {
                ArrayList<Atom> betas = new ArrayList();
                Atom HG = (Atom)residue.getAtomNode("HG");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (HG != null || !atomName.contains("HG")) continue;
                    HG = atom;
                    HG.setName("HG");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                break;
            }
            case CYX: {
                break;
            }
            case PRO: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList<Atom>();
                ArrayList<Atom> deltas = new ArrayList();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HG")) {
                        gammas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HD")) continue;
                    deltas.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 23);
                break;
            }
            case PHE: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList<Atom>();
                ArrayList<Atom> epsilons = new ArrayList();
                Atom HZ = (Atom)residue.getAtomNode("HZ");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HE")) {
                        epsilons.add(atom);
                        continue;
                    }
                    if (HZ != null || !atomName.contains("HZ")) continue;
                    HZ = atom;
                    HZ.setName("HZ");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 12);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 12);
                break;
            }
            case TYR: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                Atom HH = (Atom)residue.getAtomNode("HH");
                Atom OH = (Atom)residue.getAtomNode("OH");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HE")) {
                        epsilons.add(atom);
                        continue;
                    }
                    if (HH == null && atomName.contains("HH")) {
                        HH = atom;
                        HH.setName("HH");
                        continue;
                    }
                    if (OH != null || !atomName.contains("O") || !atomName.contains("H")) continue;
                    OH = atom;
                    OH.setName("OH");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 12);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 12);
                break;
            }
            case TYD: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                Atom OH = (Atom)residue.getAtomNode("OH");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HE")) {
                        epsilons.add(atom);
                        continue;
                    }
                    if (OH != null || !atomName.contains("O") || !atomName.contains("H")) continue;
                    OH = atom;
                    OH.setName("OH");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 12);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 12);
                break;
            }
            case TRP: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList<Atom>();
                ArrayList<Atom> zetas = new ArrayList<Atom>();
                Atom HD1 = (Atom)residue.getAtomNode("HD1");
                Atom HH2 = (Atom)residue.getAtomNode("HH2");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HE")) {
                        epsilons.add(atom);
                        continue;
                    }
                    if (atomName.contains("HZ")) {
                        zetas.add(atom);
                        continue;
                    }
                    if (HD1 == null && atomName.contains("HD")) {
                        HD1 = atom;
                        HD1.setName("HD1");
                        continue;
                    }
                    if (HH2 != null || !atomName.contains("HH")) continue;
                    HH2 = atom;
                    HH2.setName("HH2");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 13);
                NamingUtils.renameZetaHydrogen(residue, zetas, 23);
                break;
            }
            case HIS: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HE")) continue;
                    epsilons.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 12);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 12);
                break;
            }
            case HID: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                Atom HE1 = (Atom)residue.getAtomNode("HE1");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (HE1 != null || !atomName.contains("HE")) continue;
                    HE1 = atom;
                    HE1.setName("HE1");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 12);
                break;
            }
            case HIE: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                Atom HD2 = (Atom)residue.getAtomNode("HD2");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HE")) {
                        epsilons.add(atom);
                        continue;
                    }
                    if (HD2 != null || !atomName.contains("HD")) continue;
                    HD2 = atom;
                    HD2.setName("HD2");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 12);
                break;
            }
            case ASH: {
                ArrayList<Atom> betas = new ArrayList();
                Atom HD2 = (Atom)residue.getAtomNode("HD2");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (HD2 != null || !atomName.contains("HD")) continue;
                    HD2 = atom;
                    HD2.setName("HD2");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                break;
            }
            case ASD: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HD")) continue;
                    deltas.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 12);
                break;
            }
            case ASN: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> HD2s = new ArrayList<Atom>();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HD")) continue;
                    HD2s.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameAsparagineHydrogen(residue, HD2s);
                break;
            }
            case GLU: 
            case MET: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HG")) continue;
                    gammas.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                break;
            }
            case GLH: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList();
                Atom HE2 = (Atom)residue.getAtomNode("HE2");
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HG")) {
                        gammas.add(atom);
                        continue;
                    }
                    if (HE2 != null || !atomName.contains("HE")) continue;
                    HE2 = atom;
                    HE2.setName("HE2");
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                break;
            }
            case GLD: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HG")) {
                        gammas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HE")) continue;
                    epsilons.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 12);
                break;
            }
            case GLN: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HG")) {
                        gammas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HE")) continue;
                    epsilons.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                NamingUtils.renameGlutamineHydrogen(residue, epsilons);
                break;
            }
            case LYS: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HG")) {
                        gammas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HE")) continue;
                    epsilons.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 23);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 23);
                break;
            }
            case LYD: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                ArrayList<Atom> epsilons = new ArrayList();
                ArrayList<Atom> zetas = new ArrayList<Atom>();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HG")) {
                        gammas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HE")) {
                        epsilons.add(atom);
                        continue;
                    }
                    if (!atomName.contains("HZ")) continue;
                    zetas.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 23);
                NamingUtils.renameEpsilonHydrogen(residue, epsilons, 23);
                NamingUtils.renameZetaHydrogen(residue, zetas, 12);
                break;
            }
            case ARG: {
                ArrayList<Atom> betas = new ArrayList();
                ArrayList<Atom> gammas = new ArrayList();
                ArrayList<Atom> deltas = new ArrayList();
                Atom HE = (Atom)residue.getAtomNode("HE");
                ArrayList<Atom> HHn = new ArrayList<Atom>();
                for (Atom atom : resAtoms) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.contains("HB")) {
                        betas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HG")) {
                        gammas.add(atom);
                        continue;
                    }
                    if (atomName.contains("HD")) {
                        deltas.add(atom);
                        continue;
                    }
                    if (HE == null && atomName.contains("HE")) {
                        HE = atom;
                        HE.setName("HE");
                        continue;
                    }
                    if (!atomName.contains("HH")) continue;
                    HHn.add(atom);
                }
                NamingUtils.renameBetaHydrogen(residue, betas, 23);
                NamingUtils.renameGammaHydrogen(residue, gammas, 23);
                NamingUtils.renameDeltaHydrogen(residue, deltas, 23);
                NamingUtils.renameArginineHydrogen(residue, HHn);
                break;
            }
        }
    }

    public static void nameAcetylCap(Residue residue, Atom aceC) {
        logger.fine(String.format(" Probable ACE cap attached to residue %s; duplicate atom names may result.", residue));
        aceC.setName("C");
        BondedUtils.findBondedAtoms(aceC, 8).getFirst().setName("O");
        Atom CH3 = BondedUtils.findBondedAtoms(aceC, 6).getFirst();
        CH3.setName("CH3");
        List<Atom> ntermHs = BondedUtils.findBondedAtoms(CH3, 1);
        for (int i = 0; i < ntermHs.size(); ++i) {
            ntermHs.get(i).setName(String.format("H%d", i + 1));
        }
    }

    public static Optional<Atom> renameAlkyl(Atom carbon, Atom priorAtom, int protonOffset, char posName) {
        carbon.setName(String.format("C%c", Character.valueOf(posName)));
        List<Atom> hydrogen = BondedUtils.findBondedAtoms(carbon, 1);
        int numH = hydrogen.size();
        if (numH == 1) {
            hydrogen.get(0).setName(String.format("H%c", Character.valueOf(posName)));
        } else {
            for (int i = 0; i < numH; ++i) {
                hydrogen.get(i).setName(String.format("H%c%d", Character.valueOf(posName), i + protonOffset));
            }
        }
        return carbon.getBonds().stream().map(b -> b.get1_2(carbon)).filter(a -> a != priorAtom).filter(a -> !hydrogen.contains(a)).findAny();
    }

    public static boolean renameAminoAcidToPDBStandard(Residue residue) {
        if (residue.getChainID() == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Setting Chain ID to Z for " + String.valueOf(residue));
            }
            residue.setChainID(Character.valueOf('Z'));
        }
        AminoAcidUtils.AminoAcid3 aa3 = residue.getAminoAcid3();
        Atom N = BondedUtils.findNitrogenAtom(residue);
        if (N != null) {
            N.setName("N");
            Atom CA = BondedUtils.getAlphaCarbon(residue, N);
            CA.setName("CA");
            List<Atom> hydrogenForCA = BondedUtils.findBondedAtoms(CA, 1);
            switch (aa3) {
                case NME: {
                    BondedUtils.findBondedAtoms(N, 1).get(0).setName("H");
                    CA.setName("CH3");
                    for (int i = 1; i <= 3; ++i) {
                        hydrogenForCA.get(i - 1).setName(String.format("H%d", i));
                    }
                    return true;
                }
                case GLY: {
                    hydrogenForCA.get(0).setName("HA2");
                    hydrogenForCA.get(1).setName("HA3");
                    break;
                }
                default: {
                    hydrogenForCA.get(0).setName("HA");
                }
            }
            Atom C = null;
            Atom CB = null;
            for (Atom carbon : BondedUtils.findBondedAtoms(CA, 6)) {
                if (BondedUtils.hasAttachedAtom(carbon, 8) && !BondedUtils.hasAttachedAtom(carbon, 1)) {
                    C = carbon;
                    C.setName("C");
                    continue;
                }
                CB = carbon;
                CB.setName("CB");
            }
            if (C == null) {
                throw new IllegalArgumentException(String.format(" The carbonyl carbon for residue %s could not be found.", residue));
            }
            if (CB == null && aa3 != AminoAcidUtils.AminoAcid3.GLY) {
                throw new IllegalArgumentException(String.format(" The beta carbon for residue %s could not be found.", residue));
            }
            List<Atom> cTerminalOxygen = BondedUtils.findBondedAtoms(C, 8);
            switch (cTerminalOxygen.size()) {
                case 1: {
                    cTerminalOxygen.get(0).setName("O");
                    break;
                }
                case 2: {
                    Atom O = null;
                    for (Atom oxygen : cTerminalOxygen) {
                        if (oxygen.getBonds().size() != 2) continue;
                        O = oxygen;
                        O.setName("OH");
                        BondedUtils.findBondedAtoms(O, 1).get(0).setName("HO");
                    }
                    if (O != null) break;
                    cTerminalOxygen.get(0).setName("O");
                    cTerminalOxygen.get(1).setName("OXT");
                }
            }
            List<Atom> amideProtons = BondedUtils.findBondedAtoms(N, 1);
            if (amideProtons.size() == 1) {
                amideProtons.get(0).setName("H");
            } else {
                for (int i = 1; i <= amideProtons.size(); ++i) {
                    amideProtons.get(i - 1).setName(String.format("H%d", i));
                }
            }
            NamingUtils.renameCommonAminoAcids(residue, aa3, CA, CB);
        } else if (aa3 == AminoAcidUtils.AminoAcid3.ACE) {
            Atom O = BondedUtils.findAtomsOfElement(residue, 8).get(0);
            O.setName("O");
            Atom C = BondedUtils.findBondedAtoms(O, 6).get(0);
            C.setName("C");
            Atom CH3 = BondedUtils.findBondedAtoms(C, 6).get(0);
            CH3.setName("CH3");
            List<Atom> hydrogen = BondedUtils.findBondedAtoms(CH3, 1);
            for (int i = 1; i <= 3; ++i) {
                hydrogen.get(i - 1).setName(String.format("H%d", i));
            }
        } else {
            logger.fine(String.format(" Mapping of nitrogen to residue (%s) failed. Trying to remap to molecule.", residue));
            return false;
        }
        return true;
    }

    public static void renameArginineHydrogen(Residue residue, List<Atom> resAtoms) {
        Atom HH11 = (Atom)residue.getAtomNode("HH11");
        Atom HH12 = (Atom)residue.getAtomNode("HH12");
        Atom HH21 = (Atom)residue.getAtomNode("HH21");
        Atom HH22 = (Atom)residue.getAtomNode("HH22");
        if (HH11 != null) {
            resAtoms.remove(HH11);
        }
        if (HH12 != null) {
            resAtoms.remove(HH12);
        }
        if (HH21 != null) {
            resAtoms.remove(HH21);
        }
        if (HH22 != null) {
            resAtoms.remove(HH22);
        }
        if (!resAtoms.isEmpty() && HH11 == null) {
            resAtoms.get(0).setName("HH11");
            resAtoms.remove(0);
        }
        if (!resAtoms.isEmpty() && HH12 == null) {
            resAtoms.get(0).setName("HH12");
            resAtoms.remove(0);
        }
        if (!resAtoms.isEmpty() && HH21 == null) {
            resAtoms.get(0).setName("HH21");
            resAtoms.remove(0);
        }
        if (!resAtoms.isEmpty() && HH22 == null) {
            resAtoms.get(0).setName("HH22");
            resAtoms.remove(0);
        }
    }

    public static void renameAsparagineHydrogen(Residue residue, List<Atom> resAtoms) {
        Atom HD21 = (Atom)residue.getAtomNode("HD21");
        Atom HD22 = (Atom)residue.getAtomNode("HD22");
        if (HD21 != null) {
            resAtoms.remove(HD21);
        }
        if (HD22 != null) {
            resAtoms.remove(HD22);
        }
        if (!resAtoms.isEmpty() && HD21 == null) {
            resAtoms.get(0).setName("HD21");
            resAtoms.remove(0);
        }
        if (!resAtoms.isEmpty() && HD22 == null) {
            resAtoms.get(0).setName("HD21");
        }
    }

    public static void renameAtomsToPDBStandard(MolecularAssembly molecularAssembly) {
        Polymer[] polymers = molecularAssembly.getChains();
        if (polymers != null) {
            for (Polymer polymer : polymers) {
                for (Residue residue : polymer.getResidues()) {
                    switch (residue.getResidueType()) {
                        case AA: {
                            NamingUtils.renameAminoAcidToPDBStandard(residue);
                            break;
                        }
                        case NA: {
                            NamingUtils.renameNucleicAcidToPDBStandard(residue);
                            break;
                        }
                    }
                }
            }
        }
    }

    public static void renameBetaHydrogen(Residue residue, List<Atom> resAtoms, int indexes) {
        Atom[] HBn = new Atom[3];
        switch (indexes) {
            case 12: {
                HBn[0] = (Atom)residue.getAtomNode("HB1");
                HBn[1] = (Atom)residue.getAtomNode("HB2");
                break;
            }
            case 13: {
                HBn[0] = (Atom)residue.getAtomNode("HB1");
                HBn[2] = (Atom)residue.getAtomNode("HB3");
                break;
            }
            case 23: {
                HBn[1] = (Atom)residue.getAtomNode("HB2");
                HBn[2] = (Atom)residue.getAtomNode("HB3");
                break;
            }
            default: {
                return;
            }
        }
        for (Atom HBatom : HBn) {
            resAtoms.remove(HBatom);
        }
        if (!(resAtoms.isEmpty() || HBn[0] != null || indexes != 12 && indexes != 13)) {
            resAtoms.get(0).setName("HB1");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HBn[1] != null || indexes != 12 && indexes != 23)) {
            resAtoms.get(0).setName("HB2");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HBn[2] != null || indexes != 13 && indexes != 23)) {
            resAtoms.get(0).setName("HB3");
            resAtoms.remove(0);
        }
    }

    public static Optional<Atom> renameBranchedAlkyl(Atom carbon, Atom priorAtom, int protonOffset, int branchNum, char posName) {
        carbon.setName(String.format("C%c%d", Character.valueOf(posName), branchNum));
        List<Atom> hydrogen = BondedUtils.findBondedAtoms(carbon, 1);
        int numH = hydrogen.size();
        if (numH == 1) {
            hydrogen.get(0).setName(String.format("H%c%d", Character.valueOf(posName), branchNum));
        } else {
            for (int i = 0; i < numH; ++i) {
                hydrogen.get(i).setName(String.format("H%c%d%d", Character.valueOf(posName), branchNum, i + protonOffset));
            }
        }
        return carbon.getBonds().stream().map(b -> b.get1_2(carbon)).filter(a -> a != priorAtom).filter(a -> !hydrogen.contains(a)).findAny();
    }

    public static void renameCommonAminoAcids(Residue residue, AminoAcidUtils.AminoAcid3 aa3, Atom CA, Atom CB) {
        block0 : switch (aa3) {
            case ALA: {
                NamingUtils.renameAlkyl(CB, CA, 1, 'B');
                break;
            }
            case CYD: 
            case CYS: {
                Atom SG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                SG.setName("SG");
                if (BondedUtils.hasAttachedAtom(SG, 1)) {
                    assert (aa3 == AminoAcidUtils.AminoAcid3.CYS);
                    BondedUtils.findBondedAtoms(SG, 1).get(0).setName("HG");
                    break;
                }
                if (BondedUtils.hasAttachedAtom(SG, 16)) {
                    logger.finer(String.format(" SG atom %s likely part of a disulfide bond.", SG));
                    break;
                }
                residue.setName("CYD");
                break;
            }
            case ASP: 
            case ASH: 
            case ASD: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                CG.setName("CG");
                List<Atom> ODs = BondedUtils.findBondedAtoms(CG, 8);
                int protonatedOD = -1;
                for (int i = 0; i < 2; ++i) {
                    if (!BondedUtils.hasAttachedAtom(ODs.get(i), 1)) continue;
                    protonatedOD = i;
                    break;
                }
                if (BondedUtils.hasAttachedAtom(ODs.get(0), 1) && BondedUtils.hasAttachedAtom(ODs.get(1), 1)) {
                    protonatedOD = 2;
                }
                switch (protonatedOD) {
                    case -1: {
                        ODs.get(0).setName("OD1");
                        ODs.get(1).setName("OD2");
                        break;
                    }
                    case 0: {
                        if (aa3 != AminoAcidUtils.AminoAcid3.ASH) {
                            residue.setName("ASH");
                        }
                        ODs.get(0).setName("OD2");
                        BondedUtils.findBondedAtoms(ODs.get(0), 1).get(0).setName("HD2");
                        ODs.get(1).setName("OD1");
                        break;
                    }
                    case 1: {
                        if (aa3 != AminoAcidUtils.AminoAcid3.ASH) {
                            residue.setName("ASH");
                        }
                        ODs.get(1).setName("OD2");
                        BondedUtils.findBondedAtoms(ODs.get(1), 1).get(0).setName("HD2");
                        ODs.get(0).setName("OD1");
                        break;
                    }
                    case 2: {
                        if (aa3 != AminoAcidUtils.AminoAcid3.ASD) {
                            residue.setName("ASD");
                        }
                        ODs.get(0).setName("OD1");
                        BondedUtils.findBondedAtoms(ODs.get(0), 1).get(0).setName("HD1");
                        ODs.get(1).setName("OD2");
                        BondedUtils.findBondedAtoms(ODs.get(1), 1).get(0).setName("HD2");
                    }
                }
                break;
            }
            case GLU: 
            case GLH: 
            case GLD: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                Atom CD = NamingUtils.renameAlkyl(CG, CB, 2, 'G').get();
                CD.setName("CD");
                List<Atom> OEs = BondedUtils.findBondedAtoms(CD, 8);
                int protonatedOE = -1;
                for (int i = 0; i < 2; ++i) {
                    if (!BondedUtils.hasAttachedAtom(OEs.get(i), 1)) continue;
                    protonatedOE = i;
                    break;
                }
                if (BondedUtils.hasAttachedAtom(OEs.get(0), 1) && BondedUtils.hasAttachedAtom(OEs.get(1), 1)) {
                    protonatedOE = 2;
                }
                switch (protonatedOE) {
                    case -1: {
                        OEs.get(0).setName("OE1");
                        OEs.get(1).setName("OE2");
                        break;
                    }
                    case 0: {
                        if (aa3 != AminoAcidUtils.AminoAcid3.GLH) {
                            residue.setName("GLH");
                        }
                        OEs.get(0).setName("OE2");
                        BondedUtils.findBondedAtoms(OEs.get(0), 1).get(0).setName("HE2");
                        OEs.get(1).setName("OE1");
                        break;
                    }
                    case 1: {
                        if (aa3 != AminoAcidUtils.AminoAcid3.GLH) {
                            residue.setName("GLH");
                        }
                        OEs.get(1).setName("OE2");
                        BondedUtils.findBondedAtoms(OEs.get(1), 1).get(0).setName("HE2");
                        OEs.get(0).setName("OE1");
                        break;
                    }
                    case 2: {
                        if (aa3 != AminoAcidUtils.AminoAcid3.GLD) {
                            residue.setName("GLD");
                        }
                        OEs.get(0).setName("OE1");
                        BondedUtils.findBondedAtoms(OEs.get(0), 1).get(0).setName("HE1");
                        OEs.get(1).setName("OE2");
                        BondedUtils.findBondedAtoms(OEs.get(1), 1).get(0).setName("HE2");
                    }
                }
                break;
            }
            case PHE: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                CG.setName("CG");
                List<Atom> CDs = BondedUtils.findBondedAtoms(CG, CB, 6);
                MSNode CZ = null;
                for (int i = 1; i <= 2; ++i) {
                    Atom CD = CDs.get(i - 1);
                    Atom CE = NamingUtils.renameBranchedAlkyl(CD, CG, 0, i, 'D').get();
                    CZ = NamingUtils.renameBranchedAlkyl(CE, CD, 0, i, 'E').get();
                }
                CZ.setName("CZ");
                BondedUtils.findBondedAtoms((Atom)CZ, 1).get(0).setName("HZ");
                break;
            }
            case GLY: {
                break;
            }
            case HIS: 
            case HID: 
            case HIE: {
                boolean deltaProtonated;
                boolean epsProtonated;
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                CG.setName("CG");
                Atom CD2 = BondedUtils.findBondedAtoms(CG, 6).stream().filter(a -> a != CB).findAny().get();
                CD2.setName("CD2");
                BondedUtils.findBondedAtoms(CD2, 1).get(0).setName("HD2");
                Atom NE2 = BondedUtils.findBondedAtoms(CD2, 7).get(0);
                NE2.setName("NE2");
                List<Atom> HE2 = BondedUtils.findBondedAtoms(NE2, 1);
                boolean bl = epsProtonated = HE2 != null && !HE2.isEmpty();
                if (epsProtonated) {
                    HE2.get(0).setName("HE2");
                }
                Atom CE1 = BondedUtils.findBondedAtoms(NE2, CD2, 6).get(0);
                CE1.setName("CE1");
                BondedUtils.findBondedAtoms(CE1, 1).get(0).setName("HE1");
                Atom ND1 = BondedUtils.findBondedAtoms(CG, 7).get(0);
                ND1.setName("ND1");
                List<Atom> HD1 = BondedUtils.findBondedAtoms(ND1, 1);
                boolean bl2 = deltaProtonated = HD1 != null && !HD1.isEmpty();
                if (deltaProtonated) {
                    HD1.get(0).setName("HD1");
                }
                if (epsProtonated && deltaProtonated) {
                    assert (aa3 == AminoAcidUtils.AminoAcid3.HIS);
                    break;
                }
                if (epsProtonated) {
                    residue.setName("HIE");
                    break;
                }
                if (deltaProtonated) {
                    residue.setName("HID");
                    break;
                }
                throw new IllegalArgumentException(String.format(" Histidine residue %s is doubly deprotonated!", residue));
            }
            case ILE: {
                BondedUtils.findBondedAtoms(CB, 1).get(0).setName("HB");
                List<Atom> CGs = BondedUtils.findBondedAtoms(CB, CA, 6);
                for (Atom CG : CGs) {
                    List<Atom> HGs = BondedUtils.findBondedAtoms(CG, 1);
                    int numHGs = HGs.size();
                    if (numHGs == 3) {
                        NamingUtils.renameBranchedAlkyl(CG, CB, 1, 2, 'G');
                        continue;
                    }
                    if (numHGs == 2) {
                        Atom CD1 = NamingUtils.renameBranchedAlkyl(CG, CB, 2, 1, 'G').get();
                        NamingUtils.renameBranchedAlkyl(CD1, CG, 1, 1, 'D');
                        continue;
                    }
                    throw new IllegalArgumentException(String.format(" Isoleucine residue %s had %d gamma hydrogen, expecting 2-3!", residue, numHGs));
                }
                break;
            }
            case LYS: 
            case LYD: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                Atom CD = NamingUtils.renameAlkyl(CG, CB, 2, 'G').get();
                Atom CE = NamingUtils.renameAlkyl(CD, CG, 2, 'D').get();
                Atom NZ = NamingUtils.renameAlkyl(CE, CD, 2, 'E').get();
                NamingUtils.renameAlkyl(NZ, CE, 1, 'Z');
                NZ.setName("NZ");
                int numH = BondedUtils.findBondedAtoms(NZ, 1).size();
                switch (numH) {
                    case 2: {
                        residue.setName("LYD");
                        break block0;
                    }
                    case 3: {
                        assert (aa3 == AminoAcidUtils.AminoAcid3.LYS);
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format(" Lysine residue %s had %d amine protons, expecting 2-3!", residue, numH));
                    }
                }
            }
            case LEU: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                CG.setName("CG");
                BondedUtils.findBondedAtoms(CG, 1).get(0).setName("HG");
                List<Atom> CDs = BondedUtils.findBondedAtoms(CG, CB, 6);
                for (int i = 0; i < 2; ++i) {
                    NamingUtils.renameBranchedAlkyl(CDs.get(i), CG, 1, i + 1, 'D');
                }
                break;
            }
            case MET: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                Atom SD = NamingUtils.renameAlkyl(CG, CB, 2, 'G').get();
                Atom CE = NamingUtils.renameAlkyl(SD, CG, 0, 'D').get();
                SD.setName("SD");
                NamingUtils.renameAlkyl(CE, SD, 1, 'E');
                break;
            }
            case ASN: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                CG.setName("CG");
                BondedUtils.findBondedAtoms(CG, 8).get(0).setName("OD1");
                Atom ND2 = BondedUtils.findBondedAtoms(CG, 7).get(0);
                NamingUtils.renameBranchedAlkyl(ND2, CG, 1, 2, 'D');
                ND2.setName("ND2");
                break;
            }
            case PRO: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                Atom CD = NamingUtils.renameAlkyl(CG, CB, 2, 'G').get();
                Atom N = NamingUtils.renameAlkyl(CD, CG, 2, 'D').get();
                assert (N.getName().equals("N"));
                break;
            }
            case GLN: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                Atom CD = NamingUtils.renameAlkyl(CG, CB, 2, 'G').get();
                CD.setName("CD");
                BondedUtils.findBondedAtoms(CD, 8).get(0).setName("OE1");
                Atom NE2 = BondedUtils.findBondedAtoms(CD, 7).get(0);
                NamingUtils.renameBranchedAlkyl(NE2, CD, 1, 2, 'E');
                NE2.setName("NE2");
                break;
            }
            case ARG: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                Atom CD = NamingUtils.renameAlkyl(CG, CB, 2, 'G').get();
                Atom NE = NamingUtils.renameAlkyl(CD, CG, 2, 'D').get();
                Atom CZ = NamingUtils.renameAlkyl(NE, CD, 0, 'E').get();
                NE.setName("NE");
                CZ.setName("CZ");
                List<Atom> NHs = BondedUtils.findBondedAtoms(CZ, NE, 7);
                assert (NHs.size() == 2);
                for (int i = 0; i < 2; ++i) {
                    Atom NHx = NHs.get(i);
                    NamingUtils.renameBranchedAlkyl(NHx, CZ, 1, i + 1, 'H');
                    NHx.setName(String.format("NH%d", i + 1));
                }
                break;
            }
            case SER: {
                Atom OG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                NamingUtils.renameAlkyl(OG, CB, 0, 'G');
                OG.setName("OG");
                break;
            }
            case THR: {
                CB.setName("CB");
                BondedUtils.findBondedAtoms(CB, 1).get(0).setName("HB");
                Atom OG1 = BondedUtils.findBondedAtoms(CB, 8).get(0);
                OG1.setName("OG1");
                BondedUtils.findBondedAtoms(OG1, 1).get(0).setName("HG1");
                Atom CG2 = BondedUtils.findBondedAtoms(CB, CA, 6).get(0);
                NamingUtils.renameBranchedAlkyl(CG2, CB, 1, 2, 'G');
                break;
            }
            case VAL: {
                CB.setName("CB");
                BondedUtils.findBondedAtoms(CB, 1).get(0).setName("HB");
                List<Atom> CGs = BondedUtils.findBondedAtoms(CB, CA, 6);
                assert (CGs.size() == 2);
                for (int i = 0; i < 2; ++i) {
                    Atom CGx = CGs.get(i);
                    NamingUtils.renameBranchedAlkyl(CGx, CB, 1, i + 1, 'G');
                }
                break;
            }
            case TRP: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                CG.setName("CG");
                List<Atom> CDs = BondedUtils.findBondedAtoms(CG, CB, 6);
                Atom CD1 = null;
                Atom CD2 = null;
                for (Atom CDx : CDs) {
                    if (BondedUtils.hasAttachedAtom(CDx, 1)) {
                        CD1 = CDx;
                        continue;
                    }
                    CD2 = CDx;
                    CD2.setName("CD2");
                }
                Atom NE1 = NamingUtils.renameBranchedAlkyl(CD1, CG, 0, 1, 'D').get();
                Atom CE2 = NamingUtils.renameBranchedAlkyl(NE1, CD1, 0, 1, 'E').get();
                NE1.setName("NE1");
                CE2.setName("CE2");
                Atom CZ2 = BondedUtils.findBondedAtoms(CE2, CD2, 6).get(0);
                Atom CH2 = NamingUtils.renameBranchedAlkyl(CZ2, CE2, 0, 2, 'Z').get();
                Atom CZ3 = NamingUtils.renameBranchedAlkyl(CH2, CZ2, 0, 2, 'H').get();
                Atom CE3 = NamingUtils.renameBranchedAlkyl(CZ3, CH2, 0, 3, 'Z').get();
                if (CD2 == NamingUtils.renameBranchedAlkyl(CE3, CZ3, 0, 3, 'E').get()) break;
                throw new IllegalArgumentException(String.format(" Error in cyclizing tryptophan %s!", residue));
            }
            case TYR: 
            case TYD: {
                Atom CG = NamingUtils.renameAlkyl(CB, CA, 2, 'B').get();
                CG.setName("CG");
                List<Atom> CDs = BondedUtils.findBondedAtoms(CG, CB, 6);
                MSNode CZ = null;
                assert (CDs.size() == 2);
                for (int i = 1; i <= 2; ++i) {
                    Atom CDx = CDs.get(i - 1);
                    Atom CEx = NamingUtils.renameBranchedAlkyl(CDx, CG, 0, i, 'D').get();
                    CZ = NamingUtils.renameBranchedAlkyl(CEx, CDx, 0, i, 'E').get();
                }
                CZ.setName("CZ");
                Atom OH = BondedUtils.findBondedAtoms((Atom)CZ, 8).get(0);
                OH.setName("OH");
                if (BondedUtils.hasAttachedAtom(OH, 1)) {
                    assert (aa3 == AminoAcidUtils.AminoAcid3.TYR);
                    BondedUtils.findBondedAtoms(OH, 1).get(0).setName("HH");
                    break;
                }
                residue.setName("TYD");
                break;
            }
            default: {
                logger.info(String.format(" Amino acid %s (%s) not recognized!", new Object[]{residue, aa3}));
            }
        }
    }

    public static void renameCommonNucleicAcid(Residue residue, NucleicAcidUtils.NucleicAcid3 na3) {
        Optional<Atom> optO4s = BondedUtils.findNucleotideO4s(residue);
        if (optO4s.isPresent()) {
            Atom O4s = optO4s.get();
            O4s.setName("O4'");
            List<Atom> bondedC = BondedUtils.findBondedAtoms(O4s, 6);
            Atom C4s = null;
            Atom C1s = null;
            Atom N19 = null;
            Atom H1s = null;
            for (Atom c : bondedC) {
                if (BondedUtils.hasAttachedAtom(c, 7)) {
                    C1s = c;
                    C1s.setName("C1'");
                    H1s = BondedUtils.findBondedAtoms(C1s, 1).get(0);
                    H1s.setName("H1'");
                    N19 = BondedUtils.findBondedAtoms(C1s, 7).get(0);
                    continue;
                }
                C4s = c;
                C4s.setName("C4'");
                BondedUtils.findBondedAtoms(C4s, 1).get(0).setName("H4'");
            }
            assert (C4s != null && C1s != null);
            Atom C2s = BondedUtils.findBondedAtoms(C1s, 6).get(0);
            C2s.setName("C2'");
            bondedC = BondedUtils.findBondedAtoms(C4s, 6);
            Atom C5s = null;
            for (Atom c : bondedC) {
                if (c.getBonds().stream().anyMatch(b -> b.get1_2(c) == C2s)) {
                    Atom C3s = c;
                    C3s.setName("C3'");
                    Atom O3s = BondedUtils.findBondedAtoms(C3s, 8).get(0);
                    O3s.setName("O3'");
                    BondedUtils.findBondedAtoms(C3s, 1).get(0).setName("H3'");
                    if (!BondedUtils.hasAttachedAtom(O3s, 1)) continue;
                    BondedUtils.findBondedAtoms(O3s, 1).get(0).setName("HO3'");
                    continue;
                }
                C5s = c;
                C5s.setName("C5'");
                List<Atom> allH5List = BondedUtils.findBondedAtoms(C5s, 1);
                Atom[] allH5s = allH5List.toArray(new Atom[0]);
                BondedUtils.sortAtomsByDistance(O4s, allH5s);
                allH5s[0].setName("H5'");
                allH5s[1].setName("H5''");
            }
            if (BondedUtils.hasAttachedAtom(C2s, 8)) {
                Atom O2s = BondedUtils.findBondedAtoms(C2s, 8).get(0);
                O2s.setName("O2'");
                BondedUtils.findBondedAtoms(O2s, 1).get(0).setName("HO2'");
                BondedUtils.findBondedAtoms(C2s, 1).get(0).setName("H2'");
            } else {
                List<Atom> bothH2List = BondedUtils.findBondedAtoms(C2s, 1);
                Atom[] bothH2 = bothH2List.toArray(new Atom[0]);
                BondedUtils.sortAtomsByDistance(H1s, bothH2);
                bothH2[0].setName("H2''");
                bothH2[1].setName("H2'");
            }
            Atom O5s = BondedUtils.findBondedAtoms(C5s, 8).get(0);
            O5s.setName("O5'");
            if (BondedUtils.hasAttachedAtom(O5s, 1)) {
                BondedUtils.findBondedAtoms(O5s, 1).get(0).setName("HO5'");
            } else if (BondedUtils.hasAttachedAtom(O5s, 15)) {
                Atom P = BondedUtils.findBondedAtoms(O5s, 15).get(0);
                P.setName("P");
                List<Atom> bondedO = BondedUtils.findBondedAtoms(P, O5s, 8);
                List<Atom> thisResO = bondedO.stream().filter(o -> residue.getAtomList().contains(o)).toList();
                int nBonded = bondedO.size();
                int nRes = thisResO.size();
                if (nBonded != 0) {
                    if (nBonded == nRes) {
                        Atom OP1 = bondedO.get(0);
                        OP1.setName("OP1");
                        xyzC5s = C5s.getXYZ(new double[3]);
                        xyzO5s = O5s.getXYZ(new double[3]);
                        xyzP = P.getXYZ(new double[3]);
                        double[] xyzOP1 = OP1.getXYZ(new double[3]);
                        dihedral = DoubleMath.dihedralAngle((double[])xyzC5s, (double[])xyzO5s, (double[])xyzP, (double[])xyzOP1);
                        twoPiOver3 = 2.0943951023931953;
                        target = ScalarMath.modToRange((double)(dihedral + twoPiOver3), (double)(-Math.PI), (double)Math.PI);
                        otherO = bondedO.stream().filter(o -> o != OP1).sorted(Comparator.comparingDouble(o -> {
                            double[] xyzO = o.getXYZ(new double[3]);
                            double dihedO = DoubleMath.dihedralAngle((double[])xyzC5s, (double[])xyzO5s, (double[])xyzP, (double[])xyzO);
                            double diff = dihedO - target;
                            double twoPi = Math.PI * 2;
                            diff = (diff = ScalarMath.modToRange((double)diff, (double)0.0, (double)twoPi)) < Math.PI ? diff : twoPi - diff;
                            return diff;
                        })).toList();
                        for (i = 0; i < otherO.size(); ++i) {
                            otherO.get(i).setName(String.format("OP%d", i + 2));
                        }
                    } else {
                        Atom nextO3s = bondedO.stream().filter(o -> !residue.getAtomList().contains(o)).findAny().get();
                        xyzC5s = C5s.getXYZ(new double[3]);
                        xyzO5s = O5s.getXYZ(new double[3]);
                        xyzP = P.getXYZ(new double[3]);
                        double[] xyzNextO3s = nextO3s.getXYZ(new double[3]);
                        dihedral = DoubleMath.dihedralAngle((double[])xyzC5s, (double[])xyzO5s, (double[])xyzP, (double[])xyzNextO3s);
                        twoPiOver3 = 2.0943951023931953;
                        target = ScalarMath.modToRange((double)(dihedral + twoPiOver3), (double)(-Math.PI), (double)Math.PI);
                        otherO = bondedO.stream().filter(o -> o != nextO3s).sorted(Comparator.comparingDouble(o -> {
                            double[] xyzO = o.getXYZ(new double[3]);
                            double dihedO = DoubleMath.dihedralAngle((double[])xyzC5s, (double[])xyzO5s, (double[])xyzP, (double[])xyzO);
                            double diff = dihedO - target;
                            double twoPi = Math.PI * 2;
                            diff = (diff = ScalarMath.modToRange((double)diff, (double)0.0, (double)twoPi)) < Math.PI ? diff : twoPi - diff;
                            return diff;
                        })).toList();
                        for (i = 0; i < otherO.size(); ++i) {
                            otherO.get(i).setName(String.format("OP%d", i + 1));
                        }
                    }
                }
                for (Atom op : bondedO) {
                    if (!BondedUtils.hasAttachedAtom(op, 1)) continue;
                    BondedUtils.findBondedAtoms(op, 1).get(0).setName("H" + op.getName());
                }
            }
            NamingUtils.renameCommonNucleobase(N19, C1s, na3);
        } else {
            logger.warning(" Could not find O4' for residue " + String.valueOf(residue));
        }
    }

    public static void renameCommonNucleobase(Atom N19, Atom C1s, NucleicAcidUtils.NucleicAcid3 na3) {
        block0 : switch (na3) {
            case ADE: 
            case DAD: {
                Map<String, Atom> purineBase = NamingUtils.renameCommonPurine(N19, C1s);
                BondedUtils.findBondedAtoms(purineBase.get("C2"), 1).get(0).setName("H2");
                Atom C6 = purineBase.get("C6");
                Atom N1 = purineBase.get("N1");
                Atom N6 = BondedUtils.findBondedAtoms(C6, N1, 7).get(0);
                N6.setName("N6");
                List<Atom> allH6List = BondedUtils.findBondedAtoms(N6, 1);
                Atom[] allH6 = BondedUtils.sortAtomsByDistance(N1, allH6List);
                allH6[0].setName("H61");
                allH6[1].setName("H62");
                break;
            }
            case CYT: 
            case DCY: {
                Map<String, Atom> pyrimidineBase = NamingUtils.renameCommonPyrimidine(N19, C1s);
                Atom C4 = pyrimidineBase.get("C4");
                Atom N3 = pyrimidineBase.get("N3");
                Atom N4 = BondedUtils.findBondedAtoms(C4, N3, 7).get(0);
                N4.setName("N4");
                Atom[] allH4 = BondedUtils.sortAtomsByDistance(N3, BondedUtils.findBondedAtoms(N4, 1));
                allH4[0].setName("H41");
                allH4[1].setName("H42");
                break;
            }
            case GUA: 
            case DGU: {
                Map<String, Atom> purineBase = NamingUtils.renameCommonPurine(N19, C1s);
                Atom N1 = purineBase.get("N1");
                Atom C2 = purineBase.get("C2");
                Atom C6 = purineBase.get("C6");
                BondedUtils.findBondedAtoms(N1, 1).get(0).setName("H1");
                Atom N2 = BondedUtils.findBondedAtoms(C2, N1, 7).stream().filter(n -> BondedUtils.hasAttachedAtom(n, 1)).findAny().get();
                N2.setName("N2");
                Atom[] allH2 = BondedUtils.sortAtomsByDistance(N1, BondedUtils.findBondedAtoms(N2, 1));
                allH2[0].setName("H21");
                allH2[1].setName("H22");
                BondedUtils.findBondedAtoms(C6, 8).get(0).setName("O6");
                break;
            }
            case URI: {
                Map<String, Atom> pyrimidineBase = NamingUtils.renameCommonPyrimidine(N19, C1s);
                BondedUtils.findBondedAtoms(pyrimidineBase.get("N3"), 1).get(0).setName("H3");
                BondedUtils.findBondedAtoms(pyrimidineBase.get("C4"), 8).get(0).setName("O4");
                break;
            }
            case THY: 
            case DTY: {
                Map<String, Atom> pyrimidineBase = NamingUtils.renameCommonPyrimidine(N19, C1s);
                BondedUtils.findBondedAtoms(pyrimidineBase.get("N3"), 1).get(0).setName("H3");
                BondedUtils.findBondedAtoms(pyrimidineBase.get("C4"), 8).get(0).setName("O4");
                Atom C5 = pyrimidineBase.get("C5");
                for (Atom c : BondedUtils.findBondedAtoms(C5, 6)) {
                    List<Atom> bondedH = BondedUtils.findBondedAtoms(c, 1);
                    if (bondedH == null || bondedH.size() != 3) continue;
                    c.setName("C7");
                    for (int i = 0; i < 3; ++i) {
                        bondedH.get(i).setName(String.format("H7%d", i + 1));
                    }
                    break block0;
                }
                break;
            }
        }
    }

    public static Map<String, Atom> renameCommonPurine(Atom N9, Atom C1s) {
        HashMap<String, Atom> keyAtoms = new HashMap<String, Atom>(10);
        N9.setName("N9");
        for (Atom c : BondedUtils.findBondedAtoms(N9, C1s, 6)) {
            if (BondedUtils.hasAttachedAtom(c, 1)) {
                Atom C8 = c;
                C8.setName("C8");
                BondedUtils.findBondedAtoms(C8, 1).get(0).setName("H8");
                Atom N7 = BondedUtils.findBondedAtoms(C8, N9, 7).get(0);
                N7.setName("N7");
                Atom C5 = BondedUtils.findBondedAtoms(N7, C8, 6).get(0);
                C5.setName("C5");
                continue;
            }
            Atom C4 = c;
            C4.setName("C4");
            Atom N3 = BondedUtils.findBondedAtoms(C4, N9, 7).get(0);
            N3.setName("N3");
            Atom C2 = BondedUtils.findBondedAtoms(N3, C4, 6).get(0);
            C2.setName("C2");
            keyAtoms.put("C2", C2);
            Atom N1 = BondedUtils.findBondedAtoms(C2, N3, 7).get(0);
            N1.setName("N1");
            keyAtoms.put("N1", N1);
            Atom C6 = BondedUtils.findBondedAtoms(N1, C2, 6).get(0);
            C6.setName("C6");
            keyAtoms.put("C6", C6);
        }
        return keyAtoms;
    }

    public static Map<String, Atom> renameCommonPyrimidine(Atom N1, Atom C1s) {
        HashMap<String, Atom> keyAtoms = new HashMap<String, Atom>();
        N1.setName("N1");
        for (Atom c : BondedUtils.findBondedAtoms(N1, C1s, 6)) {
            if (BondedUtils.hasAttachedAtom(c, 8)) {
                Atom C2 = c;
                C2.setName("C2");
                BondedUtils.findBondedAtoms(C2, 8).get(0).setName("O2");
                Atom N3 = BondedUtils.findBondedAtoms(C2, N1, 7).get(0);
                N3.setName("N3");
                keyAtoms.put("N3", N3);
                Atom C4 = BondedUtils.findBondedAtoms(N3, C2, 6).get(0);
                C4.setName("C4");
                keyAtoms.put("C4", C4);
                Atom C5 = BondedUtils.findBondedAtoms(C4, 6).get(0);
                C5.setName("C5");
                keyAtoms.put("C5", C5);
                if (!BondedUtils.hasAttachedAtom(C5, 1)) continue;
                BondedUtils.findBondedAtoms(C5, 1).get(0).setName("H5");
                continue;
            }
            Atom C6 = c;
            C6.setName("C6");
            BondedUtils.findBondedAtoms(C6, 1).get(0).setName("H6");
        }
        return keyAtoms;
    }

    public static void renameDeltaHydrogen(Residue residue, List<Atom> resAtoms, int indexes) {
        Atom[] HDn = new Atom[3];
        switch (indexes) {
            case 12: {
                HDn[0] = (Atom)residue.getAtomNode("HD1");
                HDn[1] = (Atom)residue.getAtomNode("HD2");
                break;
            }
            case 13: {
                HDn[0] = (Atom)residue.getAtomNode("HD1");
                HDn[2] = (Atom)residue.getAtomNode("HD3");
                break;
            }
            case 23: {
                HDn[1] = (Atom)residue.getAtomNode("HD2");
                HDn[2] = (Atom)residue.getAtomNode("HD3");
                break;
            }
            default: {
                return;
            }
        }
        for (Atom HDatom : HDn) {
            resAtoms.remove(HDatom);
        }
        if (!(resAtoms.isEmpty() || HDn[0] != null || indexes != 12 && indexes != 13)) {
            resAtoms.get(0).setName("HD1");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HDn[1] != null || indexes != 12 && indexes != 23)) {
            resAtoms.get(0).setName("HD2");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HDn[2] != null || indexes != 13 && indexes != 23)) {
            resAtoms.get(0).setName("HD3");
            resAtoms.remove(0);
        }
    }

    public static void renameEpsilonHydrogen(Residue residue, List<Atom> resAtoms, int indexes) {
        Atom[] HEn = new Atom[3];
        switch (indexes) {
            case 12: {
                HEn[0] = (Atom)residue.getAtomNode("HE1");
                HEn[1] = (Atom)residue.getAtomNode("HE2");
                break;
            }
            case 13: {
                HEn[0] = (Atom)residue.getAtomNode("HE1");
                HEn[2] = (Atom)residue.getAtomNode("HE3");
                break;
            }
            case 23: {
                HEn[1] = (Atom)residue.getAtomNode("HE2");
                HEn[2] = (Atom)residue.getAtomNode("HE3");
                break;
            }
            default: {
                return;
            }
        }
        for (Atom HEatom : HEn) {
            resAtoms.remove(HEatom);
        }
        if (!(resAtoms.isEmpty() || HEn[0] != null || indexes != 12 && indexes != 13)) {
            resAtoms.get(0).setName("HE1");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HEn[1] != null || indexes != 12 && indexes != 23)) {
            resAtoms.get(0).setName("HE2");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HEn[2] != null || indexes != 13 && indexes != 23)) {
            resAtoms.get(0).setName("HE3");
            resAtoms.remove(0);
        }
    }

    public static void renameGammaHydrogen(Residue residue, List<Atom> resAtoms, int indexes) {
        Atom[] HGn = new Atom[3];
        switch (indexes) {
            case 12: {
                HGn[0] = (Atom)residue.getAtomNode("HG1");
                HGn[1] = (Atom)residue.getAtomNode("HG2");
                break;
            }
            case 13: {
                HGn[0] = (Atom)residue.getAtomNode("HG1");
                HGn[2] = (Atom)residue.getAtomNode("HG3");
                break;
            }
            case 23: {
                HGn[1] = (Atom)residue.getAtomNode("HG2");
                HGn[2] = (Atom)residue.getAtomNode("HG3");
                break;
            }
            default: {
                return;
            }
        }
        for (Atom HGatom : HGn) {
            resAtoms.remove(HGatom);
        }
        if (!(resAtoms.isEmpty() || HGn[0] != null || indexes != 12 && indexes != 13)) {
            resAtoms.get(0).setName("HG1");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HGn[1] != null || indexes != 12 && indexes != 23)) {
            resAtoms.get(0).setName("HG2");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HGn[2] != null || indexes != 13 && indexes != 23)) {
            resAtoms.get(0).setName("HG3");
            resAtoms.remove(0);
        }
    }

    public static void renameGlutamineHydrogen(Residue residue, List<Atom> resAtoms) {
        Atom HE21 = (Atom)residue.getAtomNode("HE21");
        Atom HE22 = (Atom)residue.getAtomNode("HE22");
        if (HE21 != null) {
            resAtoms.remove(HE21);
        }
        if (HE22 != null) {
            resAtoms.remove(HE22);
        }
        if (!resAtoms.isEmpty() && HE21 == null) {
            resAtoms.get(0).setName("HE21");
            resAtoms.remove(0);
        }
        if (!resAtoms.isEmpty() && HE22 == null) {
            resAtoms.get(0).setName("HE21");
        }
    }

    public static void renameGlycineAlphaHydrogen(Residue residue, List<Atom> resAtoms) {
        Atom HA2 = (Atom)residue.getAtomNode("HA2");
        Atom HA3 = (Atom)residue.getAtomNode("HA3");
        if (HA2 != null) {
            resAtoms.remove(HA2);
        }
        if (HA3 != null) {
            resAtoms.remove(HA3);
        }
        if (HA2 == null && !resAtoms.isEmpty()) {
            resAtoms.get(0).setName("HA2");
            resAtoms.remove(0);
        }
        if (HA3 == null && !resAtoms.isEmpty()) {
            resAtoms.get(0).setName("HA3");
        }
    }

    public static void renameIsoleucineHydrogen(Residue residue, List<Atom> resAtoms) {
        Atom HG12 = (Atom)residue.getAtomNode("HG12");
        Atom HG13 = (Atom)residue.getAtomNode("HG13");
        if (HG12 != null) {
            resAtoms.remove(HG12);
        }
        if (HG13 != null) {
            resAtoms.remove(HG13);
        }
        if (HG12 == null && !resAtoms.isEmpty()) {
            resAtoms.get(0).setName("HG12");
            resAtoms.remove(0);
        }
        if (HG13 == null && !resAtoms.isEmpty()) {
            resAtoms.get(0).setName("HG13");
        }
    }

    public static void renameNTerminusHydrogen(Residue residue) {
        Atom[] h = new Atom[]{(Atom)residue.getAtomNode("H1"), (Atom)residue.getAtomNode("H2"), (Atom)residue.getAtomNode("H3")};
        int numAtoms = 0;
        for (Atom atom : h) {
            numAtoms += atom == null ? 0 : 1;
        }
        if (numAtoms == 3) {
            return;
        }
        List<Atom> resAtoms = residue.getAtomList();
        for (Atom resAtom : resAtoms) {
            String atomName;
            boolean doContinue = false;
            for (Atom hAtom : h) {
                if (!resAtom.equals(hAtom)) continue;
                doContinue = true;
                break;
            }
            if (doContinue || !(atomName = resAtom.getName().toUpperCase()).equals("H") && !atomName.matches("H[1-3]") && !atomName.matches("[1-3]H")) continue;
            ++numAtoms;
            for (int i = 0; i < h.length; ++i) {
                if (h[i] != null) continue;
                resAtom.setName("H" + (i + 1));
                h[i] = resAtom;
                break;
            }
            if (numAtoms != 3) continue;
            return;
        }
    }

    public static void renameNucleicAcidToPDBStandard(Residue residue) {
        if (residue.getChainID() == null) {
            logger.info(" Setting Chain ID to Z for " + String.valueOf(residue));
            residue.setChainID(Character.valueOf('Z'));
        }
        assert (residue.getResidueType() == Residue.ResidueType.NA);
        NucleicAcidUtils.NucleicAcid3 na3 = residue.getNucleicAcid3(true);
        residue.setName(na3.toString());
        switch (na3) {
            case ADE: 
            case DAD: 
            case CYT: 
            case DCY: 
            case GUA: 
            case DGU: 
            case URI: 
            case THY: 
            case DTY: {
                NamingUtils.renameCommonNucleicAcid(residue, na3);
                break;
            }
            default: {
                logger.info(" Could not rename atoms for nonstandard nucleic acid " + String.valueOf((Object)na3));
            }
        }
    }

    public static void renameZetaHydrogen(Residue residue, List<Atom> resAtoms, int indexes) {
        Atom[] HZn = new Atom[3];
        switch (indexes) {
            case 12: {
                HZn[0] = (Atom)residue.getAtomNode("HZ1");
                HZn[1] = (Atom)residue.getAtomNode("HZ2");
                break;
            }
            case 13: {
                HZn[0] = (Atom)residue.getAtomNode("HZ1");
                HZn[2] = (Atom)residue.getAtomNode("HZ3");
                break;
            }
            case 23: {
                HZn[1] = (Atom)residue.getAtomNode("HZ2");
                HZn[2] = (Atom)residue.getAtomNode("HZ3");
                break;
            }
            default: {
                return;
            }
        }
        for (Atom HZatom : HZn) {
            resAtoms.remove(HZatom);
        }
        if (!(resAtoms.isEmpty() || HZn[0] != null || indexes != 12 && indexes != 13)) {
            resAtoms.get(0).setName("HZ1");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HZn[1] != null || indexes != 12 && indexes != 23)) {
            resAtoms.get(0).setName("HZ2");
            resAtoms.remove(0);
        }
        if (!(resAtoms.isEmpty() || HZn[2] != null || indexes != 13 && indexes != 23)) {
            resAtoms.get(0).setName("HZ3");
            resAtoms.remove(0);
        }
    }

    public static enum HetAtoms {
        BR,
        CA,
        CA2,
        CL,
        I,
        K,
        MG,
        MG2,
        NA,
        HOH,
        H2O,
        WAT,
        ZN,
        ZN2;


        public static HetAtoms parse(String str) {
            String hName = str.toUpperCase().replaceFirst("[0-9+\\-]+$", "");
            return HetAtoms.valueOf(hName);
        }
    }
}

