/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.Joint;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.vecmath.Color3f;

public class MultiResidue
extends Residue {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MultiResidue.class.getName());
    ForceField forceField;
    private Residue activeResidue;
    private final List<Residue> consideredResidues;
    private Rotamer[] rotamers;
    private Rotamer originalRotamer;

    public MultiResidue(Residue residue, ForceField forceField) {
        super(residue.getResidueNumber() + "-MultiResidue", residue.getResidueNumber(), residue.residueType, residue.getChainID(), residue.getChainID().toString());
        this.forceField = forceField;
        this.activeResidue = residue;
        this.consideredResidues = new ArrayList<Residue>();
        this.consideredResidues.add(residue);
        this.removeLeaves();
    }

    @Override
    public MSNode addMSNode(MSNode o) {
        if (o instanceof Residue) {
            this.add(o);
            return o;
        }
        return null;
    }

    public void addResidue(Residue newResidue) {
        this.consideredResidues.add(newResidue);
        Residue prevResidue = this.activeResidue.getPreviousResidue();
        Residue nextResidue = this.activeResidue.getNextResidue();
        Residue prev2Residue = null;
        if (prevResidue != null) {
            prev2Residue = prevResidue.getPreviousResidue();
        }
        Residue next2Residue = null;
        if (nextResidue != null) {
            next2Residue = nextResidue.getNextResidue();
        }
        this.moveBackBoneAtoms(this.activeResidue, newResidue);
        List<Joint> joints = this.activeResidue.getJoints();
        for (Joint joint : joints) {
            newResidue.addJoint(joint);
        }
        this.activeResidue.removeFromParent();
        this.add(newResidue);
        this.activeResidue = newResidue;
        try {
            AminoAcidUtils.assignAminoAcidAtomTypes(newResidue, prevResidue, nextResidue, this.forceField, null);
            if (nextResidue != null) {
                Atom C = (Atom)newResidue.getAtomNode("C");
                Atom nextN = (Atom)nextResidue.getAtomNode("N");
                for (Joint joint : joints) {
                    Bond bond = joint.getBondList().get(0);
                    if (!bond.containsAtom(C) || !bond.containsAtom(nextN)) continue;
                    C.setBond(bond);
                }
            }
        }
        catch (BondedUtils.MissingAtomTypeException | BondedUtils.MissingHeavyAtomException exception) {
            logger.severe(exception.toString());
        }
        newResidue.finalize(true, this.forceField);
        this.updateGeometry(newResidue, prevResidue, nextResidue, prev2Residue, next2Residue);
    }

    @Override
    public void assignBondedTerms(ForceField forceField) {
        this.activeResidue.assignBondedTerms(forceField);
    }

    @Override
    public Joint createJoint(Bond bond, MSGroup group1, MSGroup group2, ForceField forceField) {
        return this.activeResidue.createJoint(bond, group1, group2, forceField);
    }

    @Override
    public Joint createJoint(MSGroup group1, MSGroup group2, ForceField forceField) {
        return this.activeResidue.createJoint(group1, group2, forceField);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiResidue multiResidue = (MultiResidue)o;
        return Objects.equals(this.getSegID(), multiResidue.getSegID()) && Objects.equals(this.getResidueNumber(), multiResidue.getResidueNumber()) && Objects.equals(this.getName(), multiResidue.getName());
    }

    @Override
    public void finalize(boolean finalizeGeometry, ForceField forceField) {
        this.activeResidue.finalize(finalizeGeometry, forceField);
    }

    @Override
    public void findDangelingAtoms() {
        this.activeResidue.findDangelingAtoms();
    }

    public Residue getActive() {
        return this.activeResidue;
    }

    @Override
    public AminoAcidUtils.AminoAcid3 getAminoAcid3() {
        return this.activeResidue.getAminoAcid3();
    }

    @Override
    public MSNode getAngles() {
        return this.activeResidue.getAngles();
    }

    @Override
    public void setAngles(MSNode t) {
        this.activeResidue.setAngles(t);
    }

    @Override
    public MSNode getAtomNode() {
        return this.activeResidue.getAtomNode();
    }

    @Override
    public void setAtomNode(MSNode t) {
        this.activeResidue.setAtomNode(t);
    }

    @Override
    public MSNode getAtomNode(int index) {
        return this.activeResidue.getAtomNode(index);
    }

    @Override
    public MSNode getAtomNode(String n) {
        return this.activeResidue.getAtomNode(n);
    }

    @Override
    public List<MSNode> getAtomNodeList() {
        return this.activeResidue.getAtomNodeList();
    }

    @Override
    public Bond getBond(String id) {
        return this.activeResidue.getBond(id);
    }

    @Override
    public Bond getBond(int index) {
        return this.activeResidue.getBond(index);
    }

    @Override
    public MSNode getBonds() {
        return this.activeResidue.getBonds();
    }

    @Override
    public void setBonds(MSNode t) {
        this.activeResidue.setBonds(t);
    }

    @Override
    public double[] getCenter() {
        return this.activeResidue.getCenter();
    }

    @Override
    public void setCenter(double[] d) {
        this.activeResidue.setCenter(d);
    }

    public List<Residue> getConsideredResidues() {
        return new ArrayList<Residue>(this.consideredResidues);
    }

    @Override
    public List<Atom> getDanglingAtoms() {
        return this.activeResidue.getDanglingAtoms();
    }

    @Override
    public void setDanglingAtoms(List<Atom> a) {
        this.activeResidue.setDanglingAtoms(a);
    }

    public List<Residue> getInactive() {
        ArrayList<Residue> ret = new ArrayList<Residue>();
        for (Residue res : this.consideredResidues) {
            if (res == this.activeResidue) continue;
            ret.add(res);
        }
        return ret;
    }

    @Override
    public double[] getMultiScaleCenter(boolean w) {
        return this.activeResidue.getMultiScaleCenter(w);
    }

    @Override
    public String getName() {
        if (this.activeResidue != null) {
            return this.activeResidue.getName();
        }
        return super.getName();
    }

    public int getResidueCount() {
        if (this.consideredResidues == null) {
            return 0;
        }
        return this.consideredResidues.size();
    }

    @Override
    public Rotamer[] getRotamers() {
        return this.rotamers;
    }

    @Override
    public Rotamer[] setRotamers(RotamerLibrary library) {
        ArrayList<Rotamer[]> usual = new ArrayList<Rotamer[]>();
        int nRots = 0;
        for (Residue residue : this.consideredResidues) {
            Rotamer[] rotamers = library.getRotamers(residue);
            if (rotamers == null || rotamers.length <= 0) continue;
            usual.add(rotamers);
            nRots += rotamers.length;
        }
        if (library.getUsingOrigCoordsRotamer()) {
            Rotamer[] allRotamers;
            if (this.originalRotamer == null && (this.residueType == Residue.ResidueType.AA || this.residueType == Residue.ResidueType.NA)) {
                ResidueState origState = this.storeState();
                double[] chi = RotamerLibrary.measureRotamer(this.activeResidue, false);
                if (this.residueType == Residue.ResidueType.AA) {
                    AminoAcidUtils.AminoAcid3 aa3 = this.getAminoAcid3();
                    this.originalRotamer = new Rotamer(aa3, origState, chi);
                } else if (this.residueType == Residue.ResidueType.NA) {
                    NucleicAcidUtils.NucleicAcid3 na3 = this.getNucleicAcid3();
                    this.originalRotamer = new Rotamer(na3, origState, chi);
                }
            }
            if (this.originalRotamer != null) {
                allRotamers = new Rotamer[nRots + 1];
                int index = 1;
                allRotamers[0] = this.originalRotamer;
                for (Rotamer[] rotamersI : usual) {
                    int nRotamers = rotamersI.length;
                    System.arraycopy(rotamersI, 0, allRotamers, index, nRotamers);
                    index += nRotamers;
                }
            } else {
                allRotamers = this.addAllDefaultRotamers(usual, nRots);
            }
            this.rotamers = allRotamers;
        } else {
            this.rotamers = this.addAllDefaultRotamers(usual, nRots);
        }
        return this.rotamers;
    }

    @Override
    public List<Atom> getSideChainAtoms() {
        return this.activeResidue.getSideChainAtoms();
    }

    @Override
    public MSNode getTermNode() {
        return this.activeResidue.getTermNode();
    }

    @Override
    public MSNode getTorsions() {
        return this.activeResidue.getTorsions();
    }

    @Override
    public void setTorsions(MSNode t) {
        this.activeResidue.setTorsions(t);
    }

    @Override
    public List<Atom> getVariableAtoms() {
        return this.activeResidue.getAtomList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getSegID(), this.getResidueNumber(), this.getName());
    }

    @Override
    public boolean isFinalized() {
        return this.activeResidue.isFinalized();
    }

    @Override
    public void setFinalized(boolean t) {
        this.activeResidue.setFinalized(t);
    }

    @Override
    public void reOrderAtoms() {
        this.activeResidue.reOrderAtoms();
    }

    public boolean setActiveResidue(int i) {
        if (this.consideredResidues == null) {
            return false;
        }
        if (i >= this.consideredResidues.size()) {
            return false;
        }
        return this.setActiveResidue(this.consideredResidues.get(i));
    }

    public boolean setActiveResidue(Residue residue) {
        if (!this.consideredResidues.contains(residue)) {
            return false;
        }
        if (residue == this.activeResidue) {
            return true;
        }
        Residue prevResidue = this.activeResidue.getPreviousResidue();
        Residue nextResidue = this.activeResidue.getNextResidue();
        Residue prev2Residue = null;
        if (prevResidue != null) {
            prev2Residue = prevResidue.getPreviousResidue();
        }
        Residue next2Residue = null;
        if (nextResidue != null) {
            next2Residue = nextResidue.getNextResidue();
        }
        this.activeResidue.removeFromParent();
        this.moveBackBoneAtoms(this.activeResidue, residue);
        this.updateGeometry(residue, prevResidue, nextResidue, prev2Residue, next2Residue);
        this.activeResidue = residue;
        this.setName(this.toString());
        this.add(this.activeResidue);
        return true;
    }

    public boolean setActiveResidue(AminoAcidUtils.AminoAcid3 aa) {
        Residue residue = null;
        for (Residue res : this.consideredResidues) {
            if (res.getAminoAcid3() != aa) continue;
            residue = res;
            break;
        }
        if (residue == null) {
            return false;
        }
        return this.setActiveResidue(residue);
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        this.activeResidue.setColor(newColorModel, color, mat);
    }

    @Override
    public void setOutOfPlaneBends(MSNode t) {
        this.activeResidue.setOutOfPlaneBends(t);
    }

    @Override
    public void setPiOrbitalTorsions(MSNode t) {
        this.activeResidue.setPiOrbitalTorsions(t);
    }

    @Override
    public void setStretchBends(MSNode t) {
        this.activeResidue.setStretchBends(t);
    }

    @Override
    public void setTerms(MSNode t) {
        this.activeResidue.setTerms(t);
    }

    @Override
    public void setTorsionTorsions(MSNode t) {
        this.activeResidue.setTorsionTorsions(t);
    }

    @Override
    public void setUreyBradleys(MSNode t) {
        this.activeResidue.setUreyBradleys(t);
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        this.activeResidue.setView(newViewModel, newShapes);
    }

    @Override
    public ResidueState storeState() {
        return this.storeMultiResState();
    }

    @Override
    public String toString() {
        int resNum = this.consideredResidues.get(0).getResidueNumber();
        StringBuilder sb = new StringBuilder();
        sb.append(resNum).append("-");
        for (Residue res : this.consideredResidues) {
            int num = AminoAcidUtils.getAminoAcidNumber(res.getName());
            String aa1 = AminoAcidUtils.AminoAcid1.values()[num].toString();
            if (res == this.activeResidue) {
                sb.append("[").append(aa1).append("]");
                continue;
            }
            sb.append(aa1);
        }
        return sb.toString();
    }

    @Override
    public void update() {
        this.activeResidue.update();
    }

    @Override
    public void updateAtoms() {
        this.activeResidue.updateAtoms();
    }

    @Override
    public void updateBonds() {
        this.activeResidue.updateBonds();
    }

    private ResidueState storeMultiResState() {
        return new ResidueState(this, this.activeResidue);
    }

    private Rotamer[] addAllDefaultRotamers(List<Rotamer[]> rotamerList, int nRots) {
        Rotamer[] allRotamers = new Rotamer[nRots];
        int index = 0;
        for (Rotamer[] rotamers : rotamerList) {
            int nRotamers = rotamers.length;
            System.arraycopy(rotamers, 0, allRotamers, index, nRotamers);
            index += nRotamers;
        }
        return allRotamers;
    }

    @Override
    public void revertState(ResidueState state) {
        Residue res = state.getStateResidue();
        if (!this.setActiveResidue(res)) {
            throw new IllegalArgumentException(String.format(" Could not revert multi-residue %s to residue identity %s", this, state.getStateResidue().toString()));
        }
        for (Atom atom : this.getAtomList()) {
            atom.moveTo(state.getAtomCoords(atom));
        }
    }

    private void moveBackBoneAtoms(Residue fromResidue, Residue toResidue) {
        Residue prevRes = this.getPreviousResidue();
        Residue nextRes = this.getNextResidue();
        Atom CA = (Atom)fromResidue.getAtomNode("CA");
        Atom C = (Atom)fromResidue.getAtomNode("C");
        Atom HA = (Atom)fromResidue.getAtomNode("HA");
        Atom N = (Atom)fromResidue.getAtomNode("N");
        Atom O = (Atom)fromResidue.getAtomNode("O");
        CA.removeFromParent();
        HA.removeFromParent();
        C.removeFromParent();
        O.removeFromParent();
        N.removeFromParent();
        CA.clearGeometry();
        HA.clearGeometry();
        C.clearGeometry();
        O.clearGeometry();
        N.clearGeometry();
        String resName = toResidue.getName();
        CA.setResName(resName);
        HA.setResName(resName);
        C.setResName(resName);
        O.setResName(resName);
        N.setResName(resName);
        toResidue.addMSNode(CA);
        toResidue.addMSNode(HA);
        toResidue.addMSNode(C);
        toResidue.addMSNode(O);
        toResidue.addMSNode(N);
        if (prevRes == null) {
            Atom H1 = (Atom)fromResidue.getAtomNode("H1");
            Atom H2 = (Atom)fromResidue.getAtomNode("H2");
            Atom H3 = (Atom)fromResidue.getAtomNode("H3");
            H1.removeFromParent();
            H2.removeFromParent();
            H1.clearGeometry();
            H2.clearGeometry();
            H1.setResName(resName);
            H2.setResName(resName);
            toResidue.addMSNode(H1);
            toResidue.addMSNode(H2);
            if (H3 != null) {
                H3.removeFromParent();
                H3.clearGeometry();
                H3.setResName(resName);
                toResidue.addMSNode(H3);
            }
        } else {
            Atom H = (Atom)fromResidue.getAtomNode("H");
            H.removeFromParent();
            H.clearGeometry();
            H.setResName(resName);
            toResidue.addMSNode(H);
        }
        if (nextRes == null) {
            Atom OXT = (Atom)fromResidue.getAtomNode("OXT");
            if (OXT != null) {
                OXT.removeFromParent();
                OXT.clearGeometry();
                OXT.setResName(resName);
                toResidue.addMSNode(OXT);
            } else {
                Atom OH = (Atom)fromResidue.getAtomNode("OH");
                Atom HO = (Atom)fromResidue.getAtomNode("HO");
                OH.removeFromParent();
                HO.removeFromParent();
                OH.clearGeometry();
                HO.clearGeometry();
                OH.setResName(resName);
                HO.setResName(resName);
                toResidue.addMSNode(OH);
                toResidue.addMSNode(HO);
            }
        }
    }

    private void updateGeometry(Residue residue, Residue prev, Residue next, Residue prev2, Residue next2) {
        List<Joint> joints;
        if (residue == null) {
            return;
        }
        List<Atom> atoms = residue.getAtomList();
        List<Bond> bonds = residue.getBondList();
        List<Angle> angles = residue.getAngleList();
        List<Torsion> torsions = residue.getTorsionList();
        if (prev != null) {
            atoms.addAll(prev.getAtomList());
            bonds.addAll(prev.getBondList());
            angles.addAll(prev.getAngleList());
            torsions.addAll(prev.getTorsionList());
            joints = prev.getJoints();
            for (Joint joint : joints) {
                bonds.addAll(joint.getBondList());
                angles.addAll(joint.getAngleList());
                torsions.addAll(joint.getTorsionList());
            }
        }
        if (prev2 != null) {
            bonds.addAll(prev2.getBondList());
            angles.addAll(prev2.getAngleList());
            torsions.addAll(prev2.getTorsionList());
        }
        if (next != null) {
            atoms.addAll(next.getAtomList());
            bonds.addAll(next.getBondList());
            angles.addAll(next.getAngleList());
            torsions.addAll(next.getTorsionList());
            joints = next.getJoints();
            for (Joint joint : joints) {
                bonds.addAll(joint.getBondList());
                angles.addAll(joint.getAngleList());
                torsions.addAll(joint.getTorsionList());
            }
        }
        if (next2 != null) {
            bonds.addAll(next2.getBondList());
            angles.addAll(next2.getAngleList());
            torsions.addAll(next2.getTorsionList());
        }
        for (Atom atom : atoms) {
            atom.clearGeometry();
        }
        for (Atom atom : atoms) {
            for (Bond b : bonds) {
                if (!b.containsAtom(atom)) continue;
                atom.setBond(b);
            }
        }
        for (Atom atom : atoms) {
            for (Angle a : angles) {
                if (!a.containsAtom(atom)) continue;
                atom.setAngle(a);
            }
        }
        for (Atom atom : atoms) {
            for (Torsion t : torsions) {
                if (!t.containsAtom(atom)) continue;
                atom.setTorsion(t);
            }
        }
    }
}

