/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.Angle;
import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.bonded.ROLS;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.StretchBend;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.bonded.Torsion;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.bonded.UreyBradley;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.vecmath.Color3f;

public class MSNode
extends DefaultMutableTreeNode
implements ROLS {
    private static final long serialVersionUID = 1L;
    private final int MultiScaleLevel;
    protected boolean selected = false;
    private String name;
    private double totalMass;

    public MSNode() {
        this.name = "";
        this.MultiScaleLevel = 5;
    }

    public MSNode(String n) {
        this.name = n;
        this.MultiScaleLevel = 5;
    }

    public MSNode(String n, int multiScaleLevel) {
        this.name = n;
        this.MultiScaleLevel = multiScaleLevel;
    }

    public MSNode contains(MSNode msNode) {
        Enumeration<TreeNode> e = this.depthFirstEnumeration();
        ArrayList<TreeNode> list = Collections.list(e);
        for (TreeNode node : list) {
            if (!node.equals(msNode)) continue;
            return (MSNode)node;
        }
        return null;
    }

    public boolean destroy() {
        if (this.getParent() != null) {
            this.removeFromParent();
        }
        this.name = null;
        this.selected = false;
        return true;
    }

    @Override
    public void drawLabel(Canvas3D graphics, J3DGraphics2D g2d, Node node) {
        if (!this.isSelected()) {
            return;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode dataNode = (MSNode)e.nextElement();
            dataNode.drawLabel(graphics, g2d, node);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSNode msNode = (MSNode)o;
        return Objects.equals(this.name, msNode.getName());
    }

    public List<Angle> getAngleList() {
        return this.getList(Angle.class);
    }

    public List<AngleTorsion> getAngleTorsionList() {
        return this.getList(AngleTorsion.class);
    }

    public List<Atom> getAtomList() {
        List<Atom> atomList = this.getList(Atom.class);
        Collections.sort(atomList);
        return atomList;
    }

    public Atom getFirstActiveHeavyAtom() {
        List<Atom> atomList = this.getAtomList();
        for (Atom atom : atomList) {
            if (!atom.isHeavy() || !atom.isActive()) continue;
            return atom;
        }
        return null;
    }

    public List<Atom> getAtomList(boolean originalOrder) {
        return this.getAtomList();
    }

    public List<Bond> getBondList() {
        return this.getList(Bond.class);
    }

    @Override
    public double[] getCenter(boolean w) {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        double sum = 0.0;
        double mass = 1.0;
        List<Atom> atomList = this.getAtomList();
        for (Atom a : atomList) {
            if (w) {
                mass = a.getMass();
                sum += mass;
            }
            Rc[0] = Rc[0] + mass * a.getX();
            Rc[1] = Rc[1] + mass * a.getY();
            Rc[2] = Rc[2] + mass * a.getZ();
        }
        if (!w) {
            sum = atomList.size();
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            Rc[n] = Rc[n] / sum;
        }
        return Rc;
    }

    public List<MSNode> getChildList() {
        ArrayList<MSNode> l = new ArrayList<MSNode>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            l.add((MSNode)e.nextElement());
        }
        return l;
    }

    public double getExtent() {
        double extent = 0.0;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            double temp = node.getExtent();
            if (!(temp > extent)) continue;
            extent = temp;
        }
        return extent;
    }

    public List<ImproperTorsion> getImproperTorsionList() {
        return this.getList(ImproperTorsion.class);
    }

    public <T extends TreeNode> List<T> getList(Class<T> c) {
        return this.getList(c, new ArrayList());
    }

    @Override
    public <T extends TreeNode> List<T> getList(Class<T> c, List<T> nodes) {
        if (c.isInstance(this)) {
            nodes.add((TreeNode)c.cast(this));
        }
        if (this.isLeaf() || !this.canBeChild(c)) {
            return nodes;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.getList(c, nodes);
        }
        return nodes;
    }

    @Override
    public <T extends TreeNode> long getMSCount(Class<T> c, long count) {
        if (c.isInstance(this)) {
            ++count;
        }
        if (!this.canBeChild(c)) {
            return count;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            count += node.getMSCount(c, count);
        }
        return count;
    }

    @Override
    public <T extends TreeNode> T getMSNode(Class<T> c) {
        TreeNode[] nodes;
        for (TreeNode n : nodes = this.getPath()) {
            if (!c.isInstance(n)) continue;
            return (T)((TreeNode)c.cast(n));
        }
        return null;
    }

    @Override
    public double getMW() {
        double weight = 0.0;
        for (Atom atom : this.getAtomList()) {
            weight += atom.getMass();
        }
        return weight;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public List<OutOfPlaneBend> getOutOfPlaneBendList() {
        return this.getList(OutOfPlaneBend.class);
    }

    public List<PiOrbitalTorsion> getPiOrbitalTorsionList() {
        return this.getList(PiOrbitalTorsion.class);
    }

    public List<StretchBend> getStretchBendList() {
        return this.getList(StretchBend.class);
    }

    public List<StretchTorsion> getStretchTorsionList() {
        return this.getList(StretchTorsion.class);
    }

    public List<Torsion> getTorsionList() {
        return this.getList(Torsion.class);
    }

    public List<TorsionTorsion> getTorsionTorsionList() {
        return this.getList(TorsionTorsion.class);
    }

    public double getTotalMass() {
        if (this.totalMass == 0.0) {
            return this.getTotalMass(true, false);
        }
        return this.totalMass;
    }

    public List<UreyBradley> getUreyBradleyList() {
        return this.getList(UreyBradley.class);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.setSelected(b);
        }
    }

    public void print() {
        System.out.println(this.name);
    }

    public void removeChild(MSNode child) {
        if (child != null && child.getParent() == this) {
            this.remove(child);
        }
    }

    @Override
    public void setColor(RendererCache.ColorModel colorModel, Color3f color, Material mat) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.setColor(colorModel, color, mat);
        }
    }

    @Override
    public void setView(RendererCache.ViewModel viewModel, List<BranchGroup> newShapes) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.setView(viewModel, newShapes);
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void update() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.update();
        }
    }

    private double getTotalMass(boolean recalculate, boolean useKahan) {
        if (recalculate) {
            List<Atom> atoms = this.getAtomList();
            this.totalMass = atoms.isEmpty() ? 0.0 : (useKahan ? this.kahanSumMasses(atoms) : this.sumMasses(atoms));
        }
        return this.totalMass;
    }

    private double sumMasses(List<Atom> atoms) {
        double sumMasses = 0.0;
        for (Atom atom : atoms) {
            sumMasses += atom.getMass();
        }
        return sumMasses;
    }

    private double kahanSumMasses(List<Atom> atoms) {
        double sum = 0.0;
        double comp = 0.0;
        for (Atom atom : atoms) {
            double atomMass = atom.getMass() - comp;
            double temp = sum + atomMass;
            comp = temp - sum - atomMass;
            sum = temp;
        }
        return sum;
    }

    private <T extends TreeNode> boolean canBeChild(Class<T> c) {
        try {
            int multiScaleLevel = c.getDeclaredField("MultiScaleLevel").getInt(null);
            if (multiScaleLevel >= this.MultiScaleLevel) {
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return true;
        }
        return true;
    }
}

