/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.Angle;
import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.StretchBend;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.bonded.Torsion;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.bonded.UreyBradley;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;

public class Joint
extends MSNode {
    private static final long serialVersionUID = 1L;
    private final MSGroup group1;
    private final MSGroup group2;

    public Joint() {
        super("Joint");
        this.group2 = null;
        this.group1 = null;
    }

    public Joint(String name) {
        super(name);
        this.group2 = null;
        this.group1 = null;
    }

    public Joint(MSGroup group1, MSGroup group2, MSNode bondNode, MSNode angleNode, MSNode stretchBendNode, MSNode ureyBradleyNode, MSNode outOfPlaneNode, MSNode torsionNode, MSNode improperTorsionNode, MSNode stretchTorsionNode, MSNode angleTorsionNode, MSNode piOrbitalTorsionNode, MSNode torsionTorsionNode) {
        super(String.valueOf(group1) + "  " + String.valueOf(group2));
        this.group1 = group1;
        this.group2 = group2;
        if (bondNode != null && bondNode.getChildCount() != 0) {
            this.add(bondNode);
        }
        if (angleNode != null && angleNode.getChildCount() != 0) {
            this.add(angleNode);
        }
        if (stretchBendNode != null && stretchBendNode.getChildCount() != 0) {
            this.add(stretchBendNode);
        }
        if (ureyBradleyNode != null && ureyBradleyNode.getChildCount() != 0) {
            this.add(ureyBradleyNode);
        }
        if (outOfPlaneNode != null && outOfPlaneNode.getChildCount() != 0) {
            this.add(outOfPlaneNode);
        }
        if (torsionNode != null && torsionNode.getChildCount() != 0) {
            this.add(torsionNode);
        }
        if (improperTorsionNode != null && improperTorsionNode.getChildCount() != 0) {
            this.add(improperTorsionNode);
        }
        if (stretchTorsionNode != null && stretchTorsionNode.getChildCount() != 0) {
            this.add(stretchTorsionNode);
        }
        if (angleTorsionNode != null && angleTorsionNode.getChildCount() != 0) {
            this.add(angleTorsionNode);
        }
        if (piOrbitalTorsionNode != null && piOrbitalTorsionNode.getChildCount() != 0) {
            this.add(piOrbitalTorsionNode);
        }
        if (torsionTorsionNode != null && torsionTorsionNode.getChildCount() != 0) {
            this.add(torsionTorsionNode);
        }
        this.refresh(null, null, null, null, null, null, null, null, null, null, null);
    }

    public void merge(Joint j) {
        if (!(this.group1 == j.group1 && this.group2 == j.group2 || this.group2 == j.group1 && this.group1 == j.group2)) {
            return;
        }
        this.refresh(j.getNode(Bond.class), j.getNode(Angle.class), j.getNode(StretchBend.class), j.getNode(UreyBradley.class), j.getNode(OutOfPlaneBend.class), j.getNode(Torsion.class), j.getNode(ImproperTorsion.class), j.getNode(StretchTorsion.class), j.getNode(AngleTorsion.class), j.getNode(PiOrbitalTorsion.class), j.getNode(TorsionTorsion.class));
    }

    public void setColor(RendererCache.ColorModel newColorModel) {
        MSNode bonds = this.getNode(Bond.class);
        if (bonds == null) {
            return;
        }
        Enumeration<TreeNode> e = bonds.children();
        while (e.hasMoreElements()) {
            Bond b = (Bond)e.nextElement();
            b.setColor(b.getAtom(0));
            b.setColor(b.getAtom(1));
        }
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        MSNode bonds = this.getNode(Bond.class);
        if (bonds == null) {
            return;
        }
        Enumeration<TreeNode> e = bonds.children();
        while (e.hasMoreElements()) {
            Bond b = (Bond)e.nextElement();
            b.setView(newViewModel, newShapes);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void refresh(MSNode bonds, MSNode angles, MSNode stretchBends, MSNode ureyBradleys, MSNode outOfPlaneBends, MSNode torsions, MSNode improperTorsions, MSNode stretchTorsions, MSNode angleTorsions, MSNode piOrbitalTorsions, MSNode torsionTorsions) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode jointChild = (MSNode)e.nextElement();
            if (jointChild.getChildCount() == 0) {
                jointChild.removeFromParent();
                continue;
            }
            MSNode node = (MSNode)jointChild.getChildAt(0);
            if (node instanceof Bond) {
                this.addAll("Bonds", jointChild, bonds);
                bonds = null;
                continue;
            }
            if (node instanceof Angle) {
                this.addAll("Angles", jointChild, angles);
                angles = null;
                continue;
            }
            if (node instanceof StretchBend) {
                this.addAll("Stretch-Bends", jointChild, stretchBends);
                stretchBends = null;
                continue;
            }
            if (node instanceof UreyBradley) {
                this.addAll("Urey-Bradleys", jointChild, ureyBradleys);
                ureyBradleys = null;
                continue;
            }
            if (node instanceof OutOfPlaneBend) {
                this.addAll("Out-of-Plane Bends", jointChild, outOfPlaneBends);
                outOfPlaneBends = null;
                continue;
            }
            if (node instanceof Torsion) {
                this.addAll("Torsional Angles", jointChild, torsions);
                torsions = null;
                continue;
            }
            if (node instanceof ImproperTorsion) {
                this.addAll("Improper Torsions", jointChild, improperTorsions);
                improperTorsions = null;
                continue;
            }
            if (node instanceof StretchTorsion) {
                this.addAll("Stretch-Torsions", jointChild, stretchTorsions);
                stretchTorsions = null;
                continue;
            }
            if (node instanceof AngleTorsion) {
                this.addAll("Angle-Torsions", jointChild, angleTorsions);
                angleTorsions = null;
                continue;
            }
            if (node instanceof PiOrbitalTorsion) {
                this.addAll("Pi-Orbital Torsions", jointChild, piOrbitalTorsions);
                piOrbitalTorsions = null;
                continue;
            }
            if (!(node instanceof TorsionTorsion)) continue;
            this.addAll("Torsion-Torsions", jointChild, torsionTorsions);
            torsionTorsions = null;
        }
        if (bonds != null) {
            this.add(bonds);
        }
        if (angles != null) {
            this.add(angles);
        }
        if (stretchBends != null) {
            this.add(stretchBends);
        }
        if (ureyBradleys != null) {
            this.add(ureyBradleys);
        }
        if (outOfPlaneBends != null) {
            this.add(outOfPlaneBends);
        }
        if (torsions != null) {
            this.add(torsions);
        }
        if (improperTorsions != null) {
            this.add(improperTorsions);
        }
        if (stretchTorsions != null) {
            this.add(stretchTorsions);
        }
        if (angleTorsions != null) {
            this.add(angleTorsions);
        }
        if (piOrbitalTorsions != null) {
            this.add(piOrbitalTorsions);
        }
        if (torsionTorsions != null) {
            this.add(torsionTorsions);
        }
    }

    private void addAll(String name, MSNode parent, MSNode node) {
        if (node == null) {
            return;
        }
        for (MSNode bond : node.getChildList()) {
            parent.add(bond);
        }
        parent.setName(name + " (" + parent.getChildCount() + ")");
    }

    private MSNode getNode(Class<? extends BondedTerm> clazz) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode m = (MSNode)e.nextElement();
            TreeNode node = m.getChildAt(0);
            if (!node.getClass().equals(clazz)) continue;
            return m;
        }
        return null;
    }
}

