/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.math.Double3;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.PolarizeType;
import ffx.potential.parameters.SoluteType;
import ffx.potential.parameters.VDWType;
import ffx.potential.utils.EnergyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class Atom
extends MSNode
implements Comparable<Atom> {
    public static final Map<Integer, Color3f> AtomColor;
    private static final Logger logger;
    private static final Map<Integer, Double> AtomVDW;
    private static final Map<String, Integer> hybridTable;
    private static final Point3d point3d;
    private static final Point2d point2d;
    public static Comparator<Atom> XYZIndexComparator;
    private final double[] xyz = new double[3];
    private final double[] velocity = new double[3];
    private final double[] acceleration = new double[3];
    private final double[] previousAcceleration = new double[3];
    private final double[] xyzGradient = new double[3];
    private final double[] xyzLambdaGradient = new double[3];
    private final List<Bond> bonds = new ArrayList<Bond>();
    private final List<Angle> angles = new ArrayList<Angle>();
    private final List<Torsion> torsions = new ArrayList<Torsion>();
    private final Vector3d vector3d = new Vector3d();
    private int xyzIndex = -1;
    private int topologyAtomIndex = -1;
    private int topologyIndex = -1;
    private String resName = null;
    private int resSeq = -1;
    private Character chainID = null;
    private Character altLoc;
    private double mass;
    private double[] redXYZ;
    private double occupancy;
    private double occupancyGradient;
    private double occupancyVelocity;
    private double occupancyAcceleration;
    private double occupancyPreviousAcceleration;
    private double tempFactor;
    private double tempFactorGradient;
    private double tempFactorVelocity;
    private double tempFactorAcceleration;
    private double tempFactorPreviousAcceleration;
    private double[] anisou;
    private double[] anisouGradient;
    private double[] anisouVelocity;
    private double[] anisouAcceleration;
    private double[] anisouPreviousAcceleration;
    private Resolution resolution = Resolution.AMOEBA;
    private boolean use = true;
    private boolean active = true;
    private boolean built = false;
    private boolean hetatm = false;
    private boolean modres = false;
    private boolean electrostatics = true;
    private boolean neuralNetwork = false;
    private List<Integer> specialPositionSymOps = null;
    private String segID = null;
    private double formFactorWidth = 3.5;
    private double formFactorWidth2 = this.formFactorWidth * this.formFactorWidth;
    private int xrayCoordIndex = -1;
    private ArrayList<Vector3d> trajectory;
    private AtomType atomType = null;
    private MultipoleType multipoleType = null;
    private int[] axisAtomIndices = null;
    private PolarizeType polarizeType = null;
    private VDWType vdwType = null;
    private SoluteType soluteType = null;
    private boolean applyState = false;
    private int moleculeNumber = 0;
    private RendererCache.ViewModel viewModel = RendererCache.ViewModel.INVISIBLE;
    private RendererCache.ViewModel polygonType = RendererCache.ViewModel.FILL;
    private Shape3D sphere;
    private BranchGroup branchGroup;
    private TransformGroup transformGroup;
    private Transform3D transform3D;
    private Appearance appearance;
    private Color3f currentCol;
    private Color3f previousCol;
    private Color3f userColor = RendererCache.userColor;
    private int detail = RendererCache.detail;
    private double radius = RendererCache.radius;
    private double scale = 1.0;
    private boolean stale = false;

    public Atom(String name) {
        super(name, 1);
        this.currentCol = this.previousCol = RendererCache.toAtomColor(name);
        this.redXYZ = null;
        this.mass = 1.008;
    }

    public Atom(int xyzIndex, String name, AtomType atomType, double[] xyz) {
        this(name);
        this.xyzIndex = xyzIndex;
        this.atomType = atomType;
        System.arraycopy(xyz, 0, this.xyz, 0, 3);
        this.setAllowsChildren(false);
        if (atomType != null) {
            this.mass = atomType.atomicWeight;
            this.currentCol = this.previousCol = AtomColor.get(atomType.atomicNumber);
        }
    }

    public Atom(int xyzIndex, String name, Character altLoc, double[] xyz, String resName, int resSeq, Character chainID, double occupancy, double tempFactor, String segID) {
        this(xyzIndex, name, null, xyz);
        this.resName = resName;
        this.resSeq = resSeq;
        this.chainID = chainID;
        this.altLoc = altLoc;
        this.occupancy = occupancy;
        this.tempFactor = tempFactor;
        this.segID = segID;
    }

    public Atom(int xyzIndex, String name, Character altLoc, double[] xyz, String resName, int resSeq, Character chainID, double occupancy, double tempFactor, String segID, boolean built) {
        this(xyzIndex, name, altLoc, xyz, resName, resSeq, chainID, occupancy, tempFactor, segID);
        this.built = built;
    }

    public Atom(int xyzIndex, Atom copyFrom, double[] xyz, int resSeq, char chainID, String segID) {
        this(xyzIndex, copyFrom.getName(), copyFrom.getAltLoc(), xyz, copyFrom.getResidueName(), resSeq, Character.valueOf(chainID), copyFrom.getOccupancy(), copyFrom.getTempFactor(), segID);
        this.setAtomType(copyFrom.getAtomType());
        double[] aniso = new double[3];
        aniso = copyFrom.getAnisou(aniso);
        this.setAnisou(aniso);
        this.setApplyLambda(copyFrom.applyLambda());
        this.setElectrostatics(copyFrom.getElectrostatics());
        this.setHetero(copyFrom.isHetero());
        this.setMass(copyFrom.getMass());
        this.setModRes(copyFrom.modres);
    }

    public void addToAnisouGradient(double[] anisouGradient) {
        if (this.active) {
            if (anisouGradient == null) {
                return;
            }
            if (this.anisouGradient == null) {
                this.anisouGradient = Arrays.copyOf(anisouGradient, 6);
            } else {
                for (int i = 0; i < 6; ++i) {
                    int n = i;
                    this.anisouGradient[n] = this.anisouGradient[n] + anisouGradient[i];
                }
            }
        }
    }

    public void addToLambdaXYZGradient(double x, double y, double z) {
        if (this.active) {
            this.xyzLambdaGradient[0] = this.xyzLambdaGradient[0] + x;
            this.xyzLambdaGradient[1] = this.xyzLambdaGradient[1] + y;
            this.xyzLambdaGradient[2] = this.xyzLambdaGradient[2] + z;
        }
    }

    public void addToOccupancyGradient(double occupancyGradient) {
        if (this.active) {
            this.occupancyGradient += occupancyGradient;
        }
    }

    public void addToTempFactorGradient(double tempFactorGradient) {
        if (this.active) {
            this.tempFactorGradient += tempFactorGradient;
        }
    }

    public void addToXYZGradient(double x, double y, double z) {
        if (this.active) {
            if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(y) || Double.isInfinite(y) || Double.isNaN(z) || Double.isInfinite(z)) {
                StringBuilder sb = new StringBuilder(String.format(" Attempted to add undefined gradient (%8.3f,%8.3f,%8.3f) to atom:\n %s", x, y, z, this));
                double[] vals = new double[3];
                this.getVelocity(vals);
                sb.append(String.format("\n Velocities:             %26.16E%26.16E%26.16E", vals[0], vals[1], vals[2]));
                this.getAcceleration(vals);
                sb.append(String.format("\n Accelerations:          %26.16E%26.16E%26.16E", vals[0], vals[1], vals[2]));
                this.getPreviousAcceleration(vals);
                sb.append(String.format("\n Previous accelerations: %26.16E%26.16E%26.16E", vals[0], vals[1], vals[2]));
                throw new EnergyException(sb.toString());
            }
            this.xyzGradient[0] = this.xyzGradient[0] + x;
            this.xyzGradient[1] = this.xyzGradient[1] + y;
            this.xyzGradient[2] = this.xyzGradient[2] + z;
        }
    }

    public void addToXYZGradient(int axis, double value) {
        if (this.active) {
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                StringBuilder sb = new StringBuilder(String.format("Adding gradient of atom %s of value %8.3f to axis %2d is not permitted.", this, value, axis));
                double[] vals = new double[3];
                this.getVelocity(vals);
                sb.append(String.format("\n Velocities: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                this.getAcceleration(vals);
                sb.append(String.format("\n Accelerations: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                this.getPreviousAcceleration(vals);
                sb.append(String.format("\n Previous accelerations: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                throw new EnergyException(sb.toString());
            }
            int n = axis;
            this.xyzGradient[n] = this.xyzGradient[n] + value;
        }
    }

    public boolean applyLambda() {
        return this.applyState;
    }

    @Override
    public int compareTo(Atom a) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (a == this) {
            return 0;
        }
        return Integer.compare(this.xyzIndex, a.xyzIndex);
    }

    public String describe(Descriptions type) {
        return switch (type.ordinal()) {
            default -> this.toString();
            case 1 -> String.format("%d-%-3s %s %s%d", this.getIndex(), this.getName(), this.resName, this.segID, this.resSeq);
            case 2 -> String.format("%d-%s", this.getIndex(), this.getName());
            case 3 -> String.format("%d-%s", this.getIndex() - 1, this.getName());
            case 4 -> String.format("%d-%s", this.resSeq, this.getName());
        };
    }

    @Override
    public void drawLabel(Canvas3D canvas, J3DGraphics2D g2d, Node node) {
        if (RendererCache.labelAtoms) {
            Atom.point3d.x = this.getX();
            Atom.point3d.y = this.getY();
            Atom.point3d.z = this.getZ();
            RendererCache.getScreenCoordinate(canvas, node, point3d, point2d);
            g2d.drawString(this.describe(Descriptions.XyzIndex_Name), (float)Atom.point2d.x, (float)Atom.point2d.y);
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Atom atom = (Atom)o;
        if (this.segID == null || atom.segID == null) {
            return false;
        }
        return Objects.equals(this.resName, atom.resName) && this.resSeq == atom.resSeq && Objects.equals(this.getName(), atom.getName()) && Objects.equals(this.segID, atom.segID);
    }

    public List<Atom> get12List() {
        ArrayList<Atom> n12 = new ArrayList<Atom>();
        for (Bond b : this.bonds) {
            Atom atom = b.get1_2(this);
            n12.add(atom);
        }
        n12.sort(XYZIndexComparator);
        return n12;
    }

    public List<Atom> get13List() {
        List<Atom> n12 = this.get12List();
        ArrayList<Atom> n13 = new ArrayList<Atom>();
        for (Atom a12 : n12) {
            List<Atom> bond12 = a12.get12List();
            for (Atom a13 : bond12) {
                if (a13 == this || n12.contains(a13)) continue;
                n13.add(a13);
            }
        }
        n13.sort(XYZIndexComparator);
        return n13;
    }

    public List<Atom> get14List() {
        List<Atom> n12 = this.get12List();
        List<Atom> n13 = this.get13List();
        ArrayList<Atom> n14 = new ArrayList<Atom>();
        for (Atom a13 : n13) {
            List<Atom> bond13 = a13.get12List();
            for (Atom a14 : bond13) {
                if (a14 == this || n12.contains(a14) || n13.contains(a14)) continue;
                n14.add(a14);
            }
        }
        n14.sort(XYZIndexComparator);
        return n14;
    }

    public List<Atom> get15List() {
        List<Atom> n12 = this.get12List();
        List<Atom> n13 = this.get13List();
        List<Atom> n14 = this.get14List();
        ArrayList<Atom> n15 = new ArrayList<Atom>();
        for (Atom a14 : n14) {
            List<Atom> bond12 = a14.get12List();
            for (Atom a15 : bond12) {
                if (a15 == this || n12.contains(a15) || n13.contains(a15) || n14.contains(a15)) continue;
                n15.add(a15);
            }
        }
        n15.sort(XYZIndexComparator);
        return n15;
    }

    public void getAcceleration(double[] acceleration) {
        if (acceleration == null) {
            acceleration = new double[]{this.acceleration[0], this.acceleration[1], this.acceleration[2]};
        }
    }

    public Character getAltLoc() {
        return this.altLoc;
    }

    public void setAltLoc(Character a) {
        this.altLoc = a;
    }

    public Angle getAngle(Atom centralAtom, Atom endAtom) {
        for (Angle angle : this.angles) {
            Atom atom13 = angle.get1_3(this);
            if (atom13 == null || !atom13.equals(endAtom) || !angle.getCentralAtom().equals(centralAtom)) continue;
            return angle;
        }
        return null;
    }

    public List<Angle> getAngles() {
        return this.angles;
    }

    public double[] getAnisou(@Nullable double[] anisou) {
        if (this.anisou == null) {
            return null;
        }
        if (anisou == null || anisou.length < 6) {
            anisou = Arrays.copyOf(this.anisou, 6);
        } else {
            System.arraycopy(this.anisou, 0, anisou, 0, 6);
        }
        return anisou;
    }

    public double[] getAnisouAcceleration(@Nullable double[] anisouAcceleration) {
        if (this.anisouAcceleration == null) {
            return null;
        }
        if (anisouAcceleration == null || anisouAcceleration.length < 6) {
            anisouAcceleration = Arrays.copyOf(this.anisouAcceleration, 6);
        } else {
            System.arraycopy(this.anisouAcceleration, 0, anisouAcceleration, 0, 6);
        }
        return anisouAcceleration;
    }

    public double[] getAnisouGradient(@Nullable double[] anisouGradient) {
        if (this.anisouGradient == null) {
            return null;
        }
        if (anisouGradient == null || anisouGradient.length < 6) {
            anisouGradient = Arrays.copyOf(this.anisouGradient, 6);
        } else {
            System.arraycopy(this.anisouGradient, 0, anisouGradient, 0, 6);
        }
        return anisouGradient;
    }

    public double[] getAnisouPreviousAcceleration(@Nullable double[] anisouPreviousAcceleration) {
        if (this.anisouPreviousAcceleration == null) {
            return null;
        }
        if (anisouPreviousAcceleration == null || anisouPreviousAcceleration.length < 6) {
            anisouPreviousAcceleration = Arrays.copyOf(this.anisouPreviousAcceleration, 6);
        } else {
            System.arraycopy(this.anisouPreviousAcceleration, 0, anisouPreviousAcceleration, 0, 6);
        }
        return anisouPreviousAcceleration;
    }

    public double[] getAnisouVelocity(@Nullable double[] anisouVelocity) {
        if (this.anisouVelocity == null) {
            return null;
        }
        if (anisouVelocity == null || anisouVelocity.length < 6) {
            anisouVelocity = Arrays.copyOf(this.anisouVelocity, 6);
        } else {
            System.arraycopy(this.anisouVelocity, 0, anisouVelocity, 0, 6);
        }
        return anisouVelocity;
    }

    public final int getTopologyAtomIndex() {
        return this.topologyAtomIndex;
    }

    public final void setTopologyAtomIndex(int topologyAtomIndex) {
        this.topologyAtomIndex = topologyAtomIndex;
    }

    public final int getTopologyIndex() {
        return this.topologyIndex;
    }

    public final void setTopologyIndex(int topologyIndex) {
        this.topologyIndex = topologyIndex;
    }

    public final int getArrayIndex() {
        return this.xyzIndex - 1;
    }

    @Override
    public List<Atom> getAtomList() {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        atoms.add(this);
        return atoms;
    }

    public AtomType getAtomType() {
        return this.atomType;
    }

    public void setAtomType(AtomType atomType) {
        this.atomType = atomType;
        this.mass = atomType.atomicWeight;
    }

    public int getAtomicNumber() {
        return this.atomType.atomicNumber;
    }

    public int[] getAxisAtomIndices() {
        return ArrayUtils.clone((int[])this.axisAtomIndices);
    }

    public Bond getBond(Atom a) {
        for (Bond bond : this.bonds) {
            if (bond.get1_2(a) != this) continue;
            return bond;
        }
        return null;
    }

    public List<Bond> getBonds() {
        return this.bonds;
    }

    public boolean getBuilt() {
        return this.built;
    }

    public void setBuilt(boolean built) {
        this.built = built;
    }

    public Character getChainID() {
        if (this.chainID != null) {
            return this.chainID;
        }
        Polymer p = this.getMSNode(Polymer.class);
        if (p == null) {
            return null;
        }
        this.chainID = Character.valueOf(p.getName().charAt(0));
        return this.chainID;
    }

    public void setChainID(Character chainID) {
        this.chainID = chainID;
    }

    public double getCharge() throws IllegalStateException {
        return this.getCharge(null);
    }

    public double getCharge(ForceField ff) {
        if (this.multipoleType != null) {
            return this.multipoleType.getCharge();
        }
        if (ff != null) {
            String key = this.atomType.getKey();
            return ff.getMultipoleType(key).getCharge();
        }
        throw new IllegalStateException(String.format(" Atom %s does not yet have an assigned multipole type!", this));
    }

    public boolean getElectrostatics() {
        return this.electrostatics;
    }

    public void setElectrostatics(boolean electrostatics) {
        this.electrostatics = electrostatics;
    }

    public double getEpsilon() {
        return 1.0;
    }

    public int getXrayCoordIndex() {
        return this.xrayCoordIndex;
    }

    public void setXrayCoordIndex(int xrayCoordIndex) {
        this.xrayCoordIndex = xrayCoordIndex;
    }

    public double getFormFactorWidth() {
        return this.formFactorWidth;
    }

    public void setFormFactorWidth(double width) {
        this.formFactorWidth = width;
        this.formFactorWidth2 = width * width;
    }

    public double getFormFactorWidth2() {
        return this.formFactorWidth2;
    }

    public int getHybridization() {
        return this.atomType.valence;
    }

    public String getIdent() {
        return this.atomType.environment;
    }

    public final int getIndex() {
        return this.xyzIndex;
    }

    public String getKey() {
        if (this.atomType != null) {
            return this.atomType.getKey();
        }
        return null;
    }

    public void getLambdaXYZGradient(double[] x) {
        if (x == null) {
            x = new double[]{this.xyzLambdaGradient[0], this.xyzLambdaGradient[1], this.xyzLambdaGradient[2]};
        }
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public int getMoleculeNumber() {
        return this.moleculeNumber;
    }

    public void setMoleculeNumber(int molecule) {
        this.moleculeNumber = molecule;
    }

    public MultipoleType getMultipoleType() {
        return this.multipoleType;
    }

    public void setMultipoleType(MultipoleType multipoleType) {
        this.multipoleType = multipoleType;
    }

    public final int getNumAngles() {
        return this.angles.size();
    }

    public final int getNumBonds() {
        return this.bonds.size();
    }

    public final int getNumDihedrals() {
        return this.torsions.size();
    }

    public int getNumberOfBondedHydrogen() {
        List<Bond> bonds = this.getBonds();
        int n = 0;
        for (Bond b1 : bonds) {
            Atom atom = b1.get1_2(this);
            if (atom.getAtomType().atomicNumber != 1) continue;
            ++n;
        }
        return n;
    }

    public double getOccupancy() {
        return this.occupancy;
    }

    public void setOccupancy(double occupancy) {
        if (this.active) {
            this.occupancy = occupancy;
        }
    }

    public double getOccupancyAcceleration() {
        return this.occupancyAcceleration;
    }

    public void setOccupancyAcceleration(double occupancyAcceleration) {
        if (this.active) {
            this.occupancyAcceleration = occupancyAcceleration;
        }
    }

    public double getOccupancyGradient() {
        return this.occupancyGradient;
    }

    public void setOccupancyGradient(double occupancyGradient) {
        if (this.active) {
            this.occupancyGradient = occupancyGradient;
        }
    }

    public double getOccupancyPreviousAcceleration() {
        return this.occupancyPreviousAcceleration;
    }

    public void setOccupancyPreviousAcceleration(double occupancyPreviousAcceleration) {
        if (this.active) {
            this.occupancyPreviousAcceleration = occupancyPreviousAcceleration;
        }
    }

    public double getOccupancyVelocity() {
        return this.occupancyVelocity;
    }

    public void setOccupancyVelocity(double occupancyVelocity) {
        if (this.active) {
            this.occupancyVelocity = occupancyVelocity;
        }
    }

    public PolarizeType getPolarizeType() {
        return this.polarizeType;
    }

    public void setPolarizeType(PolarizeType polarizeType) {
        this.polarizeType = polarizeType;
    }

    public void getPreviousAcceleration(double[] previousAcceleration) {
        if (previousAcceleration == null) {
            previousAcceleration = new double[]{this.previousAcceleration[0], this.previousAcceleration[1], this.previousAcceleration[2]};
        }
    }

    public final double getRedX() {
        return this.redXYZ == null ? this.xyz[0] : this.redXYZ[0];
    }

    public void getRedXYZ(double[] x) {
        if (this.redXYZ != null) {
            x[0] = this.redXYZ[0];
            x[1] = this.redXYZ[1];
            x[2] = this.redXYZ[2];
        } else {
            this.getXYZ(x);
        }
    }

    public double[] getRedXYZ() {
        if (this.active) {
            return this.redXYZ == null ? this.xyz : this.redXYZ;
        }
        if (this.redXYZ != null) {
            return Arrays.copyOf(this.redXYZ, 3);
        }
        return Arrays.copyOf(this.xyz, 3);
    }

    public void setRedXYZ(double[] redXYZ) {
        if (this.active) {
            if (this.redXYZ == null) {
                this.redXYZ = new double[3];
            }
            this.redXYZ[0] = redXYZ[0];
            this.redXYZ[1] = redXYZ[1];
            this.redXYZ[2] = redXYZ[2];
        }
    }

    public final double getRedY() {
        return this.redXYZ == null ? this.xyz[1] : this.redXYZ[1];
    }

    public final double getRedZ() {
        return this.redXYZ == null ? this.xyz[2] : this.redXYZ[2];
    }

    public String getResidueName() {
        if (this.resName != null) {
            return this.resName;
        }
        Residue r = this.getMSNode(Residue.class);
        if (r != null) {
            return r.getName();
        }
        return null;
    }

    public int getResidueNumber() {
        return this.resSeq;
    }

    public void setResidueNumber(int resNumber) {
        this.resSeq = resNumber;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public String getSegID() {
        return this.segID;
    }

    public void setSegID(String segID) {
        this.segID = segID;
    }

    public double getSigma() {
        return 1.0;
    }

    public double getTempFactor() {
        return this.tempFactor;
    }

    public void setTempFactor(double tempFactor) {
        if (this.active) {
            this.tempFactor = tempFactor;
        }
    }

    public double getTempFactorAcceleration() {
        return this.tempFactorAcceleration;
    }

    public void setTempFactorAcceleration(double tempFactorAcceleration) {
        if (this.active) {
            this.tempFactorAcceleration = tempFactorAcceleration;
        }
    }

    public double getTempFactorGradient() {
        return this.tempFactorGradient;
    }

    public void setTempFactorGradient(double tempFactorGradient) {
        if (this.active) {
            this.tempFactorGradient = tempFactorGradient;
        }
    }

    public double getTempFactorPreviousAcceleration() {
        return this.tempFactorPreviousAcceleration;
    }

    public void setTempFactorPreviousAcceleration(double tempFactorPreviousAcceleration) {
        if (this.active) {
            this.tempFactorPreviousAcceleration = tempFactorPreviousAcceleration;
        }
    }

    public double getTempFactorVelocity() {
        return this.tempFactorVelocity;
    }

    public void setTempFactorVelocity(double tempFactorVelocity) {
        if (this.active) {
            this.tempFactorVelocity = tempFactorVelocity;
        }
    }

    public Torsion getTorsion(Atom atom2, Atom atom3, Atom atom4) {
        for (Torsion torsion : this.torsions) {
            if (!torsion.compare(this, atom2, atom3, atom4)) continue;
            return torsion;
        }
        return null;
    }

    public List<Torsion> getTorsions() {
        return this.torsions;
    }

    public Vector3d getTrajectoryCoords(int position) {
        return this.trajectory.get(position);
    }

    public int getTrajectoryLength() {
        return this.trajectory.size();
    }

    public int getType() {
        return this.atomType.type;
    }

    public boolean getUse() {
        return this.use;
    }

    public void setUse(boolean use) {
        this.use = use;
    }

    public void getV3D(Vector3d temp) {
        temp.set(this.xyz);
    }

    public double getVDWR() {
        return 1.0;
    }

    public VDWType getVDWType() {
        return this.vdwType;
    }

    public void setVDWType(VDWType vdwType) {
        this.vdwType = vdwType;
    }

    public SoluteType getSoluteType() {
        return this.soluteType;
    }

    public void setSoluteType(SoluteType soluteType) {
        this.soluteType = soluteType;
    }

    public void getVelocity(double[] velocity) {
        if (velocity == null) {
            velocity = new double[]{this.velocity[0], this.velocity[1], this.velocity[2]};
        }
    }

    public final double getX() {
        return this.xyz[0];
    }

    public double[] getXYZ(@Nullable double[] xyz) {
        if (xyz == null) {
            xyz = Arrays.copyOf(this.xyz, 3);
        } else {
            System.arraycopy(this.xyz, 0, xyz, 0, 3);
        }
        return xyz;
    }

    public Double3 getXYZ() {
        return new Double3(this.xyz[0], this.xyz[1], this.xyz[2]);
    }

    public void setXYZ(double[] xyz) {
        if (this.active) {
            System.arraycopy(xyz, 0, this.xyz, 0, 3);
        }
    }

    public void getXYZGradient(double[] x) {
        if (x == null) {
            x = new double[]{this.xyzGradient[0], this.xyzGradient[1], this.xyzGradient[2]};
        }
    }

    public final int getXyzIndex() {
        return this.xyzIndex;
    }

    public final void setXyzIndex(int set) {
        this.xyzIndex = set;
    }

    public final double getY() {
        return this.xyz[1];
    }

    public final double getZ() {
        return this.xyz[2];
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resName, this.resSeq, this.getName(), this.segID);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isNeuralNetwork() {
        return this.neuralNetwork;
    }

    public void setNeuralNetwork(boolean neuralNetwork) {
        this.neuralNetwork = neuralNetwork;
    }

    public boolean isSpecialPosition() {
        return this.specialPositionSymOps != null;
    }

    public void setSpecialPositionSymOps(List<Integer> specialPositionSymOps) {
        this.specialPositionSymOps = specialPositionSymOps;
    }

    public boolean isSpecialPositionSymOp(int symOp) {
        return this.specialPositionSymOps != null && this.specialPositionSymOps.contains(symOp);
    }

    public boolean isBonded(Atom a) {
        for (Bond bond : this.bonds) {
            if (bond.get1_2(a) != this) continue;
            return true;
        }
        return false;
    }

    public boolean isDeuterium() {
        String name = this.getName().toUpperCase();
        return this.isHydrogen() && name.charAt(0) == 'D';
    }

    public boolean isHeavy() {
        return this.atomType != null && this.atomType.atomicNumber != 1;
    }

    public boolean isHetero() {
        return this.hetatm;
    }

    public void setHetero(boolean hetatm) {
        this.hetatm = hetatm;
    }

    public boolean isHydrogen() {
        if (this.atomType == null) {
            return false;
        }
        return this.atomType.atomicNumber == 1;
    }

    public boolean isHalogen() {
        if (this.atomType == null) {
            return false;
        }
        return this.atomType.atomicNumber == 9 || this.atomType.atomicNumber == 17 || this.atomType.atomicNumber == 35 || this.atomType.atomicNumber == 53;
    }

    public boolean isModRes() {
        return this.modres;
    }

    public void setModRes(boolean modres) {
        this.modres = modres;
    }

    public boolean isRing(Atom a2) {
        boolean two = this.isBonded(a2);
        boolean three = this.is_1_3(a2);
        if (two && three) {
            return true;
        }
        boolean four = this.is_1_4(a2);
        if (two && four) {
            return true;
        }
        if (three && four) {
            return true;
        }
        boolean five = this.is_1_5(a2);
        if (two && five) {
            return true;
        }
        if (three && five) {
            return true;
        }
        if (four && five) {
            return true;
        }
        boolean six = this.is_1_6(a2);
        if (two && six) {
            return true;
        }
        if (three && six) {
            return true;
        }
        if (four && six) {
            return true;
        }
        if (five && six) {
            return true;
        }
        boolean seven = this.is_1_7(a2);
        if (two && seven) {
            return true;
        }
        if (three && seven) {
            return true;
        }
        if (four && seven) {
            return true;
        }
        if (five && seven) {
            return true;
        }
        if (six && seven) {
            return true;
        }
        boolean eight = this.is_1_8(a2);
        if (two && eight) {
            return true;
        }
        if (three && eight) {
            return true;
        }
        if (four && eight) {
            return true;
        }
        if (five && eight) {
            return true;
        }
        if (six && eight) {
            return true;
        }
        return seven && eight;
    }

    public boolean isStale() {
        return this.stale;
    }

    public boolean isTrigonal() {
        return this.bonds.size() == 3;
    }

    public boolean isVisible() {
        return this.viewModel != RendererCache.ViewModel.INVISIBLE;
    }

    public boolean is_12_or_13(Atom a) {
        return this.isBonded(a) || this.is_1_3(a);
    }

    public boolean is_1_3(Atom atom) {
        for (Angle a : this.angles) {
            if (a.get1_3(atom) != this) continue;
            return true;
        }
        return false;
    }

    public boolean is_1_4(Atom atom) {
        ArrayList<Atom> pathAtoms = new ArrayList<Atom>();
        for (Angle angle : this.angles) {
            Atom a1_3;
            Atom[] angleAtoms = angle.getAtomArray();
            if (angleAtoms[1] == this || (a1_3 = angle.get1_3(this)) == null) continue;
            pathAtoms.addAll(Arrays.asList(angleAtoms));
            List<Bond> bonds = a1_3.getBonds();
            for (Bond bond : bonds) {
                Atom a1_4 = bond.get1_2(a1_3);
                if (a1_4 == null || pathAtoms.contains(a1_4) || a1_4 != atom) continue;
                return true;
            }
            pathAtoms.removeAll(Arrays.asList(angleAtoms));
        }
        return false;
    }

    public boolean is_1_5(Atom atom) {
        ArrayList<Atom> pathAtoms = new ArrayList<Atom>();
        for (Angle angle : this.angles) {
            Atom a1_3;
            Atom[] angleAtoms = angle.getAtomArray();
            if (angleAtoms[1] == this || (a1_3 = angle.get1_3(this)) == null) continue;
            pathAtoms.addAll(Arrays.asList(angleAtoms));
            List<Angle> angles2 = a1_3.getAngles();
            for (Angle angle2 : angles2) {
                Atom[] angleAtoms2 = angle2.getAtomArray();
                Atom a1_5 = angle2.get1_3(a1_3);
                if (a1_5 == null || pathAtoms.contains(a1_5) || pathAtoms.contains(angleAtoms2[1]) || a1_5 != atom) continue;
                return true;
            }
            pathAtoms.removeAll(Arrays.asList(angleAtoms));
        }
        return false;
    }

    public boolean is_1_6(Atom atom) {
        ArrayList<Atom> pathAtoms = new ArrayList<Atom>();
        for (Angle angle : this.angles) {
            Atom a1_3;
            Atom[] angleAtoms = angle.getAtomArray();
            if (angleAtoms[1] == this || (a1_3 = angle.get1_3(this)) == null) continue;
            pathAtoms.addAll(Arrays.asList(angleAtoms));
            List<Angle> angles2 = a1_3.getAngles();
            for (Angle angle2 : angles2) {
                Atom[] angleAtoms2 = angle2.getAtomArray();
                Atom a1_5 = angle2.get1_3(a1_3);
                if (a1_5 == null || pathAtoms.contains(a1_5) || pathAtoms.contains(angleAtoms2[1])) continue;
                pathAtoms.add(angleAtoms2[1]);
                pathAtoms.add(a1_5);
                List<Bond> bonds = a1_5.getBonds();
                for (Bond bond : bonds) {
                    Atom a1_6 = bond.get1_2(a1_5);
                    if (a1_6 == null || pathAtoms.contains(a1_6) || a1_6 != atom) continue;
                    return true;
                }
                pathAtoms.remove(angleAtoms2[1]);
                pathAtoms.remove(a1_5);
            }
            pathAtoms.removeAll(Arrays.asList(angleAtoms));
        }
        return false;
    }

    public boolean is_1_7(Atom atom) {
        ArrayList<Atom> pathAtoms = new ArrayList<Atom>();
        for (Angle angle : this.angles) {
            Atom a1_3;
            Atom[] angleAtoms = angle.getAtomArray();
            if (angleAtoms[1] == this || (a1_3 = angle.get1_3(this)) == null) continue;
            pathAtoms.addAll(Arrays.asList(angleAtoms));
            List<Angle> angles2 = a1_3.getAngles();
            for (Angle angle2 : angles2) {
                Atom[] angleAtoms2 = angle2.getAtomArray();
                Atom a1_5 = angle2.get1_3(a1_3);
                if (a1_5 == null || pathAtoms.contains(a1_5) || pathAtoms.contains(angleAtoms2[1])) continue;
                pathAtoms.add(a1_5);
                pathAtoms.add(angleAtoms2[1]);
                List<Angle> angles3 = a1_5.getAngles();
                for (Angle angle3 : angles3) {
                    Atom[] angleAtoms3 = angle3.getAtomArray();
                    Atom a1_7 = angle3.get1_3(a1_5);
                    if (a1_7 == null || pathAtoms.contains(a1_7) || pathAtoms.contains(angleAtoms3[1]) || a1_7 != atom) continue;
                    return true;
                }
                pathAtoms.remove(angleAtoms2[1]);
                pathAtoms.remove(a1_5);
            }
            pathAtoms.removeAll(Arrays.asList(angleAtoms));
        }
        return false;
    }

    public boolean is_1_8(Atom atom) {
        ArrayList<Atom> pathAtoms = new ArrayList<Atom>();
        for (Angle angle : this.angles) {
            Atom a1_3;
            Atom[] angleAtoms = angle.getAtomArray();
            if (angleAtoms[1] == this || (a1_3 = angle.get1_3(this)) == null) continue;
            pathAtoms.addAll(Arrays.asList(angleAtoms));
            List<Angle> angles2 = a1_3.getAngles();
            for (Angle angle2 : angles2) {
                Atom[] angleAtoms2 = angle2.getAtomArray();
                Atom a1_5 = angle2.get1_3(a1_3);
                if (a1_5 == null || pathAtoms.contains(a1_5) || pathAtoms.contains(angleAtoms2[1])) continue;
                pathAtoms.add(a1_5);
                pathAtoms.add(angleAtoms2[1]);
                List<Angle> angles3 = a1_5.getAngles();
                for (Angle angle3 : angles3) {
                    Atom[] angleAtoms3 = angle3.getAtomArray();
                    Atom a1_7 = angle3.get1_3(a1_5);
                    if (a1_7 == null || pathAtoms.contains(a1_7) || pathAtoms.contains(angleAtoms3[1])) continue;
                    pathAtoms.add(a1_7);
                    pathAtoms.add(angleAtoms3[1]);
                    List<Bond> bonds = a1_7.getBonds();
                    for (Bond bond : bonds) {
                        Atom a1_8 = bond.get1_2(a1_7);
                        if (a1_8 == null || pathAtoms.contains(a1_8) || a1_8 != atom) continue;
                        return true;
                    }
                    pathAtoms.remove(a1_7);
                    pathAtoms.remove(angleAtoms3[1]);
                }
                pathAtoms.remove(a1_5);
                pathAtoms.remove(angleAtoms2[1]);
            }
            pathAtoms.removeAll(Arrays.asList(angleAtoms));
        }
        return false;
    }

    public void move(double[] d) {
        if (this.active) {
            this.xyz[0] = this.xyz[0] + d[0];
            this.xyz[1] = this.xyz[1] + d[1];
            this.xyz[2] = this.xyz[2] + d[2];
            this.stale = true;
        }
    }

    public void moveTo(double a, double b, double c) {
        if (this.active) {
            this.xyz[0] = a;
            this.xyz[1] = b;
            this.xyz[2] = c;
            this.stale = true;
        }
    }

    public void moveTo(double[] d) {
        if (this.active) {
            this.moveTo(d[0], d[1], d[2]);
        }
    }

    public void moveTo(Vector3d v) {
        if (this.active) {
            this.moveTo(v.x, v.y, v.z);
        }
    }

    @Override
    public final void print() {
        this.print(Level.INFO);
    }

    public final void print(Level logLevel) {
        logger.log(logLevel, this.toString());
    }

    @Override
    public void removeFromParent() {
        super.removeFromParent();
        this.angles.clear();
        this.torsions.clear();
        if (this.trajectory != null) {
            this.trajectory.clear();
        }
        this.trajectory = null;
        this.stale = false;
        this.viewModel = RendererCache.ViewModel.INVISIBLE;
        RendererCache.poolTransform3D(this.transform3D);
        if (this.branchGroup != null) {
            this.branchGroup.detach();
            this.branchGroup.setUserData(null);
            RendererCache.poolSphere(this.branchGroup);
            this.branchGroup = null;
        }
    }

    public void rotate(double[][] d) {
        int rowsInA = this.xyz.length;
        double columnsInA = d.length;
        int columnsInB = d[0].length;
        double[][] c = new double[rowsInA][columnsInB];
        for (int i = 0; i < rowsInA; ++i) {
            for (int j = 0; j < columnsInB; ++j) {
                int k = 0;
                while ((double)k < columnsInA) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.xyz[k] * d[k][j];
                    ++k;
                }
            }
        }
        this.stale = true;
    }

    public void setAcceleration(double[] acceleration) {
        if (this.active && acceleration != null) {
            System.arraycopy(acceleration, 0, this.acceleration, 0, 3);
        }
    }

    public void setAcceleration(double x, double y, double z) {
        if (this.active) {
            this.acceleration[0] = x;
            this.acceleration[1] = y;
            this.acceleration[2] = z;
        }
    }

    public void setAngle(Angle a) {
        if (a != null && a.containsAtom(this)) {
            this.angles.add(a);
        }
    }

    public void setAnisou(double[] anisou) {
        if (this.active) {
            if (anisou == null) {
                this.anisou = null;
            } else if (this.anisou == null) {
                this.anisou = Arrays.copyOf(anisou, 6);
            } else {
                System.arraycopy(anisou, 0, this.anisou, 0, 6);
            }
        }
    }

    public void setAnisouAcceleration(double[] anisouAcceleration) {
        if (this.active) {
            if (anisouAcceleration == null) {
                this.anisouAcceleration = null;
            } else if (this.anisouAcceleration == null) {
                this.anisouAcceleration = Arrays.copyOf(anisouAcceleration, 6);
            } else {
                System.arraycopy(anisouAcceleration, 0, this.anisouAcceleration, 0, 6);
            }
        } else if (anisouAcceleration == null) {
            this.anisouAcceleration = null;
        } else {
            if (this.anisouAcceleration == null) {
                this.anisouAcceleration = new double[6];
            }
            Arrays.fill(anisouAcceleration, 0.0);
        }
    }

    public void setAnisouGradient(double[] anisouGradient) {
        if (this.active) {
            if (anisouGradient == null) {
                this.anisouGradient = null;
            } else if (this.anisouGradient == null) {
                this.anisouGradient = Arrays.copyOf(anisouGradient, 6);
            } else {
                System.arraycopy(anisouGradient, 0, this.anisouGradient, 0, 6);
            }
        } else if (anisouGradient == null) {
            this.anisouGradient = null;
        } else {
            if (this.anisouGradient == null) {
                this.anisouGradient = new double[6];
            }
            Arrays.fill(anisouGradient, 0.0);
        }
    }

    public void setAnisouPreviousAcceleration(double[] anisouPreviousAcceleration) {
        if (this.active) {
            if (anisouPreviousAcceleration == null) {
                this.anisouPreviousAcceleration = null;
            } else if (this.anisouPreviousAcceleration == null) {
                this.anisouPreviousAcceleration = Arrays.copyOf(anisouPreviousAcceleration, 6);
            } else {
                System.arraycopy(anisouPreviousAcceleration, 0, this.anisouPreviousAcceleration, 0, 6);
            }
        } else if (anisouPreviousAcceleration == null) {
            this.anisouPreviousAcceleration = null;
        } else {
            if (this.anisouPreviousAcceleration == null) {
                this.anisouPreviousAcceleration = new double[6];
            }
            Arrays.fill(anisouPreviousAcceleration, 0.0);
        }
    }

    public void setAnisouVelocity(double[] anisouVelocity) {
        if (this.active) {
            if (anisouVelocity == null) {
                this.anisouVelocity = null;
            } else if (this.anisouVelocity == null) {
                this.anisouVelocity = Arrays.copyOf(anisouVelocity, 6);
            } else {
                System.arraycopy(anisouVelocity, 0, this.anisouVelocity, 0, 6);
            }
        } else if (anisouVelocity == null) {
            this.anisouVelocity = null;
        } else {
            if (this.anisouVelocity == null) {
                this.anisouVelocity = new double[6];
            }
            Arrays.fill(anisouVelocity, 0.0);
        }
    }

    public void setApplyLambda(boolean applyState) {
        this.applyState = applyState;
    }

    public void setAxisAtoms(Atom ... set) {
        Atom[] axisAtoms = (Atom[])ArrayUtils.clone((Object[])set);
        if (axisAtoms == null) {
            this.axisAtomIndices = null;
            return;
        }
        this.axisAtomIndices = new int[axisAtoms.length];
        for (int i = 0; i < set.length; ++i) {
            this.axisAtomIndices[i] = set[i].getArrayIndex();
        }
    }

    public void setBond(Bond b) {
        if (b != null && b.containsAtom(this)) {
            for (Bond bond : this.bonds) {
                if (bond != b) continue;
                return;
            }
            this.bonds.add(b);
        }
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f newCol, Material newMat) {
        switch (newColorModel) {
            case CPK: {
                newCol = RendererCache.getColor(this, RendererCache.ColorModel.CPK);
                if (newCol == this.currentCol) {
                    return;
                }
                this.currentCol = this.previousCol = newCol;
                break;
            }
            case USERCOLOR: {
                this.currentCol = this.previousCol = this.userColor;
                break;
            }
            case APPLYUSERCOLOR: {
                this.currentCol = this.previousCol = (this.userColor = RendererCache.userColor);
                break;
            }
            case MONOCHROME: {
                this.currentCol = this.previousCol = RendererCache.WHITE;
                break;
            }
            case SELECT: {
                if (this.isSelected()) {
                    newCol = RendererCache.selectionColor;
                    if (newCol != this.currentCol) {
                        this.currentCol = newCol;
                        break;
                    }
                    return;
                }
                this.currentCol = this.previousCol;
                break;
            }
            case PICK: {
                newCol = RendererCache.pickingColor;
                if (newCol != this.currentCol) {
                    this.currentCol = newCol;
                    break;
                }
                return;
            }
            case REVERT: {
                if (RendererCache.highlightSelections && this.isSelected()) {
                    this.currentCol = RendererCache.selectionColor;
                    break;
                }
                this.currentCol = this.previousCol;
                break;
            }
            case PARTIALCHARGE: {
                newCol = RendererCache.getColor(this, RendererCache.ColorModel.PARTIALCHARGE);
                if (newCol == this.currentCol) {
                    return;
                }
                this.currentCol = this.previousCol = newCol;
                break;
            }
            default: {
                if (newCol == this.currentCol || newCol == null) {
                    return;
                }
                this.currentCol = this.previousCol = newCol;
            }
        }
        this.appearance = RendererCache.appearanceFactory(this.currentCol, this.polygonType);
        if (this.branchGroup != null && this.viewModel != RendererCache.ViewModel.INVISIBLE) {
            this.sphere.setAppearance(this.appearance);
        }
        for (Bond bond : this.bonds) {
            bond.setColor(this);
        }
    }

    public void setCurrentCycle(int cycle) {
        if (this.trajectory == null) {
            return;
        }
        if (cycle <= 0 || cycle > this.trajectory.size()) {
            return;
        }
        this.moveTo(this.trajectory.get(cycle - 1));
    }

    public void setLambdaXYZGradient(double x, double y, double z) {
        if (this.active) {
            this.xyzLambdaGradient[0] = x;
            this.xyzLambdaGradient[1] = y;
            this.xyzLambdaGradient[2] = z;
        }
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        if (this.active && previousAcceleration != null) {
            System.arraycopy(previousAcceleration, 0, this.previousAcceleration, 0, 3);
        }
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setTorsion(Torsion torsion) {
        if (torsion == null || !torsion.containsAtom(this)) {
            return;
        }
        for (Torsion t : this.torsions) {
            if (torsion != t) continue;
            return;
        }
        this.torsions.add(torsion);
    }

    public void setVelocity(double[] velocity) {
        if (this.active && velocity != null) {
            System.arraycopy(velocity, 0, this.velocity, 0, 3);
        }
    }

    public void setVelocity(double x, double y, double z) {
        if (this.active) {
            this.velocity[0] = x;
            this.velocity[1] = y;
            this.velocity[2] = z;
        }
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        switch (newViewModel) {
            case INVISIBLE: 
            case WIREFRAME: {
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setSphereVisible(false, newShapes);
                break;
            }
            case SPACEFILL: {
                this.viewModel = RendererCache.ViewModel.SPACEFILL;
                this.scale = AtomVDW.get(this.atomType.atomicNumber) * this.radius;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case RMIN: {
                this.viewModel = RendererCache.ViewModel.RMIN;
                this.scale = this.radius;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case BALLANDSTICK: {
                this.viewModel = RendererCache.ViewModel.BALLANDSTICK;
                this.scale = AtomVDW.get(this.atomType.atomicNumber) / 5.0 * this.radius;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case TUBE: {
                this.viewModel = RendererCache.ViewModel.TUBE;
                this.scale = RendererCache.radius * 0.2;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case SHOWHYDROGEN: {
                this.setView(this.viewModel, newShapes);
                break;
            }
            case HIDEHYDROGEN: {
                if (this.atomType.atomicNumber != 1) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setSphereVisible(false, newShapes);
                break;
            }
            case RESTRICT: {
                if (this.isSelected()) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setSphereVisible(false, newShapes);
                break;
            }
            case DETAIL: {
                double newradius;
                int newdetail = RendererCache.detail;
                if (newdetail != this.detail) {
                    this.detail = newdetail;
                    if (this.sphere != null) {
                        Geometry geom = RendererCache.getSphereGeom(this.detail);
                        this.sphere.removeAllGeometries();
                        this.sphere.addGeometry(geom);
                    }
                }
                if ((newradius = RendererCache.radius) == this.radius) break;
                this.radius = newradius;
                this.setView(this.viewModel, newShapes);
                break;
            }
            case FILL: 
            case POINTS: 
            case LINES: {
                this.polygonType = newViewModel;
                this.appearance = RendererCache.appearanceFactory(this.currentCol, this.polygonType);
                if (this.viewModel == RendererCache.ViewModel.INVISIBLE) break;
                this.setSphereVisible(true, newShapes);
            }
        }
    }

    public void setXYZGradient(double x, double y, double z) {
        if (this.active) {
            if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(y) || Double.isInfinite(y) || Double.isNaN(z) || Double.isInfinite(z)) {
                StringBuilder sb = new StringBuilder(String.format("Setting gradient of atom %s to (%8.3f,%8.3f,%8.3f) is not permitted.", this, x, y, z));
                double[] vals = new double[3];
                this.getVelocity(vals);
                sb.append(String.format("\n Velocities: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                this.getAcceleration(vals);
                sb.append(String.format("\n Accelerations: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                this.getPreviousAcceleration(vals);
                sb.append(String.format("\n Previous accelerations: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                throw new EnergyException(sb.toString());
            }
            this.xyzGradient[0] = x;
            this.xyzGradient[1] = y;
            this.xyzGradient[2] = z;
        }
    }

    @Override
    public String toString() {
        Object sid = this.segID == null ? "" : " " + this.segID;
        if (this.altLoc != null && this.altLoc.charValue() != ' ') {
            return String.format("%s %7d-%s %s %d (%7.2f,%7.2f,%7.2f)%s", this.altLoc, this.getIndex(), this.getName(), this.resName, this.resSeq, this.xyz[0], this.xyz[1], this.xyz[2], sid);
        }
        if (this.resName == null) {
            return String.format("%7d-%s (%7.2f,%7.2f,%7.2f)", this.getIndex(), this.getName(), this.xyz[0], this.xyz[1], this.xyz[2]);
        }
        return String.format("%7d-%s %s %d (%7.2f,%7.2f,%7.2f)%s", this.getIndex(), this.getName(), this.resName, this.resSeq, this.xyz[0], this.xyz[1], this.xyz[2], sid);
    }

    @Override
    public void update() {
        if (this.stale) {
            this.updateSphere();
            this.stale = false;
        }
    }

    void addTrajectoryCoords(Vector3d coords, int position) {
        if (this.trajectory == null) {
            this.trajectory = new ArrayList();
            this.trajectory.add(0, new Vector3d(this.xyz));
        }
        this.trajectory.add(position, coords);
    }

    Appearance getAtomAppearance() {
        if (this.appearance == null) {
            this.appearance = RendererCache.appearanceFactory(this.currentCol, this.polygonType);
        }
        return this.appearance;
    }

    Color3f getAtomColor() {
        return this.currentCol;
    }

    private void initSphere(List<BranchGroup> newShapes) {
        if (this.appearance == null) {
            this.appearance = RendererCache.appearanceFactory(this.currentCol, RendererCache.ViewModel.FILL);
        }
        if (this.transform3D == null) {
            this.transform3D = RendererCache.transform3DFactory(new Vector3d(this.xyz), this.scale);
        } else {
            this.transform3D.setTranslation(new Vector3d(this.xyz));
            this.transform3D.setScale(this.scale);
        }
        this.detail = RendererCache.detail;
        this.branchGroup = RendererCache.sphereFactory(this.appearance, this.detail, this.transform3D);
        this.transformGroup = (TransformGroup)this.branchGroup.getChild(0);
        this.sphere = (Shape3D)this.transformGroup.getChild(0);
        this.sphere.setUserData((Object)this);
        newShapes.add(this.branchGroup);
    }

    boolean isDangeling() {
        Integer hybrid = hybridTable.get("" + this.atomType.atomicNumber);
        if (hybrid == null) {
            return false;
        }
        int result = hybrid.compareTo(this.bonds.size());
        return result > 0;
    }

    void clearGeometry() {
        this.bonds.clear();
        this.angles.clear();
        this.torsions.clear();
    }

    private void setSphereVisible(boolean sphereVisible, List<BranchGroup> newShapes) {
        if (!sphereVisible) {
            if (this.branchGroup != null) {
                this.sphere.setPickable(false);
                this.sphere.setAppearance(RendererCache.nullAp);
            }
        } else {
            if (this.branchGroup == null) {
                this.initSphere(newShapes);
            }
            this.sphere.setAppearance(this.appearance);
            this.sphere.setPickable(true);
            this.updateSphere();
        }
    }

    private void updateSphere() {
        if (this.branchGroup != null && this.viewModel != RendererCache.ViewModel.INVISIBLE) {
            this.vector3d.set(this.xyz);
            this.transform3D.setTranslation(this.vector3d);
            this.transform3D.setScale(this.scale);
            this.transformGroup.setTransform(this.transform3D);
        }
    }

    static {
        int i;
        logger = Logger.getLogger(Atom.class.getName());
        point3d = new Point3d();
        point2d = new Point2d();
        XYZIndexComparator = new Comparator<Atom>(){

            @Override
            public int compare(Atom atom1, Atom atom2) {
                int index2;
                boolean equal = atom1.equals(atom2);
                if (equal) {
                    return 0;
                }
                int index1 = atom1.getXyzIndex();
                if (index1 != (index2 = atom2.getXyzIndex())) {
                    if (index1 < index2) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        };
        AtomColor = new HashMap<Integer, Color3f>();
        AtomVDW = new HashMap<Integer, Double>();
        hybridTable = new HashMap<String, Integer>();
        AtomVDW.put(0, 1.0);
        AtomVDW.put(1, 1.2);
        AtomVDW.put(2, 1.22);
        AtomVDW.put(3, 0.78);
        AtomVDW.put(4, 0.34);
        AtomVDW.put(5, 2.08);
        AtomVDW.put(6, 1.85);
        AtomVDW.put(7, 1.54);
        AtomVDW.put(8, 1.4);
        AtomVDW.put(9, 1.35);
        AtomVDW.put(10, 1.6);
        AtomVDW.put(11, 0.98);
        AtomVDW.put(12, 0.78);
        AtomVDW.put(13, 0.57);
        AtomVDW.put(14, 2.0);
        AtomVDW.put(15, 1.9);
        AtomVDW.put(16, 1.85);
        AtomVDW.put(17, 1.81);
        AtomVDW.put(18, 1.91);
        AtomVDW.put(19, 1.33);
        AtomVDW.put(20, 1.06);
        AtomVDW.put(21, 0.91);
        AtomVDW.put(22, 0.83);
        AtomVDW.put(23, 0.82);
        AtomVDW.put(24, 2.0);
        AtomVDW.put(25, 2.0);
        AtomVDW.put(26, 2.0);
        AtomVDW.put(27, 2.0);
        AtomVDW.put(28, 2.0);
        AtomVDW.put(29, 2.0);
        AtomVDW.put(30, 2.0);
        AtomVDW.put(31, 2.0);
        AtomVDW.put(32, 2.0);
        AtomVDW.put(33, 2.0);
        AtomVDW.put(34, 2.0);
        AtomVDW.put(35, 1.95);
        AtomVDW.put(36, 1.89);
        for (i = 37; i < 109; ++i) {
            AtomVDW.put(i, 2.0);
        }
        AtomColor.put(0, RendererCache.RED);
        AtomColor.put(1, RendererCache.WHITE);
        AtomColor.put(2, RendererCache.GREEN);
        AtomColor.put(3, RendererCache.MAGENTA);
        AtomColor.put(4, RendererCache.MAGENTA);
        AtomColor.put(5, RendererCache.MAGENTA);
        AtomColor.put(6, RendererCache.GRAY);
        AtomColor.put(7, RendererCache.BLUE);
        AtomColor.put(8, RendererCache.RED);
        AtomColor.put(9, RendererCache.GREEN);
        AtomColor.put(10, RendererCache.GREEN);
        AtomColor.put(11, RendererCache.MAGENTA);
        AtomColor.put(12, RendererCache.MAGENTA);
        AtomColor.put(13, RendererCache.MAGENTA);
        AtomColor.put(14, RendererCache.GRAY);
        AtomColor.put(15, RendererCache.ORANGE);
        AtomColor.put(16, RendererCache.YELLOW);
        AtomColor.put(17, RendererCache.GREEN);
        AtomColor.put(18, RendererCache.GREEN);
        for (i = 19; i < 109; ++i) {
            if (i != 36 && i != 54 && i != 86) {
                AtomColor.put(i, RendererCache.MAGENTA);
                continue;
            }
            AtomColor.put(i, RendererCache.GREEN);
        }
        hybridTable.put("1", 1);
        hybridTable.put("6", 4);
        hybridTable.put("7", 3);
        hybridTable.put("8", 2);
        hybridTable.put("15", 4);
        hybridTable.put("16", 2);
        hybridTable.put("19", 0);
        hybridTable.put("26", 8);
    }

    public static enum Resolution {
        FIXEDCHARGE,
        AMOEBA;

    }

    public static enum Descriptions {
        Default,
        Trim,
        XyzIndex_Name,
        ArrayIndex_Name,
        Resnum_Name;

    }

    public static enum ElementSymbol {
        H,
        He,
        Li,
        Be,
        B,
        C,
        N,
        O,
        F,
        Ne,
        Na,
        Mg,
        Al,
        Si,
        P,
        S,
        Cl,
        Ar,
        K,
        Ca,
        Sc,
        Ti,
        V,
        Cr,
        Mn,
        Fe,
        Co,
        Ni,
        Cu,
        Zn,
        Ga,
        Ge,
        As,
        Se,
        Br,
        Kr,
        Rb,
        Sr,
        Y,
        Zr,
        Nb,
        Mo,
        Tc,
        Ru,
        Rh,
        Pd,
        Ag,
        Cd,
        In,
        Sn,
        Sb,
        Te,
        I,
        Xe,
        Cs,
        Ba,
        La,
        Ce,
        Pr,
        Nd,
        Pm,
        Sm,
        Eu,
        Gd,
        Tb,
        Dy,
        Ho,
        Er,
        Tm,
        Yb,
        Lu,
        Hf,
        Ta,
        W,
        Re,
        Os,
        Ir,
        Pt,
        Au,
        Hg,
        Tl,
        Pb,
        Bi,
        Po,
        At,
        Rn,
        Fr,
        Ra,
        Ac,
        Th,
        Pa,
        U,
        Np,
        Pu,
        Am,
        Cm,
        Bk,
        Cf,
        Es,
        Fm,
        Md,
        No,
        Lr,
        Rf,
        Db,
        Sg,
        Bh,
        Hs,
        Mt;

    }
}

