/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.AngleTorsionType;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TorsionType;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class AngleTorsion
extends BondedTerm
implements LambdaInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AngleTorsion.class.getName());
    private static final String mathForm;
    private final double[] constants = new double[6];
    private final double[] tsin = new double[]{0.0, 0.0, 0.0};
    private final double[] tcos = new double[]{1.0, 1.0, 1.0};
    public AngleType angleType1 = null;
    public AngleType angleType2 = null;
    private AngleTorsionType angleTorsionType = null;
    private TorsionType torsionType = null;
    private double lambda = 1.0;
    private double dEdL = 0.0;
    private boolean lambdaTerm = false;

    public AngleTorsion(Angle an1, Angle an2) {
        this.bonds = new Bond[3];
        this.bonds[1] = an1.getCommonBond(an2);
        this.bonds[0] = an1.getOtherBond(this.bonds[1]);
        this.bonds[2] = an2.getOtherBond(this.bonds[1]);
        this.initialize();
    }

    public AngleTorsion(Bond b1, Bond b2, Bond b3) {
        this.bonds = new Bond[3];
        this.bonds[0] = b1;
        this.bonds[1] = b2;
        this.bonds[2] = b3;
        this.initialize();
    }

    public AngleTorsion(String n) {
        super(n);
    }

    public static String angleTorsionForm() {
        return mathForm;
    }

    static AngleTorsion angleTorsionFactory(Torsion torsion, ForceField forceField) {
        TorsionType torsionType = torsion.torsionType;
        String key = torsionType.getKey();
        AngleTorsionType angleTorsionType = forceField.getAngleTorsionType(key);
        if (angleTorsionType != null) {
            Bond bond1 = torsion.bonds[0];
            Bond middleBond = torsion.bonds[1];
            Bond bond3 = torsion.bonds[2];
            AngleTorsion angleTorsion = new AngleTorsion(bond1, middleBond, bond3);
            angleTorsion.angleTorsionType = angleTorsionType;
            angleTorsion.torsionType = torsion.torsionType;
            Atom atom1 = torsion.atoms[0];
            Atom atom2 = torsion.atoms[1];
            Atom atom3 = torsion.atoms[2];
            Atom atom4 = torsion.atoms[3];
            Angle angle1 = atom1.getAngle(atom2, atom3);
            Angle angle2 = atom2.getAngle(atom3, atom4);
            angleTorsion.angleType1 = angle1.angleType;
            angleTorsion.angleType2 = angle2.angleType;
            angleTorsion.setFlipped(atom1.getAtomType().atomClass != angleTorsionType.atomClasses[0] || atom2.getAtomType().atomClass != angleTorsionType.atomClasses[1] || atom3.getAtomType().atomClass != angleTorsionType.atomClasses[2] || atom4.getAtomType().atomClass != angleTorsionType.atomClasses[3]);
            return angleTorsion;
        }
        return null;
    }

    public boolean compare(Atom a0, Atom a1, Atom a2, Atom a3) {
        if (a0 == this.atoms[0] && a1 == this.atoms[1] && a2 == this.atoms[2] && a3 == this.atoms[3]) {
            return true;
        }
        return a0 == this.atoms[3] && a1 == this.atoms[2] && a2 == this.atoms[1] && a3 == this.atoms[0];
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.energy = 0.0;
        this.value = 0.0;
        this.dEdL = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        Atom atomD = this.atoms[3];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vd = atomD.getXYZ();
        Double3 vba = vb.sub(va);
        Double3 vcb = vc.sub(vb);
        Double3 vdc = vd.sub(vc);
        double rba2 = vba.length2();
        double rcb2 = vcb.length2();
        double rdc2 = vdc.length2();
        if (FastMath.min((double)FastMath.min((double)rba2, (double)rcb2), (double)rdc2) == 0.0) {
            return 0.0;
        }
        double rcb = FastMath.sqrt((double)rcb2);
        Double3 vt = vba.X(vcb);
        Double3 vu = vcb.X(vdc);
        double rt2 = FastMath.max((double)vt.length2(), (double)1.0E-6);
        double ru2 = FastMath.max((double)vu.length2(), (double)1.0E-6);
        double rtru = FastMath.sqrt((double)(rt2 * ru2));
        Double3 vca = vc.sub(va);
        Double3 vdb = vd.sub(vb);
        double cosine = vt.dot(vu) / rtru;
        double sine = vcb.dot(vt.X(vu)) / (rcb * rtru);
        this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
        if (sine < 0.0) {
            this.value = -this.value;
        }
        double cosine2 = cosine * cosine - sine * sine;
        double sine2 = 2.0 * cosine * sine;
        double cosine3 = cosine * cosine2 - sine * sine2;
        double sine3 = cosine * sine2 + sine * cosine2;
        double phi1 = 1.0 + (cosine * this.tcos[0] + sine * this.tsin[0]);
        double dphi1 = cosine * this.tsin[0] - sine * this.tcos[0];
        double phi2 = 1.0 + (cosine2 * this.tcos[1] + sine2 * this.tsin[1]);
        double dphi2 = 2.0 * (cosine2 * this.tsin[1] - sine2 * this.tcos[1]);
        double phi3 = 1.0 + (cosine3 * this.tcos[2] + sine3 * this.tsin[2]);
        double dphi3 = 3.0 * (cosine3 * this.tsin[2] - sine3 * this.tcos[2]);
        double c1 = this.constants[0];
        double c2 = this.constants[1];
        double c3 = this.constants[2];
        double angle1 = FastMath.toDegrees((double)FastMath.acos((double)(-vba.dot(vcb) / FastMath.sqrt((double)(rba2 * rcb2)))));
        double dt1 = angle1 - this.angleType1.angle[0];
        double s1 = c1 * phi1 + c2 * phi2 + c3 * phi3;
        double e1 = this.angleTorsionType.angtorunit * dt1 * s1;
        double c4 = this.constants[3];
        double c5 = this.constants[4];
        double c6 = this.constants[5];
        double angle2 = FastMath.toDegrees((double)FastMath.acos((double)(-vcb.dot(vdc) / FastMath.sqrt((double)(rcb2 * rdc2)))));
        double dt2 = angle2 - this.angleType2.angle[0];
        double s2 = c4 * phi1 + c5 * phi2 + c6 * phi3;
        double e2 = this.angleTorsionType.angtorunit * dt2 * s2;
        this.energy = e1 + e2;
        this.energy *= this.lambda;
        this.dEdL = this.energy;
        if (gradient || this.lambdaTerm) {
            double dedphi = this.angleTorsionType.angtorunit * dt1 * (c1 * dphi1 + c2 * dphi2 + c3 * dphi3);
            double ddt = this.angleTorsionType.angtorunit * FastMath.toDegrees((double)s1);
            Double3 vdt = vt.X(vcb).scaleI(dedphi / (rt2 * rcb));
            Double3 vdu = vcb.X(vu).scaleI(dedphi / (ru2 * rcb));
            double rt = FastMath.sqrt((double)rt2);
            double sa = -ddt / (rba2 * rt);
            double sc = ddt / (rcb2 * rt);
            Double3 ga = vt.X(vba).scaleI(sa).addI(vdt.X(vcb));
            Double3 gb = vba.X(vt).scaleI(sa).addI(vt.X(vcb).scaleI(sc)).addI(vca.X(vdt)).addI(vdu.X(vdc));
            Double3 gc = vcb.X(vt).scaleI(sc).addI(vdt.X(vba)).addI(vdb.X(vdu));
            Double3 gd = vdu.X(vcb);
            dedphi = this.angleTorsionType.angtorunit * dt2 * (c4 * dphi1 + c5 * dphi2 + c6 * dphi3);
            ddt = this.angleTorsionType.angtorunit * FastMath.toDegrees((double)s2);
            vdt = vt.X(vcb).scaleI(dedphi / (rt2 * rcb));
            vdu = vcb.X(vu).scaleI(dedphi / (ru2 * rcb));
            double ur = FastMath.sqrt((double)ru2);
            double sb = -ddt / (rcb2 * ur);
            double sd = ddt / (rdc2 * ur);
            ga.addI(vdt.X(vcb));
            gb.addI(vu.X(vcb).scaleI(sb)).addI(vca.X(vdt)).addI(vdu.X(vdc));
            gc.addI(vcb.X(vu).scaleI(sb)).addI(vu.X(vdc).scaleI(sd)).addI(vdt.X(vba)).addI(vdb.X(vdu));
            gd.addI(vdc.X(vu).scaleI(sd)).addI(vdu.X(vcb));
            int ia = atomA.getIndex() - 1;
            int ib = atomB.getIndex() - 1;
            int ic = atomC.getIndex() - 1;
            int id = atomD.getIndex() - 1;
            if (this.lambdaTerm) {
                lambdaGrad.add(threadID, ia, ga);
                lambdaGrad.add(threadID, ib, gb);
                lambdaGrad.add(threadID, ic, gc);
                lambdaGrad.add(threadID, id, gd);
            }
            if (gradient) {
                grad.add(threadID, ia, ga.scaleI(this.lambda));
                grad.add(threadID, ib, gb.scaleI(this.lambda));
                grad.add(threadID, ic, gc.scaleI(this.lambda));
                grad.add(threadID, id, gd.scaleI(this.lambda));
            }
        }
        return this.energy;
    }

    public Atom get1_4(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[3];
        }
        if (a == this.atoms[3]) {
            return this.atoms[0];
        }
        return null;
    }

    public double[] getConstants() {
        return Arrays.copyOf(this.constants, this.constants.length);
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.applyAllLambda()) {
            this.lambda = lambda;
            this.lambdaTerm = true;
        } else {
            this.lambda = 1.0;
        }
    }

    @Override
    public double getd2EdL2() {
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
    }

    public void log() {
        logger.info(String.format(" %-8s %6d-%s %6d-%s %6d-%s %6d-%s %10.4f %10.4f", "Angle-Torsion", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.atoms[3].getIndex(), this.atoms[3].getAtomType().name, this.value, this.energy));
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.1f,%7.2f)", this.id, this.value, this.energy);
    }

    private void initialize() {
        this.atoms = new Atom[4];
        this.atoms[1] = this.bonds[0].getCommonAtom(this.bonds[1]);
        this.atoms[0] = this.bonds[0].get1_2(this.atoms[1]);
        this.atoms[2] = this.bonds[1].get1_2(this.atoms[1]);
        this.atoms[3] = this.bonds[2].get1_2(this.atoms[2]);
        this.setID_Key(false);
        this.value = DoubleMath.dihedralAngle((double[])this.atoms[0].getXYZ(null), (double[])this.atoms[1].getXYZ(null), (double[])this.atoms[2].getXYZ(null), (double[])this.atoms[3].getXYZ(null));
    }

    private void setFlipped(boolean flipped) {
        if (flipped) {
            this.constants[0] = this.angleTorsionType.forceConstants[3];
            this.constants[1] = this.angleTorsionType.forceConstants[4];
            this.constants[2] = this.angleTorsionType.forceConstants[5];
            this.constants[3] = this.angleTorsionType.forceConstants[0];
            this.constants[4] = this.angleTorsionType.forceConstants[1];
            this.constants[5] = this.angleTorsionType.forceConstants[2];
        } else {
            System.arraycopy(this.angleTorsionType.forceConstants, 0, this.constants, 0, 6);
        }
        System.arraycopy(this.torsionType.sine, 0, this.tsin, 0, FastMath.min((int)this.torsionType.sine.length, (int)3));
        System.arraycopy(this.torsionType.cosine, 0, this.tcos, 0, FastMath.min((int)this.torsionType.cosine.length, (int)3));
    }

    static {
        StringBuilder mathFormBuilder = new StringBuilder();
        for (int m = 1; m < 3; ++m) {
            for (int n = 1; n < 4; ++n) {
                mathFormBuilder.append(String.format("k%d%d*(aVal%d-a%d)*(1+cos(%d*tVal+phi%d))+", m, n, m, m, n, n));
            }
        }
        int lenStr = mathFormBuilder.length();
        mathFormBuilder.replace(lenStr - 1, lenStr, ";");
        for (int m = 1; m < 3; ++m) {
            mathFormBuilder.append(String.format("aVal%d=angle(p%d,p%d,p%d);", m, m, m + 1, m + 2));
        }
        mathFormBuilder.append("tVal=dihedral(p1,p2,p3,p4)");
        mathForm = mathFormBuilder.toString();
    }
}

