/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import ffx.crystal.Crystal;
import ffx.crystal.SpaceGroup;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class XtalEnergy
implements Potential {
    private static final Logger logger = Logger.getLogger(XtalEnergy.class.getName());
    private final MolecularAssembly molecularAssembly;
    private final ForceFieldEnergy forceFieldEnergy;
    private final Atom[] activeAtoms;
    private final int nActive;
    private final double[] xyz;
    private final double[] gr;
    private final int nParams;
    private final Crystal crystal;
    private final boolean latticeOnly;
    private final Potential.VARIABLE_TYPE[] type;
    private final double[] mass;
    private final Crystal unitCell;
    private double[] scaling;
    private double totalEnergy;
    private MolecularAssembly.FractionalMode fractionalMode = MolecularAssembly.FractionalMode.OFF;

    public XtalEnergy(ForceFieldEnergy forceFieldEnergy, MolecularAssembly molecularAssembly) {
        this(forceFieldEnergy, molecularAssembly, false);
    }

    public XtalEnergy(ForceFieldEnergy forceFieldEnergy, MolecularAssembly molecularAssembly, boolean latticeOnly) {
        int i;
        this.forceFieldEnergy = forceFieldEnergy;
        this.molecularAssembly = molecularAssembly;
        this.latticeOnly = latticeOnly;
        if (!latticeOnly) {
            Atom[] atoms = molecularAssembly.getAtomArray();
            ArrayList<Atom> active = new ArrayList<Atom>();
            for (Atom a : atoms) {
                if (!a.isActive()) continue;
                active.add(a);
            }
            this.nActive = active.size();
            this.activeAtoms = active.toArray(new Atom[0]);
            this.xyz = new double[3 * this.nActive];
            this.gr = new double[3 * this.nActive];
        } else {
            this.nActive = 0;
            this.activeAtoms = null;
            this.xyz = null;
            this.gr = null;
        }
        this.nParams = 3 * this.nActive + 6;
        this.crystal = forceFieldEnergy.getCrystal();
        logger.info(" XtalEnergy Crystal: " + String.valueOf(this.crystal));
        this.unitCell = this.crystal.getUnitCell();
        this.type = new Potential.VARIABLE_TYPE[this.nParams];
        this.mass = new double[this.nParams];
        int index = 0;
        for (i = 0; i < this.nActive; ++i) {
            double m;
            this.mass[index] = m = this.activeAtoms[i].getMass();
            this.mass[index + 1] = m;
            this.mass[index + 2] = m;
            this.type[index] = Potential.VARIABLE_TYPE.X;
            this.type[index + 1] = Potential.VARIABLE_TYPE.Y;
            this.type[index + 2] = Potential.VARIABLE_TYPE.Z;
            index += 3;
        }
        for (i = this.nActive * 3; i < this.nActive * 3 + 6; ++i) {
            this.mass[i] = 1.0;
            this.type[i] = Potential.VARIABLE_TYPE.OTHER;
        }
    }

    public boolean destroy() {
        return this.forceFieldEnergy.destroy();
    }

    public double energy(double[] x) {
        this.unscaleCoordinates(x);
        this.setCoordinates(x);
        this.totalEnergy = this.forceFieldEnergy.energy(false, false);
        this.scaleCoordinates(x);
        return this.totalEnergy;
    }

    public double energyAndGradient(double[] x, double[] g) {
        this.unscaleCoordinates(x);
        this.setCoordinates(x);
        this.totalEnergy = this.latticeOnly ? this.forceFieldEnergy.energy(false, false) : this.forceFieldEnergy.energyAndGradient(this.xyz, this.gr);
        this.packGradient(x, g);
        this.unitCellParameterDerivatives(x, g);
        return this.totalEnergy;
    }

    public double[] getAcceleration(double[] acceleration) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] getCoordinates(double[] x) {
        int n = this.getNumberOfVariables();
        if (x == null || x.length < n) {
            x = new double[n];
        }
        int index = 0;
        for (int i = 0; i < this.nActive; ++i) {
            Atom a = this.activeAtoms[i];
            x[index] = a.getX();
            x[++index] = a.getY();
            x[++index] = a.getZ();
            ++index;
        }
        x[index] = this.unitCell.a;
        x[++index] = this.unitCell.b;
        x[++index] = this.unitCell.c;
        x[++index] = this.unitCell.alpha;
        x[++index] = this.unitCell.beta;
        x[++index] = this.unitCell.gamma;
        return x;
    }

    public Potential.STATE getEnergyTermState() {
        return this.forceFieldEnergy.getEnergyTermState();
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.forceFieldEnergy.setEnergyTermState(state);
    }

    public double[] getMass() {
        return this.mass;
    }

    public int getNumberOfVariables() {
        return this.nParams;
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] getScaling() {
        return this.scaling;
    }

    public void setScaling(double[] scaling) {
        this.scaling = scaling;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        return this.type;
    }

    public double[] getVelocity(double[] velocity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAcceleration(double[] acceleration) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setFractionalCoordinateMode(MolecularAssembly.FractionalMode fractionalMode) {
        this.fractionalMode = fractionalMode;
        this.molecularAssembly.setFractionalMode(fractionalMode);
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setVelocity(double[] velocity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void unitCellParameterDerivatives(double[] x, double[] g) {
        int index = 3 * this.nActive;
        double eps = 1.0E-5;
        double deps = FastMath.toDegrees((double)eps);
        SpaceGroup spaceGroup = this.crystal.spaceGroup;
        switch (spaceGroup.latticeSystem) {
            case TRICLINIC_LATTICE: {
                g[index] = this.finiteDifference(x, index, eps);
                g[++index] = this.finiteDifference(x, index, eps);
                g[++index] = this.finiteDifference(x, index, eps);
                g[++index] = this.finiteDifference(x, index, deps);
                g[++index] = this.finiteDifference(x, index, deps);
                g[++index] = this.finiteDifference(x, index, deps);
                break;
            }
            case MONOCLINIC_LATTICE: {
                g[index] = this.finiteDifference(x, index, eps);
                g[++index] = this.finiteDifference(x, index, eps);
                g[++index] = this.finiteDifference(x, index, eps);
                g[++index] = 0.0;
                g[++index] = this.finiteDifference(x, index, deps);
                g[++index] = 0.0;
                break;
            }
            case ORTHORHOMBIC_LATTICE: {
                g[index] = this.finiteDifference(x, index, eps);
                g[++index] = this.finiteDifference(x, index, eps);
                g[++index] = this.finiteDifference(x, index, eps);
                g[++index] = 0.0;
                g[++index] = 0.0;
                g[++index] = 0.0;
                break;
            }
            case TETRAGONAL_LATTICE: 
            case HEXAGONAL_LATTICE: {
                g[index] = this.finiteDifference2(x, index, index + 1, eps);
                g[++index] = g[index - 1];
                g[++index] = this.finiteDifference(x, index, eps);
                g[++index] = 0.0;
                g[++index] = 0.0;
                g[++index] = 0.0;
                break;
            }
            case RHOMBOHEDRAL_LATTICE: {
                g[index] = this.finiteDifference3(x, index, index + 1, index + 2, eps);
                g[++index] = g[index - 1];
                g[++index] = g[index - 2];
                g[++index] = this.finiteDifference3(x, index, index + 1, index + 2, deps);
                g[++index] = g[index - 1];
                g[++index] = g[index - 2];
                break;
            }
            case CUBIC_LATTICE: {
                g[index] = this.finiteDifference3(x, index, index + 1, index + 2, eps);
                g[++index] = g[index - 1];
                g[++index] = g[index - 2];
                g[++index] = 0.0;
                g[++index] = 0.0;
                g[++index] = 0.0;
            }
        }
        if (this.scaling != null) {
            index = 3 * this.nActive;
            for (int i = 0; i < 6; ++i) {
                int n = index;
                g[n] = g[n] / this.scaling[index];
                ++index;
            }
        }
    }

    private double finiteDifference(double[] x, int index, double eps) {
        double scale = 1.0;
        if (this.scaling != null) {
            scale = this.scaling[index];
        }
        double x1 = x[index];
        double param = x1 / scale;
        x[index] = (param + eps / 2.0) * scale;
        double ePlus = this.energy(x);
        x[index] = (param - eps / 2.0) * scale;
        double eMinus = this.energy(x);
        x[index] = x1;
        return (ePlus - eMinus) / eps;
    }

    private double finiteDifference2(double[] x, int index1, int index2, double eps) {
        double scale1 = 1.0;
        double scale2 = 1.0;
        if (this.scaling != null) {
            scale1 = this.scaling[index1];
            scale2 = this.scaling[index2];
        }
        double x1 = x[index1];
        double x2 = x[index2];
        double param1 = x1 / scale1;
        double param2 = x2 / scale2;
        x[index1] = (param1 + eps / 2.0) * scale1;
        x[index2] = (param2 + eps / 2.0) * scale2;
        double ePlus = this.energy(x);
        x[index1] = (param1 - eps / 2.0) * scale1;
        x[index2] = (param2 - eps / 2.0) * scale2;
        double eMinus = this.energy(x);
        x[index1] = x1;
        x[index2] = x2;
        return (ePlus - eMinus) / eps;
    }

    private double finiteDifference3(double[] x, int index1, int index2, int index3, double eps) {
        double scale1 = 1.0;
        double scale2 = 1.0;
        double scale3 = 1.0;
        if (this.scaling != null) {
            scale1 = this.scaling[index1];
            scale2 = this.scaling[index2];
            scale3 = this.scaling[index3];
        }
        double x1 = x[index1];
        double x2 = x[index2];
        double x3 = x[index3];
        double param1 = x1 / scale1;
        double param2 = x2 / scale2;
        double param3 = x3 / scale3;
        x[index1] = (param1 + eps / 2.0) * scale1;
        x[index2] = (param2 + eps / 2.0) * scale2;
        x[index3] = (param3 + eps / 2.0) * scale3;
        double ePlus = this.energy(x);
        x[index1] = (param1 - eps / 2.0) * scale1;
        x[index2] = (param2 - eps / 2.0) * scale2;
        x[index3] = (param3 - eps / 2.0) * scale3;
        double eMinus = this.energy(x);
        x[index1] = x1;
        x[index2] = x2;
        x[index3] = x3;
        return (ePlus - eMinus) / eps;
    }

    private void packGradient(double[] x, double[] g) {
        if (this.scaling != null) {
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (this.fractionalMode == MolecularAssembly.FractionalMode.OFF) {
                    int n = i;
                    g[n] = g[n] / this.scaling[i];
                } else {
                    g[i] = 0.0;
                }
                int n = i;
                x[n] = x[n] * this.scaling[i];
            }
        }
    }

    public void setCoordinates(double[] x) {
        assert (x != null);
        if (this.fractionalMode != MolecularAssembly.FractionalMode.OFF) {
            this.molecularAssembly.computeFractionalCoordinates();
        }
        int index = this.nActive * 3;
        double a = x[index];
        double b = x[index + 1];
        double c = x[index + 2];
        double alpha = x[index + 3];
        double beta = x[index + 4];
        double gamma = x[index + 5];
        SpaceGroup spaceGroup = this.crystal.spaceGroup;
        switch (spaceGroup.latticeSystem) {
            case TRICLINIC_LATTICE: {
                break;
            }
            case MONOCLINIC_LATTICE: {
                alpha = 90.0;
                gamma = 90.0;
                break;
            }
            case ORTHORHOMBIC_LATTICE: {
                alpha = 90.0;
                beta = 90.0;
                gamma = 90.0;
                break;
            }
            case TETRAGONAL_LATTICE: {
                double ab;
                a = ab = 0.5 * (a + b);
                b = ab;
                alpha = 90.0;
                beta = 90.0;
                gamma = 90.0;
                break;
            }
            case RHOMBOHEDRAL_LATTICE: {
                double angles;
                double abc;
                a = abc = (a + b + c) / 3.0;
                b = abc;
                c = abc;
                alpha = angles = (alpha + beta + gamma) / 3.0;
                beta = angles;
                gamma = angles;
                break;
            }
            case HEXAGONAL_LATTICE: {
                double ab;
                a = ab = 0.5 * (a + b);
                b = ab;
                alpha = 90.0;
                beta = 90.0;
                gamma = 120.0;
                break;
            }
            case CUBIC_LATTICE: {
                double abc;
                a = abc = (a + b + c) / 3.0;
                b = abc;
                c = abc;
                alpha = 90.0;
                beta = 90.0;
                gamma = 90.0;
            }
        }
        this.crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
        this.forceFieldEnergy.setCrystal(this.crystal);
        if (this.fractionalMode == MolecularAssembly.FractionalMode.OFF) {
            index = 0;
            for (int i = 0; i < this.nActive; ++i) {
                Atom atom = this.activeAtoms[i];
                xx = x[index];
                double yy = x[index + 1];
                double zz = x[index + 2];
                this.xyz[index] = xx;
                this.xyz[index + 1] = yy;
                this.xyz[index + 2] = zz;
                index += 3;
                atom.moveTo(xx, yy, zz);
            }
        } else {
            this.molecularAssembly.moveToFractionalCoordinates();
            index = 0;
            for (int i = 0; i < this.nActive; ++i) {
                Atom atom = this.activeAtoms[i];
                xx = atom.getX();
                double yy = atom.getY();
                double zz = atom.getZ();
                this.xyz[index] = xx;
                this.xyz[index + 1] = yy;
                this.xyz[index + 2] = zz;
                index += 3;
            }
        }
    }
}

