/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.Molecule;
import ffx.potential.bonded.NamingUtils;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public final class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());
    private static final List<List<Atom>> atomListPool = new ArrayList<List<Atom>>();

    public static double RMSCoordDev(MolecularAssembly m1, MolecularAssembly m2) {
        int n2;
        if (m1 == null || m2 == null) {
            return 0.0;
        }
        int n1 = m1.getAtomList().size();
        if (n1 != (n2 = m2.getAtomList().size())) {
            return 0.0;
        }
        double[] d = new double[3];
        double[] da = new double[3];
        double[] db = new double[3];
        double rms = 0.0;
        ListIterator<Atom> li = m1.getAtomList().listIterator();
        ListIterator<Atom> lj = m2.getAtomList().listIterator();
        while (li.hasNext()) {
            Atom a1 = li.next();
            Atom a2 = lj.next();
            a1.getXYZ(da);
            a2.getXYZ(db);
            DoubleMath.sub((double[])da, (double[])db, (double[])d);
            rms += d[0] * d[0] + d[1] * d[1] + d[2] * d[2];
        }
        return FastMath.sqrt((double)(rms / (double)n1));
    }

    public static void biochemistry(MolecularAssembly molecularAssembly, List<Atom> atoms) {
        Atom seed = null;
        int num = 0;
        int waterNum = 0;
        int ionNum = 0;
        int moleculeNum = 0;
        ArrayList<String> segIDs = new ArrayList<String>();
        while (!atoms.isEmpty()) {
            Atom atom;
            Atom a2;
            Iterator<Atom> iterator = atoms.iterator();
            while (iterator.hasNext() && (seed = (a2 = iterator.next())).getAtomicNumber() != 7) {
            }
            if (seed.getAtomicNumber() != 7) {
                while (!atoms.isEmpty()) {
                    atom = atoms.get(0);
                    if (atom.getNumBonds() == 0) {
                        Molecule ion = new Molecule(atom.getName() + "-" + ++ionNum);
                        ion.addMSNode(atom);
                        atoms.remove(0);
                        molecularAssembly.addMSNode(ion);
                        continue;
                    }
                    if (atom.getAtomicNumber() == 8 && Utilities.isWaterOxygen(atom)) {
                        Molecule water = new Molecule("Water-" + ++waterNum);
                        water.addMSNode(atom);
                        atoms.remove(0);
                        List<Bond> bonds = atom.getBonds();
                        for (Bond bond : bonds) {
                            Atom hydrogen = bond.get1_2(atom);
                            water.addMSNode(hydrogen);
                            atoms.remove(hydrogen);
                        }
                        molecularAssembly.addMSNode(water);
                        continue;
                    }
                    Molecule molecule = new Molecule("Molecule-" + ++moleculeNum);
                    List<Atom> moleculeAtoms = Utilities.getAtomListFromPool();
                    Utilities.collectAtoms(atoms.get(0), moleculeAtoms, true);
                    while (!moleculeAtoms.isEmpty()) {
                        atom = moleculeAtoms.get(0);
                        moleculeAtoms.remove(0);
                        molecule.addMSNode(atom);
                        atoms.remove(atom);
                    }
                    molecularAssembly.addMSNode(molecule);
                }
                break;
            }
            List<Atom> backbone = Utilities.findPolymer(seed, null);
            if (backbone != null && !backbone.isEmpty()) {
                seed = backbone.get(backbone.size() - 1);
                backbone = Utilities.findPolymer(seed, null);
            }
            Character chainID = Utilities.getChainID(num);
            String segID = Utilities.getSegID(chainID, segIDs);
            Polymer c = new Polymer(chainID, segID, true);
            if (backbone != null && backbone.size() > 2 && Utilities.divideBackbone(backbone, c)) {
                for (Atom a : c.getAtomList()) {
                    atoms.remove(a);
                }
                molecularAssembly.addMSNode(c);
                ++num;
                continue;
            }
            for (Atom a : atoms) {
                a.setParent(null);
            }
            Molecule molecule = new Molecule("Molecule-" + ++moleculeNum);
            atom = backbone.get(0);
            List<Atom> heteroAtomList = Utilities.getAtomListFromPool();
            Utilities.collectAtoms(atom, heteroAtomList, true);
            for (Atom a3 : heteroAtomList) {
                molecule.addMSNode(a3);
            }
            for (Atom a : molecule.getAtomList()) {
                atoms.remove(a);
            }
            molecularAssembly.addMSNode(molecule);
        }
    }

    public static Atom findSeed(Atom end, Atom other) {
        for (Bond b : end.getBonds()) {
            Atom seed = b.get1_2(end);
            if (seed == other) continue;
            return seed;
        }
        return null;
    }

    public static Character getChainID(int i) {
        if (i > 35) {
            i %= 36;
        }
        char c = i < 26 ? (char)(i + 65) : (char)((i -= 26) + 48);
        return Character.valueOf(c);
    }

    public static String stackTraceToString(Throwable ex) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)byteArrayOutputStream, true, StandardCharsets.UTF_8);
        try {
            ex.printStackTrace(ps);
            String string = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
            ps.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warning("Unable to convert stack trace to String");
                return "";
            }
        }
    }

    private static void addAtomListToPool(List<Atom> a) {
        a.clear();
        atomListPool.add(a);
    }

    private static void addCap(Atom end, Atom seed, Residue residue) {
        List<Atom> cap = Utilities.getAtomListFromPool();
        cap.add(end);
        Utilities.collectAtoms(seed, cap);
        cap.remove(0);
        cap.remove(0);
        for (Atom a : cap) {
            residue.addMSNode(a);
        }
    }

    private static void addPhosphate(Atom phosphate, Residue residue) {
        if (phosphate == null) {
            return;
        }
        residue.addMSNode(phosphate);
        for (Bond b : phosphate.getBonds()) {
            Atom oxygen = b.get1_2(phosphate);
            if (Utilities.numberOfBondsWith(oxygen, 6) != 0) continue;
            residue.addMSNode(oxygen);
            Atom hydrogen = Utilities.findBondWith(oxygen, 1);
            if (hydrogen == null) continue;
            residue.addMSNode(hydrogen);
        }
    }

    private static Residue assignResidue(List<Atom> backbone, int start, List<Atom> atoms, List<Atom> sidePolymer) {
        String resname;
        char[] chars = new char[]{'S', 'P', 'O', 'N', 'C'};
        int[] bins = new int[5];
        block12: for (Atom a : sidePolymer) {
            int atomicnum = a.getAtomicNumber();
            switch (atomicnum) {
                case 1: {
                    continue block12;
                }
                case 6: {
                    bins[4] = bins[4] + 1;
                    continue block12;
                }
                case 7: {
                    bins[3] = bins[3] + 1;
                    continue block12;
                }
                case 8: {
                    bins[2] = bins[2] + 1;
                    continue block12;
                }
                case 15: {
                    bins[1] = bins[1] + 1;
                    continue block12;
                }
                case 16: {
                    bins[0] = bins[0] + 1;
                    continue block12;
                }
            }
            return null;
        }
        StringBuilder key = new StringBuilder();
        int atomCount = 0;
        for (int i = 0; i < 5; ++i) {
            if (bins[i] == 0) continue;
            atomCount += bins[i];
            key.append(chars[i]);
            key.append(bins[i]);
        }
        if (atomCount == 0) {
            key.append("H");
        }
        if ((resname = (resname = AminoAcidUtils.sidechainStoichiometry.get(key.toString())) == null ? "Unknown" : resname.intern()).equals("1") || resname.equals("2")) {
            Bond bond;
            Atom alpha = backbone.get(start + 1);
            Atom carbonyl = backbone.get(start + 2);
            Atom beta = null;
            List<Bond> alphabonds = alpha.getBonds();
            Iterator<Bond> iterator = alphabonds.iterator();
            while (iterator.hasNext() && ((beta = (bond = iterator.next()).get1_2(alpha)).getAtomicNumber() == 7 || beta.getAtomicNumber() == 1 || beta == carbonyl)) {
                beta = null;
            }
            if (beta == null) {
                return null;
            }
            List<Bond> betabonds = beta.getBonds();
            int carboncount = 0;
            for (Bond bond2 : betabonds) {
                Atom gamma = bond2.get1_2(beta);
                if (gamma.getAtomicNumber() != 6) continue;
                ++carboncount;
            }
            resname = resname.equals("1") ? (carboncount == 2 ? "PRO" : "VAL") : (carboncount == 2 ? "LEU" : "ILE");
        } else if (resname.equals("3")) {
            Atom c3 = backbone.get(start + 3);
            int num = Utilities.countCO(c3);
            resname = num == 2 ? "A" : "DG";
        }
        Residue residue = null;
        try {
            NucleicAcidUtils.NucleicAcid3.valueOf(resname.toUpperCase());
            residue = new Residue(resname, Residue.ResidueType.NA);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (residue == null) {
            try {
                AminoAcidUtils.AminoAcid3.valueOf(resname.toUpperCase());
                residue = new Residue(resname, Residue.ResidueType.AA);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (residue == null) {
            residue = new Residue(resname, Residue.ResidueType.UNK);
        }
        for (Atom a : atoms) {
            residue.addMSNode(a);
        }
        return residue;
    }

    private static void collectAtoms(Atom seed, List<Atom> atoms) {
        Utilities.collectAtoms(seed, atoms, false);
    }

    private static void collectAtoms(Atom seed, List<Atom> atoms, boolean searchDisulfide) {
        if (seed == null) {
            return;
        }
        atoms.add(seed);
        for (Bond b : seed.getBonds()) {
            Atom nextAtom = b.get1_2(seed);
            if (nextAtom.getParent() != null || !searchDisulfide && nextAtom.getAtomicNumber() == 16 && seed.getAtomicNumber() == 16 || atoms.contains(nextAtom)) continue;
            Utilities.collectAtoms(nextAtom, atoms, searchDisulfide);
        }
    }

    private static int countCO(Atom adjacent) {
        int total = 0;
        for (Bond b : adjacent.getBonds()) {
            Atom carbonyl = b.get1_2(adjacent);
            if (carbonyl.getAtomicNumber() != 6) continue;
            for (Bond b2 : carbonyl.getBonds()) {
                Atom oxygen = b2.get1_2(carbonyl);
                if (oxygen.getAtomicNumber() != 8) continue;
                ++total;
            }
        }
        return total;
    }

    private static boolean divideBackbone(List<Atom> backbone, Polymer c) {
        Residue res;
        int i;
        PolymerType type;
        int length = backbone.size();
        int nitrogenCount = 0;
        int phosphorusCount = 0;
        for (Atom match : backbone) {
            int atomicNumber = match.getAtomicNumber();
            if (atomicNumber == 15) {
                ++phosphorusCount;
                continue;
            }
            if (atomicNumber != 7) continue;
            ++nitrogenCount;
        }
        if (phosphorusCount >= nitrogenCount && phosphorusCount > 1) {
            type = PolymerType.NUCLEICACID;
        } else if (nitrogenCount > phosphorusCount && nitrogenCount > 2) {
            type = PolymerType.AMINOACID;
        } else {
            return false;
        }
        int start = -1;
        for (i = 0; i < length; ++i) {
            Object carbon5;
            res = Utilities.patternMatch(i, backbone, type);
            if (res == null) continue;
            for (Atom a : res.getAtomList()) {
                a.setParent(null);
            }
            if (res.getName().equals("Unknown")) continue;
            start = i;
            if (type != PolymerType.NUCLEICACID || Utilities.numberOfBondsWith((Atom)(carbon5 = backbone.get(start + 1)), 6) == 1) break;
            start = -1;
            break;
        }
        if (start == -1) {
            backbone = Utilities.reverseAtomList(backbone);
            for (i = 0; i < length; ++i) {
                res = Utilities.patternMatch(i, backbone, type);
                if (res == null) continue;
                for (Atom a : res.getAtomList()) {
                    a.setParent(null);
                }
                if (res.getName().equals("Unknown")) continue;
                start = i;
                break;
            }
        }
        if (start == -1) {
            return false;
        }
        if (type == PolymerType.AMINOACID) {
            Atom carbonyl2;
            Atom nitrogen;
            Atom nitrogen2;
            Atom alpha;
            Atom carbonyl = null;
            Residue aa = null;
            int lastRes = 0;
            int firstRes = -1;
            ArrayList<Residue> aaArray = new ArrayList<Residue>();
            while (start < length) {
                aa = Utilities.patternMatch(start, backbone, PolymerType.AMINOACID);
                if (aa != null) {
                    if (firstRes == -1) {
                        firstRes = start;
                        carbonyl = Utilities.findCarbonyl(backbone.get(start));
                    }
                    aaArray.add(aa);
                    lastRes = start;
                }
                start += 3;
            }
            aa = null;
            if (carbonyl != null && (alpha = Utilities.findAlphaCarbon(carbonyl)) != null && (nitrogen2 = Utilities.findBondWith(alpha, 7)) != null) {
                Atom nitrogen22 = Utilities.findBondWith(carbonyl, 7);
                List<Atom> firstAtoms = Utilities.getAtomListFromPool();
                firstAtoms.add(nitrogen2);
                firstAtoms.add(alpha);
                firstAtoms.add(carbonyl);
                firstAtoms.add(nitrogen22);
                aa = Utilities.patternMatch(0, firstAtoms, PolymerType.AMINOACID);
                Utilities.addAtomListToPool(firstAtoms);
                if (aa != null) {
                    Utilities.addCap(alpha, nitrogen2, aa);
                    aaArray.add(0, aa);
                }
            }
            if (aa == null) {
                Atom nitrogen3 = backbone.get(firstRes);
                alpha = backbone.get(firstRes + 1);
                Utilities.addCap(alpha, nitrogen3, (Residue)aaArray.get(0));
            }
            aa = null;
            carbonyl = Utilities.findCarbonyl(backbone.get(lastRes + 1));
            if (carbonyl != null && (nitrogen = Utilities.findBondWith(carbonyl, 7)) != null && (alpha = Utilities.findAlphaCarbon(nitrogen)) != null && (carbonyl2 = Utilities.findCarbonyl(alpha)) != null) {
                List<Atom> lastAtoms = Utilities.getAtomListFromPool();
                lastAtoms.add(carbonyl);
                lastAtoms.add(nitrogen);
                lastAtoms.add(alpha);
                lastAtoms.add(carbonyl2);
                aa = Utilities.patternMatch(1, lastAtoms, PolymerType.AMINOACID);
                Utilities.addAtomListToPool(lastAtoms);
                if (aa != null) {
                    Utilities.addCap(alpha, carbonyl2, aa);
                    aaArray.add(aa);
                }
            }
            if (aa == null) {
                carbonyl = backbone.get(lastRes + 2);
                alpha = backbone.get(lastRes + 1);
                Utilities.addCap(alpha, carbonyl, (Residue)aaArray.get(aaArray.size() - 1));
            }
            int index = 1;
            for (Residue r : aaArray) {
                r.setNumber(index++);
                if (!NamingUtils.renameAminoAcidToPDBStandard(r)) {
                    return false;
                }
                c.addMSNode(r);
            }
        } else if (type == PolymerType.NUCLEICACID) {
            Atom o3;
            Atom c3;
            Atom c2;
            Atom c1;
            Atom o2;
            int lastRes = 0;
            boolean firstBase = true;
            Atom phos = null;
            Atom oxygen1 = null;
            Atom phosphate1 = null;
            ArrayList<Residue> na = new ArrayList<Residue>();
            while (start < length) {
                Residue base = Utilities.patternMatch(start, backbone, PolymerType.NUCLEICACID);
                if (base != null) {
                    phos = backbone.get(start - 1);
                    if (phos != null && phos.getAtomicNumber() == 15) {
                        Utilities.addPhosphate(phos, base);
                    }
                    na.add(base);
                    if (firstBase) {
                        firstBase = false;
                        phosphate1 = backbone.get(start - 1);
                        oxygen1 = backbone.get(start);
                    }
                    lastRes = start;
                }
                start += 6;
            }
            if (phosphate1 != null && oxygen1 != null && (o2 = Utilities.findOtherOxygen(phosphate1, oxygen1)) != null && (c1 = Utilities.findBondWith(o2, 6)) != null && (c2 = Utilities.findCO(c1)) != null && (c3 = Utilities.findC5(c2)) != null && (o3 = Utilities.findBondWith(c3, 8)) != null) {
                List<Atom> firstAtoms = Utilities.getAtomListFromPool();
                firstAtoms.add(o3);
                firstAtoms.add(c3);
                firstAtoms.add(c2);
                firstAtoms.add(c1);
                firstAtoms.add(o2);
                firstAtoms.add(phosphate1);
                Residue base = Utilities.patternMatch(0, firstAtoms, type);
                if (base != null) {
                    Utilities.addCap(c3, o3, base);
                    na.add(0, base);
                }
            }
            oxygen1 = backbone.get(lastRes + 4);
            phosphate1 = backbone.get(lastRes + 5);
            if (phosphate1 != null && oxygen1 != null && (o2 = Utilities.findOtherOxygen(phosphate1, oxygen1)) != null && (c1 = Utilities.findBondWith(o2, 6)) != null && (c2 = Utilities.findBondWith(c1, 6)) != null && (c3 = Utilities.findCCO(c2)) != null && (o3 = Utilities.findBondWith(c3, 8)) != null) {
                List<Atom> lastAtoms = Utilities.getAtomListFromPool();
                lastAtoms.add(phosphate1);
                lastAtoms.add(o2);
                lastAtoms.add(c1);
                lastAtoms.add(c2);
                lastAtoms.add(c3);
                lastAtoms.add(o3);
                Residue base = Utilities.patternMatch(1, lastAtoms, type);
                if (base != null) {
                    Utilities.addPhosphate(phosphate1, base);
                    Utilities.addCap(c3, o3, base);
                    na.add(base);
                }
            }
            int index = 1;
            for (Residue r : na) {
                r.setNumber(index++);
                NamingUtils.renameNucleicAcidToPDBStandard(r);
                c.addMSNode(r);
            }
        } else {
            return false;
        }
        return true;
    }

    private static Atom findAlphaCarbon(Atom a) {
        for (Bond b : a.getBonds()) {
            Atom alpha = b.get1_2(a);
            if (alpha.getAtomicNumber() != 6 || Utilities.findCO(alpha) == null || !Utilities.formsBondsWith(alpha, 7)) continue;
            return alpha;
        }
        return null;
    }

    private static Atom findBondWith(Atom a, int atomicNumber) {
        for (Bond b : a.getBonds()) {
            Atom other = b.get1_2(a);
            if (other.getAtomicNumber() != atomicNumber) continue;
            return other;
        }
        return null;
    }

    private static Atom findC5(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbon = b.get1_2(adjacent);
            if (carbon.getAtomicNumber() != 6 || Utilities.numberOfBondsWith(carbon, 6) != 1 || Utilities.numberOfBondsWith(carbon, 8) != 1) continue;
            return carbon;
        }
        return null;
    }

    private static Atom findCCO(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbon = b.get1_2(adjacent);
            if (carbon.getAtomicNumber() != 6 || Utilities.numberOfBondsWith(carbon, 6) != 2 || Utilities.numberOfBondsWith(carbon, 8) < 1) continue;
            return carbon;
        }
        return null;
    }

    private static Atom findCO(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbon = b.get1_2(adjacent);
            if (carbon.getAtomicNumber() != 6 || !Utilities.formsBondsWith(carbon, 8)) continue;
            return carbon;
        }
        return null;
    }

    private static Atom findCarbonyl(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbonyl = b.get1_2(adjacent);
            if (carbonyl.getAtomicNumber() != 6) continue;
            for (Bond b2 : carbonyl.getBonds()) {
                Atom oxygen = b2.get1_2(carbonyl);
                if (oxygen.getAtomicNumber() != 8 || oxygen.getBonds().size() != 1) continue;
                return carbonyl;
            }
        }
        return null;
    }

    private static Atom findOtherOxygen(Atom p, Atom o) {
        for (Bond b : p.getBonds()) {
            Atom oxygen = b.get1_2(p);
            if (oxygen.getAtomicNumber() != 8 || oxygen == o || !Utilities.formsBondsWith(oxygen, 6)) continue;
            return oxygen;
        }
        return null;
    }

    private static List<Atom> findPolymer(Atom currentAtom, List<Atom> path) {
        List<Bond> bonds;
        int anum3;
        int size;
        Atom a;
        int anum2;
        Atom alphaCarbon;
        if (currentAtom.getBonds() == null) {
            path = Utilities.getAtomListFromPool();
            path.add(currentAtom);
            return path;
        }
        if (currentAtom.getParent() != null) {
            return null;
        }
        int anum = currentAtom.getAtomicNumber();
        if (anum != 6 && anum != 7 && anum != 8 && anum != 15) {
            return null;
        }
        if (path != null && path.size() > 6 && (anum == 8 ? !Utilities.formsBondsWith(currentAtom, 15) : (anum == 7 ? (alphaCarbon = Utilities.findAlphaCarbon(currentAtom)) == null : anum == 6 && (anum2 = (a = path.get((size = path.size()) - 1)).getAtomicNumber()) == 6 && (anum3 = (a = path.get(size - 2)).getAtomicNumber()) == 6))) {
            return null;
        }
        Atom previousAtom = null;
        if (path != null) {
            previousAtom = path.get(path.size() - 1);
        }
        if ((bonds = currentAtom.getBonds()).size() == 1 && previousAtom != null) {
            return null;
        }
        if (path == null) {
            path = Utilities.getAtomListFromPool();
            previousAtom = null;
        } else {
            List<Atom> pathclone = Utilities.getAtomListFromPool();
            pathclone.addAll(path);
            path = pathclone;
        }
        path.add(currentAtom);
        List<Atom> maxPolymer = Utilities.getAtomListFromPool();
        for (Bond b : bonds) {
            List<Atom> newPolymer;
            Atom nextAtom = b.get1_2(currentAtom);
            if (nextAtom == previousAtom || path.contains(nextAtom) || (newPolymer = Utilities.findPolymer(nextAtom, path)) == null || newPolymer.size() <= maxPolymer.size()) continue;
            Utilities.addAtomListToPool(maxPolymer);
            maxPolymer = newPolymer;
        }
        maxPolymer.add(0, currentAtom);
        return maxPolymer;
    }

    private static boolean formsBondsWith(Atom a, int atomicNumber) {
        for (Bond b : a.getBonds()) {
            Atom other = b.get1_2(a);
            if (other.getAtomicNumber() != atomicNumber) continue;
            return true;
        }
        return false;
    }

    private static List<Atom> getAtomListFromPool() {
        if (atomListPool.isEmpty()) {
            return new ArrayList<Atom>();
        }
        return atomListPool.remove(0);
    }

    private static String getSegID(Character c, List<String> segIDs) {
        if (c == null || c.equals(Character.valueOf(' '))) {
            c = Character.valueOf('A');
        }
        int m = 0;
        for (String segID : segIDs) {
            if (!segID.endsWith(c.toString())) continue;
            ++m;
        }
        Object newSegID = m == 0 ? c.toString() : c.toString() + m;
        segIDs.add((String)newSegID);
        return newSegID;
    }

    private static boolean haveCommonAtom(List<Atom> list1, List<Atom> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        for (Atom a : list1) {
            if (!list2.contains(a)) continue;
            return true;
        }
        return false;
    }

    static boolean isWaterOxygen(Atom a) {
        if (a.getAtomicNumber() != 8) {
            return false;
        }
        for (Bond b : a.getBonds()) {
            Atom h = b.get1_2(a);
            if (h.getAtomicNumber() == 1) continue;
            return false;
        }
        return true;
    }

    private static int numberOfBondsWith(Atom a, int atomicNumber) {
        int total = 0;
        for (Bond b : a.getBonds()) {
            Atom other = b.get1_2(a);
            if (other.getAtomicNumber() != atomicNumber) continue;
            ++total;
        }
        return total;
    }

    private static Residue patternMatch(int start, List<Atom> backbone, PolymerType type) {
        int[] pattern;
        if (type == PolymerType.AMINOACID) {
            pattern = AminoAcidUtils.AAPATTERN;
            if (backbone.size() < start + pattern.length) {
                return null;
            }
            Atom a = backbone.get(start + 1);
            if (Utilities.formsBondsWith(a, 8)) {
                return null;
            }
            a = backbone.get(start + 2);
            if (!Utilities.formsBondsWith(a, 8)) {
                return null;
            }
        } else if (type == PolymerType.NUCLEICACID) {
            pattern = NucleicAcidUtils.NAPATTERN;
            if (backbone.size() < start + pattern.length) {
                return null;
            }
        } else {
            return null;
        }
        int length = pattern.length;
        List<Atom> atoms = Utilities.getAtomListFromPool();
        List<Atom> sidePolymer = Utilities.getAtomListFromPool();
        for (int i = 0; i < length; ++i) {
            Atom a = backbone.get(start + i);
            sidePolymer.add(a);
            if (a.getAtomicNumber() == pattern[i]) continue;
            return null;
        }
        if (start > 0) {
            atoms.add(backbone.get(start - 1));
        }
        if (start + length < backbone.size()) {
            atoms.add(backbone.get(start + length));
        }
        Utilities.collectAtoms(backbone.get(start), atoms);
        if (start > 0) {
            atoms.remove(0);
        }
        if (start + length < backbone.size()) {
            atoms.remove(0);
        }
        if (type == PolymerType.AMINOACID) {
            Utilities.collectAtoms(sidePolymer.get(1), sidePolymer);
        } else {
            Atom seed = null;
            for (Atom a : atoms) {
                if (a.getAtomicNumber() != 7) continue;
                seed = a;
                break;
            }
            if (seed != null && seed.getAtomicNumber() == 7) {
                sidePolymer.add(seed);
                Utilities.collectAtoms(seed, sidePolymer);
            } else {
                return null;
            }
        }
        sidePolymer.subList(0, length + 1).clear();
        return Utilities.assignResidue(backbone, start, atoms, sidePolymer);
    }

    private static List<Atom> reverseAtomList(List<Atom> atomList) {
        List<Atom> reversedList = Utilities.getAtomListFromPool();
        for (Atom a : atomList) {
            reversedList.add(0, a);
        }
        return reversedList;
    }

    public static enum PolymerType {
        AMINOACID,
        NUCLEICACID,
        UNKNOWN;

    }

    public static enum FileType {
        XYZ,
        XPH,
        INT,
        ARC,
        PDB,
        CIF,
        ANY,
        SIM,
        UNK;

    }
}

