/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.crystal.LatticeSystem;
import ffx.crystal.NCSCrystal;
import ffx.crystal.ReplicatesCrystal;
import ffx.crystal.SpaceGroup;
import ffx.crystal.SpaceGroupDefinitions;
import ffx.crystal.SymOp;
import ffx.numerics.Constraint;
import ffx.numerics.Potential;
import ffx.numerics.math.Double3;
import ffx.potential.ANIEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.Platform;
import ffx.potential.Utilities;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.bonded.RestrainDistance;
import ffx.potential.bonded.RestrainPosition;
import ffx.potential.bonded.StretchBend;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.bonded.Torsion;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.bonded.UreyBradley;
import ffx.potential.constraint.CcmaConstraint;
import ffx.potential.constraint.SettleConstraint;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.nonbonded.COMRestraint;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.NCSRestraint;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.RestrainGroups;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.nonbonded.VanDerWaalsTornado;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.XYZFileFilter;
import ffx.potential.terms.AnglePotentialEnergy;
import ffx.potential.terms.AngleTorsionPotentialEnergy;
import ffx.potential.terms.BondPotentialEnergy;
import ffx.potential.terms.EnergyTermRegion;
import ffx.potential.terms.ImproperTorsionPotentialEnergy;
import ffx.potential.terms.OutOfPlaneBendPotentialEnergy;
import ffx.potential.terms.PiOrbitalTorsionPotentialEnergy;
import ffx.potential.terms.RestrainDistancePotentialEnergy;
import ffx.potential.terms.RestrainPositionPotentialEnergy;
import ffx.potential.terms.RestrainTorsionPotentialEnergy;
import ffx.potential.terms.StretchBendPotentialEnergy;
import ffx.potential.terms.StretchTorsionPotentialEnergy;
import ffx.potential.terms.TorsionPotentialEnergy;
import ffx.potential.terms.TorsionTorsionPotentialEnergy;
import ffx.potential.terms.UreyBradleyPotentialEnergy;
import ffx.potential.utils.ConvexHullOps;
import ffx.potential.utils.EnergyException;
import ffx.potential.utils.PotentialsUtils;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class ForceFieldEnergy
implements CrystalPotential,
LambdaInterface {
    private static final Logger logger = Logger.getLogger(ForceFieldEnergy.class.getName());
    private static final double toSeconds = 1.0E-9;
    private final Platform platform = Platform.FFX;
    protected final MolecularAssembly molecularAssembly;
    private final Atom[] atoms;
    private Crystal crystal;
    private final ParallelTeam parallelTeam;
    private final NCSRestraint ncsRestraint;
    private final COMRestraint comRestraint;
    private final VanDerWaals vanderWaals;
    private final ParticleMeshEwald particleMeshEwald;
    private final ANIEnergy aniEnergy;
    private final List<Constraint> constraints;
    public static final double DEFAULT_CONSTRAINT_TOLERANCE = 1.0E-4;
    @FFXProperty(name="vdw-cutoff", propertyGroup=PropertyGroup.NonBondedCutoff, defaultValue="12.0", description="Sets the cutoff distance value in Angstroms for van der Waals potential energy interactions.\nThe energy for any pair of van der Waals sites beyond the cutoff distance will be set to zero.\nOther properties can be used to define the smoothing scheme near the cutoff distance.\nThe default cutoff distance in the absence of the vdw-cutoff keyword is infinite for nonperiodic\nsystems and 12.0 for periodic systems.\n")
    private double vdwCutoff;
    @FFXProperty(name="ewald-cutoff", propertyGroup=PropertyGroup.NonBondedCutoff, defaultValue="7.0", description="Sets the value in Angstroms of the real-space distance cutoff for use during Ewald summation.\nBy default, in the absence of the ewald-cutoff property, a value of 7.0 is used.\n")
    private double ewaldCutoff;
    @FFXProperty(name="gk-cutoff", propertyGroup=PropertyGroup.NonBondedCutoff, defaultValue="12.0", description="Sets the value in Angstroms of the generalized Kirkwood distance cutoff for use\nduring implicit solvent simulations. By default, in the absence of the gk-cutoff property,\nno cutoff is used under aperiodic boundary conditions and the vdw-cutoff is used under PBC.\n")
    private double gkCutoff;
    private static final double DEFAULT_LIST_BUFFER = 2.0;
    @FFXProperty(name="list-buffer", propertyGroup=PropertyGroup.NonBondedCutoff, defaultValue="2.0", description="Sets the size of the neighbor list buffer in Angstroms for potential energy functions.\nThis value is added to the actual cutoff distance to determine which pairs will be kept on the neighbor list.\nThis buffer value is used for all potential function neighbor lists.\nThe default value in the absence of the list-buffer keyword is 2.0 Angstroms.\n")
    private double listBuffer;
    private final double cutOff2;
    private final double cutoffPlusBuffer;
    private final ForceField.ELEC_FORM elecForm;
    @FFXProperty(name="lambdaterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="false", description="Specifies use of the Lambda state variable.")
    protected boolean lambdaTerm;
    private double lambda = 1.0;
    public boolean lambdaBondedTerms = false;
    boolean lambdaAllBondedTerms = false;
    private final boolean lambdaTorsions;
    private Potential.STATE state = Potential.STATE.BOTH;
    protected double[] optimizationScaling = null;
    private final EnergyTermRegion forceFieldBondedEnergyRegion;
    private final BondPotentialEnergy bondPotentialEnergy;
    private final AnglePotentialEnergy anglePotentialEnergy;
    private final StretchBendPotentialEnergy stretchBendPotentialEnergy;
    private final UreyBradleyPotentialEnergy ureyBradleyPotentialEnergy;
    private final OutOfPlaneBendPotentialEnergy outOfPlaneBendPotentialEnergy;
    private final TorsionPotentialEnergy torsionPotentialEnergy;
    private final StretchTorsionPotentialEnergy stretchTorsionPotentialEnergy;
    private final AngleTorsionPotentialEnergy angleTorsionPotentialEnergy;
    private final ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy;
    private final PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy;
    private final TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy;
    private final EnergyTermRegion restrainEnergyRegion;
    private final RestrainMode restrainMode;
    private final RestrainPositionPotentialEnergy restrainPositionPotentialEnergy;
    private final RestrainDistancePotentialEnergy restrainDistancePotentialEnergy;
    private final RestrainTorsionPotentialEnergy restrainTorsionPotentialEnergy;
    private final RestrainGroups restrainGroups;
    private final int nAtoms;
    private int nRestrainGroups;
    private int nVanDerWaalInteractions;
    private int nPermanentInteractions;
    private int nGKInteractions;
    private boolean nnTerm;
    @FFXProperty(name="bondterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the bond stretch potential.")
    private final boolean bondTerm;
    @FFXProperty(name="angleterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the angle bend potential.")
    private final boolean angleTerm;
    @FFXProperty(name="strbndterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the stretch-bend potential.")
    private final boolean stretchBendTerm;
    @FFXProperty(name="ureyterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the Urey-Bradley potential.")
    private final boolean ureyBradleyTerm;
    @FFXProperty(name="opbendterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the out-of-plane potential.")
    private final boolean outOfPlaneBendTerm;
    @FFXProperty(name="torsionterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the torsional potential.")
    private final boolean torsionTerm;
    @FFXProperty(name="strtorterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the stretch-torsion potential.")
    private final boolean stretchTorsionTerm;
    @FFXProperty(name="angtorterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the angle-torsion potential.")
    private final boolean angleTorsionTerm;
    @FFXProperty(name="imptorterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the improper torsion potential.")
    private final boolean improperTorsionTerm;
    @FFXProperty(name="pitorsterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the pi-system torsion potential.")
    private final boolean piOrbitalTorsionTerm;
    @FFXProperty(name="tortorterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the pi-system torsion potential.")
    private final boolean torsionTorsionTerm;
    private final boolean restrainPositionTerm;
    private final boolean restrainDistanceTerm;
    private final boolean restrainTorsionTerm;
    private boolean restrainGroupTerm;
    @FFXProperty(name="vdwterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the vdw der Waals potential.\nIf set to false, all non-bonded terms are turned off.\n")
    private boolean vanderWaalsTerm;
    @FFXProperty(name="mpoleterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the fixed charge electrostatic potential.\nSetting mpoleterm to false also turns off polarization and generalized Kirkwood,\noverriding the polarizeterm and gkterm properties.\n")
    private boolean multipoleTerm;
    @FFXProperty(name="polarizeterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="true", description="Specifies use of the polarizable electrostatic potential.\nSetting polarizeterm to false overrides the polarization property.\n")
    private boolean polarizationTerm;
    @FFXProperty(name="gkterm", clazz=Boolean.class, propertyGroup=PropertyGroup.PotentialFunctionSelection, defaultValue="false", description="Specifies use of generalized Kirkwood electrostatics.")
    private boolean generalizedKirkwoodTerm;
    private boolean comTerm;
    private boolean ncsTerm;
    private final boolean nnTermOrig;
    private final boolean restrainGroupTermOrig;
    private final boolean vanderWaalsTermOrig;
    private final boolean multipoleTermOrig;
    private final boolean polarizationTermOrig;
    private final boolean generalizedKirkwoodTermOrig;
    private boolean esvTermOrig;
    private boolean ncsTermOrig;
    private boolean comTermOrig;
    private double nnEnergy;
    private double restrainGroupEnergy;
    private double vanDerWaalsEnergy;
    private double permanentMultipoleEnergy;
    private double polarizationEnergy;
    private double solvationEnergy;
    private double ncsEnergy;
    private double comRestraintEnergy;
    private double totalEnergy;
    private long ncsTime;
    private long nnTime;
    private long restrainGroupTime;
    private long comRestraintTime;
    private long vanDerWaalsTime;
    private long electrostaticTime;
    private long totalTime;
    private ExtendedSystem esvSystem = null;
    private boolean esvTerm;
    private double esvBias;
    boolean destroyed = false;
    public final double maxDebugGradient;
    private boolean printOnFailure;

    protected ForceFieldEnergy(MolecularAssembly molecularAssembly) {
        this(molecularAssembly, ParallelTeam.getDefaultThreadCount());
    }

    protected ForceFieldEnergy(MolecularAssembly molecularAssembly, int numThreads) {
        Torsion[] restrainTorsions;
        int forceGroup;
        boolean disabledNeighborUpdates;
        double gamma;
        double beta;
        double alpha;
        double c;
        double b;
        boolean aperiodic;
        double a;
        String spacegroup;
        this.molecularAssembly = molecularAssembly;
        this.atoms = molecularAssembly.getAtomArray();
        this.nAtoms = this.atoms.length;
        for (int i = 0; i < this.nAtoms; ++i) {
            int index = this.atoms[i].getXyzIndex() - 1;
            assert (i == index);
        }
        int nThreads = FastMath.min((int)this.nAtoms, (int)numThreads);
        this.parallelTeam = new ParallelTeam(nThreads);
        ForceField forceField = molecularAssembly.getForceField();
        CompositeConfiguration properties = forceField.getProperties();
        String name = forceField.toString().toUpperCase();
        logger.info(String.format(" Constructing Force Field %s", name));
        logger.info(String.format("\n SMP threads:                        %10d", nThreads));
        boolean standardizeAtomNames = properties.getBoolean("standardizeAtomNames", true);
        if (standardizeAtomNames) {
            molecularAssembly.renameWaterProtons();
        }
        this.nnTerm = forceField.getBoolean("NNTERM", false);
        if (this.nnTerm) {
            for (Atom atom : this.atoms) {
                atom.setNeuralNetwork(true);
            }
        }
        this.bondTerm = forceField.getBoolean("BONDTERM", true);
        this.angleTerm = forceField.getBoolean("ANGLETERM", true);
        this.stretchBendTerm = forceField.getBoolean("STRBNDTERM", true);
        this.ureyBradleyTerm = forceField.getBoolean("UREYTERM", true);
        this.outOfPlaneBendTerm = forceField.getBoolean("OPBENDTERM", true);
        this.torsionTerm = forceField.getBoolean("TORSIONTERM", true);
        this.stretchTorsionTerm = forceField.getBoolean("STRTORTERM", true);
        this.angleTorsionTerm = forceField.getBoolean("ANGTORTERM", true);
        this.piOrbitalTorsionTerm = forceField.getBoolean("PITORSTERM", true);
        this.torsionTorsionTerm = forceField.getBoolean("TORTORTERM", true);
        this.improperTorsionTerm = forceField.getBoolean("IMPROPERTERM", true);
        this.vanderWaalsTerm = forceField.getBoolean("VDWTERM", true);
        boolean tornadoVM = forceField.getBoolean("tornado", false);
        if (this.vanderWaalsTerm && !tornadoVM) {
            this.multipoleTerm = forceField.getBoolean("MPOLETERM", true);
            if (this.multipoleTerm) {
                String polarizeString = forceField.getString("POLARIZATION", "NONE");
                boolean defaultPolarizeTerm = !polarizeString.equalsIgnoreCase("NONE");
                this.polarizationTerm = forceField.getBoolean("POLARIZETERM", defaultPolarizeTerm);
                this.generalizedKirkwoodTerm = forceField.getBoolean("GKTERM", false);
            } else {
                this.polarizationTerm = false;
                this.generalizedKirkwoodTerm = false;
            }
        } else {
            this.multipoleTerm = false;
            this.polarizationTerm = false;
            this.generalizedKirkwoodTerm = false;
        }
        this.lambdaTerm = forceField.getBoolean("LAMBDATERM", false);
        this.comTerm = forceField.getBoolean("COMRESTRAINTERM", false);
        this.lambdaTorsions = forceField.getBoolean("TORSION_LAMBDATERM", false);
        this.printOnFailure = forceField.getBoolean("PRINT_ON_FAILURE", false);
        String mode = forceField.getString("RESTRAIN_MODE", "ENERGY");
        this.restrainMode = mode.equalsIgnoreCase("ALCHEMICAL") ? RestrainMode.ALCHEMICAL : RestrainMode.ENERGY;
        this.restrainGroupTerm = properties.containsKey("restrain-groups");
        this.nnTermOrig = this.nnTerm;
        this.restrainGroupTermOrig = this.restrainGroupTerm;
        this.vanderWaalsTermOrig = this.vanderWaalsTerm;
        this.multipoleTermOrig = this.multipoleTerm;
        this.polarizationTermOrig = this.polarizationTerm;
        this.generalizedKirkwoodTermOrig = this.generalizedKirkwoodTerm;
        this.ncsTermOrig = this.ncsTerm;
        this.comTermOrig = this.comTerm;
        try {
            spacegroup = forceField.getString("SPACEGROUP", "P 1");
            SpaceGroup sg = SpaceGroupDefinitions.spaceGroupFactory((String)spacegroup);
            LatticeSystem latticeSystem = sg.latticeSystem;
            a = forceField.getDouble("A_AXIS");
            aperiodic = false;
            b = forceField.getDouble("B_AXIS", latticeSystem.getDefaultBAxis(a));
            c = forceField.getDouble("C_AXIS", latticeSystem.getDefaultCAxis(a, b));
            alpha = forceField.getDouble("ALPHA", latticeSystem.getDefaultAlpha());
            beta = forceField.getDouble("BETA", latticeSystem.getDefaultBeta());
            gamma = forceField.getDouble("GAMMA", latticeSystem.getDefaultGamma());
            if (!sg.latticeSystem.validParameters(a, b, c, alpha, beta, gamma)) {
                logger.severe(" Check lattice parameters.");
            }
            if (a == 1.0 && b == 1.0 && c == 1.0) {
                String message = " A-, B-, and C-axis values equal to 1.0.";
                logger.info(message);
                throw new Exception(message);
            }
            if (a <= 0.0 || b <= 0.0 || c <= 0.0 || alpha <= 0.0 || beta <= 0.0 || gamma <= 0.0) {
                String message = " Crystal parameters are not valid due to negative or zero value.";
                logger.warning(message);
                throw new Exception(message);
            }
        }
        catch (Exception e) {
            aperiodic = true;
            double maxR = 0.0;
            if (this.nAtoms < 10) {
                for (int i = 0; i < this.nAtoms - 1; ++i) {
                    Double3 xi = this.atoms[i].getXYZ();
                    for (int j = 1; j < this.nAtoms; ++j) {
                        double r = this.atoms[j].getXYZ().dist(xi);
                        maxR = FastMath.max((double)r, (double)maxR);
                    }
                }
            } else {
                try {
                    maxR = ConvexHullOps.maxDist(ConvexHullOps.constructHull(this.atoms));
                }
                catch (Exception ex) {
                    logger.info(" Convex Hull operation failed with message " + String.valueOf(ex) + "\n Trying brute force approach...");
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(Utilities.stackTraceToString(ex));
                    }
                    for (int i = 0; i < this.nAtoms - 1; ++i) {
                        Double3 xi = this.atoms[i].getXYZ();
                        for (int j = 1; j < this.nAtoms; ++j) {
                            double r = this.atoms[j].getXYZ().dist(xi);
                            maxR = FastMath.max((double)r, (double)maxR);
                        }
                    }
                }
            }
            maxR = FastMath.max((double)10.0, (double)maxR);
            logger.info(String.format(" The system will be treated as aperiodic (max separation = %6.1f A).", maxR));
            forceField.addProperty("EWALD_ALPHA", "0.0");
            spacegroup = "P1";
            a = 2.0 * maxR;
            b = 2.0 * maxR;
            c = 2.0 * maxR;
            alpha = 90.0;
            beta = 90.0;
            gamma = 90.0;
        }
        Crystal unitCell = new Crystal(a, b, c, alpha, beta, gamma, spacegroup);
        unitCell.setAperiodic(aperiodic);
        this.vdwCutoff = 12.0;
        this.ewaldCutoff = 7.0;
        this.gkCutoff = this.vdwCutoff;
        if (unitCell.aperiodic()) {
            this.vdwCutoff = Double.POSITIVE_INFINITY;
            this.ewaldCutoff = Double.POSITIVE_INFINITY;
            this.gkCutoff = Double.POSITIVE_INFINITY;
        }
        this.vdwCutoff = forceField.getDouble("VDW_CUTOFF", this.vdwCutoff);
        this.ewaldCutoff = forceField.getDouble("EWALD_CUTOFF", this.ewaldCutoff);
        this.gkCutoff = forceField.getDouble("GK_CUTOFF", this.gkCutoff);
        double nlistCutoff = this.vdwCutoff;
        if (this.multipoleTerm) {
            nlistCutoff = FastMath.max((double)this.vdwCutoff, (double)this.ewaldCutoff);
        }
        if (this.generalizedKirkwoodTerm) {
            nlistCutoff = FastMath.max((double)nlistCutoff, (double)this.gkCutoff);
        }
        if (disabledNeighborUpdates = forceField.getBoolean("DISABLE_NEIGHBOR_UPDATES", false)) {
            logger.info(String.format(" Neighbor list updates disabled; interactions will only be calculated between atoms that started the simulation within a radius of %9.3g Angstroms of each other.", nlistCutoff));
            this.vdwCutoff = Double.POSITIVE_INFINITY;
            this.ewaldCutoff = Double.POSITIVE_INFINITY;
            this.gkCutoff = Double.POSITIVE_INFINITY;
        }
        this.listBuffer = forceField.getDouble("LIST_BUFFER", 2.0);
        this.cutoffPlusBuffer = nlistCutoff + this.listBuffer;
        this.cutOff2 = 2.0 * this.cutoffPlusBuffer;
        unitCell = this.configureNCS(forceField, unitCell);
        if (!aperiodic) {
            this.crystal = ReplicatesCrystal.replicatesCrystalFactory((Crystal)unitCell, (double)this.cutOff2);
            logger.info(String.format("\n Density:                                %6.3f (g/cc)", this.crystal.getDensity(molecularAssembly.getMass())));
            logger.info(this.crystal.toString());
        } else {
            this.crystal = unitCell;
        }
        if (!unitCell.aperiodic() && unitCell.spaceGroup.number == 1) {
            this.ncsTermOrig = this.ncsTerm = forceField.getBoolean("NCSTERM", false);
        } else {
            this.ncsTerm = false;
            this.ncsTermOrig = false;
        }
        int nSpecial = this.checkForSpecialPositions(forceField);
        boolean rigidHydrogens = forceField.getBoolean("RIGID_HYDROGENS", false);
        double rigidScale = forceField.getDouble("RIGID_SCALE", 10.0);
        boolean checkAllNodeCharges = forceField.getBoolean("CHECK_ALL_NODE_CHARGES", false);
        if (rigidScale <= 1.0) {
            rigidScale = 1.0;
        }
        logger.info("\n Bonded Terms");
        if (rigidHydrogens && rigidScale > 1.0) {
            logger.info(String.format("  Rigid hydrogens:                   %10.2f", rigidScale));
        }
        this.forceFieldBondedEnergyRegion = new EnergyTermRegion(this.parallelTeam, molecularAssembly, this.lambdaTerm);
        this.restrainEnergyRegion = new EnergyTermRegion(this.parallelTeam, molecularAssembly, this.lambdaTerm);
        if (this.bondTerm) {
            List<Bond> bondList = molecularAssembly.getBondList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(bondList);
            }
            if (!bondList.isEmpty()) {
                forceGroup = forceField.getInteger("BOND_FORCE_GROUP", 0);
                this.bondPotentialEnergy = new BondPotentialEnergy("Bonds", forceGroup, bondList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.bondPotentialEnergy);
            } else {
                this.bondPotentialEnergy = null;
            }
        } else {
            this.bondPotentialEnergy = null;
        }
        if (this.angleTerm) {
            List<Angle> angleList = molecularAssembly.getAngleList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(angleList);
            }
            if (!angleList.isEmpty()) {
                forceGroup = forceField.getInteger("ANGLE_FORCE_GROUP", 0);
                this.anglePotentialEnergy = new AnglePotentialEnergy("Angles", forceGroup, angleList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.anglePotentialEnergy);
            } else {
                this.anglePotentialEnergy = null;
            }
        } else {
            this.anglePotentialEnergy = null;
        }
        if (this.stretchBendTerm) {
            List<StretchBend> stretchBendList = molecularAssembly.getStretchBendList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(stretchBendList);
            }
            if (!stretchBendList.isEmpty()) {
                forceGroup = forceField.getInteger("STRETCH_BEND_FORCE_GROUP", 0);
                this.stretchBendPotentialEnergy = new StretchBendPotentialEnergy("Stretch-Bends", forceGroup, stretchBendList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.stretchBendPotentialEnergy);
            } else {
                this.stretchBendPotentialEnergy = null;
            }
        } else {
            this.stretchBendPotentialEnergy = null;
        }
        if (this.ureyBradleyTerm) {
            Iterator<BondedTerm> ureyBradleyList = molecularAssembly.getUreyBradleyList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(ureyBradleyList);
            }
            if (!ureyBradleyList.isEmpty()) {
                forceGroup = forceField.getInteger("UREY_BRADLEY_FORCE_GROUP", 0);
                this.ureyBradleyPotentialEnergy = new UreyBradleyPotentialEnergy("Urey-Bradleys", forceGroup, (List<UreyBradley>)((Object)ureyBradleyList));
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.ureyBradleyPotentialEnergy);
            } else {
                this.ureyBradleyPotentialEnergy = null;
            }
        } else {
            this.ureyBradleyPotentialEnergy = null;
        }
        if (rigidHydrogens) {
            if (this.bondPotentialEnergy != null) {
                for (Bond bond : this.bondPotentialEnergy.getBonds()) {
                    if (!bond.containsHydrogen()) continue;
                    bond.setRigidScale(rigidScale);
                }
            }
            if (this.anglePotentialEnergy != null) {
                for (Angle angle : this.anglePotentialEnergy.getAngles()) {
                    if (!angle.containsHydrogen()) continue;
                    angle.setRigidScale(rigidScale);
                }
            }
            if (this.stretchBendPotentialEnergy != null) {
                for (StretchBend stretchBend : this.stretchBendPotentialEnergy.getStretchBends()) {
                    if (!stretchBend.containsHydrogen()) continue;
                    stretchBend.setRigidScale(rigidScale);
                }
            }
            if (this.ureyBradleyPotentialEnergy != null) {
                for (UreyBradley ureyBradley : this.ureyBradleyPotentialEnergy.getUreyBradleys()) {
                    if (!ureyBradley.containsHydrogen()) continue;
                    ureyBradley.setRigidScale(rigidScale);
                }
            }
        }
        if (this.outOfPlaneBendTerm) {
            List<OutOfPlaneBend> outOfPlaneBendList = molecularAssembly.getOutOfPlaneBendList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(outOfPlaneBendList);
            }
            if (!outOfPlaneBendList.isEmpty()) {
                forceGroup = forceField.getInteger("OUT_OF_PLANE_BEND_FORCE_GROUP", 0);
                this.outOfPlaneBendPotentialEnergy = new OutOfPlaneBendPotentialEnergy("Out-0f-Plane Bends", forceGroup, outOfPlaneBendList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.outOfPlaneBendPotentialEnergy);
            } else {
                this.outOfPlaneBendPotentialEnergy = null;
            }
        } else {
            this.outOfPlaneBendPotentialEnergy = null;
        }
        if (this.torsionTerm) {
            List<Torsion> torsionList = molecularAssembly.getTorsionList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(torsionList);
            }
            if (!torsionList.isEmpty()) {
                forceGroup = forceField.getInteger("TORSION_FORCE_GROUP", 0);
                this.torsionPotentialEnergy = new TorsionPotentialEnergy("Torsions", forceGroup, torsionList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.torsionPotentialEnergy);
            } else {
                this.torsionPotentialEnergy = null;
            }
        } else {
            this.torsionPotentialEnergy = null;
        }
        if (this.stretchTorsionTerm) {
            List<StretchTorsion> stretchTorsionList = molecularAssembly.getStretchTorsionList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(stretchTorsionList);
            }
            if (!stretchTorsionList.isEmpty()) {
                forceGroup = forceField.getInteger("STRETCH_TORSION_FORCE_GROUP", 0);
                this.stretchTorsionPotentialEnergy = new StretchTorsionPotentialEnergy("Stretch-Torsions", forceGroup, stretchTorsionList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.stretchTorsionPotentialEnergy);
            } else {
                this.stretchTorsionPotentialEnergy = null;
            }
        } else {
            this.stretchTorsionPotentialEnergy = null;
        }
        if (this.angleTorsionTerm) {
            List<AngleTorsion> angleTorsionList = molecularAssembly.getAngleTorsionList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(angleTorsionList);
            }
            if (!angleTorsionList.isEmpty()) {
                forceGroup = forceField.getInteger("ANGLE_TORSION_FORCE_GROUP", 0);
                this.angleTorsionPotentialEnergy = new AngleTorsionPotentialEnergy("Angle-Torsions", forceGroup, angleTorsionList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.angleTorsionPotentialEnergy);
            } else {
                this.angleTorsionPotentialEnergy = null;
            }
        } else {
            this.angleTorsionPotentialEnergy = null;
        }
        if (this.improperTorsionTerm) {
            List<ImproperTorsion> improperTorsionList = molecularAssembly.getImproperTorsionList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(improperTorsionList);
            }
            if (!improperTorsionList.isEmpty()) {
                forceGroup = forceField.getInteger("IMPROPER_TORSION_FORCE_GROUP", 0);
                this.improperTorsionPotentialEnergy = new ImproperTorsionPotentialEnergy("Improper Torsions", forceGroup, improperTorsionList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.improperTorsionPotentialEnergy);
            } else {
                this.improperTorsionPotentialEnergy = null;
            }
        } else {
            this.improperTorsionPotentialEnergy = null;
        }
        if (this.piOrbitalTorsionTerm) {
            List<PiOrbitalTorsion> piOrbitalTorsionList = molecularAssembly.getPiOrbitalTorsionList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(piOrbitalTorsionList);
            }
            if (!piOrbitalTorsionList.isEmpty()) {
                forceGroup = forceField.getInteger("PI_ORBITAL_TORSION_FORCE_GROUP", 0);
                this.piOrbitalTorsionPotentialEnergy = new PiOrbitalTorsionPotentialEnergy("Pi-Orbital Torsions", forceGroup, piOrbitalTorsionList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.piOrbitalTorsionPotentialEnergy);
            } else {
                this.piOrbitalTorsionPotentialEnergy = null;
            }
        } else {
            this.piOrbitalTorsionPotentialEnergy = null;
        }
        if (this.torsionTorsionTerm) {
            List<TorsionTorsion> torsionTorsionList = molecularAssembly.getTorsionTorsionList();
            if (this.nnTerm) {
                BondedTerm.removeNeuralNetworkTerms(torsionTorsionList);
            }
            if (!torsionTorsionList.isEmpty()) {
                forceGroup = forceField.getInteger("TORSION_TORSION_FORCE_GROUP", 0);
                this.torsionTorsionPotentialEnergy = new TorsionTorsionPotentialEnergy("Torsion-Torsions", forceGroup, torsionTorsionList);
                this.forceFieldBondedEnergyRegion.addEnergyTerm(this.torsionTorsionPotentialEnergy);
            } else {
                this.torsionTorsionPotentialEnergy = null;
            }
        } else {
            this.torsionTorsionPotentialEnergy = null;
        }
        RestrainPosition[] restrainPositions = RestrainPosition.parseRestrainPositions(molecularAssembly);
        this.restrainPositionTerm = restrainPositions != null && restrainPositions.length > 0;
        if (this.restrainPositionTerm) {
            forceGroup = forceField.getInteger("RESTRAIN_POSITION_FORCE_GROUP", 0);
            this.restrainPositionPotentialEnergy = new RestrainPositionPotentialEnergy("Restrain Positions", forceGroup, Arrays.asList(restrainPositions));
            this.restrainEnergyRegion.addEnergyTerm(this.restrainPositionPotentialEnergy);
        } else {
            this.restrainPositionPotentialEnergy = null;
        }
        RestrainDistance[] restrainDistances = RestrainDistancePotentialEnergy.configureRestrainDistances(properties, this.atoms, this.crystal, this.lambdaTerm);
        this.restrainDistanceTerm = restrainDistances != null && restrainDistances.length > 0;
        if (this.restrainDistanceTerm) {
            int forceGroup2 = forceField.getInteger("RESTRAIN_DISTANCE_FORCE_GROUP", 0);
            this.restrainDistancePotentialEnergy = new RestrainDistancePotentialEnergy("Restrain Distances", forceGroup2, Arrays.asList(restrainDistances));
            this.restrainEnergyRegion.addEnergyTerm(this.restrainDistancePotentialEnergy);
        } else {
            this.restrainDistancePotentialEnergy = null;
        }
        Torsion[] torsions = null;
        if (this.torsionPotentialEnergy != null) {
            torsions = this.torsionPotentialEnergy.getTorsionArray();
        }
        this.restrainTorsionTerm = (restrainTorsions = RestrainTorsionPotentialEnergy.configureRestrainTorsions(properties, forceField, this.atoms, torsions)) != null && restrainTorsions.length > 0;
        if (this.restrainTorsionTerm) {
            logger.info(" Restrain Torsion Mode: " + String.valueOf((Object)this.restrainMode));
            int forceGroup3 = forceField.getInteger("RESTRAIN_TORSION_FORCE_GROUP", 0);
            this.restrainTorsionPotentialEnergy = new RestrainTorsionPotentialEnergy("Restrain Torsions", forceGroup3, Arrays.asList(restrainTorsions));
            this.restrainEnergyRegion.addEnergyTerm(this.restrainTorsionPotentialEnergy);
        } else {
            this.restrainTorsionPotentialEnergy = null;
        }
        int[] molecule = molecularAssembly.getMoleculeNumbers();
        if (this.vanderWaalsTerm) {
            logger.info("\n Non-Bonded Terms");
            boolean[] nn = null;
            if (this.nnTerm) {
                nn = molecularAssembly.getNeuralNetworkIdentity();
            } else {
                nn = new boolean[this.nAtoms];
                Arrays.fill(nn, false);
            }
            this.vanderWaals = !tornadoVM ? new VanDerWaals(this.atoms, molecule, nn, this.crystal, forceField, this.parallelTeam, this.vdwCutoff, nlistCutoff) : new VanDerWaalsTornado(this.atoms, this.crystal, forceField, this.vdwCutoff);
        } else {
            this.vanderWaals = null;
        }
        this.aniEnergy = this.nnTerm ? new ANIEnergy(molecularAssembly) : null;
        if (this.multipoleTerm) {
            this.elecForm = name.contains("OPLS") || name.contains("AMBER") || name.contains("CHARMM") ? ForceField.ELEC_FORM.FIXED_CHARGE : ForceField.ELEC_FORM.PAM;
            this.particleMeshEwald = new ParticleMeshEwald(this.atoms, molecule, forceField, this.crystal, this.vanderWaals.getNeighborList(), this.elecForm, this.ewaldCutoff, this.gkCutoff, this.parallelTeam);
            double charge = molecularAssembly.getCharge(checkAllNodeCharges);
            logger.info(String.format("\n  Overall system charge:             %10.3f", charge));
        } else {
            this.elecForm = null;
            this.particleMeshEwald = null;
        }
        if (this.ncsTerm) {
            String sg = forceField.getString("NCSGROUP", "P 1");
            Crystal ncsCrystal = new Crystal(a, b, c, alpha, beta, gamma, sg);
            this.ncsRestraint = new NCSRestraint(this.atoms, forceField, ncsCrystal);
        } else {
            this.ncsRestraint = null;
        }
        if (this.restrainGroupTerm) {
            this.restrainGroups = new RestrainGroups(molecularAssembly);
            this.nRestrainGroups = this.restrainGroups.getNumberOfRestraints();
        } else {
            this.restrainGroups = null;
        }
        this.comRestraint = this.comTerm ? new COMRestraint(molecularAssembly) : null;
        this.maxDebugGradient = forceField.getDouble("MAX_DEBUG_GRADIENT", Double.POSITIVE_INFINITY);
        molecularAssembly.setPotential(this);
        this.constraints = this.configureConstraints(forceField);
        if (this.lambdaTerm) {
            this.setLambda(1.0);
            if (nSpecial == 0) {
                this.crystal.setSpecialPositionCutoff(0.0);
            } else {
                logger.info(" Special positions checking will be performed during a lambda simulation.");
            }
        }
    }

    public MolecularAssembly getMolecularAssembly() {
        return this.molecularAssembly;
    }

    public void setLambdaTerm(boolean lambdaTerm) {
        this.lambdaTerm = lambdaTerm;
    }

    public boolean getLambdaTerm() {
        return this.lambdaTerm;
    }

    private int checkForSpecialPositions(ForceField forceField) {
        int nSymm;
        boolean specialPositionsInactive = forceField.getBoolean("SPECIAL_POSITIONS_INACTIVE", true);
        int nSpecial = 0;
        if (specialPositionsInactive && (nSymm = this.crystal.getNumSymOps()) > 1) {
            SpaceGroup spaceGroup = this.crystal.spaceGroup;
            double sp2 = this.crystal.getSpecialPositionCutoff2();
            double[] mate = new double[3];
            StringBuilder sb = new StringBuilder("\n Atoms at Special Positions set to Inactive:\n");
            block0: for (int i = 0; i < this.nAtoms; ++i) {
                Atom atom = this.atoms[i];
                double[] xyz = atom.getXYZ(null);
                for (int iSymm = 1; iSymm < nSymm; ++iSymm) {
                    SymOp symOp = spaceGroup.getSymOp(iSymm);
                    this.crystal.applySymOp(xyz, mate, symOp);
                    double dr2 = this.crystal.image(xyz, mate);
                    if (!(dr2 < sp2)) continue;
                    sb.append(String.format("  %s separation with SymOp %d at %8.6f A.\n", this.atoms[i], iSymm, FastMath.sqrt((double)dr2)));
                    atom.setActive(false);
                    ++nSpecial;
                    continue block0;
                }
            }
            if (nSpecial > 0) {
                logger.info(sb.toString());
            }
        }
        return nSpecial;
    }

    private List<Constraint> configureConstraints(ForceField forceField) {
        String constraintStrings = forceField.getString("CONSTRAIN", forceField.getString("RATTLE", null));
        if (constraintStrings == null) {
            return Collections.emptyList();
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        logger.info(String.format(" Experimental: parsing constraints option %s", constraintStrings));
        Set<Object> numericBonds = new HashSet(1);
        HashSet<Object> numericAngles = new HashSet(1);
        if (constraintStrings.isEmpty() || constraintStrings.matches("^\\s*$")) {
            logger.info(" Constraining X-H bonds.");
            Bond[] bonds = this.bondPotentialEnergy.getBondArray();
            numericBonds = Arrays.stream(bonds).filter(bond -> bond.getAtom(0).getAtomicNumber() == 1 || bond.getAtom(1).getAtomicNumber() == 1).collect(Collectors.toSet());
        } else {
            String[] constraintToks = constraintStrings.split("\\s+");
            for (String tok : constraintToks) {
                if (tok.equalsIgnoreCase("WATER")) {
                    logger.info(" Constraining waters to be rigid based on angle & bonds.");
                    Stream<MSNode> settleStream = this.molecularAssembly.getMolecules().stream().filter(m -> m.getAtomList().size() == 3).filter(m -> {
                        List<Atom> atoms = m.getAtomList();
                        Atom O = null;
                        ArrayList<Atom> H = new ArrayList<Atom>(2);
                        for (Atom at : atoms) {
                            int atN = at.getAtomicNumber();
                            if (atN == 8) {
                                O = at;
                                continue;
                            }
                            if (atN != 1) continue;
                            H.add(at);
                        }
                        return O != null && H.size() == 2;
                    });
                    settleStream = Stream.concat(settleStream, this.molecularAssembly.getWater().stream());
                    List<SettleConstraint> settleConstraints = settleStream.map(m -> m.getAngleList().getFirst()).map(SettleConstraint::settleFactory).toList();
                    constraints.addAll(settleConstraints);
                    continue;
                }
                if (tok.equalsIgnoreCase("DIATOMIC")) {
                    logger.severe(" Diatomic distance constraints not yet implemented properly.");
                    continue;
                }
                if (!tok.equalsIgnoreCase("TRIATOMIC")) continue;
                logger.severe(" Triatomic SETTLE constraints for non-water molecules not yet implemented properly.");
            }
            for (String tok : constraintToks) {
                if (tok.equalsIgnoreCase("BONDS") && this.bondPotentialEnergy != null) {
                    Bond[] bonds = this.bondPotentialEnergy.getBondArray();
                    numericBonds = new HashSet<Bond>(Arrays.asList(bonds));
                    continue;
                }
                if (!tok.equalsIgnoreCase("ANGLES") || this.anglePotentialEnergy == null) continue;
                Angle[] angles = this.anglePotentialEnergy.getAngleArray();
                numericAngles = new HashSet<Angle>(Arrays.asList(angles));
            }
        }
        for (Angle angle : numericAngles) {
            angle.getBondList().forEach(numericBonds::remove);
        }
        List<Angle> ccmaAngles = numericAngles.stream().filter(ang -> !ang.isConstrained()).collect(Collectors.toList());
        List<Bond> ccmaBonds = numericBonds.stream().filter(bond -> !bond.isConstrained()).collect(Collectors.toList());
        CcmaConstraint ccmaConstraint = CcmaConstraint.ccmaFactory(ccmaBonds, ccmaAngles, this.atoms, this.getMass(), 0.01);
        constraints.add(ccmaConstraint);
        logger.info(String.format(" Added %d constraints.", constraints.size()));
        return constraints;
    }

    public static ForceFieldEnergy energyFactory(MolecularAssembly assembly) {
        return ForceFieldEnergy.energyFactory(assembly, ParallelTeam.getDefaultThreadCount());
    }

    public static ForceFieldEnergy energyFactory(MolecularAssembly assembly, int numThreads) {
        Platform platform;
        ForceField forceField = assembly.getForceField();
        String platformString = ForceField.toEnumForm(forceField.getString("PLATFORM", "FFX"));
        try {
            platform = Platform.valueOf(platformString);
        }
        catch (IllegalArgumentException e) {
            logger.warning(String.format(" String %s did not match a known energy implementation", platformString));
            platform = Platform.FFX;
        }
        String dtPlatformString = ForceField.toEnumForm(forceField.getString("PLATFORM_DT", "FFX"));
        try {
            Platform dtPlatform = Platform.valueOf(dtPlatformString);
            if (dtPlatform != Platform.FFX) {
                platform = Platform.FFX;
            }
        }
        catch (IllegalArgumentException dtPlatform) {
            // empty catch block
        }
        switch (platform) {
            case OMM: 
            case OMM_REF: 
            case OMM_CUDA: 
            case OMM_OPENCL: {
                try {
                    return new OpenMMEnergy(assembly, platform, numThreads);
                }
                catch (Exception ex) {
                    logger.warning(String.format(" Exception creating OpenMMEnergy: %s", ex));
                    ForceFieldEnergy ffxEnergy = assembly.getPotentialEnergy();
                    if (ffxEnergy == null) {
                        ffxEnergy = new ForceFieldEnergy(assembly, numThreads);
                        assembly.setPotential(ffxEnergy);
                    }
                    return ffxEnergy;
                }
            }
            case OMM_CPU: {
                logger.warning(String.format(" Platform %s not supported; defaulting to FFX", new Object[]{platform}));
            }
        }
        ForceFieldEnergy ffxEnergy = assembly.getPotentialEnergy();
        if (ffxEnergy == null) {
            ffxEnergy = new ForceFieldEnergy(assembly, numThreads);
            assembly.setPotential(ffxEnergy);
        }
        return ffxEnergy;
    }

    public Atom[] getAtomArray() {
        return this.atoms;
    }

    public void applyAllConstraintPositions(double[] xPrior, double[] xNew) {
        this.applyAllConstraintPositions(xPrior, xNew, 1.0E-4);
    }

    public void applyAllConstraintPositions(double[] xPrior, double[] xNew, double tol) {
        if (xPrior == null) {
            xPrior = Arrays.copyOf(xNew, xNew.length);
        }
        for (Constraint constraint : this.constraints) {
            constraint.applyConstraintToStep(xPrior, xNew, this.getMass(), tol);
        }
    }

    public void attachExtendedSystem(ExtendedSystem system) {
        if (system == null) {
            throw new IllegalArgumentException();
        }
        this.esvTermOrig = this.esvTerm = true;
        this.esvSystem = system;
        if (this.vanderWaalsTerm) {
            if (this.vanderWaals == null) {
                logger.warning("Null VdW during ESV setup.");
            } else {
                this.vanderWaals.attachExtendedSystem(system);
            }
        }
        if (this.multipoleTerm) {
            if (this.particleMeshEwald == null) {
                logger.warning("Null PME during ESV setup.");
            } else {
                this.particleMeshEwald.attachExtendedSystem(system);
            }
        }
    }

    @Override
    public boolean dEdLZeroAtEnds() {
        return !this.lambdaTerm;
    }

    public boolean destroy() {
        if (this.destroyed) {
            logger.fine(String.format(" This ForceFieldEnergy is already destroyed: %s", this));
            return true;
        }
        try {
            if (this.parallelTeam != null) {
                this.parallelTeam.shutdown();
            }
            if (this.vanderWaals != null) {
                this.vanderWaals.destroy();
            }
            if (this.particleMeshEwald != null) {
                this.particleMeshEwald.destroy();
            }
            this.molecularAssembly.finishDestruction();
            this.destroyed = true;
            return true;
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception in shutting down a ForceFieldEnergy: %s", ex));
            logger.info(Utilities.stackTraceToString(ex));
            return false;
        }
    }

    public double energy() {
        return this.energy(false, false);
    }

    public double energy(boolean gradient, boolean print) {
        try {
            this.totalTime = System.nanoTime();
            this.nnTime = 0L;
            this.restrainGroupTime = 0L;
            this.vanDerWaalsTime = 0L;
            this.electrostaticTime = 0L;
            this.ncsTime = 0L;
            double forceFieldBondedEnergy = 0.0;
            this.nnEnergy = 0.0;
            double restrainEnergy = 0.0;
            this.restrainGroupEnergy = 0.0;
            this.ncsEnergy = 0.0;
            double totalNonBondedEnergy = 0.0;
            double totalMultipoleEnergy = 0.0;
            this.vanDerWaalsEnergy = 0.0;
            this.permanentMultipoleEnergy = 0.0;
            this.polarizationEnergy = 0.0;
            this.solvationEnergy = 0.0;
            this.esvBias = 0.0;
            this.totalEnergy = 0.0;
            try {
                this.forceFieldBondedEnergyRegion.setGradient(gradient);
                this.forceFieldBondedEnergyRegion.setLambdaBondedTerms(this.lambdaBondedTerms);
                this.forceFieldBondedEnergyRegion.setLambdaAllBondedTerms(this.lambdaAllBondedTerms);
                this.forceFieldBondedEnergyRegion.setInitAtomGradients(true);
                this.parallelTeam.execute((ParallelRegion)this.forceFieldBondedEnergyRegion);
                forceFieldBondedEnergy = this.forceFieldBondedEnergyRegion.getEnergy();
            }
            catch (RuntimeException ex) {
                logger.warning("Runtime exception during bonded term calculation.");
                throw ex;
            }
            catch (Exception ex) {
                logger.info(Utilities.stackTraceToString(ex));
                logger.severe(ex.toString());
            }
            try {
                if (this.restrainMode == RestrainMode.ENERGY || this.restrainMode == RestrainMode.ALCHEMICAL && this.lambdaBondedTerms) {
                    boolean checkAlchemicalAtoms = this.restrainMode == RestrainMode.ENERGY;
                    this.restrainEnergyRegion.setGradient(gradient);
                    this.restrainEnergyRegion.setLambdaBondedTerms(this.lambdaBondedTerms);
                    this.restrainEnergyRegion.setLambdaAllBondedTerms(this.lambdaAllBondedTerms);
                    this.restrainEnergyRegion.setCheckAlchemicalAtoms(checkAlchemicalAtoms);
                    this.restrainEnergyRegion.setInitAtomGradients(false);
                    this.parallelTeam.execute((ParallelRegion)this.restrainEnergyRegion);
                    restrainEnergy = this.restrainEnergyRegion.getEnergy();
                }
            }
            catch (RuntimeException ex) {
                logger.warning("Runtime exception during restrain term calculation.");
                throw ex;
            }
            catch (Exception ex) {
                logger.info(Utilities.stackTraceToString(ex));
                logger.severe(ex.toString());
            }
            if (!this.lambdaBondedTerms) {
                if (this.ncsTerm) {
                    this.ncsTime = -System.nanoTime();
                    this.ncsEnergy = this.ncsRestraint.residual(gradient, print);
                    this.ncsTime += System.nanoTime();
                }
                if (this.restrainGroupTerm) {
                    this.restrainGroupTime = -System.nanoTime();
                    this.restrainGroupEnergy = this.restrainGroups.energy(gradient);
                    this.restrainGroupTime += System.nanoTime();
                }
                if (this.comTerm) {
                    this.comRestraintTime = -System.nanoTime();
                    this.comRestraintEnergy = this.comRestraint.residual(gradient, print);
                    this.comRestraintTime += System.nanoTime();
                }
                if (this.nnTerm) {
                    this.nnTime = -System.nanoTime();
                    this.nnEnergy = this.aniEnergy.energy(gradient, print);
                    this.nnTime += System.nanoTime();
                }
                if (this.vanderWaalsTerm) {
                    this.vanDerWaalsTime = -System.nanoTime();
                    this.vanDerWaalsEnergy = this.vanderWaals.energy(gradient, print);
                    this.nVanDerWaalInteractions = this.vanderWaals.getInteractions();
                    this.vanDerWaalsTime += System.nanoTime();
                }
                if (this.multipoleTerm) {
                    this.electrostaticTime = -System.nanoTime();
                    totalMultipoleEnergy = this.particleMeshEwald.energy(gradient, print);
                    this.permanentMultipoleEnergy = this.particleMeshEwald.getPermanentEnergy();
                    this.polarizationEnergy = this.particleMeshEwald.getPolarizationEnergy();
                    this.nPermanentInteractions = this.particleMeshEwald.getInteractions();
                    this.solvationEnergy = this.particleMeshEwald.getSolvationEnergy();
                    this.nGKInteractions = this.particleMeshEwald.getGKInteractions();
                    this.electrostaticTime += System.nanoTime();
                }
            }
            this.totalTime = System.nanoTime() - this.totalTime;
            double totalBondedEnergy = forceFieldBondedEnergy + restrainEnergy + this.nnEnergy + this.ncsEnergy + this.comRestraintEnergy + this.restrainGroupEnergy;
            totalNonBondedEnergy = this.vanDerWaalsEnergy + totalMultipoleEnergy;
            this.totalEnergy = totalBondedEnergy + totalNonBondedEnergy + this.solvationEnergy;
            if (this.esvTerm) {
                this.esvBias = this.esvSystem.getBiasEnergy();
                this.totalEnergy += this.esvBias;
            }
            if (print) {
                StringBuilder sb = new StringBuilder();
                if (gradient) {
                    sb.append("\n Computed Potential Energy and Atomic Coordinate Gradients\n");
                } else {
                    sb.append("\n Computed Potential Energy\n");
                }
                sb.append(this);
                logger.info(sb.toString());
            }
            return this.totalEnergy;
        }
        catch (EnergyException ex) {
            if (this.printOnFailure) {
                this.printFailure();
            }
            if (ex.doCauseSevere()) {
                logger.info(Utilities.stackTraceToString(ex));
                logger.log(Level.SEVERE, " Error in calculating energies or gradients", ex);
            } else {
                logger.log(Level.INFO, String.format(" Exception in energy calculation:\n %s", ex));
            }
            throw ex;
        }
    }

    public double energy(double[] x) {
        return this.energy(x, false);
    }

    public double energy(double[] x, boolean verbose) {
        assert (Arrays.stream(x).allMatch(Double::isFinite));
        this.unscaleCoordinates(x);
        this.setCoordinates(x);
        double e = this.energy(false, verbose);
        this.scaleCoordinates(x);
        return e;
    }

    public double energyAndGradient(double[] x, double[] g) {
        return this.energyAndGradient(x, g, false);
    }

    public double energyAndGradient(double[] x, double[] g, boolean verbose) {
        this.unscaleCoordinates(x);
        this.setCoordinates(x);
        double e = this.energy(true, verbose);
        try {
            boolean extremeGrad;
            this.fillGradient(g);
            this.scaleCoordinatesAndGradient(x, g);
            if (this.maxDebugGradient < Double.MAX_VALUE && (extremeGrad = Arrays.stream(g).anyMatch(gi -> gi > this.maxDebugGradient || gi < -this.maxDebugGradient))) {
                File origFile = this.molecularAssembly.getFile();
                String timeString = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss"));
                String filename = String.format("%s-LARGEGRAD-%s.pdb", FilenameUtils.removeExtension((String)this.molecularAssembly.getFile().getName()), timeString);
                PotentialsUtils ef = new PotentialsUtils();
                filename = ef.versionFile(filename);
                logger.warning(String.format(" Excessively large gradient detected; printing snapshot to file %s", filename));
                ef.saveAsPDB(this.molecularAssembly, new File(filename));
                this.molecularAssembly.setFile(origFile);
            }
            return e;
        }
        catch (EnergyException ex) {
            if (this.printOnFailure) {
                this.printFailure();
            }
            if (ex.doCauseSevere()) {
                logger.info(Utilities.stackTraceToString(ex));
                logger.log(Level.SEVERE, " Error in calculating energies or gradients", ex);
            } else {
                logger.log(Level.INFO, String.format(" Exception in energy calculation:\n %s", ex));
            }
            throw ex;
        }
    }

    private void printFailure() {
        String timeString = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss"));
        File file = this.molecularAssembly.getFile();
        String ext = "pdb";
        if (XYZFileFilter.isXYZ(file)) {
            ext = "xyz";
        }
        String filename = String.format("%s-ERROR-%s.%s", FilenameUtils.removeExtension((String)file.getName()), timeString, ext);
        PotentialsUtils ef = new PotentialsUtils();
        filename = ef.versionFile(filename);
        logger.info(String.format(" Writing on-error snapshot to file %s", filename));
        ef.save(this.molecularAssembly, new File(filename));
    }

    public double[] getAcceleration(double[] acceleration) {
        int n = this.getNumberOfVariables();
        if (acceleration == null || acceleration.length < n) {
            acceleration = new double[n];
        }
        int index = 0;
        double[] a = new double[3];
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            this.atoms[i].getAcceleration(a);
            acceleration[index++] = a[0];
            acceleration[index++] = a[1];
            acceleration[index++] = a[2];
        }
        return acceleration;
    }

    public Angle[] getAngles(AngleType.AngleMode angleMode) {
        if (this.anglePotentialEnergy == null) {
            return null;
        }
        Angle[] angles = this.anglePotentialEnergy.getAngleArray();
        int nAngles = angles.length;
        ArrayList<Angle> angleList = new ArrayList<Angle>();
        for (int i = 0; i < nAngles; ++i) {
            if (angles[i].getAngleMode() != angleMode) continue;
            angleList.add(angles[i]);
        }
        nAngles = angleList.size();
        if (nAngles < 1) {
            return null;
        }
        return angleList.toArray(new Angle[0]);
    }

    public List<Constraint> getConstraints() {
        return this.constraints.isEmpty() ? Collections.emptyList() : new ArrayList<Constraint>(this.constraints);
    }

    public double[] getCoordinates(double[] x) {
        int n = this.getNumberOfVariables();
        if (x == null || x.length < n) {
            x = new double[n];
        }
        int index = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom a = this.atoms[i];
            if (!a.isActive()) continue;
            x[index++] = a.getX();
            x[index++] = a.getY();
            x[index++] = a.getZ();
        }
        return x;
    }

    public Crystal getCrystal() {
        return this.crystal;
    }

    public void setCrystal(Crystal crystal) {
        this.setCrystal(crystal, false);
    }

    public double getCutoffPlusBuffer() {
        return this.cutoffPlusBuffer;
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
        if (this.forceFieldBondedEnergyRegion != null) {
            this.forceFieldBondedEnergyRegion.setState(state);
        }
        if (this.restrainEnergyRegion != null) {
            this.restrainEnergyRegion.setState(state);
        }
        switch (state) {
            case FAST: {
                this.nnTerm = this.nnTermOrig;
                this.restrainGroupTerm = this.restrainGroupTermOrig;
                this.ncsTerm = this.ncsTermOrig;
                this.comTerm = this.comTermOrig;
                this.vanderWaalsTerm = false;
                this.multipoleTerm = false;
                this.polarizationTerm = false;
                this.generalizedKirkwoodTerm = false;
                this.esvTerm = false;
                break;
            }
            case SLOW: {
                this.vanderWaalsTerm = this.vanderWaalsTermOrig;
                this.multipoleTerm = this.multipoleTermOrig;
                this.polarizationTerm = this.polarizationTermOrig;
                this.generalizedKirkwoodTerm = this.generalizedKirkwoodTermOrig;
                this.esvTerm = this.esvTermOrig;
                this.nnTerm = false;
                this.restrainGroupTerm = false;
                this.ncsTerm = false;
                this.comTerm = false;
                break;
            }
            default: {
                this.nnTerm = this.nnTermOrig;
                this.restrainGroupTerm = this.restrainGroupTermOrig;
                this.ncsTerm = this.ncsTermOrig;
                this.comTermOrig = this.comTerm;
                this.vanderWaalsTerm = this.vanderWaalsTermOrig;
                this.multipoleTerm = this.multipoleTermOrig;
                this.polarizationTerm = this.polarizationTermOrig;
                this.generalizedKirkwoodTerm = this.generalizedKirkwoodTermOrig;
            }
        }
    }

    public double getEsvBiasEnergy() {
        return this.esvBias;
    }

    public ExtendedSystem getExtendedSystem() {
        return this.esvSystem;
    }

    public GeneralizedKirkwood getGK() {
        if (this.particleMeshEwald != null) {
            return this.particleMeshEwald.getGK();
        }
        return null;
    }

    public double[] getGradient(double[] g) {
        return this.fillGradient(g);
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.lambdaTerm) {
            if (lambda <= 1.0 && lambda >= 0.0) {
                this.lambda = lambda;
                if (this.vanderWaalsTerm) {
                    this.vanderWaals.setLambda(lambda);
                }
                if (this.multipoleTerm) {
                    this.particleMeshEwald.setLambda(lambda);
                }
                if (this.restrainDistanceTerm && this.restrainDistancePotentialEnergy != null) {
                    for (RestrainDistance restrainDistance : this.restrainDistancePotentialEnergy.getRestrainDistances()) {
                        restrainDistance.setLambda(lambda);
                    }
                }
                if (this.restrainTorsionTerm && this.restrainTorsionPotentialEnergy != null) {
                    for (Torsion restrainTorsion : this.restrainTorsionPotentialEnergy.getRestrainTorsions()) {
                        restrainTorsion.setLambda(lambda);
                    }
                }
                if (this.ncsTerm && this.ncsRestraint != null) {
                    this.ncsRestraint.setLambda(lambda);
                }
                if (this.comTerm && this.comRestraint != null) {
                    this.comRestraint.setLambda(lambda);
                }
                if (this.lambdaTorsions) {
                    if (this.torsionPotentialEnergy != null) {
                        this.torsionPotentialEnergy.setLambda(lambda);
                    }
                    if (this.piOrbitalTorsionPotentialEnergy != null) {
                        this.piOrbitalTorsionPotentialEnergy.setLambda(lambda);
                    }
                    if (this.torsionTorsionPotentialEnergy != null) {
                        this.torsionTorsionPotentialEnergy.setLambda(lambda);
                    }
                }
            } else {
                String message = String.format("Lambda value %8.3f is not in the range [0..1].", lambda);
                logger.warning(message);
            }
        } else {
            logger.fine(" Attempting to set a lambda value on a ForceFieldEnergy with lambdaterm false.");
        }
    }

    public double[] getMass() {
        int n = this.getNumberOfVariables();
        double[] mass = new double[n];
        int index = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom a = this.atoms[i];
            if (!a.isActive()) continue;
            double m = a.getMass();
            mass[index++] = m;
            mass[index++] = m;
            mass[index++] = m;
        }
        return mass;
    }

    public int getNumberOfVariables() {
        int nActive = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            ++nActive;
        }
        return nActive * 3;
    }

    public String getPDBHeaderString() {
        this.energy(false, false);
        StringBuilder sb = new StringBuilder();
        sb.append("REMARK   3  CALCULATED POTENTIAL ENERGY\n");
        sb.append(this.forceFieldBondedEnergyRegion.toPDBString());
        sb.append(this.restrainEnergyRegion.toPDBString());
        if (this.nnTerm) {
            sb.append(String.format("REMARK   3   %s %g (%d)\n", "NEUTRAL NETWORK            : ", this.nnEnergy, this.nAtoms));
        }
        if (this.ncsTerm) {
            sb.append(String.format("REMARK   3   %s %g (%d)\n", "NCS RESTRAINT              : ", this.ncsEnergy, this.nAtoms));
        }
        if (this.comTerm) {
            sb.append(String.format("REMARK   3   %s %g (%d)\n", "COM RESTRAINT              : ", this.comRestraintEnergy, this.nAtoms));
        }
        if (this.vanderWaalsTerm) {
            sb.append(String.format("REMARK   3   %s %g (%d)\n", "VAN DER WAALS              : ", this.vanDerWaalsEnergy, this.nVanDerWaalInteractions));
        }
        if (this.multipoleTerm) {
            sb.append(String.format("REMARK   3   %s %g (%d)\n", "ATOMIC MULTIPOLES          : ", this.permanentMultipoleEnergy, this.nPermanentInteractions));
        }
        if (this.polarizationTerm) {
            sb.append(String.format("REMARK   3   %s %g (%d)\n", "POLARIZATION               : ", this.polarizationEnergy, this.nPermanentInteractions));
        }
        sb.append(String.format("REMARK   3   %s %g\n", "TOTAL POTENTIAL (KCAL/MOL) : ", this.totalEnergy));
        int nsymm = this.crystal.getUnitCell().spaceGroup.getNumberOfSymOps();
        if (nsymm > 1) {
            sb.append(String.format("REMARK   3   %s %g\n", "UNIT CELL POTENTIAL        : ", this.totalEnergy * (double)nsymm));
        }
        if (this.crystal.getUnitCell() != this.crystal && (nsymm = this.crystal.spaceGroup.getNumberOfSymOps()) > 1) {
            sb.append(String.format("REMARK   3   %s %g\n", "REPLICATES CELL POTENTIAL  : ", this.totalEnergy * (double)nsymm));
        }
        sb.append("REMARK   3\n");
        return sb.toString();
    }

    public ParallelTeam getParallelTeam() {
        return this.parallelTeam;
    }

    public int getPermanentInteractions() {
        return this.nPermanentInteractions;
    }

    public double getPermanentMultipoleEnergy() {
        return this.permanentMultipoleEnergy;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public ParticleMeshEwald getPmeNode() {
        return this.particleMeshEwald;
    }

    public double getPolarizationEnergy() {
        return this.polarizationEnergy;
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        int n = this.getNumberOfVariables();
        if (previousAcceleration == null || previousAcceleration.length < n) {
            previousAcceleration = new double[n];
        }
        int index = 0;
        double[] a = new double[3];
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            this.atoms[i].getPreviousAcceleration(a);
            previousAcceleration[index++] = a[0];
            previousAcceleration[index++] = a[1];
            previousAcceleration[index++] = a[2];
        }
        return previousAcceleration;
    }

    public double[] getScaling() {
        return this.optimizationScaling;
    }

    public void setScaling(double[] scaling) {
        this.optimizationScaling = scaling;
    }

    public double getSolvationEnergy() {
        return this.solvationEnergy;
    }

    public int getSolvationInteractions() {
        return this.nGKInteractions;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double getVanDerWaalsEnergy() {
        return this.vanDerWaalsEnergy;
    }

    public int getVanDerWaalsInteractions() {
        return this.nVanDerWaalInteractions;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        int n = this.getNumberOfVariables();
        Potential.VARIABLE_TYPE[] type = new Potential.VARIABLE_TYPE[n];
        int i = 0;
        for (int j = 0; j < this.nAtoms; ++j) {
            if (!this.atoms[j].isActive()) continue;
            type[i++] = Potential.VARIABLE_TYPE.X;
            type[i++] = Potential.VARIABLE_TYPE.Y;
            type[i++] = Potential.VARIABLE_TYPE.Z;
        }
        return type;
    }

    public VanDerWaals getVdwNode() {
        return this.vanderWaals;
    }

    public double[] getVelocity(double[] velocity) {
        int n = this.getNumberOfVariables();
        if (velocity == null || velocity.length < n) {
            velocity = new double[n];
        }
        int index = 0;
        double[] v = new double[3];
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom a = this.atoms[i];
            if (!a.isActive()) continue;
            a.getVelocity(v);
            velocity[index++] = v[0];
            velocity[index++] = v[1];
            velocity[index++] = v[2];
        }
        return velocity;
    }

    @Override
    public double getd2EdL2() {
        double d2EdLambda2 = 0.0;
        if (!this.lambdaBondedTerms) {
            if (this.vanderWaalsTerm) {
                d2EdLambda2 = this.vanderWaals.getd2EdL2();
            }
            if (this.multipoleTerm) {
                d2EdLambda2 += this.particleMeshEwald.getd2EdL2();
            }
            if (this.restrainDistanceTerm && this.restrainDistancePotentialEnergy != null) {
                for (RestrainDistance restrainDistance : this.restrainDistancePotentialEnergy.getRestrainDistanceArray()) {
                    d2EdLambda2 += restrainDistance.getd2EdL2();
                }
            }
            if (this.ncsTerm && this.ncsRestraint != null) {
                d2EdLambda2 += this.ncsRestraint.getd2EdL2();
            }
            if (this.comTerm && this.comRestraint != null) {
                d2EdLambda2 += this.comRestraint.getd2EdL2();
            }
            if (this.lambdaTorsions) {
                if (this.torsionPotentialEnergy != null) {
                    d2EdLambda2 += this.torsionPotentialEnergy.getd2EdL2();
                }
                if (this.piOrbitalTorsionPotentialEnergy != null) {
                    d2EdLambda2 += this.piOrbitalTorsionPotentialEnergy.getd2EdL2();
                }
                if (this.torsionTorsionPotentialEnergy != null) {
                    d2EdLambda2 += this.torsionTorsionPotentialEnergy.getd2EdL2();
                }
            }
        }
        return d2EdLambda2;
    }

    @Override
    public double getdEdL() {
        double dEdLambda = 0.0;
        if (!this.lambdaBondedTerms) {
            if (this.vanderWaalsTerm) {
                dEdLambda = this.vanderWaals.getdEdL();
            }
            if (this.multipoleTerm) {
                dEdLambda += this.particleMeshEwald.getdEdL();
            }
            if (this.restrainDistanceTerm && this.restrainDistancePotentialEnergy != null) {
                for (RestrainDistance restrainDistance : this.restrainDistancePotentialEnergy.getRestrainDistanceArray()) {
                    dEdLambda += restrainDistance.getdEdL();
                }
            }
            if (this.ncsTerm && this.ncsRestraint != null) {
                dEdLambda += this.ncsRestraint.getdEdL();
            }
            if (this.comTerm && this.comRestraint != null) {
                dEdLambda += this.comRestraint.getdEdL();
            }
            if (this.lambdaTorsions) {
                if (this.torsionPotentialEnergy != null) {
                    dEdLambda += this.torsionPotentialEnergy.getdEdL();
                }
                if (this.piOrbitalTorsionPotentialEnergy != null) {
                    dEdLambda += this.piOrbitalTorsionPotentialEnergy.getdEdL();
                }
                if (this.torsionTorsionPotentialEnergy != null) {
                    dEdLambda += this.torsionTorsionPotentialEnergy.getdEdL();
                }
            }
        }
        return dEdLambda;
    }

    @Override
    public void getdEdXdL(double[] gradients) {
        if (!this.lambdaBondedTerms) {
            if (this.vanderWaalsTerm) {
                this.vanderWaals.getdEdXdL(gradients);
            }
            if (this.multipoleTerm) {
                this.particleMeshEwald.getdEdXdL(gradients);
            }
            if (this.restrainDistanceTerm && this.restrainDistancePotentialEnergy != null) {
                for (RestrainDistance restrainDistance : this.restrainDistancePotentialEnergy.getRestrainDistanceArray()) {
                    restrainDistance.getdEdXdL(gradients);
                }
            }
            if (this.ncsTerm && this.ncsRestraint != null) {
                this.ncsRestraint.getdEdXdL(gradients);
            }
            if (this.comTerm && this.comRestraint != null) {
                this.comRestraint.getdEdXdL(gradients);
            }
            if (this.lambdaTorsions) {
                double[] grad = new double[3];
                int index = 0;
                for (int i = 0; i < this.nAtoms; ++i) {
                    Atom a = this.atoms[i];
                    if (!a.isActive()) continue;
                    a.getLambdaXYZGradient(grad);
                    int n = index++;
                    gradients[n] = gradients[n] + grad[0];
                    int n2 = index++;
                    gradients[n2] = gradients[n2] + grad[1];
                    int n3 = index++;
                    gradients[n3] = gradients[n3] + grad[2];
                }
            }
        }
    }

    public void setAcceleration(double[] acceleration) {
        if (acceleration == null) {
            return;
        }
        int index = 0;
        double[] accel = new double[3];
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            accel[0] = acceleration[index++];
            accel[1] = acceleration[index++];
            accel[2] = acceleration[index++];
            this.atoms[i].setAcceleration(accel);
        }
    }

    public void setCoordinates(@Nullable double[] coords) {
        if (coords == null) {
            return;
        }
        int index = 0;
        for (Atom a : this.atoms) {
            if (!a.isActive()) continue;
            double x = coords[index++];
            double y = coords[index++];
            double z = coords[index++];
            a.moveTo(x, y, z);
        }
    }

    public void setCrystal(Crystal crystal, boolean checkReplicatesCell) {
        this.crystal = checkReplicatesCell ? ReplicatesCrystal.replicatesCrystalFactory((Crystal)crystal.getUnitCell(), (double)this.cutOff2) : crystal;
        if (this.vanderWaalsTerm) {
            this.vanderWaals.setCrystal(this.crystal);
        }
        if (this.multipoleTerm) {
            this.particleMeshEwald.setCrystal(this.crystal);
        }
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        if (previousAcceleration == null) {
            return;
        }
        int index = 0;
        double[] prev = new double[3];
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            prev[0] = previousAcceleration[index++];
            prev[1] = previousAcceleration[index++];
            prev[2] = previousAcceleration[index++];
            this.atoms[i].setPreviousAcceleration(prev);
        }
    }

    public void setPrintOnFailure(boolean onFail, boolean override) {
        if (override) {
            this.printOnFailure = onFail;
        } else {
            try {
                this.molecularAssembly.getForceField().getBoolean("PRINT_ON_FAILURE");
            }
            catch (Exception ex) {
                this.printOnFailure = onFail;
            }
        }
    }

    public void setVelocity(double[] velocity) {
        if (velocity == null) {
            return;
        }
        int index = 0;
        double[] vel = new double[3];
        for (Atom a : this.atoms) {
            if (a.isActive()) {
                vel[0] = velocity[index++];
                vel[1] = velocity[index++];
                vel[2] = velocity[index++];
            } else {
                vel[0] = 0.0;
                vel[1] = 0.0;
                vel[2] = 0.0;
            }
            a.setVelocity(vel);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.forceFieldBondedEnergyRegion.toString());
        sb.append(this.restrainEnergyRegion.toString());
        if (this.restrainGroupTerm && this.nRestrainGroups > 0) {
            sb.append(String.format("  %s %20.8f %12d %12.3f\n", "Restrain Groups   ", this.restrainGroupEnergy, this.nRestrainGroups, (double)this.restrainGroupTime * 1.0E-9));
        }
        if (this.ncsTerm) {
            sb.append(String.format("  %s %20.8f %12d %12.3f\n", "NCS Restraint     ", this.ncsEnergy, this.nAtoms, (double)this.ncsTime * 1.0E-9));
        }
        if (this.comTerm) {
            sb.append(String.format("  %s %20.8f %12d %12.3f\n", "COM Restraint     ", this.comRestraintEnergy, this.nAtoms, (double)this.comRestraintTime * 1.0E-9));
        }
        if (this.vanderWaalsTerm && this.nVanDerWaalInteractions > 0) {
            sb.append(String.format("  %s %20.8f %12d %12.3f\n", "Van der Waals     ", this.vanDerWaalsEnergy, this.nVanDerWaalInteractions, (double)this.vanDerWaalsTime * 1.0E-9));
        }
        if (this.multipoleTerm && this.nPermanentInteractions > 0) {
            if (this.polarizationTerm) {
                sb.append(String.format("  %s %20.8f %12d\n", "Atomic Multipoles ", this.permanentMultipoleEnergy, this.nPermanentInteractions));
            } else if (this.elecForm == ForceField.ELEC_FORM.FIXED_CHARGE) {
                sb.append(String.format("  %s %20.8f %12d %12.3f\n", "Atomic Charges    ", this.permanentMultipoleEnergy, this.nPermanentInteractions, (double)this.electrostaticTime * 1.0E-9));
            } else {
                sb.append(String.format("  %s %20.8f %12d %12.3f\n", "Atomic Multipoles ", this.permanentMultipoleEnergy, this.nPermanentInteractions, (double)this.electrostaticTime * 1.0E-9));
            }
        }
        if (this.polarizationTerm && this.nPermanentInteractions > 0) {
            sb.append(String.format("  %s %20.8f %12d %12.3f\n", "Polarization      ", this.polarizationEnergy, this.nPermanentInteractions, (double)this.electrostaticTime * 1.0E-9));
        }
        if (this.generalizedKirkwoodTerm && this.nGKInteractions > 0) {
            sb.append(String.format("  %s %20.8f %12d\n", "Solvation         ", this.solvationEnergy, this.nGKInteractions));
        }
        if (this.esvTerm) {
            sb.append(String.format("  %s %20.8f  %s\n", "ExtendedSystemBias", this.esvBias, this.esvSystem.getLambdaList()));
            sb.append(this.esvSystem.getBiasDecomposition());
        }
        if (this.nnTerm) {
            sb.append(String.format("  %s %20.8f %12d %12.3f\n", "Neural Network    ", this.nnEnergy, this.nAtoms, (double)this.nnTime * 1.0E-9));
        }
        sb.append(String.format("  %s %20.8f  %s %12.3f (sec)", "Total Potential   ", this.totalEnergy, "(Kcal/mole)", (double)this.totalTime * 1.0E-9));
        int nsymm = this.crystal.getUnitCell().spaceGroup.getNumberOfSymOps();
        if (nsymm > 1) {
            sb.append(String.format("\n  %s %20.8f", "Unit Cell         ", this.totalEnergy * (double)nsymm));
        }
        if (this.crystal.getUnitCell() != this.crystal) {
            nsymm = this.crystal.spaceGroup.getNumberOfSymOps();
            sb.append(String.format("\n  %s %20.8f", "Replicates Cell   ", this.totalEnergy * (double)nsymm));
        }
        return sb.toString();
    }

    public void logBondedTermsAndRestraints() {
        if (this.forceFieldBondedEnergyRegion != null) {
            this.forceFieldBondedEnergyRegion.log();
        }
        if (this.restrainEnergyRegion != null) {
            this.restrainEnergyRegion.log();
        }
        if (this.restrainGroupTerm && this.nRestrainGroups > 0) {
            logger.info("\n Restrain Group Interactions:");
            logger.info(this.restrainGroups.toString());
        }
    }

    void setLambdaBondedTerms(boolean lambdaBondedTerms, boolean lambdaAllBondedTerms) {
        this.lambdaBondedTerms = lambdaBondedTerms;
        this.lambdaAllBondedTerms = lambdaAllBondedTerms;
    }

    private double[] fillGradient(double[] g) {
        assert (g != null);
        double[] grad = new double[3];
        int n = this.getNumberOfVariables();
        if (g == null || g.length < n) {
            g = new double[n];
        }
        int index = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom a = this.atoms[i];
            if (!a.isActive()) continue;
            a.getXYZGradient(grad);
            double gx = grad[0];
            double gy = grad[1];
            double gz = grad[2];
            if (Double.isNaN(gx) || Double.isInfinite(gx) || Double.isNaN(gy) || Double.isInfinite(gy) || Double.isNaN(gz) || Double.isInfinite(gz)) {
                StringBuilder sb = new StringBuilder(String.format("The gradient of atom %s is (%8.3f,%8.3f,%8.3f).", a, gx, gy, gz));
                double[] vals = new double[3];
                a.getVelocity(vals);
                sb.append(String.format("\n Velocities: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                a.getAcceleration(vals);
                sb.append(String.format("\n Accelerations: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                a.getPreviousAcceleration(vals);
                sb.append(String.format("\n Previous accelerations: %8.3g %8.3g %8.3g", vals[0], vals[1], vals[2]));
                throw new EnergyException(sb.toString());
            }
            g[index++] = gx;
            g[index++] = gy;
            g[index++] = gz;
        }
        return g;
    }

    private Crystal configureNCS(ForceField forceField, Crystal unitCell) {
        if (forceField.getProperties().containsKey("MTRIX1") && forceField.getProperties().containsKey("MTRIX2") && forceField.getProperties().containsKey("MTRIX3")) {
            Crystal unitCell2 = new Crystal(unitCell.a, unitCell.b, unitCell.c, unitCell.alpha, unitCell.beta, unitCell.gamma, unitCell.spaceGroup.pdbName);
            SpaceGroup spaceGroup = unitCell2.spaceGroup;
            CompositeConfiguration properties = forceField.getProperties();
            String[] MTRX1List = properties.getStringArray("MTRIX1");
            String[] MTRX2List = properties.getStringArray("MTRIX2");
            String[] MTRX3List = properties.getStringArray("MTRIX3");
            spaceGroup.symOps.clear();
            for (int i = 0; i < MTRX1List.length; ++i) {
                double[][] Rot_MTRX = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
                double[] Tr_MTRX = new double[]{0.0, 0.0, 0.0};
                String[] tokens1 = MTRX1List[i].trim().split(" +");
                String[] tokens2 = MTRX2List[i].trim().split(" +");
                String[] tokens3 = MTRX3List[i].trim().split(" +");
                for (int k = 0; k < 4; ++k) {
                    double number1 = Double.parseDouble(tokens1[k]);
                    double number2 = Double.parseDouble(tokens2[k]);
                    double number3 = Double.parseDouble(tokens3[k]);
                    if (k != 3) {
                        Rot_MTRX[0][k] = number1;
                        Rot_MTRX[1][k] = number2;
                        Rot_MTRX[2][k] = number3;
                        continue;
                    }
                    Tr_MTRX[0] = number1;
                    Tr_MTRX[1] = number2;
                    Tr_MTRX[2] = number3;
                }
                SymOp symOp = new SymOp((double[][])Rot_MTRX, Tr_MTRX);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.info(String.format(" MTRIXn SymOp: %d of %d\n" + String.valueOf(symOp), i + 1, MTRX1List.length));
                }
                spaceGroup.symOps.add(symOp);
            }
            unitCell = NCSCrystal.NCSCrystalFactory((Crystal)unitCell, (List)spaceGroup.symOps);
            unitCell.updateCrystal();
        }
        return unitCell;
    }

    public RestrainMode getRestrainMode() {
        return this.restrainMode;
    }

    public RestrainGroups getRestrainGroups() {
        return this.restrainGroups;
    }

    public TorsionTorsionPotentialEnergy getTorsionTorsionPotentialEnergy() {
        return this.torsionTorsionPotentialEnergy;
    }

    public AnglePotentialEnergy getAnglePotentialEnergy() {
        return this.anglePotentialEnergy;
    }

    public BondPotentialEnergy getBondPotentialEnergy() {
        return this.bondPotentialEnergy;
    }

    public StretchBendPotentialEnergy getStretchBendPotentialEnergy() {
        return this.stretchBendPotentialEnergy;
    }

    public UreyBradleyPotentialEnergy getUreyBradleyPotentialEnergy() {
        return this.ureyBradleyPotentialEnergy;
    }

    public OutOfPlaneBendPotentialEnergy getOutOfPlaneBendPotentialEnergy() {
        return this.outOfPlaneBendPotentialEnergy;
    }

    public TorsionPotentialEnergy getTorsionPotentialEnergy() {
        return this.torsionPotentialEnergy;
    }

    public StretchTorsionPotentialEnergy getStretchTorsionPotentialEnergy() {
        return this.stretchTorsionPotentialEnergy;
    }

    public AngleTorsionPotentialEnergy getAngleTorsionPotentialEnergy() {
        return this.angleTorsionPotentialEnergy;
    }

    public ImproperTorsionPotentialEnergy getImproperTorsionPotentialEnergy() {
        return this.improperTorsionPotentialEnergy;
    }

    public PiOrbitalTorsionPotentialEnergy getPiOrbitalTorsionPotentialEnergy() {
        return this.piOrbitalTorsionPotentialEnergy;
    }

    public RestrainPositionPotentialEnergy getRestrainPositionPotentialEnergy() {
        return this.restrainPositionPotentialEnergy;
    }

    public RestrainDistancePotentialEnergy getRestrainDistancePotentialEnergy() {
        return this.restrainDistancePotentialEnergy;
    }

    public RestrainTorsionPotentialEnergy getRestrainTorsionPotentialEnergy() {
        return this.restrainTorsionPotentialEnergy;
    }

    public static enum RestrainMode {
        ENERGY,
        ALCHEMICAL;

    }
}

