/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.crystal.SymOp;
import ffx.numerics.Potential;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.Platform;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ForceField;
import ffx.potential.utils.EnergyException;
import ffx.potential.utils.Superpose;
import ffx.utilities.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

public class DualTopologyEnergy
implements CrystalPotential,
LambdaInterface {
    private static final Logger logger = Logger.getLogger(DualTopologyEnergy.class.getName());
    private final int nShared;
    private final int nVariables;
    private final EnergyRegion energyRegion;
    private final double[] mass;
    private final Potential.VARIABLE_TYPE[] variableTypes;
    private final double[] x1;
    private final double[] x2;
    private final double[] g1;
    private final double[] g2;
    private final double[] rg1;
    private final double[] rg2;
    private final double[] gl1;
    private final double[] gl2;
    private final double[] rgl1;
    private final double[] rgl2;
    private final CrystalPotential potential1;
    private final CrystalPotential potential2;
    private final LambdaInterface lambdaInterface1;
    private final LambdaInterface lambdaInterface2;
    private final ForceFieldEnergy forceFieldEnergy1;
    private final ForceFieldEnergy forceFieldEnergy2;
    private final int nActive1;
    private final int nActive2;
    private final Atom[] activeAtoms1;
    private final Atom[] activeAtoms2;
    private final boolean[] sharedAtoms1;
    private final boolean[] sharedAtoms2;
    private final int[] system1AtomIndex;
    private final int[] system2AtomIndex;
    private final Atom[] dualTopologyAtoms;
    private final Atom[] dualTopologyAtoms2;
    private final UnivariateSwitchingFunction switchFunction;
    private double energy1 = 0.0;
    private double energy2 = 0.0;
    private ParallelTeam parallelTeam;
    private final boolean doValenceRestraint1;
    private final boolean doValenceRestraint2;
    private final boolean useFirstSystemBondedEnergy;
    private double restraintEnergy1 = 0.0;
    private double restraintEnergy2 = 0.0;
    private double dEdL_1 = 0.0;
    private double dEdL_2 = 0.0;
    private double restraintdEdL_1 = 0.0;
    private double restraintdEdL_2 = 0.0;
    private double d2EdL2_1 = 0.0;
    private double d2EdL2_2 = 0.0;
    private double restraintd2EdL2_1 = 0.0;
    private double restraintd2EdL2_2 = 0.0;
    private double totalEnergy = 0.0;
    private double lambda = 1.0;
    private double f1L = 1.0;
    private double f2L = 0.0;
    private double dF1dL = 0.0;
    private double dF2dL = 0.0;
    private double d2F1dL2 = 0.0;
    private double d2F2dL2 = 0.0;
    private double[] scaling = null;
    private Potential.STATE state = Potential.STATE.BOTH;
    private SymOp[] symOp;
    private SymOp[] inverse;
    private final ArrayList<List<Integer>> symOpAtoms = new ArrayList();
    private boolean[][] mask = null;
    private boolean useSymOp = false;

    /*
     * WARNING - void declaration
     */
    public DualTopologyEnergy(MolecularAssembly topology1, MolecularAssembly topology2, UnivariateSwitchingFunction switchFunction) {
        double m;
        Atom a;
        int i;
        this.forceFieldEnergy1 = topology1.getPotentialEnergy();
        this.forceFieldEnergy2 = topology2.getPotentialEnergy();
        this.potential1 = this.forceFieldEnergy1;
        this.potential2 = this.forceFieldEnergy2;
        this.lambdaInterface1 = this.forceFieldEnergy1;
        this.lambdaInterface2 = this.forceFieldEnergy2;
        Atom[] atoms1 = topology1.getAtomArray();
        Atom[] atoms2 = topology2.getAtomArray();
        ForceField forceField1 = topology1.getForceField();
        this.doValenceRestraint1 = forceField1.getBoolean("LAMBDA_VALENCE_RESTRAINTS", true);
        ForceField forceField2 = topology2.getForceField();
        this.doValenceRestraint2 = forceField2.getBoolean("LAMBDA_VALENCE_RESTRAINTS", true);
        this.useFirstSystemBondedEnergy = forceField2.getBoolean("USE_FIRST_SYSTEM_BONDED_ENERGY", false);
        int shared1 = 0;
        int shared2 = 0;
        int activeCount1 = 0;
        int activeCount2 = 0;
        for (Atom a1 : atoms1) {
            if (!a1.isActive()) continue;
            ++activeCount1;
            if (a1.applyLambda()) continue;
            ++shared1;
        }
        for (Atom a2 : atoms2) {
            if (!a2.isActive()) continue;
            ++activeCount2;
            if (a2.applyLambda()) continue;
            ++shared2;
        }
        if (shared1 != shared2) {
            logger.severe(" Shared active atoms are not equal between topologies:\n Topology 1 has " + shared1 + " shared atoms.\n Topology 2 has " + shared2 + " shared atoms.\n Please check the input files or force field parameters.");
        }
        assert (shared1 == shared2);
        this.nActive1 = activeCount1;
        this.nActive2 = activeCount2;
        this.activeAtoms1 = new Atom[this.nActive1];
        this.activeAtoms2 = new Atom[this.nActive2];
        this.sharedAtoms1 = new boolean[this.nActive1];
        this.sharedAtoms2 = new boolean[this.nActive2];
        Arrays.fill(this.sharedAtoms1, true);
        Arrays.fill(this.sharedAtoms2, true);
        int nAlchemical1 = 0;
        int nShared1 = 0;
        int nAlchemical2 = 0;
        int nShared2 = 0;
        for (Atom atom : atoms1) {
            if (atom.applyLambda()) {
                ++nAlchemical1;
                continue;
            }
            ++nShared1;
        }
        for (Atom atom : atoms2) {
            if (atom.applyLambda()) {
                ++nAlchemical2;
                continue;
            }
            ++nShared2;
        }
        if (nShared1 != nShared2) {
            logger.severe(" Shared atoms are not equal between topologies:\n Topology 1 has " + nShared1 + " shared atoms.\n Topology 2 has " + nShared2 + " shared atoms.\n Please check the input files or force field parameters.");
        }
        this.dualTopologyAtoms = new Atom[nShared1 + nAlchemical1 + nAlchemical2];
        this.dualTopologyAtoms2 = new Atom[nShared1 + nAlchemical1 + nAlchemical2];
        int indexShared = 0;
        int indexAlchemical = nShared1;
        int index1 = 0;
        this.system1AtomIndex = new int[atoms1.length];
        for (Atom a3 : atoms1) {
            a3.setTopologyIndex(0);
            if (a3.applyLambda()) {
                this.system1AtomIndex[index1] = indexAlchemical;
                a3.setTopologyAtomIndex(indexAlchemical);
                this.dualTopologyAtoms[indexAlchemical] = a3;
                this.dualTopologyAtoms2[indexAlchemical] = a3;
                ++indexAlchemical;
            } else {
                this.system1AtomIndex[index1] = indexShared;
                a3.setTopologyAtomIndex(indexShared);
                this.dualTopologyAtoms[indexShared] = a3;
                ++indexShared;
            }
            ++index1;
        }
        indexShared = 0;
        boolean bl = false;
        this.system2AtomIndex = new int[atoms2.length];
        for (Atom a4 : atoms2) {
            void var19_27;
            a4.setTopologyIndex(1);
            if (a4.applyLambda()) {
                this.system2AtomIndex[var19_27] = indexAlchemical;
                a4.setTopologyAtomIndex(indexAlchemical);
                this.dualTopologyAtoms[indexAlchemical] = a4;
                this.dualTopologyAtoms2[indexAlchemical] = a4;
                ++indexAlchemical;
            } else {
                this.system2AtomIndex[var19_27] = indexShared;
                a4.setTopologyAtomIndex(indexShared);
                this.dualTopologyAtoms2[indexShared] = a4;
                ++indexShared;
            }
            ++var19_27;
        }
        int index = 0;
        for (Atom a1 : atoms1) {
            if (!a1.isActive()) continue;
            this.activeAtoms1[index] = a1;
            if (a1.applyLambda()) {
                this.sharedAtoms1[index] = false;
            }
            ++index;
        }
        index = 0;
        for (Atom a2 : atoms2) {
            if (!a2.isActive()) continue;
            this.activeAtoms2[index] = a2;
            if (a2.applyLambda()) {
                this.sharedAtoms2[index] = false;
            }
            ++index;
        }
        this.nShared = shared1;
        int nSoftCore1 = this.nActive1 - this.nShared;
        int nSoftCore2 = this.nActive2 - this.nShared;
        int nTotal = this.nShared + nSoftCore1 + nSoftCore2;
        this.nVariables = 3 * nTotal;
        this.x1 = new double[this.nActive1 * 3];
        this.x2 = new double[this.nActive2 * 3];
        this.g1 = new double[this.nActive1 * 3];
        this.g2 = new double[this.nActive2 * 3];
        this.rg1 = new double[this.nActive1 * 3];
        this.rg2 = new double[this.nActive2 * 3];
        this.gl1 = new double[this.nActive1 * 3];
        this.gl2 = new double[this.nActive2 * 3];
        this.rgl1 = new double[this.nActive1 * 3];
        this.rgl2 = new double[this.nActive2 * 3];
        index = 0;
        this.variableTypes = new Potential.VARIABLE_TYPE[this.nVariables];
        for (int i2 = 0; i2 < nTotal; ++i2) {
            this.variableTypes[index++] = Potential.VARIABLE_TYPE.X;
            this.variableTypes[index++] = Potential.VARIABLE_TYPE.Y;
            this.variableTypes[index++] = Potential.VARIABLE_TYPE.Z;
        }
        int commonIndex = 0;
        int softcoreIndex = 3 * this.nShared;
        this.mass = new double[this.nVariables];
        for (i = 0; i < this.nActive1; ++i) {
            a = this.activeAtoms1[i];
            m = a.getMass();
            if (this.sharedAtoms1[i]) {
                this.mass[commonIndex++] = m;
                this.mass[commonIndex++] = m;
                this.mass[commonIndex++] = m;
                continue;
            }
            this.mass[softcoreIndex++] = m;
            this.mass[softcoreIndex++] = m;
            this.mass[softcoreIndex++] = m;
        }
        commonIndex = 0;
        for (i = 0; i < this.nActive2; ++i) {
            a = this.activeAtoms2[i];
            m = a.getMass();
            if (this.sharedAtoms2[i]) {
                for (int j = 0; j < 3; ++j) {
                    double massCommon = this.mass[commonIndex];
                    massCommon = Math.max(massCommon, m);
                    this.mass[commonIndex++] = massCommon;
                }
                continue;
            }
            this.mass[softcoreIndex++] = m;
            this.mass[softcoreIndex++] = m;
            this.mass[softcoreIndex++] = m;
        }
        this.energyRegion = new EnergyRegion(this);
        this.parallelTeam = new ParallelTeam(1);
        this.switchFunction = switchFunction;
        logger.info(String.format("\n Dual topology using switching function:\n  %s", switchFunction));
        logger.info(String.format(" Shared atoms: %d (1: %d of %d; 2: %d of %d)\n ", this.nShared, shared1, this.nActive1, shared2, this.nActive2));
        String symOpString = forceField2.getString("symop", null);
        if (symOpString != null) {
            this.readSymOp(symOpString);
        } else {
            this.potential2.setCrystal(this.potential1.getCrystal());
            this.useSymOp = false;
            this.symOp = null;
            this.inverse = null;
        }
        int i1 = 0;
        int i2 = 0;
        if (!this.useSymOp) {
            for (int i3 = 0; i3 < this.nShared; ++i3) {
                Atom a1 = atoms1[i1++];
                while (a1.applyLambda()) {
                    a1 = atoms1[i1++];
                }
                Atom a2 = atoms2[i2++];
                while (a2.applyLambda()) {
                    a2 = atoms2[i2++];
                }
                assert (a1.getX() == a2.getX());
                assert (a1.getY() == a2.getY());
                assert (a1.getZ() == a2.getZ());
                this.reconcileAtoms(a1, a2, Level.INFO);
            }
        }
    }

    public static DualTopologyEnergy energyFactory(MolecularAssembly molecularAssembly1, MolecularAssembly molecularAssembly2, UnivariateSwitchingFunction switchFunction) {
        ForceField forceField = molecularAssembly1.getForceField();
        String platformString = ForceField.toEnumForm(forceField.getString("PLATFORM-DT", "FFX"));
        try {
            Platform platform = Platform.valueOf(platformString);
            switch (platform) {
                case OMM: 
                case OMM_REF: 
                case OMM_CUDA: 
                case OMM_OPENCL: {
                    try {
                        return new OpenMMDualTopologyEnergy(molecularAssembly1, molecularAssembly2, switchFunction, platform);
                    }
                    catch (Exception ex) {
                        logger.warning(String.format(" Exception creating OpenMMDualTopologyEnergy: %s", ex));
                        return new DualTopologyEnergy(molecularAssembly1, molecularAssembly2, switchFunction);
                    }
                }
                case OMM_CPU: {
                    logger.warning(String.format(" Platform %s not supported; defaulting to FFX", new Object[]{platform}));
                }
            }
            return new DualTopologyEnergy(molecularAssembly1, molecularAssembly2, switchFunction);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            logger.warning(String.format(" String %s did not match a known energy implementation", platformString));
            return new DualTopologyEnergy(molecularAssembly1, molecularAssembly2, switchFunction);
        }
    }

    public int getNumberOfAtoms() {
        return this.dualTopologyAtoms.length;
    }

    public Atom[] getDualTopologyAtoms(int topology) {
        if (topology == 0) {
            return this.dualTopologyAtoms;
        }
        if (topology == 1) {
            return this.dualTopologyAtoms2;
        }
        throw new IllegalArgumentException(" Invalid topology index: " + topology);
    }

    public Atom getDualTopologyAtom(int topology, int index) {
        if (topology == 0) {
            return this.dualTopologyAtoms[index];
        }
        if (topology == 1) {
            return this.dualTopologyAtoms2[index];
        }
        throw new IllegalArgumentException(" Invalid topology index: " + topology);
    }

    public int mapToDualTopologyIndex(int topology, int index) {
        if (topology == 0) {
            return this.system1AtomIndex[index];
        }
        if (topology == 1) {
            return this.system2AtomIndex[index];
        }
        throw new IllegalArgumentException(" Invalid topology index: " + topology);
    }

    public ForceFieldEnergy getForceFieldEnergy1() {
        return this.forceFieldEnergy1;
    }

    public ForceFieldEnergy getForceFieldEnergy2() {
        return this.forceFieldEnergy2;
    }

    public int[] getDualTopologyIndex1() {
        return this.system1AtomIndex;
    }

    public int[] getDualTopologyIndex2() {
        return this.system2AtomIndex;
    }

    public double getTopologyScale(int topology) {
        if (topology == 0) {
            return this.f1L;
        }
        if (topology == 1) {
            return this.f2L;
        }
        throw new IllegalArgumentException(" Invalid topology index: " + topology);
    }

    private void readSymOp(String symOpString) {
        try {
            int index;
            int i;
            int sharedIndex;
            int numSymOps;
            String[] tokens = symOpString.split(" +");
            int numTokens = tokens.length;
            if (numTokens == 12) {
                numSymOps = 1;
                this.symOp = new SymOp[numSymOps];
                this.inverse = new SymOp[numSymOps];
                this.symOpAtoms.add(StringUtils.parseAtomRanges((String)"symmetryAtoms", (String)"1-N", (int)this.nActive2));
                this.symOp[0] = new SymOp((double[][])new double[][]{{Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2])}, {Double.parseDouble(tokens[3]), Double.parseDouble(tokens[4]), Double.parseDouble(tokens[5])}, {Double.parseDouble(tokens[6]), Double.parseDouble(tokens[7]), Double.parseDouble(tokens[8])}}, new double[]{Double.parseDouble(tokens[9]), Double.parseDouble(tokens[10]), Double.parseDouble(tokens[11])});
            } else if (numTokens % 14 == 0) {
                numSymOps = numTokens / 14;
                this.symOp = new SymOp[numSymOps];
                this.inverse = new SymOp[numSymOps];
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(String.format(" Number of Tokens: %3d Number of Sym Ops: %2d", numTokens, numSymOps));
                }
                for (int i2 = 0; i2 < numSymOps; ++i2) {
                    int j2 = i2 * 14;
                    this.symOpAtoms.add(StringUtils.parseAtomRanges((String)"symmetryAtoms", (String)tokens[j2], (int)this.nActive2));
                    this.symOp[i2] = new SymOp((double[][])new double[][]{{Double.parseDouble(tokens[j2 + 2]), Double.parseDouble(tokens[j2 + 3]), Double.parseDouble(tokens[j2 + 4])}, {Double.parseDouble(tokens[j2 + 5]), Double.parseDouble(tokens[j2 + 6]), Double.parseDouble(tokens[j2 + 7])}, {Double.parseDouble(tokens[j2 + 8]), Double.parseDouble(tokens[j2 + 9]), Double.parseDouble(tokens[j2 + 10])}}, new double[]{Double.parseDouble(tokens[j2 + 11]), Double.parseDouble(tokens[j2 + 12]), Double.parseDouble(tokens[j2 + 13])});
                }
            } else {
                logger.warning(String.format(" Provided symmetry operator is formatted incorrectly. Should have 12 or 14 entries, but found %3d.", numTokens));
                return;
            }
            this.useSymOp = true;
            this.mask = new boolean[numSymOps][this.nActive2];
            boolean[][] sharedMask = new boolean[numSymOps][this.nShared];
            for (int i3 = 0; i3 < numSymOps; ++i3) {
                List<Integer> symAtoms = this.symOpAtoms.get(i3);
                for (int atom : symAtoms) {
                    if (!this.sharedAtoms2[atom]) continue;
                    this.mask[i3][atom] = true;
                }
                sharedIndex = 0;
                for (int j3 = 0; j3 < this.nActive2; ++j3) {
                    if (!this.sharedAtoms2[j3]) continue;
                    if (this.mask[i3][j3]) {
                        sharedMask[i3][sharedIndex] = true;
                    }
                    ++sharedIndex;
                }
            }
            this.potential1.getCoordinates(this.x1);
            this.potential2.getCoordinates(this.x2);
            double[] x1Shared = new double[this.nShared * 3];
            double[] x2Shared = new double[this.nShared * 3];
            sharedIndex = 0;
            for (i = 0; i < this.nActive1; ++i) {
                if (!this.sharedAtoms1[i]) continue;
                index = i * 3;
                x1Shared[sharedIndex++] = this.x1[index];
                x1Shared[sharedIndex++] = this.x1[index + 1];
                x1Shared[sharedIndex++] = this.x1[index + 2];
            }
            sharedIndex = 0;
            for (i = 0; i < this.nActive2; ++i) {
                if (!this.sharedAtoms2[i]) continue;
                index = i * 3;
                x2Shared[sharedIndex++] = this.x2[index];
                x2Shared[sharedIndex++] = this.x2[index + 1];
                x2Shared[sharedIndex++] = this.x2[index + 2];
            }
            double origRMSD = Superpose.rmsd(x1Shared, x2Shared, this.mass);
            logger.info("\n RMSD to topology 2 coordinates from input file:");
            logger.info(String.format(" RMSD: %12.3f A", origRMSD));
            double[] origX1 = Arrays.copyOf(x1Shared, this.nShared * 3);
            double[] origX2 = Arrays.copyOf(x2Shared, this.nShared * 3);
            for (int i4 = 0; i4 < numSymOps; ++i4) {
                this.inverse[i4] = SymOp.invertSymOp((SymOp)this.symOp[i4]);
                SymOp.applyCartesianSymOp((double[])origX1, (double[])origX1, (SymOp)this.symOp[i4], (boolean[])sharedMask[i4]);
                logger.info(String.format("\n SymOp %3d of %3d between topologies:\n Applied to atoms: %s\n %s\n Inverse SymOp:\n %s", i4 + 1, numSymOps, StringUtils.writeAtomRanges((int[])this.symOpAtoms.get(i4).stream().mapToInt(j -> j).toArray()), this.symOp[i4].toString(), this.inverse[i4].toString()));
            }
            double symOpRMSD = Superpose.rmsd(origX1, origX2, this.mass);
            logger.info("\n RMSD to topology 2 coordinates via loaded symop:");
            logger.info(String.format(" RMSD: %12.3f A", symOpRMSD));
            logger.info("\n Checking alchemical atoms for system 1:");
            this.validateAlchemicalAtoms(this.nActive1, this.sharedAtoms1, this.activeAtoms1);
            logger.info(" Checking alchemical atoms for system 2:");
            this.validateAlchemicalAtoms(this.nActive2, this.sharedAtoms2, this.activeAtoms2);
            if (logger.isLoggable(Level.FINE)) {
                for (int i5 = 0; i5 < this.nShared; ++i5) {
                    int i3 = i5 * 3;
                    double[] dArray = new double[]{origX1[i3], origX1[i3 + 1], origX1[i3 + 2]};
                    double[] dArray2 = new double[]{origX2[i3], origX2[i3 + 1], origX2[i3 + 2]};
                    double[] dArray3 = new double[]{this.mass[i5]};
                    double rmsd = Superpose.rmsd(dArray, dArray2, dArray3);
                    if (!(rmsd > 0.5)) continue;
                    logger.fine(String.format(" Shared atom %3d has a distance of %8.3f", i5 + 1, rmsd));
                }
            }
        }
        catch (Exception ex) {
            logger.severe(" Error parsing SymOp for Dual Topology:\n (" + symOpString + ")" + Utilities.stackTraceToString(ex));
        }
    }

    @Override
    public boolean dEdLZeroAtEnds() {
        if (!this.forceFieldEnergy1.dEdLZeroAtEnds() || !this.forceFieldEnergy2.dEdLZeroAtEnds()) {
            return false;
        }
        return this.switchFunction.highestOrderZeroDerivativeAtZeroBound() > 0;
    }

    public boolean destroy() {
        boolean ffe1Destroy = this.forceFieldEnergy1.destroy();
        boolean ffe2Destroy = this.forceFieldEnergy2.destroy();
        try {
            if (this.parallelTeam != null) {
                this.parallelTeam.shutdown();
            }
            return ffe1Destroy && ffe2Destroy;
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception in shutting down DualTopologyEnergy: %s", ex));
            logger.info(Utilities.stackTraceToString(ex));
            return false;
        }
    }

    public double energy(double[] x) {
        return this.energy(x, false);
    }

    public double energy(double[] x, boolean verbose) {
        try {
            this.energyRegion.setX(x);
            this.energyRegion.setVerbose(verbose);
            this.parallelTeam.execute((ParallelRegion)this.energyRegion);
        }
        catch (Exception ex) {
            throw new EnergyException(String.format(" Exception in calculating dual-topology energy: %s", ex));
        }
        return this.totalEnergy;
    }

    public double energyAndGradient(double[] x, double[] g) {
        return this.energyAndGradient(x, g, false);
    }

    public double energyAndGradient(double[] x, double[] g, boolean verbose) {
        assert (Arrays.stream(x).allMatch(Double::isFinite));
        try {
            this.energyRegion.setX(x);
            this.energyRegion.setG(g);
            this.energyRegion.setVerbose(verbose);
            this.parallelTeam.execute((ParallelRegion)this.energyRegion);
        }
        catch (Exception ex) {
            throw new EnergyException(String.format(" Exception in calculating dual-topology energy: %s", ex));
        }
        return this.totalEnergy;
    }

    public double[] getAcceleration(double[] acceleration) {
        Atom atom;
        int i;
        if (acceleration == null || acceleration.length < this.nVariables) {
            acceleration = new double[this.nVariables];
        }
        int indexCommon = 0;
        int indexUnique = this.nShared * 3;
        double[] accel = new double[3];
        for (i = 0; i < this.nActive1; ++i) {
            atom = this.activeAtoms1[i];
            atom.getAcceleration(accel);
            if (this.sharedAtoms1[i]) {
                acceleration[indexCommon++] = accel[0];
                acceleration[indexCommon++] = accel[1];
                acceleration[indexCommon++] = accel[2];
                continue;
            }
            acceleration[indexUnique++] = accel[0];
            acceleration[indexUnique++] = accel[1];
            acceleration[indexUnique++] = accel[2];
        }
        for (i = 0; i < this.nActive2; ++i) {
            if (this.sharedAtoms2[i]) continue;
            atom = this.activeAtoms2[i];
            atom.getAcceleration(accel);
            acceleration[indexUnique++] = accel[0];
            acceleration[indexUnique++] = accel[1];
            acceleration[indexUnique++] = accel[2];
        }
        return acceleration;
    }

    public double[] getCoordinates(double[] x) {
        Atom a;
        int i;
        if (x == null) {
            x = new double[this.nVariables];
        }
        int indexCommon = 0;
        int indexUnique = this.nShared * 3;
        for (i = 0; i < this.nActive1; ++i) {
            a = this.activeAtoms1[i];
            if (this.sharedAtoms1[i]) {
                x[indexCommon++] = a.getX();
                x[indexCommon++] = a.getY();
                x[indexCommon++] = a.getZ();
                continue;
            }
            x[indexUnique++] = a.getX();
            x[indexUnique++] = a.getY();
            x[indexUnique++] = a.getZ();
        }
        for (i = 0; i < this.nActive2; ++i) {
            if (this.sharedAtoms2[i]) continue;
            a = this.activeAtoms2[i];
            x[indexUnique++] = a.getX();
            x[indexUnique++] = a.getY();
            x[indexUnique++] = a.getZ();
        }
        return x;
    }

    public void setCoordinates(@Nullable double[] x) {
        Atom a;
        int i;
        int indexCommon = 0;
        int indexUnique = this.nShared * 3;
        double[] xyz = new double[3];
        for (i = 0; i < this.nActive1; ++i) {
            if (this.sharedAtoms1[i]) {
                xyz[0] = x[indexCommon++];
                xyz[1] = x[indexCommon++];
                xyz[2] = x[indexCommon++];
            } else {
                xyz[0] = x[indexUnique++];
                xyz[1] = x[indexUnique++];
                xyz[2] = x[indexUnique++];
            }
            a = this.activeAtoms1[i];
            a.setXYZ(xyz);
        }
        indexCommon = 0;
        for (i = 0; i < this.nActive2; ++i) {
            if (this.sharedAtoms2[i]) {
                xyz[0] = x[indexCommon++];
                xyz[1] = x[indexCommon++];
                xyz[2] = x[indexCommon++];
            } else {
                xyz[0] = x[indexUnique++];
                xyz[1] = x[indexUnique++];
                xyz[2] = x[indexUnique++];
            }
            a = this.activeAtoms2[i];
            a.setXYZ(xyz);
        }
    }

    public Crystal getCrystal() {
        if (this.useSymOp && logger.isLoggable(Level.FINE)) {
            logger.fine(" Get method only returned first crystal.");
        }
        return this.potential1.getCrystal();
    }

    public void setCrystal(Crystal crystal) {
        if (this.useSymOp && logger.isLoggable(Level.FINE)) {
            logger.fine(" Both systems set to the same crystal.");
        }
        this.potential1.setCrystal(crystal);
        this.potential2.setCrystal(crystal);
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
        this.potential1.setEnergyTermState(state);
        this.potential2.setEnergyTermState(state);
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (!(lambda <= 1.0) || !(lambda >= 0.0)) {
            String message = String.format("Lambda value %8.3f is not in the range [0..1].", lambda);
            throw new IllegalArgumentException(message);
        }
        this.lambda = lambda;
        double oneMinusLambda = 1.0 - lambda;
        this.lambdaInterface1.setLambda(lambda);
        this.lambdaInterface2.setLambda(oneMinusLambda);
        this.f1L = this.switchFunction.valueAt(lambda);
        this.dF1dL = this.switchFunction.firstDerivative(lambda);
        this.d2F1dL2 = this.switchFunction.secondDerivative(lambda);
        this.f2L = this.switchFunction.valueAt(oneMinusLambda);
        this.dF2dL = -1.0 * this.switchFunction.firstDerivative(oneMinusLambda);
        this.d2F2dL2 = this.switchFunction.secondDerivative(oneMinusLambda);
    }

    public double[] getMass() {
        return this.mass;
    }

    public int getNumSharedVariables() {
        return 3 * this.nShared;
    }

    public int getNumberOfVariables() {
        return this.nVariables;
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        Atom atom;
        int i;
        if (previousAcceleration == null || previousAcceleration.length < this.nVariables) {
            previousAcceleration = new double[this.nVariables];
        }
        int indexCommon = 0;
        int indexUnique = this.nShared * 3;
        double[] prev = new double[3];
        for (i = 0; i < this.nActive1; ++i) {
            atom = this.activeAtoms1[i];
            atom.getPreviousAcceleration(prev);
            if (this.sharedAtoms1[i]) {
                previousAcceleration[indexCommon++] = prev[0];
                previousAcceleration[indexCommon++] = prev[1];
                previousAcceleration[indexCommon++] = prev[2];
                continue;
            }
            previousAcceleration[indexUnique++] = prev[0];
            previousAcceleration[indexUnique++] = prev[1];
            previousAcceleration[indexUnique++] = prev[2];
        }
        for (i = 0; i < this.nActive2; ++i) {
            atom = this.activeAtoms2[i];
            if (this.sharedAtoms2[i]) continue;
            atom.getPreviousAcceleration(prev);
            previousAcceleration[indexUnique++] = prev[0];
            previousAcceleration[indexUnique++] = prev[1];
            previousAcceleration[indexUnique++] = prev[2];
        }
        return previousAcceleration;
    }

    public double[] getScaling() {
        return this.scaling;
    }

    public void setScaling(double[] scaling) {
        this.scaling = scaling;
    }

    public UnivariateSwitchingFunction getSwitch() {
        return this.switchFunction;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public List<Potential> getUnderlyingPotentials() {
        ArrayList<Potential> under = new ArrayList<Potential>(2);
        under.add((Potential)this.forceFieldEnergy1);
        under.add((Potential)this.forceFieldEnergy2);
        under.addAll(this.forceFieldEnergy1.getUnderlyingPotentials());
        under.addAll(this.forceFieldEnergy2.getUnderlyingPotentials());
        return under;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        return this.variableTypes;
    }

    public double[] getVelocity(double[] velocity) {
        Atom atom;
        int i;
        if (velocity == null || velocity.length < this.nVariables) {
            velocity = new double[this.nVariables];
        }
        int indexCommon = 0;
        int indexUnique = this.nShared * 3;
        double[] vel = new double[3];
        for (i = 0; i < this.nActive1; ++i) {
            atom = this.activeAtoms1[i];
            atom.getVelocity(vel);
            if (this.sharedAtoms1[i]) {
                velocity[indexCommon++] = vel[0];
                velocity[indexCommon++] = vel[1];
                velocity[indexCommon++] = vel[2];
                continue;
            }
            velocity[indexUnique++] = vel[0];
            velocity[indexUnique++] = vel[1];
            velocity[indexUnique++] = vel[2];
        }
        for (i = 0; i < this.nActive2; ++i) {
            if (this.sharedAtoms2[i]) continue;
            atom = this.activeAtoms2[i];
            atom.getVelocity(vel);
            velocity[indexUnique++] = vel[0];
            velocity[indexUnique++] = vel[1];
            velocity[indexUnique++] = vel[2];
        }
        return velocity;
    }

    @Override
    public double getd2EdL2() {
        double e1 = this.f1L * this.d2EdL2_1 + 2.0 * this.dF1dL * this.dEdL_1 + this.d2F1dL2 * this.energy1 + this.f2L * this.restraintd2EdL2_1 + 2.0 * this.dF2dL * this.restraintdEdL_1 + this.d2F2dL2 * this.restraintEnergy1;
        double e2 = !this.useFirstSystemBondedEnergy ? this.f2L * this.d2EdL2_2 + 2.0 * this.dF2dL * this.dEdL_2 + this.d2F2dL2 * this.energy2 + this.f1L * this.restraintd2EdL2_2 + 2.0 * this.dF1dL * this.restraintdEdL_2 + this.d2F1dL2 * this.restraintEnergy2 : this.f2L * this.d2EdL2_2 + 2.0 * this.dF2dL * this.dEdL_2 + this.d2F2dL2 * this.energy2 - this.f2L * this.restraintd2EdL2_2 - 2.0 * this.dF2dL * this.restraintdEdL_2 - this.d2F2dL2 * this.restraintEnergy2;
        return e1 + e2;
    }

    @Override
    public double getdEdL() {
        double e1 = this.f1L * this.dEdL_1 + this.dF1dL * this.energy1 + this.f2L * this.restraintdEdL_1 + this.dF2dL * this.restraintEnergy1;
        double e2 = !this.useFirstSystemBondedEnergy ? this.f2L * this.dEdL_2 + this.dF2dL * this.energy2 + this.f1L * this.restraintdEdL_2 + this.dF1dL * this.restraintEnergy2 : this.f2L * this.dEdL_2 + this.dF2dL * this.energy2 - this.f2L * this.restraintdEdL_2 - this.dF2dL * this.restraintEnergy2;
        return e1 + e2;
    }

    @Override
    public void getdEdXdL(double[] g) {
        int i;
        if (g == null) {
            g = new double[this.nVariables];
        }
        int index = 0;
        int indexCommon = 0;
        int indexUnique = this.nShared * 3;
        for (i = 0; i < this.nActive1; ++i) {
            if (this.sharedAtoms1[i]) {
                g[indexCommon++] = this.f1L * this.gl1[index] + this.dF1dL * this.g1[index] + this.f2L * this.rgl1[index] + this.dF2dL * this.rg1[index++];
                g[indexCommon++] = this.f1L * this.gl1[index] + this.dF1dL * this.g1[index] + this.f2L * this.rgl1[index] + this.dF2dL * this.rg1[index++];
                g[indexCommon++] = this.f1L * this.gl1[index] + this.dF1dL * this.g1[index] + this.f2L * this.rgl1[index] + this.dF2dL * this.rg1[index++];
                continue;
            }
            g[indexUnique++] = this.f1L * this.gl1[index] + this.dF1dL * this.g1[index] + this.f2L * this.rgl1[index] + this.dF2dL * this.rg1[index++];
            g[indexUnique++] = this.f1L * this.gl1[index] + this.dF1dL * this.g1[index] + this.f2L * this.rgl1[index] + this.dF2dL * this.rg1[index++];
            g[indexUnique++] = this.f1L * this.gl1[index] + this.dF1dL * this.g1[index] + this.f2L * this.rgl1[index] + this.dF2dL * this.rg1[index++];
        }
        if (!this.useFirstSystemBondedEnergy) {
            index = 0;
            indexCommon = 0;
            for (i = 0; i < this.nActive2; ++i) {
                if (this.sharedAtoms2[i]) {
                    int n = indexCommon++;
                    g[n] = g[n] + (-this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] - this.f1L * this.rgl2[index] + this.dF1dL * this.rg2[index++]);
                    int n2 = indexCommon++;
                    g[n2] = g[n2] + (-this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] - this.f1L * this.rgl2[index] + this.dF1dL * this.rg2[index++]);
                    int n3 = indexCommon++;
                    g[n3] = g[n3] + (-this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] - this.f1L * this.rgl2[index] + this.dF1dL * this.rg2[index++]);
                    continue;
                }
                g[indexUnique++] = -this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] - this.f1L * this.rgl2[index] + this.dF1dL * this.rg2[index++];
                g[indexUnique++] = -this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] - this.f1L * this.rgl2[index] + this.dF1dL * this.rg2[index++];
                g[indexUnique++] = -this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] - this.f1L * this.rgl2[index] + this.dF1dL * this.rg2[index++];
            }
        } else {
            index = 0;
            indexCommon = 0;
            for (i = 0; i < this.nActive2; ++i) {
                if (this.sharedAtoms2[i]) {
                    int n = indexCommon++;
                    g[n] = g[n] + (-this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] + this.f2L * this.rgl2[index] - this.dF2dL * this.rg2[index++]);
                    int n4 = indexCommon++;
                    g[n4] = g[n4] + (-this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] + this.f2L * this.rgl2[index] - this.dF2dL * this.rg2[index++]);
                    int n5 = indexCommon++;
                    g[n5] = g[n5] + (-this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] + this.f2L * this.rgl2[index] - this.dF2dL * this.rg2[index++]);
                    continue;
                }
                g[indexUnique++] = -this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] + this.f2L * this.rgl2[index] - this.dF2dL * this.rg2[index++];
                g[indexUnique++] = -this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] + this.f2L * this.rgl2[index] - this.dF2dL * this.rg2[index++];
                g[indexUnique++] = -this.f2L * this.gl2[index] + this.dF2dL * this.g2[index] + this.f2L * this.rgl2[index] - this.dF2dL * this.rg2[index++];
            }
        }
    }

    public void setAcceleration(double[] acceleration) {
        Atom atom;
        int i;
        double[] accel = new double[3];
        int indexCommon = 0;
        int indexUnique = 3 * this.nShared;
        for (i = 0; i < this.nActive1; ++i) {
            atom = this.activeAtoms1[i];
            if (this.sharedAtoms1[i]) {
                accel[0] = acceleration[indexCommon++];
                accel[1] = acceleration[indexCommon++];
                accel[2] = acceleration[indexCommon++];
            } else {
                accel[0] = acceleration[indexUnique++];
                accel[1] = acceleration[indexUnique++];
                accel[2] = acceleration[indexUnique++];
            }
            atom.setAcceleration(accel);
        }
        indexCommon = 0;
        for (i = 0; i < this.nActive2; ++i) {
            atom = this.activeAtoms2[i];
            if (this.sharedAtoms2[i]) {
                accel[0] = acceleration[indexCommon++];
                accel[1] = acceleration[indexCommon++];
                accel[2] = acceleration[indexCommon++];
            } else {
                accel[0] = acceleration[indexUnique++];
                accel[1] = acceleration[indexUnique++];
                accel[2] = acceleration[indexUnique++];
            }
            atom.setAcceleration(accel);
        }
    }

    public void setParallel(boolean parallel) {
        if (this.parallelTeam != null) {
            try {
                this.parallelTeam.shutdown();
            }
            catch (Exception e) {
                logger.severe(String.format(" Exception in shutting down old ParallelTeam for DualTopologyEnergy: %s", e));
            }
        }
        this.parallelTeam = parallel ? new ParallelTeam(2) : new ParallelTeam(1);
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        Atom atom;
        int i;
        double[] prev = new double[3];
        int indexCommon = 0;
        int indexUnique = 3 * this.nShared;
        for (i = 0; i < this.nActive1; ++i) {
            atom = this.activeAtoms1[i];
            if (this.sharedAtoms1[i]) {
                prev[0] = previousAcceleration[indexCommon++];
                prev[1] = previousAcceleration[indexCommon++];
                prev[2] = previousAcceleration[indexCommon++];
            } else {
                prev[0] = previousAcceleration[indexUnique++];
                prev[1] = previousAcceleration[indexUnique++];
                prev[2] = previousAcceleration[indexUnique++];
            }
            atom.setPreviousAcceleration(prev);
        }
        indexCommon = 0;
        for (i = 0; i < this.nActive2; ++i) {
            atom = this.activeAtoms2[i];
            if (this.sharedAtoms2[i]) {
                prev[0] = previousAcceleration[indexCommon++];
                prev[1] = previousAcceleration[indexCommon++];
                prev[2] = previousAcceleration[indexCommon++];
            } else {
                prev[0] = previousAcceleration[indexUnique++];
                prev[1] = previousAcceleration[indexUnique++];
                prev[2] = previousAcceleration[indexUnique++];
            }
            atom.setPreviousAcceleration(prev);
        }
    }

    public void setPrintOnFailure(boolean onFail, boolean override) {
        this.forceFieldEnergy1.setPrintOnFailure(onFail, override);
        this.forceFieldEnergy2.setPrintOnFailure(onFail, override);
    }

    public void setVelocity(double[] velocity) {
        Atom atom;
        int i;
        double[] vel = new double[3];
        int indexCommon = 0;
        int indexUnique = 3 * this.nShared;
        for (i = 0; i < this.nActive1; ++i) {
            atom = this.activeAtoms1[i];
            if (this.sharedAtoms1[i]) {
                vel[0] = velocity[indexCommon++];
                vel[1] = velocity[indexCommon++];
                vel[2] = velocity[indexCommon++];
            } else {
                vel[0] = velocity[indexUnique++];
                vel[1] = velocity[indexUnique++];
                vel[2] = velocity[indexUnique++];
            }
            atom.setVelocity(vel);
        }
        indexCommon = 0;
        for (i = 0; i < this.nActive2; ++i) {
            atom = this.activeAtoms2[i];
            if (this.sharedAtoms2[i]) {
                vel[0] = velocity[indexCommon++];
                vel[1] = velocity[indexCommon++];
                vel[2] = velocity[indexCommon++];
            } else {
                vel[0] = velocity[indexUnique++];
                vel[1] = velocity[indexUnique++];
                vel[2] = velocity[indexUnique++];
            }
            atom.setVelocity(vel);
        }
    }

    private void reconcileAtoms(Atom a1, Atom a2, Level warnlev) {
        double dist = 0.0;
        double[] xyz1 = a1.getXYZ(null);
        double[] xyz2 = a2.getXYZ(null);
        double[] xyzAv = new double[3];
        for (int i = 0; i < 3; ++i) {
            double dx = xyz1[i] - xyz2[i];
            dist += dx * dx;
            xyzAv[i] = xyz1[i] + 0.5 * dx;
        }
        double maxDist2 = 0.09;
        double minDistWarn2 = 1.0E-5;
        if (dist > maxDist2) {
            logger.log(Level.SEVERE, String.format(" Distance between atoms %s and %s is %7.4f >> maximum allowed %7.4f", a1, a2, FastMath.sqrt((double)dist), FastMath.sqrt((double)maxDist2)));
        } else if (dist > minDistWarn2) {
            logger.log(warnlev, String.format(" Distance between atoms %s and %s is %7.4f; moving atoms together.", a1, a2, FastMath.sqrt((double)dist)));
            a1.setXYZ(xyzAv);
            a2.setXYZ(xyzAv);
        } else if (dist > 0.0) {
            a1.setXYZ(xyzAv);
            a2.setXYZ(xyzAv);
        }
    }

    private void packGradient(double[] x, double[] g) {
        int i;
        if (g == null) {
            g = new double[this.nVariables];
        }
        int indexCommon = 0;
        int indexUnique = this.nShared * 3;
        int index = 0;
        for (i = 0; i < this.nActive1; ++i) {
            if (this.sharedAtoms1[i]) {
                g[indexCommon++] = this.f1L * this.g1[index] + this.f2L * this.rg1[index++];
                g[indexCommon++] = this.f1L * this.g1[index] + this.f2L * this.rg1[index++];
                g[indexCommon++] = this.f1L * this.g1[index] + this.f2L * this.rg1[index++];
                continue;
            }
            g[indexUnique++] = this.f1L * this.g1[index] + this.f2L * this.rg1[index++];
            g[indexUnique++] = this.f1L * this.g1[index] + this.f2L * this.rg1[index++];
            g[indexUnique++] = this.f1L * this.g1[index] + this.f2L * this.rg1[index++];
        }
        if (!this.useFirstSystemBondedEnergy) {
            indexCommon = 0;
            index = 0;
            for (i = 0; i < this.nActive2; ++i) {
                if (this.sharedAtoms2[i]) {
                    int n = indexCommon++;
                    g[n] = g[n] + (this.f2L * this.g2[index] + this.f1L * this.rg2[index++]);
                    int n2 = indexCommon++;
                    g[n2] = g[n2] + (this.f2L * this.g2[index] + this.f1L * this.rg2[index++]);
                    int n3 = indexCommon++;
                    g[n3] = g[n3] + (this.f2L * this.g2[index] + this.f1L * this.rg2[index++]);
                    continue;
                }
                g[indexUnique++] = this.f2L * this.g2[index] + this.f1L * this.rg2[index++];
                g[indexUnique++] = this.f2L * this.g2[index] + this.f1L * this.rg2[index++];
                g[indexUnique++] = this.f2L * this.g2[index] + this.f1L * this.rg2[index++];
            }
        } else {
            indexCommon = 0;
            index = 0;
            for (i = 0; i < this.nActive2; ++i) {
                if (this.sharedAtoms2[i]) {
                    int n = indexCommon++;
                    g[n] = g[n] + (this.f2L * this.g2[index] - this.f2L * this.rg2[index++]);
                    int n4 = indexCommon++;
                    g[n4] = g[n4] + (this.f2L * this.g2[index] - this.f2L * this.rg2[index++]);
                    int n5 = indexCommon++;
                    g[n5] = g[n5] + (this.f2L * this.g2[index] - this.f2L * this.rg2[index++]);
                    continue;
                }
                g[indexUnique++] = this.f2L * this.g2[index] - this.f2L * this.rg2[index++];
                g[indexUnique++] = this.f2L * this.g2[index] - this.f2L * this.rg2[index++];
                g[indexUnique++] = this.f2L * this.g2[index] - this.f2L * this.rg2[index++];
            }
        }
        this.scaleCoordinatesAndGradient(x, g);
    }

    private void unpackCoordinates(double[] x) {
        int i;
        this.unscaleCoordinates(x);
        int index = 0;
        int indexCommon = 0;
        int indexUnique = 3 * this.nShared;
        for (i = 0; i < this.nActive1; ++i) {
            if (this.sharedAtoms1[i]) {
                this.x1[index++] = x[indexCommon++];
                this.x1[index++] = x[indexCommon++];
                this.x1[index++] = x[indexCommon++];
                continue;
            }
            this.x1[index++] = x[indexUnique++];
            this.x1[index++] = x[indexUnique++];
            this.x1[index++] = x[indexUnique++];
        }
        index = 0;
        indexCommon = 0;
        for (i = 0; i < this.nActive2; ++i) {
            if (this.sharedAtoms2[i]) {
                this.x2[index++] = x[indexCommon++];
                this.x2[index++] = x[indexCommon++];
                this.x2[index++] = x[indexCommon++];
                continue;
            }
            this.x2[index++] = x[indexUnique++];
            this.x2[index++] = x[indexUnique++];
            this.x2[index++] = x[indexUnique++];
        }
    }

    void reloadCommonMasses(boolean secondTopology) {
        int commonIndex = 0;
        if (secondTopology) {
            for (int i = 0; i < this.nActive2; ++i) {
                Atom a = this.activeAtoms2[i];
                double m = a.getMass();
                if (!this.sharedAtoms2[i]) continue;
                this.mass[commonIndex++] = m;
                this.mass[commonIndex++] = m;
                this.mass[commonIndex++] = m;
            }
        } else {
            for (int i = 0; i < this.nActive1; ++i) {
                Atom a = this.activeAtoms1[i];
                double m = a.getMass();
                if (!this.sharedAtoms1[i]) continue;
                this.mass[commonIndex++] = m;
                this.mass[commonIndex++] = m;
                this.mass[commonIndex++] = m;
            }
        }
    }

    private void validateAlchemicalAtoms(int nActive, boolean[] sharedAtoms, Atom[] activeAtoms) {
        int numSymOps = this.symOpAtoms.size();
        for (int i = 0; i < nActive; ++i) {
            List<Integer> symOpAtomGroup;
            if (sharedAtoms[i]) continue;
            Atom alchAtom = activeAtoms[i];
            int symOpForAlchemicalAtom = -1;
            for (int j = 0; j < numSymOps; ++j) {
                symOpAtomGroup = this.symOpAtoms.get(j);
                if (!symOpAtomGroup.contains(i)) continue;
                symOpForAlchemicalAtom = j;
                break;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\n Alchemical atom %s\n Symmetry group %s:\n", alchAtom, symOpForAlchemicalAtom + 1));
            symOpAtomGroup = this.symOpAtoms.get(symOpForAlchemicalAtom);
            for (Integer j : symOpAtomGroup) {
                if (j == i) continue;
                sb.append(String.format("  %d %s\n", j + 1, activeAtoms[j]));
            }
            sb.append(String.format("\n 1-2, 1-3 or 1-4 atoms in other symmetry groups:\n", new Object[0]));
            ArrayList<Integer> bondedAtoms = new ArrayList<Integer>();
            this.addUniqueBondedIndices(bondedAtoms, alchAtom.get12List());
            this.addUniqueBondedIndices(bondedAtoms, alchAtom.get13List());
            this.addUniqueBondedIndices(bondedAtoms, alchAtom.get14List());
            boolean conflict = false;
            for (int j = 0; j < numSymOps; ++j) {
                if (j == symOpForAlchemicalAtom) continue;
                symOpAtomGroup = this.symOpAtoms.get(j);
                for (Integer integer : bondedAtoms) {
                    if (!symOpAtomGroup.contains(integer)) continue;
                    conflict = true;
                    sb.append(String.format("  %d %s uses symmetry group %2d.\n", integer + 1, activeAtoms[integer], j + 1));
                }
            }
            if (!conflict) continue;
            logger.info(sb.toString());
        }
    }

    private void addUniqueBondedIndices(ArrayList<Integer> uniqueIndices, List<Atom> bondedAtoms) {
        for (Atom a : bondedAtoms) {
            int index = a.getIndex() - 1;
            if (uniqueIndices.contains(index)) continue;
            uniqueIndices.add(index);
        }
    }

    private class EnergyRegion
    extends ParallelRegion {
        private final Energy1Section e1sect;
        private final Energy2Section e2sect;
        private double[] x;
        private double[] g;
        private boolean gradient;
        private boolean verbose;
        final /* synthetic */ DualTopologyEnergy this$0;

        EnergyRegion(DualTopologyEnergy dualTopologyEnergy) {
            DualTopologyEnergy dualTopologyEnergy2 = dualTopologyEnergy;
            Objects.requireNonNull(dualTopologyEnergy2);
            this.this$0 = dualTopologyEnergy2;
            this.gradient = false;
            this.verbose = false;
            this.e1sect = new Energy1Section(dualTopologyEnergy);
            this.e2sect = new Energy2Section(dualTopologyEnergy);
        }

        public void finish() {
            this.this$0.totalEnergy = !this.this$0.useFirstSystemBondedEnergy ? this.this$0.f1L * this.this$0.energy1 + this.this$0.f2L * this.this$0.restraintEnergy1 + this.this$0.f2L * this.this$0.energy2 + this.this$0.f1L * this.this$0.restraintEnergy2 : this.this$0.f1L * this.this$0.energy1 + this.this$0.f2L * this.this$0.restraintEnergy1 + this.this$0.f2L * this.this$0.energy2 - this.this$0.f2L * this.this$0.restraintEnergy2;
            if (this.gradient) {
                this.this$0.packGradient(this.x, this.g);
            } else {
                this.this$0.scaleCoordinates(this.x);
            }
            if (this.verbose) {
                logger.info(String.format(" Total dual-topology energy: %12.4f", this.this$0.totalEnergy));
            }
            this.setVerbose(false);
            this.setGradient(false);
        }

        public void run() throws Exception {
            this.execute(this.e1sect, this.e2sect);
        }

        public void setG(double[] g) {
            this.g = g;
            this.setGradient(true);
        }

        public void setGradient(boolean grad) {
            this.gradient = grad;
            this.e1sect.setGradient(grad);
            this.e2sect.setGradient(grad);
        }

        public void setVerbose(boolean verb) {
            this.verbose = verb;
            this.e1sect.setVerbose(verb);
            this.e2sect.setVerbose(verb);
        }

        public void setX(double[] x) {
            this.x = x;
        }

        public void start() {
            this.this$0.unpackCoordinates(this.x);
        }
    }

    private class Energy2Section
    extends ParallelSection {
        private boolean gradient;
        private boolean verbose;
        final /* synthetic */ DualTopologyEnergy this$0;

        private Energy2Section(DualTopologyEnergy dualTopologyEnergy) {
            DualTopologyEnergy dualTopologyEnergy2 = dualTopologyEnergy;
            Objects.requireNonNull(dualTopologyEnergy2);
            this.this$0 = dualTopologyEnergy2;
            this.gradient = false;
            this.verbose = false;
        }

        public void run() {
            int i;
            int numSymOps = 0;
            if (this.this$0.useSymOp) {
                numSymOps = this.this$0.symOpAtoms.size();
                for (i = 0; i < numSymOps; ++i) {
                    SymOp.applyCartesianSymOp((double[])this.this$0.x2, (double[])this.this$0.x2, (SymOp)this.this$0.symOp[i], (boolean[])this.this$0.mask[i]);
                }
            }
            if (this.gradient) {
                Arrays.fill(this.this$0.gl2, 0.0);
                Arrays.fill(this.this$0.rgl2, 0.0);
                this.this$0.energy2 = this.this$0.potential2.energyAndGradient(this.this$0.x2, this.this$0.g2, this.verbose);
                this.this$0.dEdL_2 = -this.this$0.lambdaInterface2.getdEdL();
                this.this$0.d2EdL2_2 = this.this$0.lambdaInterface2.getd2EdL2();
                this.this$0.lambdaInterface2.getdEdXdL(this.this$0.gl2);
                if (this.this$0.useSymOp) {
                    for (i = 0; i < numSymOps; ++i) {
                        SymOp.applyCartesianSymRot((double[])this.this$0.g2, (double[])this.this$0.g2, (SymOp)this.this$0.inverse[i], (boolean[])this.this$0.mask[i]);
                        SymOp.applyCartesianSymRot((double[])this.this$0.gl2, (double[])this.this$0.gl2, (SymOp)this.this$0.inverse[i], (boolean[])this.this$0.mask[i]);
                    }
                }
                if (this.this$0.doValenceRestraint2) {
                    if (this.verbose) {
                        logger.info(" Calculating lambda bonded terms for topology 2");
                    }
                    this.this$0.forceFieldEnergy2.setLambdaBondedTerms(true, this.this$0.useFirstSystemBondedEnergy);
                    ForceFieldEnergy forceFieldEnergy = this.this$0.forceFieldEnergy2;
                    if (forceFieldEnergy instanceof OpenMMEnergy) {
                        OpenMMEnergy openMMEnergy = (OpenMMEnergy)forceFieldEnergy;
                        this.this$0.restraintEnergy2 = openMMEnergy.energyAndGradientFFX(this.this$0.x2, this.this$0.rg2, this.verbose);
                    } else {
                        this.this$0.restraintEnergy2 = this.this$0.forceFieldEnergy2.energyAndGradient(this.this$0.x2, this.this$0.rg2, this.verbose);
                    }
                    this.this$0.restraintdEdL_2 = -this.this$0.forceFieldEnergy2.getdEdL();
                    this.this$0.restraintd2EdL2_2 = this.this$0.forceFieldEnergy2.getd2EdL2();
                    this.this$0.forceFieldEnergy2.getdEdXdL(this.this$0.rgl2);
                    if (this.this$0.useSymOp) {
                        for (int i2 = 0; i2 < numSymOps; ++i2) {
                            SymOp.applyCartesianSymRot((double[])this.this$0.rg2, (double[])this.this$0.rg2, (SymOp)this.this$0.inverse[i2], (boolean[])this.this$0.mask[i2]);
                            SymOp.applyCartesianSymRot((double[])this.this$0.rgl2, (double[])this.this$0.rgl2, (SymOp)this.this$0.inverse[i2], (boolean[])this.this$0.mask[i2]);
                        }
                    }
                    this.this$0.forceFieldEnergy2.setLambdaBondedTerms(false, false);
                } else {
                    this.this$0.restraintEnergy2 = 0.0;
                    this.this$0.restraintdEdL_2 = 0.0;
                    this.this$0.restraintd2EdL2_2 = 0.0;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Topology 2 Energy & Restraints: %15.8f %15.8f", this.this$0.f2L * this.this$0.energy2, this.this$0.f1L * this.this$0.restraintEnergy2));
                    logger.fine(String.format(" Topology 2:    %15.8f * (%.2f)", this.this$0.energy2, this.this$0.f2L));
                    logger.fine(String.format(" T2 Restraints: %15.8f * (%.2f)", this.this$0.restraintEnergy2, this.this$0.f1L));
                }
            } else {
                this.this$0.energy2 = this.this$0.potential2.energy(this.this$0.x2, this.verbose);
                if (this.this$0.doValenceRestraint2) {
                    if (this.verbose) {
                        logger.info(" Calculating lambda bonded terms for topology 2");
                    }
                    this.this$0.forceFieldEnergy2.setLambdaBondedTerms(true, this.this$0.useFirstSystemBondedEnergy);
                    ForceFieldEnergy forceFieldEnergy = this.this$0.forceFieldEnergy2;
                    if (forceFieldEnergy instanceof OpenMMEnergy) {
                        OpenMMEnergy openMMEnergy = (OpenMMEnergy)forceFieldEnergy;
                        this.this$0.restraintEnergy2 = openMMEnergy.energyFFX(this.this$0.x2, this.verbose);
                    } else {
                        this.this$0.restraintEnergy2 = this.this$0.potential2.energy(this.this$0.x2, this.verbose);
                    }
                    this.this$0.forceFieldEnergy2.setLambdaBondedTerms(false, false);
                } else {
                    this.this$0.restraintEnergy2 = 0.0;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Topology 2 Energy & Restraints: %15.8f %15.8f", this.this$0.f2L * this.this$0.energy2, this.this$0.f1L * this.this$0.restraintEnergy2));
                }
            }
        }

        public void setGradient(boolean grad) {
            this.gradient = grad;
        }

        public void setVerbose(boolean verb) {
            this.verbose = verb;
        }
    }

    private class Energy1Section
    extends ParallelSection {
        private boolean gradient;
        private boolean verbose;
        final /* synthetic */ DualTopologyEnergy this$0;

        private Energy1Section(DualTopologyEnergy dualTopologyEnergy) {
            DualTopologyEnergy dualTopologyEnergy2 = dualTopologyEnergy;
            Objects.requireNonNull(dualTopologyEnergy2);
            this.this$0 = dualTopologyEnergy2;
            this.gradient = false;
            this.verbose = false;
        }

        public void run() {
            if (this.gradient) {
                Arrays.fill(this.this$0.gl1, 0.0);
                Arrays.fill(this.this$0.rgl1, 0.0);
                this.this$0.energy1 = this.this$0.potential1.energyAndGradient(this.this$0.x1, this.this$0.g1, this.verbose);
                this.this$0.dEdL_1 = this.this$0.lambdaInterface1.getdEdL();
                this.this$0.d2EdL2_1 = this.this$0.lambdaInterface1.getd2EdL2();
                this.this$0.lambdaInterface1.getdEdXdL(this.this$0.gl1);
                if (this.this$0.doValenceRestraint1) {
                    if (this.verbose) {
                        logger.info(" Calculating lambda bonded terms for topology 1");
                    }
                    this.this$0.forceFieldEnergy1.setLambdaBondedTerms(true, this.this$0.useFirstSystemBondedEnergy);
                    ForceFieldEnergy forceFieldEnergy = this.this$0.forceFieldEnergy1;
                    if (forceFieldEnergy instanceof OpenMMEnergy) {
                        OpenMMEnergy openMMEnergy = (OpenMMEnergy)forceFieldEnergy;
                        this.this$0.restraintEnergy1 = openMMEnergy.energyAndGradientFFX(this.this$0.x1, this.this$0.rg1, this.verbose);
                    } else {
                        this.this$0.restraintEnergy1 = this.this$0.forceFieldEnergy1.energyAndGradient(this.this$0.x1, this.this$0.rg1, this.verbose);
                    }
                    this.this$0.restraintdEdL_1 = this.this$0.forceFieldEnergy1.getdEdL();
                    this.this$0.restraintd2EdL2_1 = this.this$0.forceFieldEnergy1.getd2EdL2();
                    this.this$0.forceFieldEnergy1.getdEdXdL(this.this$0.rgl1);
                    this.this$0.forceFieldEnergy1.setLambdaBondedTerms(false, false);
                } else {
                    this.this$0.restraintEnergy1 = 0.0;
                    this.this$0.restraintdEdL_1 = 0.0;
                    this.this$0.restraintd2EdL2_1 = 0.0;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Topology 1 Energy & Restraints: %15.8f %15.8f\n", this.this$0.f1L * this.this$0.energy1, this.this$0.f2L * this.this$0.restraintEnergy1));
                    logger.fine(String.format(" Topology 1:    %15.8f * (%.2f)", this.this$0.energy1, this.this$0.f1L));
                    logger.fine(String.format(" T1 Restraints: %15.8f * (%.2f)", this.this$0.restraintEnergy1, this.this$0.f2L));
                }
            } else {
                this.this$0.energy1 = this.this$0.potential1.energy(this.this$0.x1, this.verbose);
                if (this.this$0.doValenceRestraint1) {
                    if (this.verbose) {
                        logger.info(" Calculating lambda bonded terms for topology 1");
                    }
                    this.this$0.forceFieldEnergy1.setLambdaBondedTerms(true, this.this$0.useFirstSystemBondedEnergy);
                    ForceFieldEnergy forceFieldEnergy = this.this$0.forceFieldEnergy1;
                    if (forceFieldEnergy instanceof OpenMMEnergy) {
                        OpenMMEnergy openMMEnergy = (OpenMMEnergy)forceFieldEnergy;
                        this.this$0.restraintEnergy1 = openMMEnergy.energyFFX(this.this$0.x1, this.verbose);
                    } else {
                        this.this$0.restraintEnergy1 = this.this$0.potential1.energy(this.this$0.x1, this.verbose);
                    }
                    this.this$0.forceFieldEnergy1.setLambdaBondedTerms(false, false);
                } else {
                    this.this$0.restraintEnergy1 = 0.0;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Topology 1 Energy & Restraints: %15.8f %15.8f\n", this.this$0.f1L * this.this$0.energy1, this.this$0.f2L * this.this$0.restraintEnergy1));
                }
            }
        }

        public void setGradient(boolean grad) {
            this.gradient = grad;
        }

        public void setVerbose(boolean verb) {
            this.verbose = verb;
        }
    }
}

