/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.Classifier;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.StringArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class StringArrayEncoding
implements Encoding<StringArray, ByteArray> {
    private Deque<Encoding<?, ?>> dataEncoding;
    private String stringData;
    private Deque<Encoding<?, ?>> offsetEncoding;
    private byte[] offsets;

    public StringArrayEncoding() {
    }

    public StringArrayEncoding(String stringData, byte[] offsets, Deque<Encoding<?, ?>> outputEncoding, Deque<Encoding<?, ?>> offsetEncoding) {
        this.dataEncoding = outputEncoding;
        this.stringData = stringData;
        this.offsetEncoding = offsetEncoding;
        this.offsets = offsets;
    }

    @Override
    public Map<String, Object> getMapRepresentation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kind", "StringArray");
        map.put("dataEncoding", this.toArray(this.dataEncoding));
        map.put("stringData", this.stringData);
        map.put("offsetEncoding", this.toArray(this.offsetEncoding));
        map.put("offsets", this.offsets);
        return map;
    }

    private Map<?, ?>[] toArray(Deque<Encoding<?, ?>> deque) {
        return (Map[])deque.stream().map(Encoding::getMapRepresentation).toArray(Map[]::new);
    }

    @Override
    public StringArray decode(ByteArray data) {
        int[] offsets = (int[])new ByteArray(this.offsets, this.offsetEncoding).decode().getData();
        data.setEncoding((Deque)this.dataEncoding);
        int[] indices = (int[])data.decode().getData();
        String[] strings = new String[offsets.length];
        strings[0] = "";
        for (int i = 1; i < offsets.length; ++i) {
            strings[i] = this.stringData.substring(offsets[i - 1], offsets[i]);
        }
        int offset = 0;
        String[] result = new String[indices.length];
        for (int index : indices) {
            result[offset++] = strings[index + 1];
        }
        return new StringArray((Object)result, data.getEncoding());
    }

    @Override
    public ByteArray encode(StringArray data) {
        String[] input = data.getData();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<String> strings = new ArrayList<String>();
        int[] outputArray = new int[input.length];
        ArrayList<Integer> offsetList = new ArrayList<Integer>();
        offsetList.add(0);
        int accLength = 0;
        int i = 0;
        for (String s : input) {
            int index;
            if (s == null) {
                outputArray[i++] = -1;
                continue;
            }
            if (map.containsKey(s)) {
                index = (Integer)map.get(s);
                outputArray[i++] = index;
                continue;
            }
            accLength += s.length();
            index = strings.size();
            strings.add(s);
            map.put(s, index);
            offsetList.add(accLength);
            outputArray[i++] = index;
        }
        int[] offsetArray = new int[offsetList.size()];
        for (int j = 0; j < offsetList.size(); ++j) {
            offsetArray[j] = (Integer)offsetList.get(j);
        }
        Int32Array offsetPlain = new Int32Array(offsetArray);
        EncodingStrategyHint offsetHint = Classifier.classify(offsetPlain);
        ByteArray offsets = Classifier.encode(offsetPlain, offsetHint.getEncoding());
        Int32Array outputPlain = new Int32Array(outputArray);
        EncodingStrategyHint outputHint = Classifier.classify(outputPlain);
        ByteArray output = Classifier.encode(outputPlain, outputHint.getEncoding());
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        this.offsets = offsets.getData();
        this.offsetEncoding = offsets.getEncoding();
        this.stringData = String.join((CharSequence)"", strings);
        this.dataEncoding = output.getEncoding();
        enc.add(this);
        return new ByteArray(output.getData(), (Deque<Encoding<?, ?>>)enc);
    }

    public String toString() {
        return "StringArrayEncoding{dataEncoding=" + String.valueOf(this.dataEncoding) + ", stringData='" + this.stringData + "', offsetEncoding=" + String.valueOf(this.offsetEncoding) + ", offsets=" + Arrays.toString(this.offsets) + "}";
    }
}

