/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.Classifier;
import org.rcsb.cif.binary.codec.MessagePackCodec;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.StringArray;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.Encoding;
import org.rcsb.cif.binary.encoding.FixedPointEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;
import org.rcsb.cif.binary.encoding.StringArrayEncoding;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.ValueKind;

public class BinaryCifWriter {
    private final CifOptions options;

    public BinaryCifWriter(CifOptions options) {
        this.options = options;
    }

    public byte[] write(CifFile cifFile) {
        Map<String, Object> file = this.encodeFile(cifFile);
        return MessagePackCodec.encode(file);
    }

    private Map<String, Object> encodeFile(CifFile cifFile) {
        LinkedHashMap<String, Object> file = new LinkedHashMap<String, Object>();
        file.put("encoder", this.options.getEncoder());
        file.put("version", "0.3.0");
        Object[] blocks = new Object[cifFile.getBlocks().size()];
        int blockCount = 0;
        file.put("dataBlocks", blocks);
        for (Block block : cifFile.getBlocks()) {
            LinkedHashMap<String, Object> block2 = new LinkedHashMap<String, Object>();
            String blockHeader = block.getBlockHeader();
            String header = blockHeader != null ? blockHeader.replaceAll("[ \n\t]", "").toUpperCase() : "UNKNOWN";
            block2.put("header", header);
            List filteredCategories = block.categories().filter(Category::isDefined).filter(category -> this.options.filterCategory(category.getCategoryName())).collect(Collectors.toList());
            Object[] categories = new Object[filteredCategories.size()];
            int categoryCount = 0;
            block2.put("categories", categories);
            blocks[blockCount++] = block2;
            for (Category category2 : filteredCategories) {
                String categoryName = category2.getCategoryName();
                int rowCount = category2.getRowCount();
                LinkedHashMap<String, Object> categoryMap = new LinkedHashMap<String, Object>();
                categoryMap.put("name", "_" + category2.getCategoryName());
                Object[] columns = category2.columns().filter(column -> this.options.filterColumn(categoryName, column.getColumnName())).map(column -> this.encodeColumn(categoryName, (Column<?>)column)).toArray();
                categoryMap.put("columns", columns);
                categoryMap.put("rowCount", rowCount);
                categories[categoryCount++] = categoryMap;
            }
        }
        return file;
    }

    private ByteArray encodeFloatArray(Float64Array column, EncodingStrategyHint optional) {
        EncodingStrategyHint hint;
        EncodingStrategyHint encodingStrategyHint = hint = optional != null ? optional : Classifier.classify(column);
        if (hint.getEncoding() == null) {
            hint.setEncoding(Classifier.classify(column).getEncoding());
        }
        if ("byte".equals(hint.getEncoding())) {
            return column.encode();
        }
        if (hint.getPrecision() == null) {
            hint.setPrecision(Classifier.classify(column).getPrecision());
        }
        int multiplier = BinaryCifWriter.getMultiplier(hint.getPrecision());
        Int32Array fixedPoint = column.encode(new FixedPointEncoding(multiplier));
        return Classifier.encode(fixedPoint, hint.getEncoding());
    }

    private static int getMultiplier(int mantissaDigits) {
        int m = 1;
        for (int i = 0; i < mantissaDigits; ++i) {
            m *= 10;
        }
        return m;
    }

    private ByteArray encodeIntArray(Int32Array column, EncodingStrategyHint optional) {
        String encoding = optional != null && optional.getEncoding() != null ? optional.getEncoding() : Classifier.classify(column).getEncoding();
        return Classifier.encode(column, encoding);
    }

    private Map<String, Object> encodeColumn(String categoryName, Column<?> cifColumn) {
        EncodingStrategyHint optional = this.options.getEncodingStrategyHint(categoryName, cifColumn.getColumnName()).orElse(null);
        ColumnType type = ColumnType.of(cifColumn);
        switch (type.ordinal()) {
            case 2: {
                return this.encodeStr(cifColumn);
            }
            case 1: {
                return this.encodeFloat(cifColumn, optional);
            }
            case 0: {
                return this.encodeInt(cifColumn, optional);
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)type) + " not handled");
    }

    private Map<String, Object> encodeStr(Column<?> cifColumn) {
        String[] array = cifColumn instanceof StrColumn ? (String[])((StrColumn)cifColumn).getArray() : (String[])cifColumn.stringData().toArray(String[]::new);
        ByteArray byteArray = new StringArray(array).encode(new StringArrayEncoding());
        return this.encodeColumnUsingByteArray(cifColumn, byteArray);
    }

    private Map<String, Object> encodeFloat(Column<?> cifColumn, EncodingStrategyHint optional) {
        double[] array = cifColumn instanceof FloatColumn ? (double[])((FloatColumn)cifColumn).getArray() : cifColumn.stringData().mapToDouble(FloatColumn::parseFloat).toArray();
        ByteArray byteArray = this.encodeFloatArray(new Float64Array(array), optional);
        return this.encodeColumnUsingByteArray(cifColumn, byteArray);
    }

    private Map<String, Object> encodeInt(Column<?> cifColumn, EncodingStrategyHint optional) {
        int[] array = cifColumn instanceof IntColumn ? (int[])((IntColumn)cifColumn).getArray() : cifColumn.stringData().mapToInt(IntColumn::parseInt).toArray();
        ByteArray byteArray = this.encodeIntArray(new Int32Array(array), optional);
        return this.encodeColumnUsingByteArray(cifColumn, byteArray);
    }

    private Map<String, Object> encodeColumnUsingByteArray(Column<?> cifField, ByteArray byteArray) {
        String name = cifField.getColumnName();
        int[] maskArray = new int[cifField.getRowCount()];
        Uint8Array mask = new Uint8Array(maskArray);
        boolean allPresent = true;
        for (int row = 0; row < maskArray.length; ++row) {
            ValueKind kind = cifField.getValueKind(row);
            if (kind != ValueKind.PRESENT) {
                maskArray[row] = (byte)kind.ordinal();
                allPresent = false;
                continue;
            }
            maskArray[row] = (byte)ValueKind.PRESENT.ordinal();
        }
        LinkedHashMap<String, A[]> encodedMap = new LinkedHashMap<String, A[]>();
        encodedMap.put("encoding", byteArray.getEncoding().stream().map(Encoding::getMapRepresentation).toArray(Map[]::new));
        encodedMap.put("data", byteArray.getData());
        LinkedHashMap<String, Object[]> maskData = null;
        if (!allPresent) {
            maskData = new LinkedHashMap<String, Object[]>();
            ByteArray maskRLE = mask.encode(new RunLengthEncoding()).encode();
            if (maskRLE.getData().length < mask.getData().length) {
                RunLengthEncoding rle = (RunLengthEncoding)maskRLE.getEncoding().getFirst();
                maskData.put("encoding", new Object[]{rle.getMapRepresentation(), ByteArrayEncoding.INT32.getMapRepresentation()});
                maskData.put("data", maskRLE.getData());
            } else {
                ByteArray encodedMask = mask.encode();
                maskData.put("encoding", new Object[]{ByteArrayEncoding.UINT8.getMapRepresentation()});
                maskData.put("data", encodedMask.getData());
            }
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", name);
        map.put("data", encodedMap);
        map.put("mask", maskData);
        return map;
    }

    static enum ColumnType {
        Int,
        Float,
        Str;


        static ColumnType of(Column<?> column) {
            int floatCount = 0;
            boolean hasStringOrScientific = false;
            int undefinedCount = 0;
            for (int i = 0; i < column.getRowCount(); ++i) {
                ValueKind valueKind = column.getValueKind(i);
                if (valueKind != ValueKind.PRESENT) {
                    ++undefinedCount;
                    continue;
                }
                NumberType type = NumberType.of(column.getStringData(i));
                if (type == NumberType.Int) continue;
                if (type == NumberType.Float) {
                    ++floatCount;
                    continue;
                }
                hasStringOrScientific = true;
                break;
            }
            if (hasStringOrScientific || undefinedCount == column.getRowCount()) {
                return Str;
            }
            if (floatCount > 0) {
                return Float;
            }
            return Int;
        }
    }

    static enum NumberType {
        Int,
        Float,
        Scientific,
        NaN;


        static NumberType of(String v) {
            int start = 0;
            int end = v.length();
            if (v.charAt(start) == '-') {
                ++start;
            }
            if (v.charAt(start) == '.' && end - start == 1) {
                return NaN;
            }
            while (start < end) {
                char c = v.charAt(start);
                if (c >= '0' && c < ':') {
                    ++start;
                    continue;
                }
                if (c == '.') {
                    ++start;
                    boolean hasDigit = false;
                    while (start < end) {
                        c = v.charAt(start);
                        if (c >= '0' && c < ':') {
                            hasDigit = true;
                            ++start;
                            continue;
                        }
                        if (c == 'e' || c == 'E') {
                            return NumberType.getNumberTypeScientific(v, start + 1, end);
                        }
                        return NaN;
                    }
                    return hasDigit ? Float : Int;
                }
                if (c != 'e' && c != 'E') break;
                if (start == 0 || start == 1 && v.charAt(0) == '-') {
                    return NaN;
                }
                return NumberType.getNumberTypeScientific(v, start + 1, end);
            }
            if (end >= 10) {
                try {
                    Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    return NaN;
                }
            }
            return start == end ? Int : NaN;
        }

        static NumberType getNumberTypeScientific(String v, int start, int end) {
            if (start >= v.length()) {
                return NaN;
            }
            if (v.charAt(start) == '+') {
                ++start;
            }
            return NumberType.isInt(v, start, end) ? Scientific : NaN;
        }

        static boolean isInt(String v, int start, int end) {
            if (v.charAt(start) == '-') {
                ++start;
            }
            while (start < end) {
                int c = v.charAt(start) - 48;
                if (c > 9 || c < 0) {
                    return false;
                }
                ++start;
            }
            return true;
        }
    }
}

