/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm.drude;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMDrudeLibrary;
import ffx.openmm.Integrator;

public class DrudeIntegrator
extends Integrator {
    public DrudeIntegrator(PointerByReference pointer) {
        super(pointer);
    }

    public DrudeIntegrator(double stepSize) {
        super(OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_create((double)stepSize));
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getDrudeTemperature() {
        return OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_getDrudeTemperature((PointerByReference)this.pointer);
    }

    public double getMaxDrudeDistance() {
        return OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_getMaxDrudeDistance((PointerByReference)this.pointer);
    }

    public int getRandomNumberSeed() {
        return OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_getRandomNumberSeed((PointerByReference)this.pointer);
    }

    public void setDrudeTemperature(double temperature) {
        OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_setDrudeTemperature((PointerByReference)this.pointer, (double)temperature);
    }

    public void setMaxDrudeDistance(double distance) {
        OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_setMaxDrudeDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setRandomNumberSeed(int seed) {
        OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_setRandomNumberSeed((PointerByReference)this.pointer, (int)seed);
    }

    @Override
    public void step(int steps) {
        OpenMMDrudeLibrary.OpenMM_DrudeIntegrator_step((PointerByReference)this.pointer, (int)steps);
    }
}

