/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm.amoeba;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMAmoebaLibrary;
import ffx.openmm.Context;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;

public class MultipoleForce
extends Force {
    public MultipoleForce() {
        super(OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_create());
    }

    public int addMultipole(double charge, DoubleArray molecularDipole, DoubleArray molecularQuadrupole, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY, double thole, double dampingFactor, double polarity) {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_addMultipole((PointerByReference)this.pointer, (double)charge, (PointerByReference)molecularDipole.getPointer(), (PointerByReference)molecularQuadrupole.getPointer(), (int)axisType, (int)multipoleAtomZ, (int)multipoleAtomX, (int)multipoleAtomY, (double)thole, (double)dampingFactor, (double)polarity);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    @Deprecated
    public double getAEwald() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getAEwald((PointerByReference)this.pointer);
    }

    public IntArray getCovalentMap(int i, int covalentType) {
        IntArray covalentMap = new IntArray(0);
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getCovalentMap((PointerByReference)this.pointer, (int)i, (int)covalentType, (PointerByReference)covalentMap.getPointer());
        }
        return covalentMap;
    }

    public IntArray getCovalentMaps(int i) {
        IntArray covalentMaps = new IntArray(0);
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getCovalentMaps((PointerByReference)this.pointer, (int)i, (PointerByReference)covalentMaps.getPointer());
        }
        return covalentMaps;
    }

    public double getCutoffDistance() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getCutoffDistance((PointerByReference)this.pointer);
    }

    public DoubleArray getElectrostaticPotential(Context context, DoubleArray points) {
        DoubleArray potential = new DoubleArray(0);
        if (context.hasContextPointer() && this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getElectrostaticPotential((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)points.getPointer(), (PointerByReference)potential.getPointer());
        }
        return potential;
    }

    public double getEwaldErrorTolerance() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getEwaldErrorTolerance((PointerByReference)this.pointer);
    }

    public PointerByReference getExtrapolationCoefficients() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getExtrapolationCoefficients((PointerByReference)this.pointer);
    }

    public void getInducedDipoles(Context context, DoubleArray inducedDipoles) {
        if (context.hasContextPointer() && this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getInducedDipoles((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)inducedDipoles.getPointer());
        }
    }

    public void getLabFramePermanentDipoles(Context context, DoubleArray dipoles) {
        if (context.hasContextPointer() && this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getLabFramePermanentDipoles((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)dipoles.getPointer());
        }
    }

    public void getMultipoleParameters(int index, DoubleByReference charge, PointerByReference molecularDipole, PointerByReference molecularQuadrupole, IntByReference axisType, IntByReference multipoleAtomZ, IntByReference multipoleAtomX, IntByReference multipoleAtomY, DoubleByReference thole, DoubleByReference dampingFactor, DoubleByReference polarity) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getMultipoleParameters((PointerByReference)this.pointer, (int)index, (DoubleByReference)charge, (PointerByReference)molecularDipole, (PointerByReference)molecularQuadrupole, (IntByReference)axisType, (IntByReference)multipoleAtomZ, (IntByReference)multipoleAtomX, (IntByReference)multipoleAtomY, (DoubleByReference)thole, (DoubleByReference)dampingFactor, (DoubleByReference)polarity);
    }

    public int getMutualInducedMaxIterations() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getMutualInducedMaxIterations((PointerByReference)this.pointer);
    }

    public double getMutualInducedTargetEpsilon() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getMutualInducedTargetEpsilon((PointerByReference)this.pointer);
    }

    public int getNonbondedMethod() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getNonbondedMethod((PointerByReference)this.pointer);
    }

    public int getNumMultipoles() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getNumMultipoles((PointerByReference)this.pointer);
    }

    public void getPMEParameters(DoubleByReference alpha, IntByReference nx, IntByReference ny, IntByReference nz) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getPMEParameters((PointerByReference)this.pointer, (DoubleByReference)alpha, (IntByReference)nx, (IntByReference)ny, (IntByReference)nz);
    }

    public void getPMEParametersInContext(Context context, DoubleByReference alpha, IntByReference nx, IntByReference ny, IntByReference nz) {
        if (context.hasContextPointer() && this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getPMEParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (DoubleByReference)alpha, (IntByReference)nx, (IntByReference)ny, (IntByReference)nz);
        }
    }

    public IntArray getPmeGridDimensions() {
        IntArray gridDimensions = new IntArray(0);
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getPmeGridDimensions((PointerByReference)this.pointer, (PointerByReference)gridDimensions.getPointer());
        }
        return gridDimensions;
    }

    public int getPmeBSplineOrder() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getPmeBSplineOrder((PointerByReference)this.pointer);
    }

    public int getPolarizationType() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getPolarizationType((PointerByReference)this.pointer);
    }

    public void getSystemMultipoleMoments(Context context, DoubleArray moments) {
        if (context.hasContextPointer() && this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getSystemMultipoleMoments((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)moments.getPointer());
        }
    }

    public void getTotalDipoles(Context context, DoubleArray dipoles) {
        if (context.hasContextPointer() && this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_getTotalDipoles((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)dipoles.getPointer());
        }
    }

    @Deprecated
    public void setAEwald(double aewald) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setAEwald((PointerByReference)this.pointer, (double)aewald);
    }

    public void setCovalentMap(int i, int covalentType, IntArray covalentMap) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setCovalentMap((PointerByReference)this.pointer, (int)i, (int)covalentType, (PointerByReference)covalentMap.getPointer());
    }

    public void setCutoffDistance(double cutoff) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setCutoffDistance((PointerByReference)this.pointer, (double)cutoff);
    }

    public void setEwaldErrorTolerance(double ewaldTolerance) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setEwaldErrorTolerance((PointerByReference)this.pointer, (double)ewaldTolerance);
    }

    public void setExtrapolationCoefficients(DoubleArray exptCoefficients) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setExtrapolationCoefficients((PointerByReference)this.pointer, (PointerByReference)exptCoefficients.getPointer());
    }

    public void setMultipoleParameters(int index, double charge, DoubleArray molecularDipole, DoubleArray molecularQuadrupole, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY, double thole, double dampingFactor, double polarity) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setMultipoleParameters((PointerByReference)this.pointer, (int)index, (double)charge, (PointerByReference)molecularDipole.getPointer(), (PointerByReference)molecularQuadrupole.getPointer(), (int)axisType, (int)multipoleAtomZ, (int)multipoleAtomX, (int)multipoleAtomY, (double)thole, (double)dampingFactor, (double)polarity);
    }

    public void setMutualInducedMaxIterations(int iterations) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setMutualInducedMaxIterations((PointerByReference)this.pointer, (int)iterations);
    }

    public void setMutualInducedTargetEpsilon(double epsilon) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setMutualInducedTargetEpsilon((PointerByReference)this.pointer, (double)epsilon);
    }

    public void setNonbondedMethod(int method) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setNonbondedMethod((PointerByReference)this.pointer, (int)method);
    }

    public void setPMEParameters(double alpha, int nx, int ny, int nz) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setPMEParameters((PointerByReference)this.pointer, (double)alpha, (int)nx, (int)ny, (int)nz);
    }

    public void setPmeGridDimensions(IntArray gridDimensions) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setPmeGridDimensions((PointerByReference)this.pointer, (PointerByReference)gridDimensions.getPointer());
    }

    public void setPolarizationType(int method) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_setPolarizationType((PointerByReference)this.pointer, (int)method);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMAmoebaLibrary.OpenMM_AmoebaMultipoleForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

