/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm.amoeba;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMAmoebaLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class HippoNonbondedForce
extends Force {
    public HippoNonbondedForce() {
        super(OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_create());
    }

    public int addException(int particle1, int particle2, double multipoleMultipoleScale, double dipoleMultipoleScale, double dipoleDipoleScale, double dispersionScale, double repulsionScale, double chargeTransferScale, int replace) {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_addException((PointerByReference)this.pointer, (int)particle1, (int)particle2, (double)multipoleMultipoleScale, (double)dipoleMultipoleScale, (double)dipoleDipoleScale, (double)dispersionScale, (double)repulsionScale, (double)chargeTransferScale, (int)replace);
    }

    public int addParticle(double charge, PointerByReference dipole, PointerByReference quadrupole, double coreCharge, double alpha, double epsilon, double damping, double c6, double pauliK, double pauliQ, double pauliAlpha, double polarizability, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY) {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_addParticle((PointerByReference)this.pointer, (double)charge, (PointerByReference)dipole, (PointerByReference)quadrupole, (double)coreCharge, (double)alpha, (double)epsilon, (double)damping, (double)c6, (double)pauliK, (double)pauliQ, (double)pauliAlpha, (double)polarizability, (int)axisType, (int)multipoleAtomZ, (int)multipoleAtomX, (int)multipoleAtomY);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getCutoffDistance() {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getCutoffDistance((PointerByReference)this.pointer);
    }

    public void getDPMEParameters(DoubleByReference alpha, IntByReference nx, IntByReference ny, IntByReference nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getDPMEParameters((PointerByReference)this.pointer, (DoubleByReference)alpha, (IntByReference)nx, (IntByReference)ny, (IntByReference)nz);
    }

    public void getDPMEParameters(DoubleBuffer alpha, IntBuffer nx, IntBuffer ny, IntBuffer nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getDPMEParameters((PointerByReference)this.pointer, (DoubleBuffer)alpha, (IntBuffer)nx, (IntBuffer)ny, (IntBuffer)nz);
    }

    public void getDPMEParametersInContext(Context context, DoubleByReference alpha, IntByReference nx, IntByReference ny, IntByReference nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getDPMEParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (DoubleByReference)alpha, (IntByReference)nx, (IntByReference)ny, (IntByReference)nz);
    }

    public void getDPMEParametersInContext(Context context, DoubleBuffer alpha, IntBuffer nx, IntBuffer ny, IntBuffer nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getDPMEParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (DoubleBuffer)alpha, (IntBuffer)nx, (IntBuffer)ny, (IntBuffer)nz);
    }

    public double getEwaldErrorTolerance() {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getEwaldErrorTolerance((PointerByReference)this.pointer);
    }

    public void getExceptionParameters(int index, IntByReference particle1, IntByReference particle2, DoubleByReference multipoleMultipoleScale, DoubleByReference dipoleMultipoleScale, DoubleByReference dipoleDipoleScale, DoubleByReference dispersionScale, DoubleByReference repulsionScale, DoubleByReference chargeTransferScale) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getExceptionParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle1, (IntByReference)particle2, (DoubleByReference)multipoleMultipoleScale, (DoubleByReference)dipoleMultipoleScale, (DoubleByReference)dipoleDipoleScale, (DoubleByReference)dispersionScale, (DoubleByReference)repulsionScale, (DoubleByReference)chargeTransferScale);
    }

    public void getExceptionParameters(int index, IntBuffer particle1, IntBuffer particle2, DoubleBuffer multipoleMultipoleScale, DoubleBuffer dipoleMultipoleScale, DoubleBuffer dipoleDipoleScale, DoubleBuffer dispersionScale, DoubleBuffer repulsionScale, DoubleBuffer chargeTransferScale) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getExceptionParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)particle1, (IntBuffer)particle2, (DoubleBuffer)multipoleMultipoleScale, (DoubleBuffer)dipoleMultipoleScale, (DoubleBuffer)dipoleDipoleScale, (DoubleBuffer)dispersionScale, (DoubleBuffer)repulsionScale, (DoubleBuffer)chargeTransferScale);
    }

    public PointerByReference getExtrapolationCoefficients() {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getExtrapolationCoefficients((PointerByReference)this.pointer);
    }

    public void getInducedDipoles(Context context, PointerByReference dipoles) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getInducedDipoles((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)dipoles);
    }

    public void getLabFramePermanentDipoles(Context context, PointerByReference dipoles) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getLabFramePermanentDipoles((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)dipoles);
    }

    public int getNonbondedMethod() {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getNonbondedMethod((PointerByReference)this.pointer);
    }

    public int getNumExceptions() {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getNumExceptions((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getNumParticles((PointerByReference)this.pointer);
    }

    public void getPMEParameters(DoubleByReference alpha, IntByReference nx, IntByReference ny, IntByReference nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getPMEParameters((PointerByReference)this.pointer, (DoubleByReference)alpha, (IntByReference)nx, (IntByReference)ny, (IntByReference)nz);
    }

    public void getPMEParameters(DoubleBuffer alpha, IntBuffer nx, IntBuffer ny, IntBuffer nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getPMEParameters((PointerByReference)this.pointer, (DoubleBuffer)alpha, (IntBuffer)nx, (IntBuffer)ny, (IntBuffer)nz);
    }

    public void getPMEParametersInContext(Context context, DoubleByReference alpha, IntByReference nx, IntByReference ny, IntByReference nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getPMEParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (DoubleByReference)alpha, (IntByReference)nx, (IntByReference)ny, (IntByReference)nz);
    }

    public void getPMEParametersInContext(Context context, DoubleBuffer alpha, IntBuffer nx, IntBuffer ny, IntBuffer nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getPMEParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (DoubleBuffer)alpha, (IntBuffer)nx, (IntBuffer)ny, (IntBuffer)nz);
    }

    public void getParticleParameters(int index, DoubleByReference charge, PointerByReference dipole, PointerByReference quadrupole, DoubleByReference coreCharge, DoubleByReference alpha, DoubleByReference epsilon, DoubleByReference damping, DoubleByReference c6, DoubleByReference pauliK, DoubleByReference pauliQ, DoubleByReference pauliAlpha, DoubleByReference polarizability, IntByReference axisType, IntByReference multipoleAtomZ, IntByReference multipoleAtomX, IntByReference multipoleAtomY) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (DoubleByReference)charge, (PointerByReference)dipole, (PointerByReference)quadrupole, (DoubleByReference)coreCharge, (DoubleByReference)alpha, (DoubleByReference)epsilon, (DoubleByReference)damping, (DoubleByReference)c6, (DoubleByReference)pauliK, (DoubleByReference)pauliQ, (DoubleByReference)pauliAlpha, (DoubleByReference)polarizability, (IntByReference)axisType, (IntByReference)multipoleAtomZ, (IntByReference)multipoleAtomX, (IntByReference)multipoleAtomY);
    }

    public void getParticleParameters(int index, DoubleBuffer charge, PointerByReference dipole, PointerByReference quadrupole, DoubleBuffer coreCharge, DoubleBuffer alpha, DoubleBuffer epsilon, DoubleBuffer damping, DoubleBuffer c6, DoubleBuffer pauliK, DoubleBuffer pauliQ, DoubleBuffer pauliAlpha, DoubleBuffer polarizability, IntBuffer axisType, IntBuffer multipoleAtomZ, IntBuffer multipoleAtomX, IntBuffer multipoleAtomY) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (DoubleBuffer)charge, (PointerByReference)dipole, (PointerByReference)quadrupole, (DoubleBuffer)coreCharge, (DoubleBuffer)alpha, (DoubleBuffer)epsilon, (DoubleBuffer)damping, (DoubleBuffer)c6, (DoubleBuffer)pauliK, (DoubleBuffer)pauliQ, (DoubleBuffer)pauliAlpha, (DoubleBuffer)polarizability, (IntBuffer)axisType, (IntBuffer)multipoleAtomZ, (IntBuffer)multipoleAtomX, (IntBuffer)multipoleAtomY);
    }

    public double getSwitchingDistance() {
        return OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_getSwitchingDistance((PointerByReference)this.pointer);
    }

    public void setCutoffDistance(double distance) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setCutoffDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setDPMEParameters(double alpha, int nx, int ny, int nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setDPMEParameters((PointerByReference)this.pointer, (double)alpha, (int)nx, (int)ny, (int)nz);
    }

    public void setEwaldErrorTolerance(double tolerance) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setEwaldErrorTolerance((PointerByReference)this.pointer, (double)tolerance);
    }

    public void setExceptionParameters(int index, int particle1, int particle2, double multipoleMultipoleScale, double dipoleMultipoleScale, double dipoleDipoleScale, double dispersionScale, double repulsionScale, double chargeTransferScale) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setExceptionParameters((PointerByReference)this.pointer, (int)index, (int)particle1, (int)particle2, (double)multipoleMultipoleScale, (double)dipoleMultipoleScale, (double)dipoleDipoleScale, (double)dispersionScale, (double)repulsionScale, (double)chargeTransferScale);
    }

    public void setExtrapolationCoefficients(PointerByReference coefficients) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setExtrapolationCoefficients((PointerByReference)this.pointer, (PointerByReference)coefficients);
    }

    public void setNonbondedMethod(int method) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setNonbondedMethod((PointerByReference)this.pointer, (int)method);
    }

    public void setPMEParameters(double alpha, int nx, int ny, int nz) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setPMEParameters((PointerByReference)this.pointer, (double)alpha, (int)nx, (int)ny, (int)nz);
    }

    public void setParticleParameters(int index, double charge, PointerByReference dipole, PointerByReference quadrupole, double coreCharge, double alpha, double epsilon, double damping, double c6, double pauliK, double pauliQ, double pauliAlpha, double polarizability, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (double)charge, (PointerByReference)dipole, (PointerByReference)quadrupole, (double)coreCharge, (double)alpha, (double)epsilon, (double)damping, (double)c6, (double)pauliK, (double)pauliQ, (double)pauliAlpha, (double)polarizability, (int)axisType, (int)multipoleAtomZ, (int)multipoleAtomX, (int)multipoleAtomY);
    }

    public void setSwitchingDistance(double distance) {
        OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_setSwitchingDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMAmoebaLibrary.OpenMM_HippoNonbondedForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

