/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm.amoeba;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMAmoebaLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;

public class GeneralizedKirkwoodForce
extends Force {
    public GeneralizedKirkwoodForce() {
        super(OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_create());
    }

    public int addParticle(double charge, double radius, double scalingFactor) {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_addParticle((PointerByReference)this.pointer, (double)charge, (double)radius, (double)scalingFactor);
    }

    public int addParticle(double charge, double radius, double scalingFactor, double descreenRadius, double neckFactor) {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_addParticle_1((PointerByReference)this.pointer, (double)charge, (double)radius, (double)scalingFactor, (double)descreenRadius, (double)neckFactor);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getDescreenOffset() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getDescreenOffset((PointerByReference)this.pointer);
    }

    public double getDielectricOffset() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getDielectricOffset((PointerByReference)this.pointer);
    }

    public int getIncludeCavityTerm() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getIncludeCavityTerm((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getNumParticles((PointerByReference)this.pointer);
    }

    public void getParticleParameters(int index, DoubleByReference charge, DoubleByReference radius, DoubleByReference scalingFactor, DoubleByReference descreenRadius, DoubleByReference neckFactor) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (DoubleByReference)charge, (DoubleByReference)radius, (DoubleByReference)scalingFactor, (DoubleByReference)descreenRadius, (DoubleByReference)neckFactor);
    }

    public double getProbeRadius() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getProbeRadius((PointerByReference)this.pointer);
    }

    public double getSoluteDielectric() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getSoluteDielectric((PointerByReference)this.pointer);
    }

    public double getSolventDielectric() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getSolventDielectric((PointerByReference)this.pointer);
    }

    public double getSurfaceAreaFactor() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getSurfaceAreaFactor((PointerByReference)this.pointer);
    }

    public void getTanhParameters(DoubleByReference b0, DoubleByReference b1, DoubleByReference b2) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getTanhParameters((PointerByReference)this.pointer, (DoubleByReference)b0, (DoubleByReference)b1, (DoubleByReference)b2);
    }

    public int getTanhRescaling() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_getTanhRescaling((PointerByReference)this.pointer);
    }

    public void setDescreenOffset(double offset) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setDescreenOffset((PointerByReference)this.pointer, (double)offset);
    }

    public void setDielectricOffset(double offset) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setDielectricOffset((PointerByReference)this.pointer, (double)offset);
    }

    public void setIncludeCavityTerm(int includeCavityTerm) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setIncludeCavityTerm((PointerByReference)this.pointer, (int)includeCavityTerm);
    }

    public void setParticleParameters(int index, double charge, double radius, double scalingFactor, double descreenRadius, double neckFactor) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (double)charge, (double)radius, (double)scalingFactor, (double)descreenRadius, (double)neckFactor);
    }

    public void setProbeRadius(double radius) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setProbeRadius((PointerByReference)this.pointer, (double)radius);
    }

    public void setSoluteDielectric(double dielectric) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setSoluteDielectric((PointerByReference)this.pointer, (double)dielectric);
    }

    public void setSolventDielectric(double dielectric) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setSolventDielectric((PointerByReference)this.pointer, (double)dielectric);
    }

    public void setSurfaceAreaFactor(double surfaceAreaFactor) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setSurfaceAreaFactor((PointerByReference)this.pointer, (double)surfaceAreaFactor);
    }

    public void setTanhParameters(double beta0, double beta1, double beta2) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setTanhParameters((PointerByReference)this.pointer, (double)beta0, (double)beta1, (double)beta2);
    }

    public void setTanhRescaling(int tanhRescale) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_setTanhRescaling((PointerByReference)this.pointer, (int)tanhRescale);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMAmoebaLibrary.OpenMM_AmoebaGeneralizedKirkwoodForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

