/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.BondArray;
import ffx.openmm.Context;
import ffx.openmm.Force;

public class NonbondedForce
extends Force {
    public NonbondedForce() {
        super(OpenMMLibrary.OpenMM_NonbondedForce_create());
    }

    public int addException(int particle1, int particle2, double chargeProd, double sigma, double epsilon, boolean replace) {
        return OpenMMLibrary.OpenMM_NonbondedForce_addException((PointerByReference)this.pointer, (int)particle1, (int)particle2, (double)chargeProd, (double)sigma, (double)epsilon, (int)(replace ? 1 : 0));
    }

    public int addParticle(double charge, double sigma, double eps) {
        return OpenMMLibrary.OpenMM_NonbondedForce_addParticle((PointerByReference)this.pointer, (double)charge, (double)sigma, (double)eps);
    }

    public void createExceptionsFromBonds(BondArray bondArray, double coulomb14Scale, double lj14Scale) {
        OpenMMLibrary.OpenMM_NonbondedForce_createExceptionsFromBonds((PointerByReference)this.pointer, (PointerByReference)bondArray.getPointer(), (double)coulomb14Scale, (double)lj14Scale);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_NonbondedForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getCutoffDistance() {
        return OpenMMLibrary.OpenMM_NonbondedForce_getCutoffDistance((PointerByReference)this.pointer);
    }

    public void getExceptionParameters(int index, IntByReference particle1, IntByReference particle2, DoubleByReference chargeProd, DoubleByReference sigma, DoubleByReference eps) {
        OpenMMLibrary.OpenMM_NonbondedForce_getExceptionParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle1, (IntByReference)particle2, (DoubleByReference)chargeProd, (DoubleByReference)sigma, (DoubleByReference)eps);
    }

    public int getNumExceptions() {
        return OpenMMLibrary.OpenMM_NonbondedForce_getNumExceptions((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMLibrary.OpenMM_NonbondedForce_getNumParticles((PointerByReference)this.pointer);
    }

    public void getParticleParameters(int index, DoubleByReference charge, DoubleByReference sigma, DoubleByReference eps) {
        OpenMMLibrary.OpenMM_NonbondedForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (DoubleByReference)charge, (DoubleByReference)sigma, (DoubleByReference)eps);
    }

    public void setCutoffDistance(double cutoffDistance) {
        OpenMMLibrary.OpenMM_NonbondedForce_setCutoffDistance((PointerByReference)this.pointer, (double)cutoffDistance);
    }

    public void setExceptionParameters(int index, int particle1, int particle2, double chargeProd, double sigma, double eps) {
        OpenMMLibrary.OpenMM_NonbondedForce_setExceptionParameters((PointerByReference)this.pointer, (int)index, (int)particle1, (int)particle2, (double)chargeProd, (double)sigma, (double)eps);
    }

    public void setNonbondedMethod(int method) {
        OpenMMLibrary.OpenMM_NonbondedForce_setNonbondedMethod((PointerByReference)this.pointer, (int)method);
    }

    public void setPMEParameters(double aEwald, int nx, int ny, int nz) {
        OpenMMLibrary.OpenMM_NonbondedForce_setPMEParameters((PointerByReference)this.pointer, (double)aEwald, (int)nx, (int)ny, (int)nz);
    }

    public void setParticleParameters(int index, double charge, double sigma, double eps) {
        OpenMMLibrary.OpenMM_NonbondedForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (double)charge, (double)sigma, (double)eps);
    }

    public void setSwitchingDistance(double switchingDistance) {
        OpenMMLibrary.OpenMM_NonbondedForce_setSwitchingDistance((PointerByReference)this.pointer, (double)switchingDistance);
    }

    public void setUseDispersionCorrection(int useDispersionCorrection) {
        OpenMMLibrary.OpenMM_NonbondedForce_setUseDispersionCorrection((PointerByReference)this.pointer, (int)useDispersionCorrection);
    }

    public void setUseSwitchingFunction(int useSwitchingFunction) {
        OpenMMLibrary.OpenMM_NonbondedForce_setUseSwitchingFunction((PointerByReference)this.pointer, (int)useSwitchingFunction);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_NonbondedForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_NonbondedForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

