/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;

public class MonteCarloFlexibleBarostat
extends Force {
    public MonteCarloFlexibleBarostat(double defaultPressure, double defaultTemperature, int frequency, int scaleMoleculesAsRigid) {
        super(OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_create((double)defaultPressure, (double)defaultTemperature, (int)frequency, (int)scaleMoleculesAsRigid));
    }

    public void computeCurrentPressure(Context context, PointerByReference pressure) {
        OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_computeCurrentPressure((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)pressure);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getDefaultPressure() {
        return OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_getDefaultPressure((PointerByReference)this.pointer);
    }

    public double getDefaultTemperature() {
        return OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_getDefaultTemperature((PointerByReference)this.pointer);
    }

    public int getFrequency() {
        return OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_getFrequency((PointerByReference)this.pointer);
    }

    public int getRandomNumberSeed() {
        return OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_getRandomNumberSeed((PointerByReference)this.pointer);
    }

    public int getScaleMoleculesAsRigid() {
        return OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_getScaleMoleculesAsRigid((PointerByReference)this.pointer);
    }

    public void setDefaultPressure(double pressure) {
        OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_setDefaultPressure((PointerByReference)this.pointer, (double)pressure);
    }

    public void setDefaultTemperature(double temperature) {
        OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_setDefaultTemperature((PointerByReference)this.pointer, (double)temperature);
    }

    public void setFrequency(int frequency) {
        OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_setFrequency((PointerByReference)this.pointer, (int)frequency);
    }

    public void setRandomNumberSeed(int seed) {
        OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_setRandomNumberSeed((PointerByReference)this.pointer, (int)seed);
    }

    public void setScaleMoleculesAsRigid(int scaleMoleculesAsRigid) {
        OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_setScaleMoleculesAsRigid((PointerByReference)this.pointer, (int)scaleMoleculesAsRigid);
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_MonteCarloFlexibleBarostat_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

