/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;

public class MonteCarloBarostat
extends Force {
    public MonteCarloBarostat(double pressure, double temperature, int frequency) {
        super(OpenMMLibrary.OpenMM_MonteCarloBarostat_create((double)pressure, (double)temperature, (int)frequency));
    }

    public double computeCurrentPressure(Context context) {
        return OpenMMLibrary.OpenMM_MonteCarloBarostat_computeCurrentPressure((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_MonteCarloBarostat_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getDefaultPressure() {
        return OpenMMLibrary.OpenMM_MonteCarloBarostat_getDefaultPressure((PointerByReference)this.pointer);
    }

    public double getDefaultTemperature() {
        return OpenMMLibrary.OpenMM_MonteCarloBarostat_getDefaultTemperature((PointerByReference)this.pointer);
    }

    public int getFrequency() {
        return OpenMMLibrary.OpenMM_MonteCarloBarostat_getFrequency((PointerByReference)this.pointer);
    }

    public int getRandomNumberSeed() {
        return OpenMMLibrary.OpenMM_MonteCarloBarostat_getRandomNumberSeed((PointerByReference)this.pointer);
    }

    public void setDefaultPressure(double pressure) {
        OpenMMLibrary.OpenMM_MonteCarloBarostat_setDefaultPressure((PointerByReference)this.pointer, (double)pressure);
    }

    public void setDefaultTemperature(double temperature) {
        OpenMMLibrary.OpenMM_MonteCarloBarostat_setDefaultTemperature((PointerByReference)this.pointer, (double)temperature);
    }

    public void setFrequency(int frequency) {
        OpenMMLibrary.OpenMM_MonteCarloBarostat_setFrequency((PointerByReference)this.pointer, (int)frequency);
    }

    public void setRandomNumberSeed(int seed) {
        OpenMMLibrary.OpenMM_MonteCarloBarostat_setRandomNumberSeed((PointerByReference)this.pointer, (int)seed);
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int periodic = OpenMMLibrary.OpenMM_MonteCarloBarostat_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return periodic == 1;
    }
}

