/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;

public abstract class Force {
    protected PointerByReference pointer = null;
    private int forceIndex = -1;

    public Force(PointerByReference pointer) {
        if (pointer == null || pointer.getValue() == null) {
            throw new IllegalArgumentException("Pointer cannot be null.");
        }
        this.pointer = pointer;
    }

    public abstract void destroy();

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public void setForceGroup(int forceGroup) {
        OpenMMLibrary.OpenMM_Force_setForceGroup((PointerByReference)this.pointer, (int)forceGroup);
    }

    public int getForceGroup() {
        return OpenMMLibrary.OpenMM_Force_getForceGroup((PointerByReference)this.pointer);
    }

    public void setName(String name) {
        OpenMMLibrary.OpenMM_Force_setName((PointerByReference)this.pointer, (String)name);
    }

    public String getName() {
        Pointer pointer = OpenMMLibrary.OpenMM_Force_getName((PointerByReference)this.pointer);
        if (pointer == null) {
            return null;
        }
        return pointer.getString(0L);
    }

    public void setForceIndex(int forceIndex) {
        this.forceIndex = forceIndex;
    }

    public int getForceIndex() {
        return this.forceIndex;
    }

    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_Force_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

