/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import java.nio.DoubleBuffer;

public class CustomCompoundBondForce
extends Force {
    public CustomCompoundBondForce(int numParticles, String energy) {
        super(OpenMMLibrary.OpenMM_CustomCompoundBondForce_create((int)numParticles, (String)energy));
    }

    public int addBond(IntArray particles, DoubleArray parameters) {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_addBond((PointerByReference)this.pointer, (PointerByReference)particles.getPointer(), (PointerByReference)parameters.getPointer());
    }

    public void addEnergyParameterDerivative(String name) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (String)name);
    }

    @Deprecated
    public int addFunction(String name, PointerByReference values, double min, double max) {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_addFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)values, (double)min, (double)max);
    }

    public int addGlobalParameter(String name, double defaultValue) {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)defaultValue);
    }

    public int addPerBondParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_addPerBondParameter((PointerByReference)this.pointer, (String)name);
    }

    public int addTabulatedFunction(String name, PointerByReference function) {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_addTabulatedFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomCompoundBondForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getBondParameters(int index, IntArray particles, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_getBondParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)particles.getPointer(), (PointerByReference)parameters.getPointer());
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomCompoundBondForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getEnergyParameterDerivativeName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCompoundBondForce_getEnergyParameterDerivativeName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void getFunctionParameters(int index, PointerByReference name, PointerByReference values, DoubleBuffer min, DoubleBuffer max) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_getFunctionParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)name, (PointerByReference)values, (DoubleBuffer)min, (DoubleBuffer)max);
    }

    public void getFunctionParameters(int index, PointerByReference name, PointerByReference values, DoubleByReference min, DoubleByReference max) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_getFunctionParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)name, (PointerByReference)values, (DoubleByReference)min, (DoubleByReference)max);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCompoundBondForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getNumBonds() {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getNumBonds((PointerByReference)this.pointer);
    }

    public int getNumEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getNumEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    @Deprecated
    public int getNumFunctions() {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getNumFunctions((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumParticlesPerBond() {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getNumParticlesPerBond((PointerByReference)this.pointer);
    }

    public int getNumPerBondParameters() {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getNumPerBondParameters((PointerByReference)this.pointer);
    }

    public int getNumTabulatedFunctions() {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getNumTabulatedFunctions((PointerByReference)this.pointer);
    }

    public String getPerBondParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCompoundBondForce_getPerBondParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public PointerByReference getTabulatedFunction(int index) {
        return OpenMMLibrary.OpenMM_CustomCompoundBondForce_getTabulatedFunction((PointerByReference)this.pointer, (int)index);
    }

    public String getTabulatedFunctionName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCompoundBondForce_getTabulatedFunctionName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setBondParameters(int index, IntArray particles, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_setBondParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)particles.getPointer(), (PointerByReference)parameters.getPointer());
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setFunctionParameters(int index, String name, PointerByReference values, double min, double max) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_setFunctionParameters((PointerByReference)this.pointer, (int)index, (String)name, (PointerByReference)values, (double)min, (double)max);
    }

    public void setGlobalParameterDefaultValue(int index, double defaultValue) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)defaultValue);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setPerBondParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_setPerBondParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMLibrary.OpenMM_CustomCompoundBondForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomCompoundBondForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomCompoundBondForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

