/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;

public class CustomCentroidBondForce
extends Force {
    public CustomCentroidBondForce(int numGroups, String energy) {
        super(OpenMMLibrary.OpenMM_CustomCentroidBondForce_create((int)numGroups, (String)energy));
    }

    public int addBond(IntArray groups, DoubleArray parameters) {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_addBond((PointerByReference)this.pointer, (PointerByReference)groups.getPointer(), (PointerByReference)parameters.getPointer());
    }

    public void addEnergyParameterDerivative(String name) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (String)name);
    }

    public int addGlobalParameter(String name, double defaultValue) {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)defaultValue);
    }

    public int addGroup(IntArray particles, DoubleArray weights) {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_addGroup((PointerByReference)this.pointer, (PointerByReference)particles.getPointer(), (PointerByReference)weights.getPointer());
    }

    public int addPerBondParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_addPerBondParameter((PointerByReference)this.pointer, (String)name);
    }

    public int addTabulatedFunction(String name, PointerByReference function) {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_addTabulatedFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomCentroidBondForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getBondParameters(int index, IntArray groups, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_getBondParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)groups.getPointer(), (PointerByReference)parameters.getPointer());
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomCentroidBondForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getEnergyParameterDerivativeName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCentroidBondForce_getEnergyParameterDerivativeName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCentroidBondForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void getGroupParameters(int index, IntArray particles, DoubleArray weights) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_getGroupParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)particles.getPointer(), (PointerByReference)weights.getPointer());
    }

    public int getNumBonds() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumBonds((PointerByReference)this.pointer);
    }

    public int getNumEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    @Deprecated
    public int getNumFunctions() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumFunctions((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumGroups() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumGroups((PointerByReference)this.pointer);
    }

    public int getNumGroupsPerBond() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumGroupsPerBond((PointerByReference)this.pointer);
    }

    public int getNumPerBondParameters() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumPerBondParameters((PointerByReference)this.pointer);
    }

    public int getNumTabulatedFunctions() {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getNumTabulatedFunctions((PointerByReference)this.pointer);
    }

    public String getPerBondParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCentroidBondForce_getPerBondParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public PointerByReference getTabulatedFunction(int index) {
        return OpenMMLibrary.OpenMM_CustomCentroidBondForce_getTabulatedFunction((PointerByReference)this.pointer, (int)index);
    }

    public String getTabulatedFunctionName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCentroidBondForce_getTabulatedFunctionName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setBondParameters(int index, IntArray groups, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_setBondParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)groups.getPointer(), (PointerByReference)parameters.getPointer());
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setGlobalParameterDefaultValue(int index, double defaultValue) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)defaultValue);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setGroupParameters(int index, IntArray particles, DoubleArray weights) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_setGroupParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)particles.getPointer(), (PointerByReference)weights.getPointer());
    }

    public void setPerBondParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_setPerBondParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setUsesPeriodicBoundaryConditions(int periodic) {
        OpenMMLibrary.OpenMM_CustomCentroidBondForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)periodic);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomCentroidBondForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomCentroidBondForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

