/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import java.nio.IntBuffer;

public class CustomBondForce
extends Force {
    public CustomBondForce(String energy) {
        super(OpenMMLibrary.OpenMM_CustomBondForce_create((String)energy));
    }

    public int addBond(int i1, int i2, DoubleArray parameters) {
        return OpenMMLibrary.OpenMM_CustomBondForce_addBond((PointerByReference)this.pointer, (int)i1, (int)i2, (PointerByReference)parameters.getPointer());
    }

    public void addEnergyParameterDerivative(String name) {
        OpenMMLibrary.OpenMM_CustomBondForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (String)name);
    }

    public int addGlobalParameter(String name, double value) {
        return OpenMMLibrary.OpenMM_CustomBondForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)value);
    }

    public int addPerBondParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomBondForce_addPerBondParameter((PointerByReference)this.pointer, (String)name);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomBondForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getBondParameters(int index, IntBuffer i1, IntBuffer i2, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomBondForce_getBondParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)i1, (IntBuffer)i2, (PointerByReference)parameters.getPointer());
    }

    public void getBondParameters(int index, IntByReference i1, IntByReference i2, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomBondForce_getBondParameters((PointerByReference)this.pointer, (int)index, (IntByReference)i1, (IntByReference)i2, (PointerByReference)parameters.getPointer());
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomBondForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getEnergyParameterDerivativeName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomBondForce_getEnergyParameterDerivativeName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomBondForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomBondForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getNumBonds() {
        return OpenMMLibrary.OpenMM_CustomBondForce_getNumBonds((PointerByReference)this.pointer);
    }

    public int getNumEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_CustomBondForce_getNumEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomBondForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumPerBondParameters() {
        return OpenMMLibrary.OpenMM_CustomBondForce_getNumPerBondParameters((PointerByReference)this.pointer);
    }

    public String getPerBondParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomBondForce_getPerBondParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setBondParameters(int index, int i1, int i2, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomBondForce_setBondParameters((PointerByReference)this.pointer, (int)index, (int)i1, (int)i2, (PointerByReference)parameters.getPointer());
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_CustomBondForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setGlobalParameterDefaultValue(int index, double value) {
        OpenMMLibrary.OpenMM_CustomBondForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)value);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomBondForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setPerBondParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomBondForce_setPerBondParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMLibrary.OpenMM_CustomBondForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomBondForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomBondForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

