/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.ShaderAttributeObjectRetained;
import org.jogamp.vecmath.Matrix3f;
import org.jogamp.vecmath.Matrix4f;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Point2i;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Point3i;
import org.jogamp.vecmath.Point4f;
import org.jogamp.vecmath.Point4i;
import org.jogamp.vecmath.Tuple2f;
import org.jogamp.vecmath.Tuple2i;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Tuple3i;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Tuple4i;

class ShaderAttributeValueRetained
extends ShaderAttributeObjectRetained {
    ShaderAttributeValueRetained() {
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeValueRetained mirrorSAV = new ShaderAttributeValueRetained();
            mirrorSAV.createObjectData(this.getValue());
            this.mirror = mirrorSAV;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    @Override
    int computeClassType(Object value) {
        Class<?> objClass = value.getClass();
        if (objClass.isArray()) {
            throw new ClassCastException(objClass + " -- array class not allowed");
        }
        for (int i = 0; i < classTable.length; ++i) {
            if (!classTable[i].isInstance(value)) continue;
            return i;
        }
        throw new ClassCastException(objClass + " -- unrecognized class");
    }

    @Override
    Class getBaseClass(int classType) {
        return classTable[classType];
    }

    @Override
    ShaderAttributeObjectRetained.AttrWrapper createAttrWrapper(Object value, int classType) {
        ValueWrapper attrWrapper = null;
        switch (classType) {
            case 0: {
                attrWrapper = new IntegerWrapper();
                break;
            }
            case 1: {
                attrWrapper = new FloatWrapper();
                break;
            }
            case 2: {
                attrWrapper = new Tuple2iWrapper();
                break;
            }
            case 3: {
                attrWrapper = new Tuple2fWrapper();
                break;
            }
            case 4: {
                attrWrapper = new Tuple3iWrapper();
                break;
            }
            case 5: {
                attrWrapper = new Tuple3fWrapper();
                break;
            }
            case 6: {
                attrWrapper = new Tuple4iWrapper();
                break;
            }
            case 7: {
                attrWrapper = new Tuple4fWrapper();
                break;
            }
            case 8: {
                attrWrapper = new Matrix3fWrapper();
                break;
            }
            case 9: {
                attrWrapper = new Matrix4fWrapper();
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        attrWrapper.set(value);
        return attrWrapper;
    }

    static class Matrix4fWrapper
    extends ValueWrapper {
        private float[] value = new float[16];

        Matrix4fWrapper() {
        }

        @Override
        void set(Object value) {
            Matrix4f m = (Matrix4f)value;
            this.value[0] = m.m00;
            this.value[1] = m.m01;
            this.value[2] = m.m02;
            this.value[3] = m.m03;
            this.value[4] = m.m10;
            this.value[5] = m.m11;
            this.value[6] = m.m12;
            this.value[7] = m.m13;
            this.value[8] = m.m20;
            this.value[9] = m.m21;
            this.value[10] = m.m22;
            this.value[11] = m.m23;
            this.value[12] = m.m30;
            this.value[13] = m.m31;
            this.value[14] = m.m32;
            this.value[15] = m.m33;
        }

        @Override
        Object get() {
            return new Matrix4f(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Matrix3fWrapper
    extends ValueWrapper {
        private float[] value = new float[9];

        Matrix3fWrapper() {
        }

        @Override
        void set(Object value) {
            Matrix3f m = (Matrix3f)value;
            this.value[0] = m.m00;
            this.value[1] = m.m01;
            this.value[2] = m.m02;
            this.value[3] = m.m10;
            this.value[4] = m.m11;
            this.value[5] = m.m12;
            this.value[6] = m.m20;
            this.value[7] = m.m21;
            this.value[8] = m.m22;
        }

        @Override
        Object get() {
            return new Matrix3f(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4fWrapper
    extends ValueWrapper {
        private float[] value = new float[4];

        Tuple4fWrapper() {
        }

        @Override
        void set(Object value) {
            ((Tuple4f)value).get(this.value);
        }

        @Override
        Object get() {
            return new Point4f(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4iWrapper
    extends ValueWrapper {
        private int[] value = new int[4];

        Tuple4iWrapper() {
        }

        @Override
        void set(Object value) {
            ((Tuple4i)value).get(this.value);
        }

        @Override
        Object get() {
            return new Point4i(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3fWrapper
    extends ValueWrapper {
        private float[] value = new float[3];

        Tuple3fWrapper() {
        }

        @Override
        void set(Object value) {
            ((Tuple3f)value).get(this.value);
        }

        @Override
        Object get() {
            return new Point3f(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3iWrapper
    extends ValueWrapper {
        private int[] value = new int[3];

        Tuple3iWrapper() {
        }

        @Override
        void set(Object value) {
            ((Tuple3i)value).get(this.value);
        }

        @Override
        Object get() {
            return new Point3i(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2fWrapper
    extends ValueWrapper {
        private float[] value = new float[2];

        Tuple2fWrapper() {
        }

        @Override
        void set(Object value) {
            ((Tuple2f)value).get(this.value);
        }

        @Override
        Object get() {
            return new Point2f(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2iWrapper
    extends ValueWrapper {
        private int[] value = new int[2];

        Tuple2iWrapper() {
        }

        @Override
        void set(Object value) {
            ((Tuple2i)value).get(this.value);
        }

        @Override
        Object get() {
            return new Point2i(this.value);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class FloatWrapper
    extends ValueWrapper {
        private float[] value = new float[1];

        FloatWrapper() {
        }

        @Override
        void set(Object value) {
            this.value[0] = ((Float)value).floatValue();
        }

        @Override
        Object get() {
            return new Float(this.value[0]);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class IntegerWrapper
    extends ValueWrapper {
        private int[] value = new int[1];

        IntegerWrapper() {
        }

        @Override
        void set(Object value) {
            this.value[0] = (Integer)value;
        }

        @Override
        Object get() {
            return new Integer(this.value[0]);
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static abstract class ValueWrapper
    extends ShaderAttributeObjectRetained.AttrWrapper {
        ValueWrapper() {
        }
    }
}

