/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.SoundRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;

class PointSoundRetained
extends SoundRetained {
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    Point3f xformPosition = new Point3f();
    Transform3D trans = new Transform3D();
    float[] attenuationDistance;
    float[] attenuationGain;

    PointSoundRetained() {
        this.nodeType = 13;
    }

    void setPosition(Point3f position) {
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(position, this.position);
        } else {
            this.position.set((Tuple3f)position);
        }
        this.getLastLocalToVworld().transform(position, this.xformPosition);
        this.dispatchAttribChange(64, new Point3f(this.position));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setPosition(float x, float y, float z) {
        this.position.x = x;
        this.position.y = y;
        this.position.z = z;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position);
        }
        this.getLastLocalToVworld().transform(this.position, this.xformPosition);
        this.dispatchAttribChange(64, new Point3f(this.position));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getPosition(Point3f position) {
        if (this.staticTransform != null) {
            Transform3D invTransform = this.staticTransform.getInvTransform();
            invTransform.transform(this.position, position);
        } else {
            position.set((Tuple3f)this.position);
        }
    }

    void getXformPosition(Point3f position) {
        position.set((Tuple3f)this.xformPosition);
    }

    void setDistanceGain(Point2f[] attenuation) {
        if (attenuation == null) {
            this.attenuationDistance = null;
            this.attenuationGain = null;
            return;
        }
        int attenuationLength = attenuation.length;
        this.attenuationDistance = new float[attenuationLength];
        this.attenuationGain = new float[attenuationLength];
        for (int i = 0; i < attenuationLength; ++i) {
            this.attenuationDistance[i] = attenuation[i].x;
            this.attenuationGain[i] = attenuation[i].y;
        }
        this.dispatchAttribChange(128, attenuation);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setDistanceGain(float[] distance, float[] gain) {
        if (distance == null) {
            this.attenuationDistance = null;
            this.attenuationGain = null;
            return;
        }
        int gainLength = gain.length;
        int distanceLength = distance.length;
        this.attenuationDistance = new float[distanceLength];
        this.attenuationGain = new float[distanceLength];
        System.arraycopy(distance, 0, this.attenuationDistance, 0, distanceLength);
        if (distanceLength <= gainLength) {
            System.arraycopy(gain, 0, this.attenuationGain, 0, distanceLength);
        } else {
            System.arraycopy(gain, 0, this.attenuationGain, 0, gainLength);
            for (int i = gainLength; i < distanceLength; ++i) {
                this.attenuationGain[i] = gain[gainLength - 1];
            }
        }
        Point2f[] attenuation = new Point2f[distanceLength];
        for (int i = 0; i < distanceLength; ++i) {
            attenuation[i] = new Point2f(this.attenuationDistance[i], this.attenuationGain[i]);
        }
        this.dispatchAttribChange(128, attenuation);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getDistanceGainLength() {
        if (this.attenuationDistance == null) {
            return 0;
        }
        return this.attenuationDistance.length;
    }

    void getDistanceGain(Point2f[] attenuation) {
        if (attenuation == null) {
            return;
        }
        if (this.attenuationDistance == null || this.attenuationGain == null) {
            return;
        }
        int distanceLength = this.attenuationDistance.length;
        int attenuationLength = attenuation.length;
        if (distanceLength > attenuationLength) {
            distanceLength = attenuationLength;
        }
        for (int i = 0; i < distanceLength; ++i) {
            attenuation[i].x = this.attenuationDistance[i];
            attenuation[i].y = this.attenuationGain[i];
        }
    }

    void getDistanceGain(float[] distance, float[] gain) {
        if (distance == null || gain == null) {
            return;
        }
        if (this.attenuationDistance == null || this.attenuationGain == null) {
            return;
        }
        int distanceLength = distance.length;
        int attenuationLength = this.attenuationDistance.length;
        if (distanceLength > attenuationLength) {
            distanceLength = attenuationLength;
        }
        System.arraycopy(this.attenuationDistance, 0, distance, 0, distanceLength);
        attenuationLength = this.attenuationDistance.length;
        int gainLength = gain.length;
        if (gainLength > attenuationLength) {
            gainLength = attenuationLength;
        }
        System.arraycopy(this.attenuationGain, 0, gain, 0, gainLength);
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        int numSnds = (Integer)objs[2];
        SoundRetained[] mSnds = (SoundRetained[])objs[3];
        if (component == -1) {
            this.initMirrorObject((PointSoundRetained)objs[2]);
            return;
        }
        if ((component & 0x40) != 0) {
            for (int i = 0; i < numSnds; ++i) {
                PointSoundRetained point = (PointSoundRetained)mSnds[i];
                Object o = objs[4];
                if (!(o instanceof Point3f)) continue;
                point.position = (Point3f)objs[4];
                point.getLastLocalToVworld().transform(point.position, point.xformPosition);
            }
        }
        super.updateMirrorObject(objs);
    }

    synchronized void initMirrorObject(PointSoundRetained ms) {
        super.initMirrorObject(ms);
        ms.position.set((Tuple3f)this.position);
        ms.xformPosition.set((Tuple3f)this.xformPosition);
    }

    @Override
    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.position, this.xformPosition);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        xform.transform.transform(this.position, this.position);
    }
}

