/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Hashtable;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.RestrictedAccessException;
import org.jogamp.java3d.SceneGraphCycleException;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Transform3D;

public abstract class Node
extends SceneGraphObject {
    public static final int ENABLE_PICK_REPORTING = 1;
    public static final int ENABLE_COLLISION_REPORTING = 0;
    public static final int ALLOW_BOUNDS_READ = 3;
    public static final int ALLOW_BOUNDS_WRITE = 4;
    public static final int ALLOW_PICKABLE_READ = 5;
    public static final int ALLOW_PICKABLE_WRITE = 6;
    public static final int ALLOW_COLLIDABLE_READ = 7;
    public static final int ALLOW_COLLIDABLE_WRITE = 8;
    public static final int ALLOW_AUTO_COMPUTE_BOUNDS_READ = 9;
    public static final int ALLOW_AUTO_COMPUTE_BOUNDS_WRITE = 10;
    public static final int ALLOW_LOCAL_TO_VWORLD_READ = 11;
    public static final int ALLOW_PARENT_READ = 46;
    public static final int ALLOW_LOCALE_READ = 47;
    private static final int[] readCapabilities = new int[]{3, 5, 7, 9, 11, 46, 47};
    private boolean visited = false;

    public Node() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Node getParent() {
        if (this.isLiveOrCompiled() && !this.getCapability(46)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node0"));
        }
        NodeRetained nr = ((NodeRetained)this.retained).getParent();
        return nr == null ? null : (Node)nr.getSource();
    }

    public void setBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node1"));
        }
        ((NodeRetained)this.retained).setBounds(bounds);
    }

    public Bounds getBounds() {
        if (this.isLiveOrCompiled()) {
            if (!this.getCapability(3)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Node2"));
            }
        } else {
            this.checkForCycle();
        }
        return ((NodeRetained)this.retained).getBounds();
    }

    public boolean getCollidable() {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node16"));
        }
        return ((NodeRetained)this.retained).getCollidable();
    }

    public void setCollidable(boolean collidable) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node4"));
        }
        ((NodeRetained)this.retained).setCollidable(collidable);
    }

    public void setBoundsAutoCompute(boolean autoCompute) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node5"));
        }
        ((NodeRetained)this.retained).setBoundsAutoCompute(autoCompute);
    }

    public boolean getBoundsAutoCompute() {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node6"));
        }
        return ((NodeRetained)this.retained).getBoundsAutoCompute();
    }

    public void getLocalToVworld(Transform3D t) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node8"));
        }
        if (!this.isLive()) {
            if (this.isCompiled()) {
                throw new RestrictedAccessException(J3dI18N.getString("Node7"));
            }
            ((NodeRetained)this.retained).computeNonLiveLocalToVworld(t, this);
        } else {
            ((NodeRetained)this.retained).getLocalToVworld(t);
        }
    }

    public void getLocalToVworld(SceneGraphPath path, Transform3D t) {
        if (!this.isLive()) {
            throw new RestrictedAccessException(J3dI18N.getString("Node7"));
        }
        if (!this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node8"));
        }
        ((NodeRetained)this.retained).getLocalToVworld(path, t);
    }

    public Locale getLocale() {
        if (!this.isLive()) {
            return null;
        }
        if (!this.getCapability(47)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node17"));
        }
        return ((NodeRetained)this.retained).getLocale();
    }

    public Node cloneTree() {
        return this.cloneTree(new NodeReferenceTable(), false, false);
    }

    public Node cloneTree(boolean forceDuplicate) {
        return this.cloneTree(new NodeReferenceTable(), forceDuplicate, false);
    }

    public Node cloneTree(boolean forceDuplicate, boolean allowDanglingReferences) {
        return this.cloneTree(new NodeReferenceTable(), forceDuplicate, allowDanglingReferences);
    }

    public Node cloneTree(NodeReferenceTable referenceTable) {
        return this.cloneTree(referenceTable, false, false);
    }

    public Node cloneTree(NodeReferenceTable referenceTable, boolean forceDuplicate) {
        return this.cloneTree(referenceTable, forceDuplicate, false);
    }

    public Node cloneTree(NodeReferenceTable referenceTable, boolean forceDuplicate, boolean allowDanglingReferences) {
        if (!this.isLiveOrCompiled()) {
            this.checkForCycle();
        }
        referenceTable.set(allowDanglingReferences, new Hashtable());
        Node n = this.cloneTree(forceDuplicate, referenceTable.objectHashtable);
        for (SceneGraphObject o : referenceTable.objectHashtable.values()) {
            o.updateNodeReferences(referenceTable);
        }
        return n;
    }

    Node cloneTree(boolean forceDuplicate, Hashtable nodeHashtable) {
        Node l;
        this.nodeHashtable = nodeHashtable;
        try {
            l = this.cloneNode(forceDuplicate);
        }
        catch (RuntimeException e) {
            this.nodeHashtable = null;
            throw e;
        }
        this.nodeHashtable = null;
        nodeHashtable.put(this, l);
        return l;
    }

    public Node cloneNode(boolean forceDuplicate) {
        throw new RuntimeException(J3dI18N.getString("Node12"));
    }

    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.duplicateAttributes(originalNode, forceDuplicate);
    }

    final void checkDuplicateNode(Node originalNode, boolean forceDuplicate) {
        if (originalNode.nodeHashtable != null) {
            this.duplicateAttributes(originalNode, forceDuplicate);
        } else {
            originalNode.nodeHashtable = new Hashtable();
            this.duplicateAttributes(originalNode, forceDuplicate);
            originalNode.nodeHashtable = null;
        }
    }

    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        if (originalNode.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("Node13"));
        }
        super.duplicateSceneGraphObject(originalNode);
        NodeRetained attr = (NodeRetained)originalNode.retained;
        NodeRetained rt = (NodeRetained)this.retained;
        rt.setPickable(attr.getPickable());
        rt.setCollidable(attr.getCollidable());
    }

    public void setPickable(boolean pickable) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node14"));
        }
        ((NodeRetained)this.retained).setPickable(pickable);
    }

    public boolean getPickable() {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node3"));
        }
        return ((NodeRetained)this.retained).getPickable();
    }

    void checkForCycle() {
        if (this.visited) {
            throw new SceneGraphCycleException(J3dI18N.getString("Node15"));
        }
        this.visited = true;
        Node parent = this.getParent();
        if (parent != null) {
            parent.checkForCycle();
        }
        this.visited = false;
    }
}

