/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.Jogl2es2MatrixUtil;
import org.jogamp.java3d.Jogl2es2PerFrameStats;
import org.jogamp.java3d.JoglContext;
import org.jogamp.java3d.JoglShaderObject;
import org.jogamp.java3d.SparseArray;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector3f;
import org.jogamp.vecmath.Vector4f;

public class Jogl2es2Context
extends JoglContext {
    public JoglShaderObject shaderProgram;
    public int shaderProgramId = -1;
    public ProgramData programData;
    public ArrayList<GeometryArrayRetained> geoToClearBuffers = new ArrayList();
    public SparseArray<GeometryData> allGeometryData = new SparseArray();
    public SparseArray<ProgramData> allProgramData = new SparseArray();
    public fogData fogData = new fogData();
    public glFrontMaterial materialData = new glFrontMaterial();
    public static int MAX_LIGHTS = 32;
    public int maxLights;
    public int numberOfLights;
    public glLightSource[] glLightSource = new glLightSource[MAX_LIGHTS];
    public Vector4f objectColor = new Vector4f();
    public float pointSize = 0.0f;
    public int polygonMode = 2;
    public RenderingData renderingData = new RenderingData();
    public float transparencyAlpha = 0.0f;
    public Vector4f currentAmbientColor = new Vector4f();
    public Matrix4d textureTransform = new Matrix4d();
    public Matrix4d currentModelMat = new Matrix4d();
    public Matrix4d currentViewMat = new Matrix4d();
    public Matrix4d currentModelViewMat = new Matrix4d();
    public Matrix4d currentModelViewMatInverse = new Matrix4d();
    public Matrix4d currentModelViewProjMat = new Matrix4d();
    public Matrix3d currentNormalMat = new Matrix3d();
    public Matrix4d currentProjMat = new Matrix4d();
    public Matrix4d currentProjMatInverse = new Matrix4d();
    public GL_State gl_state = new GL_State();
    public int prevShaderProgram;
    public Jogl2es2PerFrameStats perFrameStats = new Jogl2es2PerFrameStats();
    private int statsFrame = 0;
    private int STATS_OUTPUT_FRAME_FREQ = 50;
    public int simpleTextureShaderProgramId = -1;
    public int simpleTextureShaderProgramVertLoc = -1;
    public int simpleTextureShaderProgramTexCoordLoc = -1;
    public int simpleTextureShaderProgramBaseMapLoc = -1;
    public Jogl2es2MatrixUtil matrixUtil = new Jogl2es2MatrixUtil();

    public Jogl2es2Context(GLContext context) {
        super(context);
    }

    public GL2ES2 gl2es2() {
        return this.context.getGL().getGL2ES2();
    }

    public GL2ES3 gl2es3() {
        if (this.context.getGL().isGL2ES3()) {
            return this.context.getGL().getGL2ES3();
        }
        return null;
    }

    @Override
    void setShaderProgram(JoglShaderObject object) {
        super.setShaderProgram(object);
        this.shaderProgram = object;
        this.shaderProgramId = object == null ? -1 : object.getValue();
        this.programData = this.allProgramData.get(this.shaderProgramId);
        if (this.programData == null) {
            this.programData = new ProgramData();
            this.allProgramData.put(this.shaderProgramId, this.programData);
        }
    }

    public void outputPerFrameData() {
        ++this.statsFrame;
        if (this.statsFrame % this.STATS_OUTPUT_FRAME_FREQ == 0) {
            this.statsFrame = 0;
            System.out.println("======================================================");
            this.perFrameStats.outputPerFrameData();
        }
        this.perFrameStats = new Jogl2es2PerFrameStats();
        this.perFrameStats.endOfPrevFrameTime = System.nanoTime();
    }

    public static class fogDataLocs {
        public boolean present = false;
        public int fogEnabled = -1;
        public int expColor = -1;
        public int expDensity = -1;
        public int linearColor = -1;
        public int linearStart = -1;
        public int linearEnd = -1;

        public void setPresent() {
            this.present = this.fogEnabled != -1 || this.expColor != -1 || this.expDensity != -1 || this.linearColor != -1 || this.linearStart != -1 || this.linearEnd != -1;
        }
    }

    public static class fogData {
        public int fogEnabled = -1;
        public Vector3f expColor = new Vector3f();
        public float expDensity;
        public Vector3f linearColor = new Vector3f();
        public float linearStart;
        public float linearEnd;

        public void clear() {
            this.fogEnabled = -1;
            this.expColor.set(Float.NEGATIVE_INFINITY, -999.0f, -999.0f);
            this.expDensity = -99.0f;
            this.linearColor.set(-999.0f, -999.0f, -999.0f);
            this.linearStart = -99.0f;
            this.linearEnd = -99.0f;
        }

        public void set(fogData ogfm) {
            this.fogEnabled = ogfm.fogEnabled;
            this.expColor.set((Tuple3f)ogfm.expColor);
            this.expDensity = ogfm.expDensity;
            this.linearColor.set((Tuple3f)ogfm.linearColor);
            this.linearStart = ogfm.linearStart;
            this.linearEnd = ogfm.linearEnd;
        }

        public boolean equals(Object o) {
            if (o instanceof fogData) {
                fogData ogfm = (fogData)o;
                return ogfm.fogEnabled == this.fogEnabled && ogfm.expColor.equals((Tuple3f)this.expColor) && ogfm.expDensity == this.expDensity && ogfm.linearColor.equals((Tuple3f)this.linearColor) && ogfm.linearStart == this.linearStart && ogfm.linearEnd == this.linearEnd;
            }
            return false;
        }
    }

    public static class glLightSourceLocs {
        public int position = -1;
        public int diffuse = -1;
        public int specular = -1;
        public int constantAttenuation = -1;
        public int linearAttenuation = -1;
        public int quadraticAttenuation = -1;
        public int spotCutoff = -1;
        public int spotExponent = -1;
        public int spotDirection = -1;
    }

    public static class glLightSource {
        public int enabled = -1;
        public int prevLightSlot = -1;
        public Vector4f position = new Vector4f();
        public Vector4f diffuse = new Vector4f();
        public Vector4f specular = new Vector4f();
        public float constantAttenuation;
        public float linearAttenuation;
        public float quadraticAttenuation;
        public float spotCutoff;
        public float spotExponent;
        public Vector3f spotDirection = new Vector3f();

        public void clear() {
            this.enabled = -1;
            this.prevLightSlot = -1;
            this.position.set(-999.0f, -999.0f, -999.0f, -999.0f);
            this.diffuse.set(-999.0f, -999.0f, -999.0f, -999.0f);
            this.specular.set(-999.0f, -999.0f, -999.0f, -999.0f);
            this.constantAttenuation = -99.0f;
            this.linearAttenuation = -99.0f;
            this.quadraticAttenuation = -99.0f;
            this.spotCutoff = -99.0f;
            this.spotExponent = -99.0f;
            this.spotDirection.set(-999.0f, -999.0f, -999.0f);
        }

        public void set(glLightSource ogfm) {
            this.enabled = ogfm.enabled;
            this.prevLightSlot = ogfm.prevLightSlot;
            this.position.set((Tuple4f)ogfm.position);
            this.diffuse.set((Tuple4f)ogfm.diffuse);
            this.specular.set((Tuple4f)ogfm.specular);
            this.constantAttenuation = ogfm.constantAttenuation;
            this.linearAttenuation = ogfm.linearAttenuation;
            this.quadraticAttenuation = ogfm.quadraticAttenuation;
            this.spotCutoff = ogfm.spotCutoff;
            this.spotExponent = ogfm.spotExponent;
            this.spotDirection.set((Tuple3f)ogfm.spotDirection);
        }

        public boolean equals(Object o) {
            if (o instanceof glLightSource) {
                glLightSource ogfm = (glLightSource)o;
                return this.enabled == ogfm.enabled && this.prevLightSlot == ogfm.prevLightSlot && ogfm.position.equals((Tuple4f)this.position) && ogfm.diffuse.equals((Tuple4f)this.diffuse) && ogfm.specular.equals((Tuple4f)this.specular) && ogfm.constantAttenuation == this.constantAttenuation && ogfm.linearAttenuation == this.linearAttenuation && ogfm.quadraticAttenuation == this.quadraticAttenuation && ogfm.spotCutoff == this.spotCutoff && ogfm.spotExponent == this.spotExponent && ogfm.spotDirection.equals((Tuple3f)this.spotDirection);
            }
            return false;
        }
    }

    public static class glFrontMaterialLocs {
        public boolean present = false;
        public int lightEnabled = -1;
        public int ambient = -1;
        public int diffuse = -1;
        public int emission = -1;
        public int specular = -1;
        public int shininess = -1;

        public void setPresent() {
            this.present = this.lightEnabled != -1 || this.ambient != -1 || this.diffuse != -1 || this.emission != -1 || this.specular != -1 || this.shininess != -1;
        }
    }

    public static class glFrontMaterial {
        public int lightEnabled = -1;
        public Vector4f ambient = new Vector4f();
        public Vector4f diffuse = new Vector4f();
        public Vector3f emission = new Vector3f();
        public Vector3f specular = new Vector3f();
        public float shininess;

        public void clear() {
            this.lightEnabled = -1;
            this.ambient.set(Float.NEGATIVE_INFINITY, -999.0f, -999.0f, -999.0f);
            this.diffuse.set(Float.NEGATIVE_INFINITY, -999.0f, -999.0f, -999.0f);
            this.emission.set(Float.NEGATIVE_INFINITY, -999.0f, -999.0f);
            this.specular.set(Float.NEGATIVE_INFINITY, -999.0f, -999.0f);
            this.shininess = -99.0f;
        }

        public boolean equals(Object o) {
            if (o instanceof glFrontMaterial) {
                glFrontMaterial ogfm = (glFrontMaterial)o;
                return ogfm.lightEnabled == this.lightEnabled && ogfm.ambient.equals((Tuple4f)this.ambient) && ogfm.diffuse.equals((Tuple4f)this.diffuse) && ogfm.emission.equals((Tuple3f)this.emission) && ogfm.specular.equals((Tuple3f)this.specular) && ogfm.shininess == this.shininess;
            }
            return false;
        }
    }

    public static class GL_State {
        public boolean depthBufferEnableOverride;
        public boolean depthBufferEnable;
        public int depthTestFunction;
        public boolean depthBufferWriteEnableOverride;
        public boolean depthBufferWriteEnable;
        public boolean userStencilAvailable;
        public boolean stencilEnable;
        public boolean glDepthMask;
        public boolean glEnableGL_STENCIL_TEST;
        public int stencilFailOp;
        public int stencilZFailOp;
        public int stencilZPassOp;
        public int stencilFunction;
        public int stencilReferenceValue;
        public int stencilCompareMask;
        public int stencilWriteMask;
        public int[] setGLSLUniform1i = new int[500];
        public int[] clearer1 = new int[500];
        public float[] setGLSLUniform1f = new float[500];
        public float[] clearer2 = new float[500];
        public boolean glEnableGL_BLEND;
        public int srcBlendFunction;
        public int dstBlendFunction;
        public int glActiveTexture;
        public int currentProgramId;
        public int[] glBindTextureGL_TEXTURE_2D = new int[35000];
        public int[] clearer3 = new int[35000];
        public int cullFace;
        public float polygonOffsetFactor;
        public float polygonOffset;
        public int ignoreVertexColors;
        public Vector4f glLightModelambient = new Vector4f();
        public Vector4f objectColor = new Vector4f();
        public float transparencyAlpha;
        public Matrix4d textureTransform = new Matrix4d();
        public Matrix4d modelMatrix = new Matrix4d();
        public Matrix4d glModelViewMatrix = new Matrix4d();
        public Matrix4d glModelViewMatrixInverse = new Matrix4d();
        public Matrix4d glModelViewProjectionMatrix = new Matrix4d();
        public Matrix3d glNormalMatrix = new Matrix3d();
        public boolean alphaTestEnabled = false;
        public int alphaTestFunction;
        public float alphaTestValue;
        public fogData fogData = new fogData();
        public glFrontMaterial glFrontMaterial = new glFrontMaterial();
        public int numberOfLights = -1;
        public glLightSource[] glLightSource = new glLightSource[MAX_LIGHTS];

        public void clear() {
            this.depthBufferEnableOverride = false;
            this.depthBufferEnable = false;
            this.depthTestFunction = -1;
            this.depthBufferWriteEnableOverride = false;
            this.depthBufferWriteEnable = false;
            this.userStencilAvailable = false;
            this.stencilEnable = false;
            this.glDepthMask = false;
            this.glEnableGL_STENCIL_TEST = false;
            this.stencilFailOp = -1;
            this.stencilZFailOp = -1;
            this.stencilZPassOp = -1;
            this.stencilFunction = -1;
            this.stencilReferenceValue = -1;
            this.stencilCompareMask = -1;
            this.stencilWriteMask = -1;
            System.arraycopy(this.clearer1, 0, this.setGLSLUniform1i, 0, this.setGLSLUniform1i.length);
            System.arraycopy(this.clearer2, 0, this.setGLSLUniform1f, 0, this.setGLSLUniform1f.length);
            this.glEnableGL_BLEND = false;
            this.srcBlendFunction = -1;
            this.dstBlendFunction = -1;
            this.glActiveTexture = -1;
            this.currentProgramId = -1;
            System.arraycopy(this.clearer3, 0, this.glBindTextureGL_TEXTURE_2D, 0, this.glBindTextureGL_TEXTURE_2D.length);
            this.cullFace = -1;
            this.polygonOffsetFactor = -1.0f;
            this.polygonOffset = -1.0f;
            this.ignoreVertexColors = -1;
            this.glLightModelambient.set(Float.NEGATIVE_INFINITY, -999.0f, -999.0f, -999.0f);
            this.objectColor.set(Float.NEGATIVE_INFINITY, -999.0f, -999.0f, -999.0f);
            this.transparencyAlpha = -1.0f;
            this.textureTransform.m00 = Double.NEGATIVE_INFINITY;
            this.modelMatrix.m00 = Double.NEGATIVE_INFINITY;
            this.glModelViewMatrix.m00 = Double.NEGATIVE_INFINITY;
            this.glModelViewMatrixInverse.m00 = Double.NEGATIVE_INFINITY;
            this.glModelViewProjectionMatrix.m00 = Double.NEGATIVE_INFINITY;
            this.glNormalMatrix.m00 = Double.NEGATIVE_INFINITY;
            this.alphaTestEnabled = false;
            this.alphaTestFunction = -1;
            this.alphaTestValue = -99.0f;
            this.fogData.clear();
            this.glFrontMaterial.clear();
            for (int i = 0; i < MAX_LIGHTS; ++i) {
                this.glLightSource[i] = null;
            }
        }
    }

    public static class LocationData {
        public int glProjectionMatrix = -1;
        public int glProjectionMatrixInverse = -1;
        public int glModelMatrix = -1;
        public int glViewMatrix = -1;
        public int glModelViewMatrix = -1;
        public int glModelViewMatrixInverse = -1;
        public int glModelViewProjectionMatrix = -1;
        public int glNormalMatrix = -1;
        public int ignoreVertexColors = -1;
        public int glLightModelambient = -1;
        public int objectColor = -1;
        public int transparencyAlpha = -1;
        public int alphaTestEnabled = -1;
        public int alphaTestFunction = -1;
        public int alphaTestValue = -1;
        public int textureTransform = -1;
        public fogDataLocs fogData = new fogDataLocs();
        public glFrontMaterialLocs glFrontMaterial = new glFrontMaterialLocs();
        public int numberOfLights = -1;
        public glLightSourceLocs[] glLightSource = new glLightSourceLocs[MAX_LIGHTS];
        public int glVertex = -1;
        public int glColor = -1;
        public int glNormal = -1;
        public int[] glMultiTexCoord = new int[16];
        public SparseArray<Integer> genAttIndexToLoc = new SparseArray();
    }

    public static class RenderingData {
        public boolean alphaTestEnabled = false;
        public int alphaTestFunction = 0;
        public float alphaTestValue = 0.0f;
        public int ignoreVertexColors;
    }

    public static class ProgramData {
        public HashMap<String, Integer> progToGenVertAttNameToGenVertAttIndex = new HashMap();
        public LocationData programToLocationData = null;
        public ByteBuffer programToUBOBB = null;
        public int programToUBOBuf = -1;
    }

    public static class GeometryData {
        public int nativeId = -1;
        public int geoToIndBuf = -1;
        public int geoToIndBufSize = -1;
        public int[] geoToIndStripBuf = null;
        public int geoToCoordBuf = -1;
        public int geoToCoordBuf1 = -2;
        public int geoToCoordBuf2 = -3;
        public int geoToCoordBuf3 = -3;
        public int geoToCoordBufSize = -1;
        public int geoToColorBuf = -1;
        public int geoToNormalBuf = -1;
        public SparseArray<Integer> geoToTexCoordsBuf = new SparseArray();
        public SparseArray<Integer> geoToVertAttribBuf = new SparseArray();
        public int coordBufId = -1;
        public int interleavedBufId = -1;
        public int interleavedStride = 0;
        public int geoToCoordOffset = -1;
        public int geoToColorsOffset = -1;
        public int geoToNormalsOffset = -1;
        public int[] geoToVattrOffset = new int[10];
        public int[] geoToTexCoordOffset = new int[10];
        public int vaoId = -1;
        private static int nextNativeId = 0;

        public GeometryData() {
            this.nativeId = nextNativeId++;
            nextNativeId = nextNativeId > 0x7FFFFFF5 ? 0 : nextNativeId;
        }
    }
}

