/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.IndexedGeometryStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineStripArrayRetained;
import org.jogamp.java3d.TriangleFanArrayRetained;
import org.jogamp.java3d.TriangleStripArrayRetained;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;

abstract class GeometryStripArrayRetained
extends GeometryArrayRetained {
    int[] stripVertexCounts;
    int[] stripStartVertexIndices;
    int[] stripStartOffsetIndices;
    int[] compileNumStrips;
    int[] compileStripCountOffset;

    GeometryStripArrayRetained() {
    }

    void setStripVertexCounts(int[] stripVertexCounts) {
        boolean isLive;
        int i;
        boolean nullGeo = false;
        int num = stripVertexCounts.length;
        int total = 0;
        for (i = 0; i < num; ++i) {
            total += stripVertexCounts[i];
            if (this instanceof LineStripArrayRetained) {
                if (stripVertexCounts[i] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("LineStripArrayRetained1"));
            }
            if (this instanceof TriangleStripArrayRetained) {
                if (stripVertexCounts[i] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("TriangleStripArrayRetained1"));
            }
            if (!(this instanceof TriangleFanArrayRetained) || stripVertexCounts[i] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained1"));
        }
        if (this.initialVertexIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray3"));
        }
        if (this.initialCoordIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray7"));
        }
        if (this.initialColorIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray4"));
        }
        if (this.initialNormalIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray5"));
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (i = 0; i < this.texCoordSetCount; ++i) {
                if (this.initialTexCoordIndex[i] + total <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray6"));
            }
        }
        if ((this.vertexFormat & 0x1000) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (i = 0; i < this.vertexAttrCount; ++i) {
                if (this.initialVertexAttrIndex[i] + total <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray8"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x40;
        this.validVertexCount = total;
        this.stripVertexCounts = new int[num];
        this.stripStartVertexIndices = new int[num];
        this.stripStartOffsetIndices = new int[num];
        this.stripStartOffsetIndices[0] = 0;
        if ((this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            this.stripStartVertexIndices[0] = this.initialCoordIndex;
            nullGeo = (this.vertexType & 0xF) == 0;
        } else {
            this.stripStartVertexIndices[0] = this.initialVertexIndex;
            if ((this.vertexFormat & 0x100) != 0) {
                nullGeo = (this.vertexFormat & 0x800) != 0 ? this.interLeavedVertexData == null : this.interleavedFloatBufferImpl == null;
            }
        }
        for (i = 0; i < num - 1; ++i) {
            this.stripVertexCounts[i] = stripVertexCounts[i];
            this.stripStartVertexIndices[i + 1] = this.stripStartVertexIndices[i] + stripVertexCounts[i];
            this.stripStartOffsetIndices[i + 1] = this.stripStartOffsetIndices[i] + stripVertexCounts[i];
        }
        this.stripVertexCounts[num - 1] = stripVertexCounts[num - 1];
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.processCoordsChanged(nullGeo);
            this.sendDataChangedMessage(true);
        }
    }

    void unIndexify(IndexedGeometryStripArrayRetained src) {
        if ((src.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(src);
        } else {
            this.unIndexifyNIOBuffer(src);
        }
    }

    private void unIndexifyJavaArray(IndexedGeometryStripArrayRetained src) {
        int vOffset = 0;
        int tOffset = 0;
        int base = src.initialIndexIndex;
        int colorStride = 0;
        float[] vdata = null;
        if ((src.vertexFormat & 0x80) == 0 || (src.vertexFormat & 0x100) != 0) {
            if ((src.vertexFormat & 0x80) == 0) {
                vdata = src.vertexData;
                if ((src.vertexFormat & 4) != 0) {
                    colorStride = 4;
                }
            } else if ((src.vertexFormat & 0x100) != 0) {
                vdata = src.interLeavedVertexData;
                if ((src.vertexFormat & 8) != 0) {
                    colorStride = 4;
                } else if ((src.vertexFormat & 4) != 0) {
                    colorStride = 3;
                }
            }
            for (int i = 0; i < src.stripIndexCounts.length; ++i) {
                for (int j = 0; j < src.stripIndexCounts[i]; ++j) {
                    int k;
                    int index = j + base;
                    if ((this.vertexFormat & 2) != 0) {
                        System.arraycopy(vdata, src.indexNormal[index] * src.stride + src.normalOffset, this.vertexData, vOffset + this.normalOffset, 3);
                    }
                    if (colorStride == 4) {
                        System.arraycopy(vdata, src.indexColor[index] * src.stride + src.colorOffset, this.vertexData, vOffset + this.colorOffset, colorStride);
                    } else if (colorStride == 3) {
                        System.arraycopy(vdata, src.indexColor[index] * src.stride + src.colorOffset, this.vertexData, vOffset + this.colorOffset, colorStride);
                        this.vertexData[vOffset + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (k = 0; k < this.texCoordSetCount; ++k) {
                            System.arraycopy(vdata, src.indexTexCoord[k][index] * src.stride + src.textureOffset + src.texCoordSetMapOffset[k], this.vertexData, vOffset + this.textureOffset + this.texCoordSetMapOffset[k], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 0x1000) != 0) {
                        for (k = 0; k < this.vertexAttrCount; ++k) {
                            System.arraycopy(vdata, src.indexVertexAttr[k][index] * src.stride + src.vertexAttrOffsets[k], this.vertexData, vOffset + this.vertexAttrOffsets[k], this.vertexAttrSizes[k]);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        System.arraycopy(vdata, src.indexCoord[index] * src.stride + src.coordinateOffset, this.vertexData, vOffset + this.coordinateOffset, 3);
                    }
                    vOffset += this.stride;
                }
                base += src.stripIndexCounts[i];
            }
        } else {
            int k;
            int index;
            int j;
            int i;
            if ((this.vertexFormat & 2) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.normalOffset;
                switch (src.vertexType & 0xC00) {
                    case 1024: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                System.arraycopy(src.floatRefNormals, src.indexNormal[index] * 3, this.vertexData, vOffset, 3);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 2048: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexNormal[j + base];
                                this.vertexData[vOffset] = src.v3fRefNormals[index].x;
                                this.vertexData[vOffset + 1] = src.v3fRefNormals[index].y;
                                this.vertexData[vOffset + 2] = src.v3fRefNormals[index].z;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.colorOffset;
                int multiplier = 3;
                if ((src.vertexFormat & 8) != 0) {
                    multiplier = 4;
                }
                switch (src.vertexType & 0x3F0) {
                    case 16: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                if ((src.vertexFormat & 8) != 0) {
                                    System.arraycopy(src.floatRefColors, src.indexColor[index] * multiplier, this.vertexData, vOffset, 4);
                                } else {
                                    System.arraycopy(src.floatRefColors, src.indexColor[index] * multiplier, this.vertexData, vOffset, 3);
                                    this.vertexData[vOffset + 3] = 1.0f;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 32: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexColor[j + base] * multiplier;
                                this.vertexData[vOffset] = (float)(src.byteRefColors[index] & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.byteRefColors[index + 1] & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.byteRefColors[index + 2] & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = (src.vertexFormat & 8) != 0 ? (float)(src.byteRefColors[index + 3] & 0xFF) * 0.003921569f : 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 64: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexColor[j + base];
                                this.vertexData[vOffset] = src.c3fRefColors[index].x;
                                this.vertexData[vOffset + 1] = src.c3fRefColors[index].y;
                                this.vertexData[vOffset + 2] = src.c3fRefColors[index].z;
                                this.vertexData[vOffset + 3] = 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 128: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexColor[j + base];
                                this.vertexData[vOffset] = src.c4fRefColors[index].x;
                                this.vertexData[vOffset + 1] = src.c4fRefColors[index].y;
                                this.vertexData[vOffset + 2] = src.c4fRefColors[index].z;
                                this.vertexData[vOffset + 3] = src.c4fRefColors[index].w;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 256: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexColor[j + base];
                                this.vertexData[vOffset] = (float)(src.c3bRefColors[index].x & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.c3bRefColors[index].y & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.c3bRefColors[index].z & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 512: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexColor[j + base];
                                this.vertexData[vOffset] = (float)(src.c4bRefColors[index].x & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.c4bRefColors[index].y & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.c4bRefColors[index].z & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = (float)(src.c4bRefColors[index].w & 0xFF) * 0.003921569f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.textureOffset;
                switch (src.vertexType & 0x7000) {
                    case 4096: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                tOffset = vOffset;
                                for (k = 0; k < this.texCoordSetCount; ++k) {
                                    System.arraycopy(src.refTexCoords[k], src.indexTexCoord[k][index] * this.texCoordStride, this.vertexData, tOffset, this.texCoordStride);
                                    tOffset += this.texCoordStride;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 8192: {
                        int srcOffset;
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                tOffset = vOffset;
                                for (k = 0; k < this.texCoordSetCount; ++k) {
                                    srcOffset = src.indexTexCoord[k][index];
                                    this.vertexData[tOffset] = ((TexCoord2f[])src.refTexCoords[k])[srcOffset].x;
                                    this.vertexData[tOffset + 1] = ((TexCoord2f[])src.refTexCoords[k])[srcOffset].y;
                                    tOffset += this.texCoordStride;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 16384: {
                        int srcOffset;
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                tOffset = vOffset;
                                for (k = 0; k < this.texCoordSetCount; ++k) {
                                    srcOffset = src.indexTexCoord[k][index];
                                    this.vertexData[tOffset] = ((TexCoord3f[])src.refTexCoords[k])[srcOffset].x;
                                    this.vertexData[tOffset + 1] = ((TexCoord3f[])src.refTexCoords[k])[srcOffset].y;
                                    this.vertexData[tOffset + 2] = ((TexCoord3f[])src.refTexCoords[k])[srcOffset].z;
                                    tOffset += this.texCoordStride;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                base = src.initialIndexIndex;
                vOffset = 0;
                switch (src.vertexType & 0x8000) {
                    case 32768: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                for (k = 0; k < this.vertexAttrCount; ++k) {
                                    System.arraycopy(src.floatRefVertexAttrs[k], src.indexVertexAttr[k][index] * this.vertexAttrSizes[k], this.vertexData, vOffset + this.vertexAttrOffsets[k], this.vertexAttrSizes[k]);
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                vOffset = this.coordinateOffset;
                base = src.initialIndexIndex;
                switch (src.vertexType & 0xF) {
                    case 1: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                System.arraycopy(src.floatRefCoords, src.indexCoord[index] * 3, this.vertexData, vOffset, 3);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 2: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexCoord[j + base] * 3;
                                this.vertexData[vOffset] = (float)src.doubleRefCoords[index];
                                this.vertexData[vOffset + 1] = (float)src.doubleRefCoords[index + 1];
                                this.vertexData[vOffset + 2] = (float)src.doubleRefCoords[index + 2];
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 4: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexCoord[j + base];
                                this.vertexData[vOffset] = src.p3fRefCoords[index].x;
                                this.vertexData[vOffset + 1] = src.p3fRefCoords[index].y;
                                this.vertexData[vOffset + 2] = src.p3fRefCoords[index].z;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 8: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexCoord[j + base];
                                this.vertexData[vOffset] = (float)src.p3dRefCoords[index].x;
                                this.vertexData[vOffset + 1] = (float)src.p3dRefCoords[index].y;
                                this.vertexData[vOffset + 2] = (float)src.p3dRefCoords[index].z;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                }
            }
        }
    }

    private void unIndexifyNIOBuffer(IndexedGeometryStripArrayRetained src) {
        int vOffset = 0;
        int tOffset = 0;
        int base = src.initialIndexIndex;
        int colorStride = 0;
        if ((src.vertexFormat & 0x100) != 0) {
            if ((src.vertexFormat & 8) != 0) {
                colorStride = 4;
            } else if ((src.vertexFormat & 4) != 0) {
                colorStride = 3;
            }
            for (int i = 0; i < src.stripIndexCounts.length; ++i) {
                for (int j = 0; j < src.stripIndexCounts[i]; ++j) {
                    int index = j + base;
                    if ((this.vertexFormat & 2) != 0) {
                        src.interleavedFloatBufferImpl.position(src.indexNormal[index] * src.stride + src.normalOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.normalOffset, 3);
                    }
                    if (colorStride == 4) {
                        src.interleavedFloatBufferImpl.position(src.indexColor[index] * src.stride + src.colorOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.colorOffset, colorStride);
                    } else if (colorStride == 3) {
                        src.interleavedFloatBufferImpl.position(src.indexColor[index] * src.stride + src.colorOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.colorOffset, colorStride);
                        this.vertexData[vOffset + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (int k = 0; k < this.texCoordSetCount; ++k) {
                            src.interleavedFloatBufferImpl.position(src.indexTexCoord[k][index] * src.stride + src.textureOffset + src.texCoordSetMapOffset[k]);
                            src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.textureOffset + this.texCoordSetMapOffset[k], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        src.interleavedFloatBufferImpl.position(src.indexCoord[index] * src.stride + src.coordinateOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.coordinateOffset, 3);
                    }
                    vOffset += this.stride;
                }
                base += src.stripIndexCounts[i];
            }
        } else {
            int k;
            int index;
            int j;
            int i;
            if ((this.vertexFormat & 2) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.normalOffset;
                if ((src.vertexType & 0xC00) != 0) {
                    for (i = 0; i < src.stripIndexCounts.length; ++i) {
                        for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                            index = j + base;
                            src.floatBufferRefNormals.position(src.indexNormal[index] * 3);
                            src.floatBufferRefNormals.get(this.vertexData, vOffset, 3);
                            vOffset += this.stride;
                        }
                        base += src.stripIndexCounts[i];
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.colorOffset;
                int multiplier = 3;
                if ((src.vertexFormat & 8) != 0) {
                    multiplier = 4;
                }
                switch (src.vertexType & 0x3F0) {
                    case 16: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                if ((src.vertexFormat & 8) != 0) {
                                    src.floatBufferRefColors.position(src.indexColor[index] * multiplier);
                                    src.floatBufferRefColors.get(this.vertexData, vOffset, 4);
                                } else {
                                    src.floatBufferRefColors.position(src.indexColor[index] * multiplier);
                                    src.floatBufferRefColors.get(this.vertexData, vOffset, 3);
                                    this.vertexData[vOffset + 3] = 1.0f;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 32: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexColor[j + base] * multiplier;
                                this.vertexData[vOffset] = (float)(src.byteBufferRefColors.get(index) & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.byteBufferRefColors.get(index + 1) & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.byteBufferRefColors.get(index + 2) & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = (src.vertexFormat & 8) != 0 ? (float)(src.byteBufferRefColors.get(index + 3) & 0xFF) * 0.003921569f : 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.textureOffset;
                if ((src.vertexType & 0x7000) != 0) {
                    for (i = 0; i < src.stripIndexCounts.length; ++i) {
                        for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                            index = j + base;
                            tOffset = vOffset;
                            for (k = 0; k < this.texCoordSetCount; ++k) {
                                FloatBuffer texBuffer = (FloatBuffer)src.refTexCoordsBuffer[k].getROBuffer();
                                texBuffer.position(src.indexTexCoord[k][index] * this.texCoordStride);
                                texBuffer.get(this.vertexData, tOffset, this.texCoordStride);
                                tOffset += this.texCoordStride;
                            }
                            vOffset += this.stride;
                        }
                        base += src.stripIndexCounts[i];
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                base = src.initialIndexIndex;
                vOffset = 0;
                if ((src.vertexType & 0x8000) == 32768) {
                    for (i = 0; i < src.stripIndexCounts.length; ++i) {
                        for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                            index = j + base;
                            for (k = 0; k < this.vertexAttrCount; ++k) {
                                int vaOffset = vOffset + this.vertexAttrOffsets[k];
                                FloatBuffer vaBuffer = src.floatBufferRefVertexAttrs[k];
                                vaBuffer.position(src.indexVertexAttr[k][index] * this.vertexAttrSizes[k]);
                                vaBuffer.get(this.vertexData, vaOffset, this.vertexAttrSizes[k]);
                            }
                            vOffset += this.stride;
                        }
                        base += src.stripIndexCounts[i];
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                vOffset = this.coordinateOffset;
                base = src.initialIndexIndex;
                switch (src.vertexType & 0xF) {
                    case 1: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = j + base;
                                src.floatBufferRefCoords.position(src.indexCoord[index] * 3);
                                src.floatBufferRefCoords.get(this.vertexData, vOffset, 3);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                    case 2: {
                        for (i = 0; i < src.stripIndexCounts.length; ++i) {
                            for (j = 0; j < src.stripIndexCounts[i]; ++j) {
                                index = src.indexCoord[j + base] * 3;
                                this.vertexData[vOffset] = (float)src.doubleBufferRefCoords.get(index);
                                this.vertexData[vOffset + 1] = (float)src.doubleBufferRefCoords.get(index + 1);
                                this.vertexData[vOffset + 2] = (float)src.doubleBufferRefCoords.get(index + 2);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i];
                        }
                        break;
                    }
                }
            }
        }
    }

    int getNumStrips() {
        return this.stripVertexCounts.length;
    }

    void getStripVertexCounts(int[] stripVertexCounts) {
        for (int stripVertexCounts[i] : this.stripVertexCounts) {
        }
    }

    void getStripVertexCounts(int id, int[] counts) {
        int stripOffset = this.compileStripCountOffset[id];
        int stripLength = this.compileNumStrips[id];
        System.arraycopy(this.stripVertexCounts, stripOffset, counts, 0, stripLength);
    }

    int getNumStrips(int id) {
        return this.compileNumStrips[id];
    }

    @Override
    void mergeGeometryArrays(ArrayList list) {
        int numMerge = list.size();
        int numStrips = 0;
        for (int i = 0; i < numMerge; ++i) {
            numStrips += ((GeometryStripArrayRetained)list.get((int)i)).stripVertexCounts.length;
        }
        this.stripVertexCounts = new int[numStrips];
        this.stripStartVertexIndices = new int[numStrips];
        this.stripStartOffsetIndices = new int[numStrips];
        int curStripOffset = 0;
        int curStripIndexOffset = 0;
        this.compileNumStrips = new int[numMerge];
        this.compileStripCountOffset = new int[numMerge];
        for (int i = 0; i < numMerge; ++i) {
            int stripLength;
            GeometryStripArrayRetained strip = (GeometryStripArrayRetained)list.get(i);
            int[] curStripVertexCounts = strip.stripVertexCounts;
            int[] curStripStartIndices = strip.stripStartVertexIndices;
            int[] curStripOffsetIndices = strip.stripStartOffsetIndices;
            this.compileNumStrips[i] = stripLength = curStripVertexCounts.length;
            this.compileStripCountOffset[i] = curStripOffset;
            System.arraycopy(curStripVertexCounts, 0, this.stripVertexCounts, curStripOffset, stripLength);
            for (int j = 0; j < stripLength; ++j) {
                this.stripStartVertexIndices[j + curStripOffset] = curStripStartIndices[j] + curStripIndexOffset;
                this.stripStartOffsetIndices[j + curStripOffset] = curStripOffsetIndices[j] + curStripIndexOffset;
            }
            curStripOffset += stripLength;
            curStripIndexOffset += strip.validVertexCount;
        }
        this.validVertexCount = curStripIndexOffset;
        super.mergeGeometryArrays(list);
    }
}

