/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryUpdater;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.vecmath.Color3b;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4b;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Point4f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;
import org.jogamp.vecmath.TexCoord4f;
import org.jogamp.vecmath.Tuple2f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public abstract class GeometryArray
extends Geometry {
    public static final int ALLOW_COORDINATE_READ = 0;
    public static final int ALLOW_COORDINATE_WRITE = 1;
    public static final int ALLOW_COLOR_READ = 2;
    public static final int ALLOW_COLOR_WRITE = 3;
    public static final int ALLOW_NORMAL_READ = 4;
    public static final int ALLOW_NORMAL_WRITE = 5;
    public static final int ALLOW_TEXCOORD_READ = 6;
    public static final int ALLOW_TEXCOORD_WRITE = 7;
    public static final int ALLOW_VERTEX_ATTR_READ = 22;
    public static final int ALLOW_VERTEX_ATTR_WRITE = 23;
    public static final int ALLOW_COUNT_READ = 8;
    public static final int ALLOW_COUNT_WRITE = 20;
    public static final int ALLOW_FORMAT_READ = 17;
    public static final int ALLOW_REF_DATA_READ = 21;
    private static final int J3D_1_2_ALLOW_REF_DATA_READ = 18;
    public static final int ALLOW_REF_DATA_WRITE = 19;
    public static final int COORDINATES = 1;
    public static final int NORMALS = 2;
    static final int COLOR = 4;
    static final int WITH_ALPHA = 8;
    public static final int COLOR_3 = 4;
    public static final int COLOR_4 = 12;
    public static final int TEXTURE_COORDINATE_2 = 32;
    public static final int TEXTURE_COORDINATE_3 = 64;
    public static final int TEXTURE_COORDINATE_4 = 1024;
    static final int TEXTURE_COORDINATE = 1120;
    public static final int BY_REFERENCE = 128;
    public static final int INTERLEAVED = 256;
    public static final int USE_NIO_BUFFER = 2048;
    public static final int USE_COORD_INDEX_ONLY = 512;
    public static final int VERTEX_ATTRIBUTES = 4096;
    public static final int BY_REFERENCE_INDICES = 8192;
    private static final int LAST_FORMAT_BIT = 8192;
    private TexCoord2f[] texCoord2fArray = null;
    private TexCoord3f[] texCoord3fArray = null;
    private TexCoord4f[] texCoord4fArray = null;
    private TexCoord2f texCoord2fScratch = null;
    private TexCoord3f texCoord3fScratch = null;
    private static final int[] defTexCoordMap = new int[]{0};
    private static final int[] readCapabilities = new int[]{2, 0, 8, 17, 4, 21, 6, 22};

    GeometryArray() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public GeometryArray(int vertexCount, int vertexFormat) {
        this(vertexCount, vertexFormat, (vertexFormat & 0x460) != 0 ? 1 : 0, (int[])((vertexFormat & 0x460) != 0 ? defTexCoordMap : null));
    }

    public GeometryArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap) {
        this(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, 0, null);
    }

    public GeometryArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes) {
        int i;
        if (vertexCount < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray96"));
        }
        if (texCoordSetCount < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray124"));
        }
        if (vertexAttrCount < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray125"));
        }
        if ((vertexFormat & 1) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray0"));
        }
        if ((vertexFormat & 0x100) != 0 && (vertexFormat & 0x80) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray80"));
        }
        if ((vertexFormat & 0x100) != 0 && (vertexFormat & 0x1000) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray128"));
        }
        if ((vertexFormat & 0x200) != 0 && !(this instanceof IndexedGeometryArray)) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray135"));
        }
        if ((vertexFormat & 0x2000) != 0) {
            if (!(this instanceof IndexedGeometryArray)) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray136"));
            }
            if ((vertexFormat & 0x80) == 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray137"));
            }
            if ((vertexFormat & 0x200) == 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray138"));
            }
        }
        if ((vertexFormat & 0x800) != 0 && (vertexFormat & 0x80) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray117"));
        }
        if ((vertexFormat & 0x460) != 0) {
            if (texCoordSetMap == null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray106"));
            }
            if (texCoordSetCount == 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray107"));
            }
            for (i = 0; i < texCoordSetMap.length; ++i) {
                if (texCoordSetMap[i] < texCoordSetCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray108"));
            }
            if ((vertexFormat & 0x20) != 0) {
                this.texCoord2fArray = new TexCoord2f[1];
                this.texCoord2fScratch = new TexCoord2f();
            } else if ((vertexFormat & 0x40) != 0) {
                this.texCoord3fArray = new TexCoord3f[1];
                this.texCoord3fScratch = new TexCoord3f();
            } else if ((vertexFormat & 0x400) != 0) {
                this.texCoord4fArray = new TexCoord4f[1];
            }
        }
        if ((vertexFormat & 0x1000) != 0) {
            if (vertexAttrCount > 0) {
                if (vertexAttrCount != vertexAttrSizes.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray132"));
                }
                for (i = 0; i < vertexAttrSizes.length; ++i) {
                    if (vertexAttrSizes[i] >= 1 && vertexAttrSizes[i] <= 4) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray133"));
                }
            } else if (vertexAttrSizes != null && vertexAttrSizes.length != 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray132"));
            }
        } else if (vertexAttrCount > 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray131"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((GeometryArrayRetained)this.retained).createGeometryArrayData(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes);
    }

    public int getVertexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray1"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexCount();
    }

    public int getVertexFormat() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray2"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexFormat();
    }

    public int getTexCoordSetCount() {
        return ((GeometryArrayRetained)this.retained).getTexCoordSetCount();
    }

    public int getTexCoordSetMapLength() {
        return ((GeometryArrayRetained)this.retained).getTexCoordSetMapLength();
    }

    public void getTexCoordSetMap(int[] texCoordSetMap) {
        ((GeometryArrayRetained)this.retained).getTexCoordSetMap(texCoordSetMap);
    }

    public int getVertexAttrCount() {
        return ((GeometryArrayRetained)this.retained).getVertexAttrCount();
    }

    public void getVertexAttrSizes(int[] vertexAttrSizes) {
        ((GeometryArrayRetained)this.retained).getVertexAttrSizes(vertexAttrSizes);
    }

    public void updateData(GeometryUpdater updater) {
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0 && this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray81"));
        }
        ((GeometryArrayRetained)this.retained).updateData(updater);
    }

    public void setValidVertexCount(int validVertexCount) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray88"));
        }
        if (validVertexCount < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray96"));
        }
        ((GeometryArrayRetained)this.retained).setValidVertexCount(validVertexCount);
    }

    public int getValidVertexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray89"));
        }
        return ((GeometryArrayRetained)this.retained).getValidVertexCount();
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        block24: {
            GeometryArrayRetained dst;
            GeometryArrayRetained src;
            block25: {
                int i;
                int vAttrCount;
                int setCount;
                block26: {
                    int format;
                    block23: {
                        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
                        src = (GeometryArrayRetained)originalNodeComponent.retained;
                        dst = (GeometryArrayRetained)this.retained;
                        format = src.getVertexFormat();
                        if ((format & 0x80) != 0) break block23;
                        System.arraycopy(src.vertexData, 0, dst.vertexData, 0, src.vertexData.length);
                        dst.setInitialVertexIndex(src.getInitialVertexIndex());
                        break block24;
                    }
                    dst.setInitialCoordIndex(src.getInitialCoordIndex());
                    dst.setInitialColorIndex(src.getInitialColorIndex());
                    dst.setInitialNormalIndex(src.getInitialNormalIndex());
                    setCount = src.getTexCoordSetCount();
                    vAttrCount = src.getVertexAttrCount();
                    for (i = 0; i < setCount; ++i) {
                        dst.setInitialTexCoordIndex(i, src.getInitialTexCoordIndex(i));
                    }
                    if ((format & 0x100) != 0) break block25;
                    if ((format & 0x800) != 0) break block26;
                    dst.setCoordRefFloat(src.getCoordRefFloat());
                    dst.setCoordRefDouble(src.getCoordRefDouble());
                    dst.setCoordRef3f(src.getCoordRef3f());
                    dst.setCoordRef3d(src.getCoordRef3d());
                    dst.setColorRefFloat(src.getColorRefFloat());
                    dst.setColorRefByte(src.getColorRefByte());
                    if ((format & 8) == 0) {
                        dst.setColorRef3f(src.getColorRef3f());
                        dst.setColorRef3b(src.getColorRef3b());
                    } else {
                        dst.setColorRef4f(src.getColorRef4f());
                        dst.setColorRef4b(src.getColorRef4b());
                    }
                    dst.setNormalRefFloat(src.getNormalRefFloat());
                    dst.setNormalRef3f(src.getNormalRef3f());
                    switch (src.getVertexAttrType()) {
                        case 32768: {
                            for (i = 0; i < vAttrCount; ++i) {
                                dst.setVertexAttrRefFloat(i, src.getVertexAttrRefFloat(i));
                            }
                            break;
                        }
                    }
                    switch (src.getTexCoordType()) {
                        case 4096: {
                            for (i = 0; i < setCount; ++i) {
                                dst.setTexCoordRefFloat(i, src.getTexCoordRefFloat(i));
                            }
                            break block24;
                        }
                        case 8192: {
                            for (i = 0; i < setCount; ++i) {
                                dst.setTexCoordRef2f(i, src.getTexCoordRef2f(i));
                            }
                            break block24;
                        }
                        case 16384: {
                            for (i = 0; i < setCount; ++i) {
                                dst.setTexCoordRef3f(i, src.getTexCoordRef3f(i));
                            }
                            break;
                        }
                    }
                    break block24;
                }
                dst.setCoordRefBuffer(src.getCoordRefBuffer());
                dst.setColorRefBuffer(src.getColorRefBuffer());
                dst.setNormalRefBuffer(src.getNormalRefBuffer());
                switch (src.getVertexAttrType()) {
                    case 32768: {
                        for (i = 0; i < vAttrCount; ++i) {
                            dst.setVertexAttrRefBuffer(i, src.getVertexAttrRefBuffer(i));
                        }
                        break;
                    }
                }
                switch (src.getTexCoordType()) {
                    case 4096: {
                        for (i = 0; i < setCount; ++i) {
                            dst.setTexCoordRefBuffer(i, src.getTexCoordRefBuffer(i));
                        }
                        break;
                    }
                }
                break block24;
            }
            dst.setInterleavedVertices(src.getInterleavedVertices());
        }
    }

    public void setInitialVertexIndex(int initialVertexIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (initialVertexIndex < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0 && (format & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray105"));
        }
        ((GeometryArrayRetained)this.retained).setInitialVertexIndex(initialVertexIndex);
    }

    public int getInitialVertexIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialVertexIndex();
    }

    public void setCoordinate(int index, float[] coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(index, coordinate);
    }

    public void setCoordinate(int index, double[] coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(index, coordinate);
    }

    public void setCoordinate(int index, Point3f coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(index, coordinate);
    }

    public void setCoordinate(int index, Point3d coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(index, coordinate);
    }

    public void setCoordinates(int index, float[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates);
    }

    public void setCoordinates(int index, double[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates);
    }

    public void setCoordinates(int index, Point3f[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates);
    }

    public void setCoordinates(int index, Point3d[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates);
    }

    public void setCoordinates(int index, float[] coordinates, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates, start, length);
    }

    public void setCoordinates(int index, double[] coordinates, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates, start, length);
    }

    public void setCoordinates(int index, Point3f[] coordinates, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates, start, length);
    }

    public void setCoordinates(int index, Point3d[] coordinates, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(index, coordinates, start, length);
    }

    public void setColor(int index, float[] color) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColor(index, color);
    }

    public void setColor(int index, byte[] color) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColor(index, color);
    }

    public void setColor(int index, Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColor(index, color);
    }

    public void setColor(int index, Color4f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColor(index, color);
    }

    public void setColor(int index, Color3b color) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColor(index, color);
    }

    public void setColor(int index, Color4b color) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColor(index, color);
    }

    public void setColors(int index, float[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors);
    }

    public void setColors(int index, byte[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors);
    }

    public void setColors(int index, Color3f[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors);
    }

    public void setColors(int index, Color4f[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors);
    }

    public void setColors(int index, Color3b[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors);
    }

    public void setColors(int index, Color4b[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors);
    }

    public void setColors(int index, float[] colors, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors, start, length);
    }

    public void setColors(int index, byte[] colors, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors, start, length);
    }

    public void setColors(int index, Color3f[] colors, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors, start, length);
    }

    public void setColors(int index, Color4f[] colors, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors, start, length);
    }

    public void setColors(int index, Color3b[] colors, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors, start, length);
    }

    public void setColors(int index, Color4b[] colors, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(index, colors, start, length);
    }

    public void setNormal(int index, float[] normal) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray33"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormal(index, normal);
    }

    public void setNormal(int index, Vector3f normal) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray33"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormal(index, normal);
    }

    public void setNormals(int index, float[] normals) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(index, normals);
    }

    public void setNormals(int index, Vector3f[] normals) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(index, normals);
    }

    public void setNormals(int index, float[] normals, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(index, normals, start, length);
    }

    public void setNormals(int index, Vector3f[] normals, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(index, normals, start, length);
    }

    public void setTextureCoordinate(int index, float[] texCoord) {
        this.setTextureCoordinate(0, index, texCoord);
    }

    public void setTextureCoordinate(int texCoordSet, int index, float[] texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoord, 0, 1);
    }

    public void setTextureCoordinate(int index, Point2f texCoord) {
        this.texCoord2fScratch.set((Tuple2f)texCoord);
        this.setTextureCoordinate(0, index, this.texCoord2fScratch);
    }

    public void setTextureCoordinate(int texCoordSet, int index, TexCoord2f texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        this.texCoord2fArray[0] = texCoord;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, this.texCoord2fArray, 0, 1);
    }

    public void setTextureCoordinate(int index, Point3f texCoord) {
        this.texCoord3fScratch.set((Tuple3f)texCoord);
        this.setTextureCoordinate(0, index, this.texCoord3fScratch);
    }

    public void setTextureCoordinate(int texCoordSet, int index, TexCoord3f texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        this.texCoord3fArray[0] = texCoord;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, this.texCoord3fArray, 0, 1);
    }

    public void setTextureCoordinate(int texCoordSet, int index, TexCoord4f texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        this.texCoord4fArray[0] = texCoord;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, this.texCoord4fArray, 0, 1);
    }

    public void setTextureCoordinates(int index, float[] texCoords) {
        this.setTextureCoordinates(0, index, texCoords);
    }

    public void setTextureCoordinates(int texCoordSet, int index, float[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x20) != 0) {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, 0, texCoords.length / 2);
        } else if ((format & 0x40) != 0) {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, 0, texCoords.length / 3);
        } else {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, 0, texCoords.length / 4);
        }
    }

    public void setTextureCoordinates(int index, Point2f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, index, texCoords, 0, texCoords.length);
    }

    public void setTextureCoordinates(int texCoordSet, int index, TexCoord2f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, 0, texCoords.length);
    }

    public void setTextureCoordinates(int index, Point3f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, index, texCoords, 0, texCoords.length);
    }

    public void setTextureCoordinates(int texCoordSet, int index, TexCoord3f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, 0, texCoords.length);
    }

    public void setTextureCoordinates(int texCoordSet, int index, TexCoord4f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, 0, texCoords.length);
    }

    public void setTextureCoordinates(int index, float[] texCoords, int start, int length) {
        this.setTextureCoordinates(0, index, texCoords, start, length);
    }

    public void setTextureCoordinates(int texCoordSet, int index, float[] texCoords, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, start, length);
    }

    public void setTextureCoordinates(int index, Point2f[] texCoords, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, index, texCoords, start, length);
    }

    public void setTextureCoordinates(int texCoordSet, int index, TexCoord2f[] texCoords, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, start, length);
    }

    public void setTextureCoordinates(int index, Point3f[] texCoords, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, index, texCoords, start, length);
    }

    public void setTextureCoordinates(int texCoordSet, int index, TexCoord3f[] texCoords, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, start, length);
    }

    public void setTextureCoordinates(int texCoordSet, int index, TexCoord4f[] texCoords, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(texCoordSet, index, texCoords, start, length);
    }

    public void setVertexAttr(int vertexAttrNum, int index, float[] vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttr, 0, 1);
    }

    public void setVertexAttr(int vertexAttrNum, int index, Point2f vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttr(vertexAttrNum, index, vertexAttr);
    }

    public void setVertexAttr(int vertexAttrNum, int index, Point3f vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttr(vertexAttrNum, index, vertexAttr);
    }

    public void setVertexAttr(int vertexAttrNum, int index, Point4f vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttr(vertexAttrNum, index, vertexAttr);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, float[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, 0, vertexAttrs.length / size);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, Point2f[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, 0, vertexAttrs.length);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, Point3f[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, 0, vertexAttrs.length);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, Point4f[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, 0, vertexAttrs.length);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, float[] vertexAttrs, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, start, length);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, Point2f[] vertexAttrs, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, start, length);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, Point3f[] vertexAttrs, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, start, length);
    }

    public void setVertexAttrs(int vertexAttrNum, int index, Point4f[] vertexAttrs, int start, int length) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray126"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrs(vertexAttrNum, index, vertexAttrs, start, length);
    }

    public void getCoordinate(int index, float[] coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(index, coordinate);
    }

    public void getCoordinate(int index, double[] coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(index, coordinate);
    }

    public void getCoordinate(int index, Point3f coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(index, coordinate);
    }

    public void getCoordinate(int index, Point3d coordinate) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(index, coordinate);
    }

    public void getCoordinates(int index, float[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(index, coordinates);
    }

    public void getCoordinates(int index, double[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(index, coordinates);
    }

    public void getCoordinates(int index, Point3f[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(index, coordinates);
    }

    public void getCoordinates(int index, Point3d[] coordinates) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(index, coordinates);
    }

    public void getColor(int index, float[] color) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColor(index, color);
    }

    public void getColor(int index, byte[] color) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColor(index, color);
    }

    public void getColor(int index, Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColor(index, color);
    }

    public void getColor(int index, Color4f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColor(index, color);
    }

    public void getColor(int index, Color3b color) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColor(index, color);
    }

    public void getColor(int index, Color4b color) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColor(index, color);
    }

    public void getColors(int index, float[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColors(index, colors);
    }

    public void getColors(int index, byte[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColors(index, colors);
    }

    public void getColors(int index, Color3f[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColors(index, colors);
    }

    public void getColors(int index, Color4f[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColors(index, colors);
    }

    public void getColors(int index, Color3b[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColors(index, colors);
    }

    public void getColors(int index, Color4b[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColors(index, colors);
    }

    public void getNormal(int index, float[] normal) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray68"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormal(index, normal);
    }

    public void getNormal(int index, Vector3f normal) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray68"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormal(index, normal);
    }

    public void getNormals(int index, float[] normals) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray70"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormals(index, normals);
    }

    public void getNormals(int index, Vector3f[] normals) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray70"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormals(index, normals);
    }

    public void getTextureCoordinate(int index, float[] texCoord) {
        this.getTextureCoordinate(0, index, texCoord);
    }

    public void getTextureCoordinate(int texCoordSet, int index, float[] texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(texCoordSet, index, texCoord);
    }

    public void getTextureCoordinate(int index, Point2f texCoord) {
        this.getTextureCoordinate(0, index, this.texCoord2fArray[0]);
        texCoord.set((Tuple2f)this.texCoord2fArray[0]);
    }

    public void getTextureCoordinate(int texCoordSet, int index, TexCoord2f texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(texCoordSet, index, texCoord);
    }

    public void getTextureCoordinate(int index, Point3f texCoord) {
        this.getTextureCoordinate(0, index, this.texCoord3fArray[0]);
        texCoord.set((Tuple3f)this.texCoord3fArray[0]);
    }

    public void getTextureCoordinate(int texCoordSet, int index, TexCoord3f texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(texCoordSet, index, texCoord);
    }

    public void getTextureCoordinate(int texCoordSet, int index, TexCoord4f texCoord) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(texCoordSet, index, texCoord);
    }

    public void getTextureCoordinates(int index, float[] texCoords) {
        this.getTextureCoordinates(0, index, texCoords);
    }

    public void getTextureCoordinates(int texCoordSet, int index, float[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(texCoordSet, index, texCoords);
    }

    public void getTextureCoordinates(int index, Point2f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(0, index, texCoords);
    }

    public void getTextureCoordinates(int texCoordSet, int index, TexCoord2f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(texCoordSet, index, texCoords);
    }

    public void getTextureCoordinates(int index, Point3f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(0, index, texCoords);
    }

    public void getTextureCoordinates(int texCoordSet, int index, TexCoord3f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(texCoordSet, index, texCoords);
    }

    public void getTextureCoordinates(int texCoordSet, int index, TexCoord4f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((format & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x60) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray109"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(texCoordSet, index, texCoords);
    }

    public void getVertexAttr(int vertexAttrNum, int index, float[] vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(vertexAttrNum, index, vertexAttr);
    }

    public void getVertexAttr(int vertexAttrNum, int index, Point2f vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(vertexAttrNum, index, vertexAttr);
    }

    public void getVertexAttr(int vertexAttrNum, int index, Point3f vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(vertexAttrNum, index, vertexAttr);
    }

    public void getVertexAttr(int vertexAttrNum, int index, Point4f vertexAttr) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttr(vertexAttrNum, index, vertexAttr);
    }

    public void getVertexAttrs(int vertexAttrNum, int index, float[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(vertexAttrNum, index, vertexAttrs);
    }

    public void getVertexAttrs(int vertexAttrNum, int index, Point2f[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 2) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(vertexAttrNum, index, vertexAttrs);
    }

    public void getVertexAttrs(int vertexAttrNum, int index, Point3f[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 3) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(vertexAttrNum, index, vertexAttrs);
    }

    public void getVertexAttrs(int vertexAttrNum, int index, Point4f[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray127"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        int size = ((GeometryArrayRetained)this.retained).vertexAttrSizes[vertexAttrNum];
        if (size != 4) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray134"));
        }
        ((GeometryArrayRetained)this.retained).getVertexAttrs(vertexAttrNum, index, vertexAttrs);
    }

    public void setInitialCoordIndex(int initialCoordIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if (initialCoordIndex < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialCoordIndex(initialCoordIndex);
    }

    public int getInitialCoordIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialCoordIndex();
    }

    public void setInitialColorIndex(int initialColorIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (initialColorIndex < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialColorIndex(initialColorIndex);
    }

    public int getInitialColorIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialColorIndex();
    }

    public void setInitialNormalIndex(int initialNormalIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (initialNormalIndex < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialNormalIndex(initialNormalIndex);
    }

    public int getInitialNormalIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialNormalIndex();
    }

    public void setInitialTexCoordIndex(int texCoordSet, int initialTexCoordIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (initialTexCoordIndex < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialTexCoordIndex(texCoordSet, initialTexCoordIndex);
    }

    public int getInitialTexCoordIndex(int texCoordSet) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialTexCoordIndex(texCoordSet);
    }

    public void setInitialVertexAttrIndex(int vertexAttrNum, int initialVertexAttrIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (initialVertexAttrIndex < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setInitialVertexAttrIndex(vertexAttrNum, initialVertexAttrIndex);
    }

    public int getInitialVertexAttrIndex(int vertexAttrNum) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialVertexAttrIndex(vertexAttrNum);
    }

    public void setCoordRefBuffer(J3DBuffer coords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefBuffer(coords);
    }

    public J3DBuffer getCoordRefBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefBuffer();
    }

    public void setCoordRefFloat(float[] coords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefFloat(coords);
    }

    public float[] getCoordRefFloat() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefFloat();
    }

    public void setCoordRefDouble(double[] coords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefDouble(coords);
    }

    public double[] getCoordRefDouble() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefDouble();
    }

    public void setCoordRef3f(Point3f[] coords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRef3f(coords);
    }

    public Point3f[] getCoordRef3f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRef3f();
    }

    public void setCoordRef3d(Point3d[] coords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRef3d(coords);
    }

    public Point3d[] getCoordRef3d() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRef3d();
    }

    public void setColorRefBuffer(J3DBuffer colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefBuffer(colors);
    }

    public J3DBuffer getColorRefBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefBuffer();
    }

    public void setColorRefFloat(float[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefFloat(colors);
    }

    public float[] getColorRefFloat() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefFloat();
    }

    public void setColorRefByte(byte[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefByte(colors);
    }

    public byte[] getColorRefByte() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefByte();
    }

    public void setColorRef3f(Color3f[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef3f(colors);
    }

    public Color3f[] getColorRef3f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef3f();
    }

    public void setColorRef4f(Color4f[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef4f(colors);
    }

    public Color4f[] getColorRef4f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef4f();
    }

    public void setColorRef3b(Color3b[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((format & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef3b(colors);
    }

    public Color3b[] getColorRef3b() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef3b();
    }

    public void setColorRef4b(Color4b[] colors) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((format & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef4b(colors);
    }

    public Color4b[] getColorRef4b() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef4b();
    }

    public void setNormalRefBuffer(J3DBuffer normals) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRefBuffer(normals);
    }

    public J3DBuffer getNormalRefBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRefBuffer();
    }

    public void setNormalRefFloat(float[] normals) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRefFloat(normals);
    }

    public float[] getNormalRefFloat() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRefFloat();
    }

    public void setNormalRef3f(Vector3f[] normals) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRef3f(normals);
    }

    public Vector3f[] getNormalRef3f() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRef3f();
    }

    public void setTexCoordRefBuffer(int texCoordSet, J3DBuffer texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRefBuffer(texCoordSet, texCoords);
    }

    public J3DBuffer getTexCoordRefBuffer(int texCoordSet) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRefBuffer(texCoordSet);
    }

    public void setTexCoordRefFloat(int texCoordSet, float[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRefFloat(texCoordSet, texCoords);
    }

    public float[] getTexCoordRefFloat(int texCoordSet) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRefFloat(texCoordSet);
    }

    public void setTexCoordRef2f(int texCoordSet, TexCoord2f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((format & 0x440) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRef2f(texCoordSet, texCoords);
    }

    public TexCoord2f[] getTexCoordRef2f(int texCoordSet) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRef2f(texCoordSet);
    }

    public void setTexCoordRef3f(int texCoordSet, TexCoord3f[] texCoords) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((format & 0x420) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRef3f(texCoordSet, texCoords);
    }

    public TexCoord3f[] getTexCoordRef3f(int texCoordSet) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRef3f(texCoordSet);
    }

    public void setVertexAttrRefBuffer(int vertexAttrNum, J3DBuffer vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrRefBuffer(vertexAttrNum, vertexAttrs);
    }

    public J3DBuffer getVertexAttrRefBuffer(int vertexAttrNum) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexAttrRefBuffer(vertexAttrNum);
    }

    public void setVertexAttrRefFloat(int vertexAttrNum, float[] vertexAttrs) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setVertexAttrRefFloat(vertexAttrNum, vertexAttrs);
    }

    public float[] getVertexAttrRefFloat(int vertexAttrNum) {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        if ((format & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexAttrRefFloat(vertexAttrNum);
    }

    public void setInterleavedVertices(float[] vertexData) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        ((GeometryArrayRetained)this.retained).setInterleavedVertices(vertexData);
    }

    public float[] getInterleavedVertices() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((format & 0x800) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray119"));
        }
        return ((GeometryArrayRetained)this.retained).getInterleavedVertices();
    }

    public void setInterleavedVertexBuffer(J3DBuffer vertexData) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        ((GeometryArrayRetained)this.retained).setInterleavedVertexBuffer(vertexData);
    }

    public J3DBuffer getInterleavedVertexBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(21) && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        if ((format & 0x800) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray118"));
        }
        return ((GeometryArrayRetained)this.retained).getInterleavedVertexBuffer();
    }
}

