/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.vecmath.Point2f;

public class FontExtrusion {
    float length = 0.2f;
    Shape shape;
    Point2f[] pnts;
    double tessellationTolerance = 0.01;

    public FontExtrusion() {
        this.shape = null;
    }

    public FontExtrusion(Shape extrusionShape) {
        this.setExtrusionShape(extrusionShape);
    }

    public FontExtrusion(Shape extrusionShape, double tessellationTolerance) {
        this.tessellationTolerance = tessellationTolerance;
        this.setExtrusionShape(extrusionShape);
    }

    public void setExtrusionShape(Shape extrusionShape) {
        this.shape = extrusionShape;
        if (this.shape == null) {
            return;
        }
        PathIterator pIt = this.shape.getPathIterator(null, this.tessellationTolerance);
        ArrayList<Point2f> coords = new ArrayList<Point2f>();
        float[] tmpCoords = new float[6];
        float prevX = 0.0f;
        int n = 0;
        int inc = -1;
        while (!pIt.isDone()) {
            Point2f vertex = new Point2f();
            int flag = pIt.currentSegment(tmpCoords);
            if (flag == 1) {
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                if (inc == -1) {
                    if (prevX < vertex.x) {
                        inc = 0;
                    } else if (prevX > vertex.x) {
                        inc = 1;
                    }
                }
                if (inc == 0 && prevX > vertex.x || inc == 1 && prevX < vertex.x) {
                    throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion0"));
                }
                prevX = vertex.x;
                ++n;
                coords.add(vertex);
            } else if (flag == 0) {
                if (n != 0) {
                    throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion3"));
                }
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                prevX = vertex.x;
                ++n;
                coords.add(vertex);
            }
            pIt.next();
        }
        int num = coords.size();
        this.pnts = new Point2f[num];
        if (inc == 0) {
            for (int i = 0; i < num; ++i) {
                this.pnts[i] = (Point2f)coords.get(i);
            }
        } else {
            for (int i = 0; i < num; ++i) {
                this.pnts[i] = (Point2f)coords.get(num - i - 1);
            }
        }
        this.pnts[num - 1].y = 0.0f;
        if (this.pnts[0].x != 0.0f) {
            throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion1"));
        }
        float dx = this.pnts[0].x - this.pnts[num - 1].x;
        float dy = this.pnts[0].y - this.pnts[num - 1].y;
        this.length = (float)Math.sqrt(dx * dx + dy * dy);
    }

    public Shape getExtrusionShape() {
        return this.shape;
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }
}

