/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.BackgroundRetained;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.EnvironmentSet;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LeafRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Tuple3f;

abstract class FogRetained
extends LeafRetained {
    static final int COLOR_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int BOUNDINGLEAF_CHANGED = 8;
    static final int INIT_MIRROR = 16;
    static final int CLEAR_MIRROR = 32;
    static final int LAST_DEFINED_BIT = 32;
    Color3f color = new Color3f(0.0f, 0.0f, 0.0f);
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Vector<GroupRetained> scopes = new Vector();
    int isDirty = 65535;
    boolean inImmCtx = false;
    Bounds region = null;
    FogRetained sgFog = null;
    FogRetained mirrorFog = null;
    static final int targetThreads = 4224;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    UnorderList environmentSets = new UnorderList(1, EnvironmentSet.class);
    boolean isViewScoped = false;
    private double localToVworldScale = 1.0;

    FogRetained() {
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void initColor(Color3f color) {
        this.color.set((Tuple3f)color);
    }

    void setColor(Color3f color) {
        this.color.set((Tuple3f)color);
        this.sendMessage(1, new Color3f(color));
    }

    void initColor(float r, float g, float b) {
        this.color.x = r;
        this.color.y = g;
        this.color.z = b;
    }

    void setColor(float r, float g, float b) {
        this.initColor(r, g, b);
        this.sendMessage(1, new Color3f(r, g, b));
    }

    void getColor(Color3f color) {
        color.set((Tuple3f)this.color);
    }

    void initInfluencingBounds(Bounds region) {
        this.regionOfInfluence = region != null ? (Bounds)region.clone() : null;
        if (this.staticTransform != null) {
            this.regionOfInfluence.transform(this.staticTransform.transform);
        }
    }

    void setInfluencingBounds(Bounds region) {
        this.initInfluencingBounds(region);
        this.sendMessage(4, region != null ? region.clone() : null);
    }

    Bounds getInfluencingBounds() {
        Bounds b = null;
        if (this.regionOfInfluence != null) {
            b = (Bounds)this.regionOfInfluence.clone();
            if (this.staticTransform != null) {
                Transform3D invTransform = this.staticTransform.getInvTransform();
                b.transform(invTransform);
            }
        }
        return b;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf region) {
        this.boundingLeaf = region != null ? (BoundingLeafRetained)region.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf region) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorFog);
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorFog);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(8, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void initScope(Group scope, int index) {
        this.scopes.setElementAt((GroupRetained)scope.retained, index);
    }

    void setScope(Group scope, int index) {
        ArrayList addScopeList = new ArrayList();
        ArrayList removeScopeList = new ArrayList();
        Object[] scopeInfo = new Object[3];
        GroupRetained group = this.scopes.get(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedFog(this.mirrorFog, removeScopeList, this.tempKey);
        group = (GroupRetained)scope.retained;
        this.initScope(scope, index);
        this.tempKey.reset();
        group.addAllNodesForScopedFog(this.mirrorFog, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void initInsertScope(Node scope, int index) {
        GroupRetained group = (GroupRetained)scope.retained;
        group.setFogScope();
        this.scopes.insertElementAt((GroupRetained)scope.retained, index);
    }

    void insertScope(Node scope, int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        this.initInsertScope(scope, index);
        GroupRetained group = (GroupRetained)scope.retained;
        this.tempKey.reset();
        group.addAllNodesForScopedFog(this.mirrorFog, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void initRemoveScope(int index) {
        GroupRetained group = this.scopes.elementAt(index);
        this.scopes.removeElementAt(index);
        group.removeFogScope();
    }

    void removeScope(int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList removeScopeList = new ArrayList();
        GroupRetained group = this.scopes.elementAt(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedFog(this.mirrorFog, removeScopeList, this.tempKey);
        this.initRemoveScope(index);
        scopeInfo[0] = null;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    Group getScope(int index) {
        return (Group)this.scopes.elementAt((int)index).source;
    }

    Iterator<Group> getAllScopes() {
        Iterator<GroupRetained> elm = this.scopes.iterator();
        Vector<Group> v = new Vector<Group>(this.scopes.size());
        while (elm.hasNext()) {
            v.add((Group)elm.next().source);
        }
        return v.iterator();
    }

    void initAddScope(Group scope) {
        GroupRetained group = (GroupRetained)scope.retained;
        this.scopes.addElement(group);
        group.setFogScope();
    }

    void addScope(Group scope) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        GroupRetained group = (GroupRetained)scope.retained;
        this.initAddScope(scope);
        this.tempKey.reset();
        group.addAllNodesForScopedFog(this.mirrorFog, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    int numScopes() {
        return this.scopes.size();
    }

    int indexOfScope(Group scope) {
        if (scope != null) {
            return this.scopes.indexOf(scope.retained);
        }
        return this.scopes.indexOf(null);
    }

    void removeScope(Group scope) {
        int i = this.indexOfScope(scope);
        if (i >= 0) {
            this.removeScope(i);
        }
    }

    void initRemoveScope(Group scope) {
        int i = this.indexOfScope(scope);
        if (i >= 0) {
            this.initRemoveScope(i);
        }
    }

    void removeAllScopes() {
        Object[] scopeInfo = new Object[3];
        ArrayList removeScopeList = new ArrayList();
        int n = this.scopes.size();
        this.tempKey.reset();
        for (int index = n - 1; index >= 0; --index) {
            GroupRetained group = this.scopes.elementAt(index);
            group.removeAllNodesForScopedFog(this.mirrorFog, removeScopeList, this.tempKey);
            this.initRemoveScope(index);
        }
        scopeInfo[0] = null;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void initRemoveAllScopes() {
        int n = this.scopes.size();
        for (int index = n - 1; index >= 0; --index) {
            this.initRemoveScope(index);
        }
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    boolean isScoped() {
        return this.scopes != null;
    }

    abstract void update(Context var1, double var2);

    void updateImmediateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        if ((component & 4) != 0) {
            this.mirrorFog.regionOfInfluence = (Bounds)objs[2];
            if (this.mirrorFog.boundingLeaf == null) {
                if (objs[2] != null) {
                    this.mirrorFog.region = this.mirrorFog.regionOfInfluence.copy(this.mirrorFog.region);
                    this.mirrorFog.region.transform(this.mirrorFog.regionOfInfluence, this.getCurrentLocalToVworld());
                } else {
                    this.mirrorFog.region = null;
                }
            }
        } else if ((component & 8) != 0) {
            this.mirrorFog.boundingLeaf = (BoundingLeafRetained)objs[2];
            if (objs[2] != null) {
                this.mirrorFog.region = this.mirrorFog.boundingLeaf.transformedRegion;
            } else if (this.mirrorFog.regionOfInfluence != null) {
                this.mirrorFog.region = this.mirrorFog.regionOfInfluence.copy(this.mirrorFog.region);
                this.mirrorFog.region.transform(this.mirrorFog.regionOfInfluence, this.getCurrentLocalToVworld());
            } else {
                this.mirrorFog.region = null;
            }
        } else if ((component & 2) != 0) {
            Shape3DRetained obj;
            int i;
            Object[] scopeList = (Object[])objs[2];
            ArrayList addList = (ArrayList)scopeList[0];
            ArrayList removeList = (ArrayList)scopeList[1];
            boolean isScoped = (Boolean)scopeList[2];
            if (addList != null) {
                this.mirrorFog.isScoped = isScoped;
                for (i = 0; i < addList.size(); ++i) {
                    obj = ((GeometryAtom)addList.get((int)i)).source;
                    obj.addFog(this.mirrorFog);
                }
            }
            if (removeList != null) {
                this.mirrorFog.isScoped = isScoped;
                for (i = 0; i < removeList.size(); ++i) {
                    obj = ((GeometryAtom)removeList.get((int)i)).source;
                    obj.removeFog(this.mirrorFog);
                }
            }
        }
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        if ((component & 1) != 0) {
            this.mirrorFog.color.set((Tuple3f)((Color3f)objs[2]));
        }
        if ((component & 0x10) != 0) {
            this.mirrorFog.color.set((Tuple3f)((Color3f)objs[3]));
        }
    }

    @Override
    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    @Override
    void setLive(SetLiveState s) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("FogRetained0"));
        }
        super.doSetLive(s);
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("FogRetained1"));
        }
        if (this.mirrorFog == null) {
            this.mirrorFog = (FogRetained)this.clone();
            this.mirrorFog.boundingLeaf = null;
            this.mirrorFog.sgFog = this;
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorFog);
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this.mirrorFog);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this.mirrorFog);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorFog, 1);
            s.notifyThreads |= 0x2000;
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorFog, 1);
        }
        this.mirrorFog.switchState = s.switchStates.get(0);
        s.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    void initMirrorObject(Object[] args) {
        Object[] scopeInfo = (Object[])args[2];
        Boolean scoped = (Boolean)scopeInfo[0];
        ArrayList shapeList = (ArrayList)scopeInfo[1];
        BoundingLeafRetained bl = (BoundingLeafRetained)((Object[])args[4])[0];
        Bounds bnds = (Bounds)((Object[])args[4])[1];
        this.mirrorFog.inBackgroundGroup = (Boolean)((Object[])args[4])[2];
        this.mirrorFog.geometryBackground = (BackgroundRetained)((Object[])args[4])[3];
        for (int i = 0; i < shapeList.size(); ++i) {
            Shape3DRetained shape = ((GeometryAtom)shapeList.get((int)i)).source;
            shape.addFog(this.mirrorFog);
        }
        this.mirrorFog.isScoped = scoped;
        if (bl != null) {
            this.mirrorFog.boundingLeaf = bl.mirrorBoundingLeaf;
            this.mirrorFog.region = this.boundingLeaf.transformedRegion;
        } else {
            this.mirrorFog.boundingLeaf = null;
            this.mirrorFog.region = null;
        }
        if (bnds != null) {
            this.mirrorFog.regionOfInfluence = bnds;
            if (this.mirrorFog.region == null) {
                this.mirrorFog.region = (Bounds)this.regionOfInfluence.clone();
                this.mirrorFog.region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
            }
        } else {
            this.mirrorFog.regionOfInfluence = null;
        }
    }

    void clearMirrorObject(Object[] args) {
        ArrayList shapeList = (ArrayList)args[2];
        for (int i = 0; i < shapeList.size(); ++i) {
            Shape3DRetained shape = ((GeometryAtom)shapeList.get((int)i)).source;
            shape.removeFog(this.mirrorFog);
        }
        this.mirrorFog.isScoped = false;
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorFog, 1);
        }
        s.notifyThreads |= 0x1080;
        if (this.mirrorFog.boundingLeaf != null) {
            this.mirrorFog.boundingLeaf.removeUser(this.mirrorFog);
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this.mirrorFog);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this.mirrorFog);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorFog, 1);
            s.notifyThreads |= 0x2000;
        }
        if (this.scopes.size() > 0) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 4096;
            createMessage.universe = this.universe;
            createMessage.type = 22;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(32);
            ArrayList removeScopeList = new ArrayList();
            for (int i = 0; i < this.scopes.size(); ++i) {
                GroupRetained group = this.scopes.get(i);
                this.tempKey.reset();
                group.removeAllNodesForScopedFog(this.mirrorFog, removeScopeList, this.tempKey);
            }
            createMessage.args[2] = removeScopeList;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    protected Object clone() {
        FogRetained fr = (FogRetained)super.clone();
        fr.color = new Color3f(this.color);
        Bounds b = this.getInfluencingBounds();
        if (b != null) {
            fr.initInfluencingBounds(b);
        }
        fr.scopes = new Vector();
        fr.isDirty = 65535;
        fr.inImmCtx = false;
        fr.region = null;
        fr.sgFog = null;
        fr.mirrorFog = null;
        fr.environmentSets = new UnorderList(1, EnvironmentSet.class);
        return fr;
    }

    @Override
    void updateTransformChange() {
        super.updateTransformChange();
        this.setLocalToVworldScale(this.sgFog.getLastLocalToVworld().getDistanceScale());
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.sgFog.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int attrMask, Object attr) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.universe = this.universe;
        createMessage.type = 22;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        if (this.regionOfInfluence != null) {
            this.regionOfInfluence.transform(xform.transform);
        }
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        leafList.add(this.mirrorFog);
    }

    protected void validateDistancesInEc(double vworldToCoexistenceScale) {
        assert (false) : "subclasses should override this method";
    }

    double getLocalToVworldScale() {
        return this.localToVworldScale;
    }

    void setLocalToVworldScale(double localToVworldScale) {
        this.localToVworldScale = localToVworldScale;
    }
}

