/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Locale;
import java.util.Objects;
import org.openscience.cdk.config.Elements;

public final class TransformOp
implements Comparable<TransformOp> {
    final Type type;
    final int a;
    final int b;
    final int c;
    final int d;

    public TransformOp(Type type, int a, int b, int c, int d) {
        this.type = type;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public TransformOp(Type type, int a, int b, int c) {
        this(type, a, b, c, 0);
    }

    public TransformOp(Type type, int a, int b) {
        this(type, a, b, 0);
    }

    public TransformOp(Type type, int a) {
        this(type, a, 0, 0);
    }

    public TransformOp(Type type, TransformOp op) {
        this(type, op.a, op.b, op.c, op.d);
    }

    public Type type() {
        return this.type;
    }

    public int argA() {
        return this.a;
    }

    public int argB() {
        return this.b;
    }

    public int argC() {
        return this.c;
    }

    public int argD() {
        return this.d;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformOp opCode = (TransformOp)o;
        return this.a == opCode.a && this.b == opCode.b && this.c == opCode.c && this.d == opCode.d && this.type == opCode.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.a, this.b, this.c, this.d});
    }

    TransformOp remap(int from, int to) {
        if (this.a == from) {
            return new TransformOp(this.type, to, this.b, this.c, this.d);
        }
        if (this.b == from && (this.type == Type.NewBond || this.type == Type.OverwriteBond || this.type == Type.DeleteBond || this.type == Type.BondOrder || this.type == Type.MoveH || this.type == Type.PromoteH)) {
            return new TransformOp(this.type, this.a, to, this.c, this.d);
        }
        if (this.type == Type.Tetrahedral || this.type == Type.DbOpposite || this.type == Type.DbTogether) {
            if (this.b == from) {
                return new TransformOp(this.type, this.a, to, this.c, this.d);
            }
            if (this.c == from) {
                return new TransformOp(this.type, this.a, this.b, to, this.d);
            }
            if (this.d == from) {
                return new TransformOp(this.type, this.a, this.b, this.c, to);
            }
        }
        return this;
    }

    int getOtherIdx(int x) {
        switch (this.type) {
            case NewBond: 
            case OverwriteBond: 
            case DeleteBond: 
            case BondOrder: 
            case MoveH: 
            case PromoteH: {
                if (x == this.a) {
                    return this.b;
                }
                if (x == this.b) {
                    return this.a;
                }
                return -1;
            }
        }
        return -1;
    }

    int getMaxAtomIdx() {
        switch (this.type) {
            case NewAtom: 
            case ReplaceAtom: 
            case DeleteAtom: 
            case Mass: 
            case Element: 
            case Aromatic: 
            case Charge: 
            case ImplH: 
            case TotalH: 
            case AdjustH: {
                return this.a;
            }
            case NewBond: 
            case OverwriteBond: 
            case DeleteBond: 
            case BondOrder: 
            case MoveH: 
            case PromoteH: 
            case AromaticBond: {
                return Math.max(this.a, this.b);
            }
            case DbOpposite: 
            case DbTogether: 
            case Tetrahedral: {
                return Math.max(Math.max(this.a, this.b), Math.max(this.c, this.d));
            }
            case RemoveUnmapped: 
            case RecomputeHydrogens: {
                return 0;
            }
        }
        throw new IllegalStateException((Object)((Object)this.type) + " atom index?");
    }

    private int getMinAtomIdx() {
        switch (this.type) {
            case NewAtom: 
            case ReplaceAtom: 
            case DeleteAtom: 
            case Mass: 
            case Element: 
            case Aromatic: 
            case Charge: 
            case ImplH: 
            case TotalH: 
            case AdjustH: {
                return this.a;
            }
            case NewBond: 
            case OverwriteBond: 
            case DeleteBond: 
            case BondOrder: 
            case MoveH: 
            case PromoteH: 
            case AromaticBond: {
                return Math.min(this.a, this.b);
            }
            case DbOpposite: 
            case DbTogether: 
            case Tetrahedral: {
                return Math.min(Math.min(this.a, this.b), Math.min(this.c, this.d));
            }
            case RemoveUnmapped: 
            case RecomputeHydrogens: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    private int getPriority() {
        switch (this.type) {
            case NewBond: 
            case OverwriteBond: 
            case NewAtom: 
            case AdjustH: {
                return 0;
            }
            case MoveH: 
            case PromoteH: {
                return 1;
            }
            case DeleteBond: 
            case DeleteAtom: {
                return 2;
            }
            case TotalH: {
                return 4;
            }
            case DbOpposite: 
            case DbTogether: 
            case Tetrahedral: {
                return 5;
            }
            case RemoveUnmapped: 
            case RecomputeHydrogens: {
                return 6;
            }
        }
        return 3;
    }

    @Override
    public int compareTo(TransformOp that) {
        int cmp = Integer.compare(this.getPriority(), that.getPriority());
        if (cmp != 0) {
            return cmp;
        }
        int thisMinIdx = this.getMinAtomIdx();
        int thisMaxIdx = this.getMaxAtomIdx();
        int thatMinIdx = that.getMinAtomIdx();
        int thatMaxIdx = that.getMaxAtomIdx();
        if (this.getPriority() == 0 && (cmp = Integer.compare(thisMaxIdx, thatMaxIdx)) != 0) {
            return cmp;
        }
        if (thisMaxIdx < thatMinIdx) {
            return -1;
        }
        if (thatMaxIdx < thisMinIdx) {
            return 1;
        }
        return this.type.compareTo(that.type);
    }

    public String toString() {
        switch (this.type) {
            case NewAtom: 
            case ReplaceAtom: {
                String desc = Elements.ofNumber((int)this.b).symbol();
                if (this.d != 0) {
                    desc = desc.toLowerCase(Locale.ROOT);
                }
                desc = desc + "H" + this.c;
                return (Object)((Object)this.type) + "{[" + desc + "@" + this.a + "]}";
            }
            case ReplaceHydrogen: {
                String desc = Elements.ofNumber((int)this.c).symbol();
                desc = desc + "H" + this.d;
                return (Object)((Object)this.type) + "{[" + desc + "@" + this.a + "=>" + this.b + "]}";
            }
            case DeleteAtom: {
                return (Object)((Object)this.type) + "{" + this.a + "}";
            }
            case Mass: 
            case Element: 
            case Aromatic: 
            case Charge: 
            case ImplH: 
            case TotalH: 
            case AdjustH: {
                return (Object)((Object)this.type) + "{" + this.b + "@" + this.a + "}";
            }
            case DeleteBond: {
                return (Object)((Object)this.type) + "{" + this.a + "-" + this.b + "}";
            }
            case NewBond: 
            case OverwriteBond: 
            case BondOrder: 
            case AromaticBond: {
                switch (this.c) {
                    case 1: {
                        return (Object)((Object)this.type) + "{" + this.a + "-" + this.b + "}";
                    }
                    case 2: {
                        return (Object)((Object)this.type) + "{" + this.a + "=" + this.b + "}";
                    }
                    case 3: {
                        return (Object)((Object)this.type) + "{" + this.a + "#" + this.b + "}";
                    }
                }
                return (Object)((Object)this.type) + "{" + this.a + "," + this.b + ",order=" + this.c + "}";
            }
            case MoveH: 
            case PromoteH: {
                return (Object)((Object)this.type) + "{" + this.a + "=>" + this.b + "}";
            }
            case Tetrahedral: {
                return (Object)((Object)this.type) + "{" + this.a + ",@(" + this.b + "," + this.c + "," + this.d + "}";
            }
            case DbOpposite: {
                return (Object)((Object)this.type) + "{" + this.c + "/" + this.a + "=" + this.b + "/" + this.d + "}";
            }
            case DbTogether: {
                return (Object)((Object)this.type) + "{" + this.c + "/" + this.a + "=" + this.b + "\\" + this.d + "}";
            }
            case RemoveUnmapped: 
            case RecomputeHydrogens: {
                return this.type.toString();
            }
        }
        throw new IllegalStateException("Unknown op:" + (Object)((Object)this.type));
    }

    public static enum Type {
        NewAtom,
        NewBond,
        OverwriteBond,
        DeleteBond,
        DeleteAtom,
        BondOrder,
        Mass,
        Element,
        Aromatic,
        AromaticBond,
        Charge,
        ImplH,
        TotalH,
        AdjustH,
        PromoteH,
        MoveH,
        Tetrahedral,
        DbTogether,
        DbOpposite,
        ReplaceAtom,
        ReplaceHydrogen,
        RemoveUnmapped,
        RecomputeHydrogens;

    }
}

