/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.schema.core;

import java.util.Arrays;
import java.util.Optional;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.schema.DelegatingBlock;
import org.rcsb.cif.schema.DelegatingCategory;
import org.rcsb.cif.schema.core.AtomAnalytical;
import org.rcsb.cif.schema.core.AtomAnalyticalMassLoss;
import org.rcsb.cif.schema.core.AtomAnalyticalSource;
import org.rcsb.cif.schema.core.AtomScatVersusStol;
import org.rcsb.cif.schema.core.AtomSite;
import org.rcsb.cif.schema.core.AtomSiteAniso;
import org.rcsb.cif.schema.core.AtomSiteAnisotrop;
import org.rcsb.cif.schema.core.AtomSites;
import org.rcsb.cif.schema.core.AtomSitesCartnTransform;
import org.rcsb.cif.schema.core.AtomSitesFractTransform;
import org.rcsb.cif.schema.core.AtomType;
import org.rcsb.cif.schema.core.AtomTypeScat;
import org.rcsb.cif.schema.core.Audit;
import org.rcsb.cif.schema.core.AuditAuthor;
import org.rcsb.cif.schema.core.AuditAuthorRole;
import org.rcsb.cif.schema.core.AuditConform;
import org.rcsb.cif.schema.core.AuditContactAuthor;
import org.rcsb.cif.schema.core.AuditLink;
import org.rcsb.cif.schema.core.AuditSupport;
import org.rcsb.cif.schema.core.Cell;
import org.rcsb.cif.schema.core.CellAngle;
import org.rcsb.cif.schema.core.CellMeasurement;
import org.rcsb.cif.schema.core.CellMeasurementRefln;
import org.rcsb.cif.schema.core.ChemCompBond;
import org.rcsb.cif.schema.core.Chemical;
import org.rcsb.cif.schema.core.ChemicalConnAtom;
import org.rcsb.cif.schema.core.ChemicalConnBond;
import org.rcsb.cif.schema.core.ChemicalFormula;
import org.rcsb.cif.schema.core.Citation;
import org.rcsb.cif.schema.core.CitationAuthor;
import org.rcsb.cif.schema.core.CitationEditor;
import org.rcsb.cif.schema.core.Computing;
import org.rcsb.cif.schema.core.Database;
import org.rcsb.cif.schema.core.DatabaseCode;
import org.rcsb.cif.schema.core.DatabaseRelated;
import org.rcsb.cif.schema.core.Diffrn;
import org.rcsb.cif.schema.core.DiffrnAttenuator;
import org.rcsb.cif.schema.core.DiffrnDetector;
import org.rcsb.cif.schema.core.DiffrnMeasurement;
import org.rcsb.cif.schema.core.DiffrnOrientMatrix;
import org.rcsb.cif.schema.core.DiffrnOrientRefln;
import org.rcsb.cif.schema.core.DiffrnRadiation;
import org.rcsb.cif.schema.core.DiffrnRadiationWavelength;
import org.rcsb.cif.schema.core.DiffrnRefln;
import org.rcsb.cif.schema.core.DiffrnReflns;
import org.rcsb.cif.schema.core.DiffrnReflnsClass;
import org.rcsb.cif.schema.core.DiffrnReflnsTransfMatrix;
import org.rcsb.cif.schema.core.DiffrnScaleGroup;
import org.rcsb.cif.schema.core.DiffrnSource;
import org.rcsb.cif.schema.core.DiffrnStandardRefln;
import org.rcsb.cif.schema.core.DiffrnStandards;
import org.rcsb.cif.schema.core.DisplayColour;
import org.rcsb.cif.schema.core.Exptl;
import org.rcsb.cif.schema.core.ExptlAbsorpt;
import org.rcsb.cif.schema.core.ExptlCrystal;
import org.rcsb.cif.schema.core.ExptlCrystalAppearance;
import org.rcsb.cif.schema.core.ExptlCrystalFace;
import org.rcsb.cif.schema.core.Function;
import org.rcsb.cif.schema.core.Geom;
import org.rcsb.cif.schema.core.GeomAngle;
import org.rcsb.cif.schema.core.GeomBond;
import org.rcsb.cif.schema.core.GeomContact;
import org.rcsb.cif.schema.core.GeomHbond;
import org.rcsb.cif.schema.core.GeomTorsion;
import org.rcsb.cif.schema.core.Journal;
import org.rcsb.cif.schema.core.JournalCoeditor;
import org.rcsb.cif.schema.core.JournalDate;
import org.rcsb.cif.schema.core.JournalIndex;
import org.rcsb.cif.schema.core.JournalTecheditor;
import org.rcsb.cif.schema.core.ModelSite;
import org.rcsb.cif.schema.core.Publ;
import org.rcsb.cif.schema.core.PublAuthor;
import org.rcsb.cif.schema.core.PublBody;
import org.rcsb.cif.schema.core.PublContactAuthor;
import org.rcsb.cif.schema.core.PublManuscript;
import org.rcsb.cif.schema.core.PublManuscriptIncl;
import org.rcsb.cif.schema.core.PublManuscriptInclExtra;
import org.rcsb.cif.schema.core.PublRequested;
import org.rcsb.cif.schema.core.PublSection;
import org.rcsb.cif.schema.core.Refine;
import org.rcsb.cif.schema.core.RefineDiff;
import org.rcsb.cif.schema.core.RefineLs;
import org.rcsb.cif.schema.core.RefineLsClass;
import org.rcsb.cif.schema.core.Refln;
import org.rcsb.cif.schema.core.Reflns;
import org.rcsb.cif.schema.core.ReflnsClass;
import org.rcsb.cif.schema.core.ReflnsScale;
import org.rcsb.cif.schema.core.ReflnsShell;
import org.rcsb.cif.schema.core.SpaceGroup;
import org.rcsb.cif.schema.core.SpaceGroupGenerator;
import org.rcsb.cif.schema.core.SpaceGroupSymop;
import org.rcsb.cif.schema.core.SpaceGroupWyckoff;
import org.rcsb.cif.schema.core.Symmetry;
import org.rcsb.cif.schema.core.SymmetryEquiv;
import org.rcsb.cif.schema.core.ValenceParam;
import org.rcsb.cif.schema.core.ValenceRef;

public class CifCoreBlock
extends DelegatingBlock {
    public CifCoreBlock(Block delegate) {
        super(delegate);
    }

    public Column<?> getAliasedColumn(String ... aliases) {
        Optional<Column> optional = Arrays.stream(aliases).filter(alias -> this.getCategories().containsKey(alias)).findFirst().map(alias -> this.getCategories().get(alias).getColumn(""));
        return optional.orElse(Column.EmptyColumn.UNNAMED_COLUMN);
    }

    @Override
    protected Category createDelegate(String categoryName, Category category) {
        switch (categoryName) {
            case "diffrn": {
                return this.getDiffrn();
            }
            case "cell": {
                return this.getCell();
            }
            case "cell_measurement": {
                return this.getCellMeasurement();
            }
            case "cell_measurement_refln": {
                return this.getCellMeasurementRefln();
            }
            case "diffrn_attenuator": {
                return this.getDiffrnAttenuator();
            }
            case "diffrn_detector": {
                return this.getDiffrnDetector();
            }
            case "diffrn_measurement": {
                return this.getDiffrnMeasurement();
            }
            case "diffrn_orient_matrix": {
                return this.getDiffrnOrientMatrix();
            }
            case "diffrn_orient_refln": {
                return this.getDiffrnOrientRefln();
            }
            case "diffrn_radiation": {
                return this.getDiffrnRadiation();
            }
            case "diffrn_radiation_wavelength": {
                return this.getDiffrnRadiationWavelength();
            }
            case "diffrn_refln": {
                return this.getDiffrnRefln();
            }
            case "diffrn_reflns": {
                return this.getDiffrnReflns();
            }
            case "diffrn_reflns_class": {
                return this.getDiffrnReflnsClass();
            }
            case "diffrn_reflns_transf_matrix": {
                return this.getDiffrnReflnsTransfMatrix();
            }
            case "diffrn_scale_group": {
                return this.getDiffrnScaleGroup();
            }
            case "diffrn_source": {
                return this.getDiffrnSource();
            }
            case "diffrn_standards": {
                return this.getDiffrnStandards();
            }
            case "diffrn_standard_refln": {
                return this.getDiffrnStandardRefln();
            }
            case "refln": {
                return this.getRefln();
            }
            case "reflns": {
                return this.getReflns();
            }
            case "reflns_class": {
                return this.getReflnsClass();
            }
            case "reflns_scale": {
                return this.getReflnsScale();
            }
            case "reflns_shell": {
                return this.getReflnsShell();
            }
            case "exptl": {
                return this.getExptl();
            }
            case "chemical": {
                return this.getChemical();
            }
            case "chemical_conn_atom": {
                return this.getChemicalConnAtom();
            }
            case "chemical_conn_bond": {
                return this.getChemicalConnBond();
            }
            case "chemical_formula": {
                return this.getChemicalFormula();
            }
            case "exptl_absorpt": {
                return this.getExptlAbsorpt();
            }
            case "exptl_crystal": {
                return this.getExptlCrystal();
            }
            case "exptl_crystal_appearance": {
                return this.getExptlCrystalAppearance();
            }
            case "exptl_crystal_face": {
                return this.getExptlCrystalFace();
            }
            case "space_group": {
                return this.getSpaceGroup();
            }
            case "symmetry": {
                return this.getSymmetry();
            }
            case "space_group_generator": {
                return this.getSpaceGroupGenerator();
            }
            case "space_group_symop": {
                return this.getSpaceGroupSymop();
            }
            case "space_group_wyckoff": {
                return this.getSpaceGroupWyckoff();
            }
            case "geom": {
                return this.getGeom();
            }
            case "geom_angle": {
                return this.getGeomAngle();
            }
            case "geom_bond": {
                return this.getGeomBond();
            }
            case "geom_contact": {
                return this.getGeomContact();
            }
            case "geom_hbond": {
                return this.getGeomHbond();
            }
            case "geom_torsion": {
                return this.getGeomTorsion();
            }
            case "model_site": {
                return this.getModelSite();
            }
            case "valence_param": {
                return this.getValenceParam();
            }
            case "valence_ref": {
                return this.getValenceRef();
            }
            case "audit": {
                return this.getAudit();
            }
            case "audit_author": {
                return this.getAuditAuthor();
            }
            case "audit_author_role": {
                return this.getAuditAuthorRole();
            }
            case "audit_conform": {
                return this.getAuditConform();
            }
            case "audit_contact_author": {
                return this.getAuditContactAuthor();
            }
            case "audit_link": {
                return this.getAuditLink();
            }
            case "audit_support": {
                return this.getAuditSupport();
            }
            case "citation": {
                return this.getCitation();
            }
            case "citation_author": {
                return this.getCitationAuthor();
            }
            case "citation_editor": {
                return this.getCitationEditor();
            }
            case "computing": {
                return this.getComputing();
            }
            case "database": {
                return this.getDatabase();
            }
            case "database_code": {
                return this.getDatabaseCode();
            }
            case "database_related": {
                return this.getDatabaseRelated();
            }
            case "display_colour": {
                return this.getDisplayColour();
            }
            case "journal": {
                return this.getJournal();
            }
            case "journal_coeditor": {
                return this.getJournalCoeditor();
            }
            case "journal_date": {
                return this.getJournalDate();
            }
            case "journal_index": {
                return this.getJournalIndex();
            }
            case "journal_techeditor": {
                return this.getJournalTecheditor();
            }
            case "publ": {
                return this.getPubl();
            }
            case "publ_author": {
                return this.getPublAuthor();
            }
            case "publ_body": {
                return this.getPublBody();
            }
            case "publ_contact_author": {
                return this.getPublContactAuthor();
            }
            case "publ_manuscript": {
                return this.getPublManuscript();
            }
            case "publ_manuscript_incl_extra": {
                return this.getPublManuscriptInclExtra();
            }
            case "publ_requested": {
                return this.getPublRequested();
            }
            case "publ_section": {
                return this.getPublSection();
            }
            case "atom_analytical": {
                return this.getAtomAnalytical();
            }
            case "atom_analytical_mass_loss": {
                return this.getAtomAnalyticalMassLoss();
            }
            case "atom_analytical_source": {
                return this.getAtomAnalyticalSource();
            }
            case "atom_scat_versus_stol": {
                return this.getAtomScatVersusStol();
            }
            case "atom_site": {
                return this.getAtomSite();
            }
            case "atom_site_aniso": {
                return this.getAtomSiteAniso();
            }
            case "atom_sites": {
                return this.getAtomSites();
            }
            case "atom_sites_cartn_transform": {
                return this.getAtomSitesCartnTransform();
            }
            case "atom_sites_fract_transform": {
                return this.getAtomSitesFractTransform();
            }
            case "atom_type": {
                return this.getAtomType();
            }
            case "atom_type_scat": {
                return this.getAtomTypeScat();
            }
            case "refine": {
                return this.getRefine();
            }
            case "refine_diff": {
                return this.getRefineDiff();
            }
            case "refine_ls": {
                return this.getRefineLs();
            }
            case "refine_ls_class": {
                return this.getRefineLsClass();
            }
            case "function": {
                return this.getFunction();
            }
            case "cell_angle": {
                return this.getCellAngle();
            }
            case "chem_comp_bond": {
                return this.getChemCompBond();
            }
            case "symmetry_equiv": {
                return this.getSymmetryEquiv();
            }
            case "publ_manuscript_incl": {
                return this.getPublManuscriptIncl();
            }
            case "atom_site_anisotrop": {
                return this.getAtomSiteAnisotrop();
            }
        }
        return new DelegatingCategory(category);
    }

    public Diffrn getDiffrn() {
        return new Diffrn(this);
    }

    public Cell getCell() {
        return new Cell(this);
    }

    public CellMeasurement getCellMeasurement() {
        return new CellMeasurement(this);
    }

    public CellMeasurementRefln getCellMeasurementRefln() {
        return new CellMeasurementRefln(this);
    }

    public DiffrnAttenuator getDiffrnAttenuator() {
        return new DiffrnAttenuator(this);
    }

    public DiffrnDetector getDiffrnDetector() {
        return new DiffrnDetector(this);
    }

    public DiffrnMeasurement getDiffrnMeasurement() {
        return new DiffrnMeasurement(this);
    }

    public DiffrnOrientMatrix getDiffrnOrientMatrix() {
        return new DiffrnOrientMatrix(this);
    }

    public DiffrnOrientRefln getDiffrnOrientRefln() {
        return new DiffrnOrientRefln(this);
    }

    public DiffrnRadiation getDiffrnRadiation() {
        return new DiffrnRadiation(this);
    }

    public DiffrnRadiationWavelength getDiffrnRadiationWavelength() {
        return new DiffrnRadiationWavelength(this);
    }

    public DiffrnRefln getDiffrnRefln() {
        return new DiffrnRefln(this);
    }

    public DiffrnReflns getDiffrnReflns() {
        return new DiffrnReflns(this);
    }

    public DiffrnReflnsClass getDiffrnReflnsClass() {
        return new DiffrnReflnsClass(this);
    }

    public DiffrnReflnsTransfMatrix getDiffrnReflnsTransfMatrix() {
        return new DiffrnReflnsTransfMatrix(this);
    }

    public DiffrnScaleGroup getDiffrnScaleGroup() {
        return new DiffrnScaleGroup(this);
    }

    public DiffrnSource getDiffrnSource() {
        return new DiffrnSource(this);
    }

    public DiffrnStandards getDiffrnStandards() {
        return new DiffrnStandards(this);
    }

    public DiffrnStandardRefln getDiffrnStandardRefln() {
        return new DiffrnStandardRefln(this);
    }

    public Refln getRefln() {
        return new Refln(this);
    }

    public Reflns getReflns() {
        return new Reflns(this);
    }

    public ReflnsClass getReflnsClass() {
        return new ReflnsClass(this);
    }

    public ReflnsScale getReflnsScale() {
        return new ReflnsScale(this);
    }

    public ReflnsShell getReflnsShell() {
        return new ReflnsShell(this);
    }

    public Exptl getExptl() {
        return new Exptl(this);
    }

    public Chemical getChemical() {
        return new Chemical(this);
    }

    public ChemicalConnAtom getChemicalConnAtom() {
        return new ChemicalConnAtom(this);
    }

    public ChemicalConnBond getChemicalConnBond() {
        return new ChemicalConnBond(this);
    }

    public ChemicalFormula getChemicalFormula() {
        return new ChemicalFormula(this);
    }

    public ExptlAbsorpt getExptlAbsorpt() {
        return new ExptlAbsorpt(this);
    }

    public ExptlCrystal getExptlCrystal() {
        return new ExptlCrystal(this);
    }

    public ExptlCrystalAppearance getExptlCrystalAppearance() {
        return new ExptlCrystalAppearance(this);
    }

    public ExptlCrystalFace getExptlCrystalFace() {
        return new ExptlCrystalFace(this);
    }

    public SpaceGroup getSpaceGroup() {
        return new SpaceGroup(this);
    }

    public Symmetry getSymmetry() {
        return new Symmetry(this);
    }

    public SpaceGroupGenerator getSpaceGroupGenerator() {
        return new SpaceGroupGenerator(this);
    }

    public SpaceGroupSymop getSpaceGroupSymop() {
        return new SpaceGroupSymop(this);
    }

    public SpaceGroupWyckoff getSpaceGroupWyckoff() {
        return new SpaceGroupWyckoff(this);
    }

    public Geom getGeom() {
        return new Geom(this);
    }

    public GeomAngle getGeomAngle() {
        return new GeomAngle(this);
    }

    public GeomBond getGeomBond() {
        return new GeomBond(this);
    }

    public GeomContact getGeomContact() {
        return new GeomContact(this);
    }

    public GeomHbond getGeomHbond() {
        return new GeomHbond(this);
    }

    public GeomTorsion getGeomTorsion() {
        return new GeomTorsion(this);
    }

    public ModelSite getModelSite() {
        return new ModelSite(this);
    }

    public ValenceParam getValenceParam() {
        return new ValenceParam(this);
    }

    public ValenceRef getValenceRef() {
        return new ValenceRef(this);
    }

    public Audit getAudit() {
        return new Audit(this);
    }

    public AuditAuthor getAuditAuthor() {
        return new AuditAuthor(this);
    }

    public AuditAuthorRole getAuditAuthorRole() {
        return new AuditAuthorRole(this);
    }

    public AuditConform getAuditConform() {
        return new AuditConform(this);
    }

    public AuditContactAuthor getAuditContactAuthor() {
        return new AuditContactAuthor(this);
    }

    public AuditLink getAuditLink() {
        return new AuditLink(this);
    }

    public AuditSupport getAuditSupport() {
        return new AuditSupport(this);
    }

    public Citation getCitation() {
        return new Citation(this);
    }

    public CitationAuthor getCitationAuthor() {
        return new CitationAuthor(this);
    }

    public CitationEditor getCitationEditor() {
        return new CitationEditor(this);
    }

    public Computing getComputing() {
        return new Computing(this);
    }

    public Database getDatabase() {
        return new Database(this);
    }

    public DatabaseCode getDatabaseCode() {
        return new DatabaseCode(this);
    }

    public DatabaseRelated getDatabaseRelated() {
        return new DatabaseRelated(this);
    }

    public DisplayColour getDisplayColour() {
        return new DisplayColour(this);
    }

    public Journal getJournal() {
        return new Journal(this);
    }

    public JournalCoeditor getJournalCoeditor() {
        return new JournalCoeditor(this);
    }

    public JournalDate getJournalDate() {
        return new JournalDate(this);
    }

    public JournalIndex getJournalIndex() {
        return new JournalIndex(this);
    }

    public JournalTecheditor getJournalTecheditor() {
        return new JournalTecheditor(this);
    }

    public Publ getPubl() {
        return new Publ(this);
    }

    public PublAuthor getPublAuthor() {
        return new PublAuthor(this);
    }

    public PublBody getPublBody() {
        return new PublBody(this);
    }

    public PublContactAuthor getPublContactAuthor() {
        return new PublContactAuthor(this);
    }

    public PublManuscript getPublManuscript() {
        return new PublManuscript(this);
    }

    public PublManuscriptInclExtra getPublManuscriptInclExtra() {
        return new PublManuscriptInclExtra(this);
    }

    public PublRequested getPublRequested() {
        return new PublRequested(this);
    }

    public PublSection getPublSection() {
        return new PublSection(this);
    }

    public AtomAnalytical getAtomAnalytical() {
        return new AtomAnalytical(this);
    }

    public AtomAnalyticalMassLoss getAtomAnalyticalMassLoss() {
        return new AtomAnalyticalMassLoss(this);
    }

    public AtomAnalyticalSource getAtomAnalyticalSource() {
        return new AtomAnalyticalSource(this);
    }

    public AtomScatVersusStol getAtomScatVersusStol() {
        return new AtomScatVersusStol(this);
    }

    public AtomSite getAtomSite() {
        return new AtomSite(this);
    }

    public AtomSiteAniso getAtomSiteAniso() {
        return new AtomSiteAniso(this);
    }

    public AtomSites getAtomSites() {
        return new AtomSites(this);
    }

    public AtomSitesCartnTransform getAtomSitesCartnTransform() {
        return new AtomSitesCartnTransform(this);
    }

    public AtomSitesFractTransform getAtomSitesFractTransform() {
        return new AtomSitesFractTransform(this);
    }

    public AtomType getAtomType() {
        return new AtomType(this);
    }

    public AtomTypeScat getAtomTypeScat() {
        return new AtomTypeScat(this);
    }

    public Refine getRefine() {
        return new Refine(this);
    }

    public RefineDiff getRefineDiff() {
        return new RefineDiff(this);
    }

    public RefineLs getRefineLs() {
        return new RefineLs(this);
    }

    public RefineLsClass getRefineLsClass() {
        return new RefineLsClass(this);
    }

    public Function getFunction() {
        return new Function(this);
    }

    public CellAngle getCellAngle() {
        return new CellAngle(this);
    }

    public ChemCompBond getChemCompBond() {
        return new ChemCompBond(this);
    }

    public SymmetryEquiv getSymmetryEquiv() {
        return new SymmetryEquiv(this);
    }

    public PublManuscriptIncl getPublManuscriptIncl() {
        return new PublManuscriptIncl(this);
    }

    public AtomSiteAnisotrop getAtomSiteAnisotrop() {
        return new AtomSiteAnisotrop(this);
    }
}

