/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.schema;

import java.util.Arrays;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.ValueKind;

public class DelegatingColumn<T>
implements Column<T> {
    protected final Column<?> delegate;
    protected final Class<T> type;
    protected T array;

    public DelegatingColumn(Column<?> delegate) {
        this(delegate, String[].class);
    }

    public DelegatingColumn(Column<?> delegate, Class<T> type) {
        this.delegate = delegate;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.delegate.getColumnName();
    }

    @Override
    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    @Override
    public String getStringData(int row) {
        return this.delegate.getStringData(row);
    }

    @Override
    public ValueKind getValueKind(int row) {
        return this.delegate.getValueKind(row);
    }

    @Override
    public T getArray() {
        if (this.array == null) {
            Object raw = this.delegate.getArray();
            this.array = this.type.isInstance(raw) ? raw : (raw != null ? this.forceType(raw) : null);
        }
        return this.array;
    }

    private T forceType(Object array) {
        if (this.type.equals(double[].class)) {
            return (T)this.forceFloatType(array);
        }
        if (this.type.equals(int[].class)) {
            return (T)this.forceIntType(array);
        }
        return (T)this.forceStrType(array);
    }

    private double[] forceFloatType(Object array) {
        if (array instanceof int[]) {
            int[] typed = (int[])array;
            return Arrays.stream(typed).mapToDouble(i -> i).toArray();
        }
        String[] typed = (String[])array;
        return Arrays.stream(typed).mapToDouble(FloatColumn::parseFloat).toArray();
    }

    private int[] forceIntType(Object array) {
        if (array instanceof double[]) {
            double[] typed = (double[])array;
            return Arrays.stream(typed).mapToInt(d -> (int)d).toArray();
        }
        String[] typed = (String[])array;
        return Arrays.stream(typed).mapToInt(IntColumn::parseInt).toArray();
    }

    private String[] forceStrType(Object array) {
        if (array instanceof int[]) {
            int[] typed = (int[])array;
            return (String[])Arrays.stream(typed).mapToObj(Integer::toString).toArray(String[]::new);
        }
        double[] typed = (double[])array;
        return (String[])Arrays.stream(typed).mapToObj(Double::toString).toArray(String[]::new);
    }
}

