/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.schema;

import java.util.List;
import java.util.Map;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.LinkedCaseInsensitiveMap;

public abstract class DelegatingBlock
implements Block {
    protected final Block delegate;

    protected DelegatingBlock(Block block) {
        this.delegate = block;
    }

    @Override
    public String getBlockHeader() {
        return this.delegate.getBlockHeader();
    }

    @Override
    public Category getCategory(String name) {
        return this.getCategories().computeIfAbsent(name, Category.EmptyCategory::new);
    }

    @Override
    public Map<String, Category> getCategories() {
        LinkedCaseInsensitiveMap<Category> categories = new LinkedCaseInsensitiveMap<Category>();
        for (Map.Entry<String, Category> entry : this.delegate.getCategories().entrySet()) {
            categories.put(entry.getKey(), this.createDelegate(entry.getKey(), entry.getValue()));
        }
        return categories;
    }

    protected abstract Category createDelegate(String var1, Category var2);

    @Override
    public List<Block> getSaveFrames() {
        return this.delegate.getSaveFrames();
    }
}

