/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rcsb.cif.binary.codec.BinaryCifCodec;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Float32Array;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.Int16Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.Int8Array;
import org.rcsb.cif.binary.data.NumberArray;
import org.rcsb.cif.binary.data.Uint16Array;
import org.rcsb.cif.binary.data.Uint32Array;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.Encoding;

public abstract class ByteArrayEncoding<T extends NumberArray<?>>
implements Encoding<T, ByteArray> {
    private final Map<String, Object> map;
    private int type;
    public static final ByteArrayEncoding<Int8Array> INT8 = new ByteArrayEncoding<Int8Array>(ByteArrayEncoding.createMap(1)){

        @Override
        public Int8Array decode(ByteArray data) {
            return new Int8Array(data);
        }
    };
    public static final ByteArrayEncoding<Int16Array> INT16 = new ByteArrayEncoding<Int16Array>(ByteArrayEncoding.createMap(2)){

        @Override
        public Int16Array decode(ByteArray data) {
            return new Int16Array(data);
        }
    };
    public static final ByteArrayEncoding<Int32Array> INT32 = new ByteArrayEncoding<Int32Array>(ByteArrayEncoding.createMap(3)){

        @Override
        public Int32Array decode(ByteArray data) {
            return new Int32Array(data);
        }
    };
    public static final ByteArrayEncoding<Uint8Array> UINT8 = new ByteArrayEncoding<Uint8Array>(ByteArrayEncoding.createMap(4)){

        @Override
        public Uint8Array decode(ByteArray data) {
            return new Uint8Array(data);
        }
    };
    public static final ByteArrayEncoding<Uint16Array> UINT16 = new ByteArrayEncoding<Uint16Array>(ByteArrayEncoding.createMap(5)){

        @Override
        public Uint16Array decode(ByteArray data) {
            return new Uint16Array(data);
        }
    };
    public static final ByteArrayEncoding<Uint32Array> UINT32 = new ByteArrayEncoding<Uint32Array>(ByteArrayEncoding.createMap(6)){

        @Override
        public Uint32Array decode(ByteArray data) {
            return new Uint32Array(data);
        }
    };
    public static final ByteArrayEncoding<Float32Array> FLOAT32 = new ByteArrayEncoding<Float32Array>(ByteArrayEncoding.createMap(32)){

        @Override
        public Float32Array decode(ByteArray data) {
            return new Float32Array(data);
        }
    };
    public static final ByteArrayEncoding<Float64Array> FLOAT64 = new ByteArrayEncoding<Float64Array>(ByteArrayEncoding.createMap(33)){

        @Override
        public Float64Array decode(ByteArray data) {
            return new Float64Array(data);
        }
    };

    private ByteArrayEncoding(Map<String, Object> map) {
        this.map = map;
    }

    private static Map<String, Object> createMap(int type) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kind", "ByteArray");
        map.put("type", type);
        return map;
    }

    @Override
    public ByteArray encode(T data) {
        this.type = data.getType();
        byte[] bytes = ByteArrayEncoding.ensureOrder(data.toByteArray(), data.getNumberOfBytes());
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        enc.add(this);
        return new ByteArray(bytes, (Deque<Encoding<?, ?>>)enc);
    }

    @Override
    public Map<String, Object> getMapRepresentation() {
        return this.map;
    }

    private static byte[] flipByteOrder(byte[] data, int bytes) {
        byte[] buffer = new byte[data.length];
        int n = data.length;
        for (int i = 0; i < n; i += bytes) {
            for (int j = 0; j < bytes; ++j) {
                buffer[i + bytes - j - 1] = data[i + j];
            }
        }
        return buffer;
    }

    private static byte[] ensureOrder(byte[] bytes, int numberOfBytes) {
        if (!BinaryCifCodec.IS_NATIVE_LITTLE_ENDIAN) {
            bytes = ByteArrayEncoding.flipByteOrder(bytes, numberOfBytes);
        }
        return bytes;
    }

    public String toString() {
        return "ByteArrayEncoding{type=" + this.type + "}";
    }
}

