/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.ImageComponent3D;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.ImageComponentState;

public class ImageComponent3DState
extends ImageComponentState {
    private BufferedImage[] bufferedImages;

    public ImageComponent3DState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        ImageComponent3D ic = (ImageComponent3D)this.node;
        if (ic.isByReference()) {
            ImageComponent3D noByRef = new ImageComponent3D(ic.getFormat(), ic.getRenderedImage(), false, ic.isYUp());
            this.bufferedImages = noByRef.getImage();
        } else {
            this.bufferedImages = ic.getImage();
        }
        out.writeInt(this.bufferedImages.length);
        int i = 0;
        while (i < this.bufferedImages.length) {
            this.writeBufferedImage(out, this.bufferedImages[i]);
            ++i;
        }
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.bufferedImages = new BufferedImage[in.readInt()];
        int i = 0;
        while (i < this.bufferedImages.length) {
            this.bufferedImages[i] = this.readBufferedImage(in);
            ++i;
        }
    }

    @Override
    protected SceneGraphObject createNode(Class j3dClass) {
        return super.createNode(j3dClass, new Class[]{Integer.TYPE, this.bufferedImages.getClass(), Boolean.TYPE, Boolean.TYPE}, new Object[]{new Integer(this.format), this.bufferedImages, new Boolean(this.byReference), new Boolean(this.yUp)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new ImageComponent3D(this.format, this.bufferedImages, this.byReference, this.yUp);
    }
}

