/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Billboard;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.BehaviorState;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class BillboardState
extends BehaviorState {
    private int target;

    public BillboardState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.target = control.getSymbolTable().addReference((SceneGraphObject)((Billboard)this.node).getTarget());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(((Billboard)this.node).getAlignmentMode());
        Vector3f vec = new Vector3f();
        ((Billboard)this.node).getAlignmentAxis(vec);
        Point3f point = new Point3f();
        ((Billboard)this.node).getRotationPoint(point);
        this.control.writeVector3f(out, vec);
        this.control.writePoint3f(out, point);
        out.writeInt(this.target);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Billboard)this.node).setAlignmentMode(in.readInt());
        ((Billboard)this.node).setAlignmentAxis(this.control.readVector3f(in));
        ((Billboard)this.node).setRotationPoint(this.control.readPoint3f(in));
        this.target = in.readInt();
    }

    @Override
    public void buildGraph() {
        ((Billboard)this.node).setTarget((TransformGroup)this.control.getSymbolTable().getJ3dNode(this.target));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Billboard();
    }
}

