/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.vp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BadTransformException;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.View;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnElapsedFrames;
import org.jogamp.java3d.utils.behaviors.sensor.SensorBeamEcho;
import org.jogamp.java3d.utils.behaviors.sensor.SensorButtonListener;
import org.jogamp.java3d.utils.behaviors.sensor.SensorEvent;
import org.jogamp.java3d.utils.behaviors.sensor.SensorEventAgent;
import org.jogamp.java3d.utils.behaviors.sensor.SensorGnomonEcho;
import org.jogamp.java3d.utils.behaviors.sensor.SensorInputAdaptor;
import org.jogamp.java3d.utils.behaviors.sensor.SensorReadListener;
import org.jogamp.java3d.utils.behaviors.vp.ViewPlatformBehavior;
import org.jogamp.java3d.utils.universe.ConfiguredUniverse;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.java3d.utils.universe.Viewer;
import org.jogamp.java3d.utils.universe.ViewingPlatform;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3d;

public class WandViewBehavior
extends ViewPlatformBehavior {
    public static final int NONE = 0;
    public static final int GRAB_VIEW = 1;
    public static final int TRANSLATE_FORWARD = 2;
    public static final int TRANSLATE_BACKWARD = 3;
    public static final int ROTATE_CCW = 4;
    public static final int ROTATE_CW = 5;
    public static final int SCALE_UP = 6;
    public static final int SCALE_DOWN = 7;
    public static final int TRANSLATION = 8;
    public static final int SCALE = 9;
    public static final int ROTATION = 10;
    public static final int PER_FRAME = 11;
    public static final int PER_SECOND = 12;
    public static final int VIRTUAL_UNITS = 13;
    public static final int PHYSICAL_METERS = 14;
    public static final int RADIANS = 15;
    public static final int DEGREES = 16;
    public static final int VIEW_PLATFORM = 17;
    public static final int HEAD = 18;
    public static final int SENSOR = 19;
    public static final int VWORLD_FIXED = 20;
    public static final int HOTSPOT = 21;
    public static final int ECHO = 22;
    public static final int GNOMON = 23;
    public static final int BEAM = 24;
    private static final int UNSET = -1;
    private View view = null;
    private SensorEventAgent eventAgent = null;
    private String sensor6DName = null;
    private String sensor2DName = null;
    private Shape3D echoGeometry = null;
    private BranchGroup echoBranchGroup = null;
    private TransformGroup echoTransformGroup = null;
    private SensorReadListener echoReadListener6D = null;
    private boolean echoBranchGroupAttached = false;
    private WakeupCondition wakeupConditions = new WakeupOnElapsedFrames(0);
    private boolean configured = false;
    private Sensor sensor6D = null;
    private Sensor sensor2D = null;
    private int x2D = 3;
    private int y2D = 7;
    private double threshold2D = 0.0;
    private int readAction6D = -1;
    private int readAction2D = -1;
    private ArrayList buttonActions6D = new ArrayList();
    private ArrayList buttonActions2D = new ArrayList();
    private double translationSpeed = 0.1;
    private int translationUnits = 14;
    private int translationTimeBase = 12;
    private double accelerationTime = 1.0;
    private double constantSpeedTime = 8.0;
    private double fastSpeedFactor = 10.0;
    private double rotationSpeed = 180.0;
    private int rotationUnits = 16;
    private int rotationTimeBase = 12;
    private int rotationCoords = 19;
    private double scaleSpeed = 2.0;
    private int scaleTimeBase = 12;
    private int transformCenterSource = 21;
    private Point3d transformCenter = new Point3d(0.0, 0.0, 0.0);
    private int resetViewButtonCount6D = 3;
    private int resetViewButtonCount2D = 0;
    private int echoType = 23;
    private double echoSize = 0.01;
    private Color3f echoColor = null;
    private float echoTransparency = 0.0f;
    private Transform3D nominalSensorRotation = null;

    public WandViewBehavior() {
        this.eventAgent = new SensorEventAgent((Object)this);
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
    }

    public WandViewBehavior(Sensor sensor6D, Sensor sensor2D, int echoType, double echoSize) {
        this();
        this.sensor6D = sensor6D;
        this.sensor2D = sensor2D;
        this.echoType = echoType;
        this.echoSize = echoSize;
    }

    public WandViewBehavior(Sensor sensor6D, Sensor sensor2D, TransformGroup echo) {
        this();
        this.sensor6D = sensor6D;
        this.sensor2D = sensor2D;
        if (echo != null) {
            echo.setCapability(18);
            echo.setCapability(12);
            echo.setCapability(13);
            echo.setCapability(14);
        }
        this.echoTransformGroup = echo;
    }

    public WandViewBehavior(Sensor sensor6D, Sensor sensor2D, View view, TransformGroup viewTransform, Transform3D homeTransform, TransformGroup echo) {
        this();
        this.sensor6D = sensor6D;
        this.sensor2D = sensor2D;
        this.view = view;
        this.targetTG = viewTransform;
        this.echoTransformGroup = echo;
        if (homeTransform == null) {
            this.setHomeTransform(new Transform3D());
        } else {
            this.setHomeTransform(homeTransform);
        }
    }

    public void initialize() {
        if (!this.configured) {
            this.configureSensorActions();
            if (this.vp != null) {
                if (this.echoTransformGroup == null && this.sensor6D != null && this.readAction6D == 22) {
                    this.configureEcho();
                }
                if (this.echoTransformGroup != null) {
                    this.echoBranchGroup = new BranchGroup();
                    this.echoBranchGroup.setCapability(17);
                    this.echoBranchGroup.setCapability(12);
                    this.echoBranchGroup.setCapability(13);
                    this.echoBranchGroup.addChild((Node)this.echoTransformGroup);
                    this.echoBranchGroup.compile();
                }
                this.attachEcho();
            }
            this.configured = true;
        }
        this.wakeupOn(this.wakeupConditions);
    }

    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        this.eventAgent.dispatchEvents();
        this.wakeupOn(this.wakeupConditions);
    }

    public void setEnable(boolean enable) {
        if (enable == this.getEnable()) {
            return;
        }
        if (enable) {
            this.attachEcho();
        } else {
            this.detachEcho();
        }
        super.setEnable(enable);
    }

    @Override
    public void setViewingPlatform(ViewingPlatform vp) {
        super.setViewingPlatform(vp);
        if (vp == null) {
            this.detachEcho();
            return;
        }
        Viewer[] viewers = vp.getViewers();
        if (viewers != null) {
            if (viewers.length != 0 && viewers[0] != null) {
                this.view = viewers[0].getView();
            }
            if (viewers.length > 1) {
                throw new RuntimeException("multiple Viewers not supported");
            }
        }
        if (this.view == null) {
            this.view = this.getView();
        }
        if (this.view == null) {
            throw new RuntimeException("a view is not available");
        }
        this.targetTG = vp.getMultiTransformGroup().getTransformGroup(0);
        if (this.homeTransform == null) {
            this.setHomeTransform(new Transform3D());
        }
        this.attachEcho();
    }

    private void attachEcho() {
        if (this.vp != null && this.echoBranchGroup != null && !this.echoBranchGroupAttached) {
            this.vp.addChild((Node)this.echoBranchGroup);
            this.echoBranchGroupAttached = true;
        }
    }

    private void detachEcho() {
        if (this.echoBranchGroup != null && this.echoBranchGroupAttached) {
            this.echoBranchGroup.detach();
            this.echoBranchGroupAttached = false;
        }
    }

    protected void configureSensorActions() {
        SensorInputAdaptor r;
        int action;
        Integer button;
        SensorButtonListener[] sbls;
        int buttonActionCount;
        int buttonCount;
        SimpleUniverse universe = null;
        if (this.vp != null) {
            universe = this.vp.getUniverse();
        }
        if (universe != null && universe instanceof ConfiguredUniverse) {
            Map sensorMap = ((ConfiguredUniverse)universe).getNamedSensors();
            if (this.sensor2D == null && this.sensor2DName != null) {
                this.sensor2D = (Sensor)sensorMap.get(this.sensor2DName);
                if (this.sensor2D == null) {
                    throw new IllegalArgumentException("\nsensor " + this.sensor2DName + " not found");
                }
            }
            if (this.sensor6D == null && this.sensor6DName != null) {
                this.sensor6D = (Sensor)sensorMap.get(this.sensor6DName);
                if (this.sensor6D == null) {
                    throw new IllegalArgumentException("\nsensor " + this.sensor6DName + " not found");
                }
            }
        }
        if (this.sensor6D != null) {
            if (this.readAction6D == -1) {
                this.readAction6D = 22;
            }
            if (this.readAction6D == 22) {
                this.echoReadListener6D = new EchoReadListener6D();
                this.eventAgent.addSensorReadListener(this.sensor6D, this.echoReadListener6D);
            }
            buttonCount = this.sensor6D.getSensorButtonCount();
            buttonActionCount = this.buttonActions6D.size();
            if (buttonActionCount > buttonCount) {
                throw new IllegalArgumentException("\nbutton index " + (buttonActionCount - 1) + " >= number of buttons (" + buttonCount + ")");
            }
            if (buttonCount > 2 && (buttonActionCount < 3 || this.buttonActions6D.get(2) == null)) {
                this.setButtonAction6D(2, 3);
            }
            if (buttonCount > 1 && (buttonActionCount < 2 || this.buttonActions6D.get(1) == null)) {
                this.setButtonAction6D(1, 2);
            }
            if (buttonCount > 0 && (buttonActionCount < 1 || this.buttonActions6D.get(0) == null)) {
                this.setButtonAction6D(0, 1);
            }
            if ((buttonActionCount = this.buttonActions6D.size()) > 0) {
                sbls = new SensorButtonListener[buttonCount];
                int i = 0;
                while (i < buttonActionCount) {
                    button = (Integer)this.buttonActions6D.get(i);
                    if (button != null) {
                        action = button;
                        if (action == 0) {
                            sbls[i] = null;
                        } else if (action == 1) {
                            sbls[i] = new GrabViewListener6D();
                        } else if (action == 2) {
                            sbls[i] = new TranslationListener6D(false);
                        } else if (action == 3) {
                            sbls[i] = new TranslationListener6D(true);
                        } else if (action == 4) {
                            sbls[i] = new RotationListener6D(false);
                        } else if (action == 5) {
                            sbls[i] = new RotationListener6D(true);
                        } else if (action == 6) {
                            sbls[i] = new ScaleListener6D(false);
                        } else if (action == 7) {
                            sbls[i] = new ScaleListener6D(true);
                        }
                    }
                    ++i;
                }
                this.eventAgent.addSensorButtonListeners(this.sensor6D, sbls);
            }
            if (this.resetViewButtonCount6D != 0) {
                r = new ResetViewListener(this.sensor6D, this.resetViewButtonCount6D);
                this.eventAgent.addSensorButtonListener(this.sensor6D, r);
                this.eventAgent.addSensorReadListener(this.sensor6D, r);
            }
        }
        if (this.sensor2D != null) {
            if (this.readAction2D == -1) {
                this.readAction2D = 10;
            }
            if (this.readAction2D == 10) {
                r = new RotationListener2D(this.sensor2D, this.sensor6D);
                this.eventAgent.addSensorReadListener(this.sensor2D, r);
            } else if (this.readAction2D == 8) {
                r = new TranslationListener2D(this.sensor2D, this.sensor6D);
                this.eventAgent.addSensorReadListener(this.sensor2D, r);
            } else if (this.readAction2D == 9) {
                r = new ScaleListener2D(this.sensor2D, this.sensor6D);
                this.eventAgent.addSensorReadListener(this.sensor2D, r);
            }
            buttonCount = this.sensor2D.getSensorButtonCount();
            buttonActionCount = this.buttonActions2D.size();
            if (buttonActionCount > buttonCount) {
                throw new IllegalArgumentException("\nbutton index " + (buttonActionCount - 1) + " >= number of buttons (" + buttonCount + ")");
            }
            if (buttonActionCount > 0) {
                sbls = new SensorButtonListener[buttonCount];
                int i = 0;
                while (i < buttonActionCount) {
                    button = (Integer)this.buttonActions2D.get(i);
                    if (button != null) {
                        action = button;
                        if (action == 0) {
                            sbls[i] = null;
                        } else if (action == 10) {
                            sbls[i] = new RotationListener2D(this.sensor2D, this.sensor6D);
                        } else if (action == 8) {
                            sbls[i] = new TranslationListener2D(this.sensor2D, this.sensor6D);
                        } else if (action == 9) {
                            sbls[i] = new ScaleListener2D(this.sensor2D, this.sensor6D);
                        }
                    }
                    ++i;
                }
                this.eventAgent.addSensorButtonListeners(this.sensor2D, sbls);
            }
            if (this.resetViewButtonCount2D != 0) {
                ResetViewListener r2 = new ResetViewListener(this.sensor2D, this.resetViewButtonCount2D);
                this.eventAgent.addSensorButtonListener(this.sensor2D, r2);
                this.eventAgent.addSensorReadListener(this.sensor2D, r2);
            }
        }
    }

    protected void configureEcho() {
        Point3d hotspot = new Point3d();
        this.sensor6D.getHotspot(hotspot);
        if (this.echoType == 23) {
            Transform3D gnomonTransform = new Transform3D();
            if (this.nominalSensorRotation != null) {
                gnomonTransform.set(this.nominalSensorRotation);
                gnomonTransform.invert();
            }
            gnomonTransform.setTranslation(new Vector3d((Tuple3d)hotspot));
            this.echoGeometry = new SensorGnomonEcho(gnomonTransform, 0.1 * this.echoSize, 0.5 * this.echoSize, true);
        } else if (this.echoType == 24) {
            this.echoGeometry = new SensorBeamEcho(hotspot, this.echoSize, true);
        }
        if (this.echoGeometry != null) {
            Appearance a = this.echoGeometry.getAppearance();
            if (this.echoColor != null) {
                Material m = a.getMaterial();
                m.setDiffuseColor(this.echoColor);
            }
            if (this.echoTransparency != 0.0f) {
                TransparencyAttributes ta = a.getTransparencyAttributes();
                ta.setTransparencyMode(2);
                ta.setTransparency(this.echoTransparency);
                if (this.echoGeometry instanceof SensorGnomonEcho) {
                    ta.setDstBlendFunction(1);
                }
            }
            this.echoTransformGroup = new TransformGroup();
            this.echoTransformGroup.setCapability(18);
            this.echoTransformGroup.setCapability(12);
            this.echoTransformGroup.setCapability(13);
            this.echoTransformGroup.setCapability(14);
            this.echoTransformGroup.addChild((Node)this.echoGeometry);
        }
    }

    protected void updateEcho(Sensor sensor, Transform3D sensorToVworld) {
        this.echoTransformGroup.setTransform(sensorToVworld);
    }

    public void Sensor6D(Object[] sensor) {
        if (sensor.length != 1) {
            throw new IllegalArgumentException("Sensor6D requires a single name or Sensor instance");
        }
        if (sensor[0] instanceof String) {
            this.sensor6DName = (String)sensor[0];
        } else if (sensor[0] instanceof Sensor) {
            this.sensor6D = (Sensor)sensor[0];
        } else {
            throw new IllegalArgumentException("Sensor6D must be a name or a Sensor instance");
        }
    }

    public Sensor getSensor6D() {
        return this.sensor6D;
    }

    public void Sensor2D(Object[] sensor) {
        if (sensor.length != 1) {
            throw new IllegalArgumentException("Sensor2D requires a single name or Sensor instance");
        }
        if (sensor[0] instanceof String) {
            this.sensor2DName = (String)sensor[0];
        } else if (sensor[0] instanceof Sensor) {
            this.sensor2D = (Sensor)sensor[0];
        } else {
            throw new IllegalArgumentException("Sensor2D must be a name or a Sensor instance");
        }
    }

    public Sensor getSensor2D() {
        return this.sensor2D;
    }

    public void ButtonAction6D(Object[] action) {
        if (action.length != 2 || !(action[0] instanceof Double) || !(action[1] instanceof String)) {
            throw new IllegalArgumentException("\nButtonAction6D must be a number and a string");
        }
        int button = ((Double)action[0]).intValue();
        String actionString = (String)action[1];
        if (actionString.equals("GrabView")) {
            this.setButtonAction6D(button, 1);
        } else if (actionString.equals("TranslateForward")) {
            this.setButtonAction6D(button, 2);
        } else if (actionString.equals("TranslateBackward")) {
            this.setButtonAction6D(button, 3);
        } else if (actionString.equals("RotateCCW")) {
            this.setButtonAction6D(button, 4);
        } else if (actionString.equals("RotateCW")) {
            this.setButtonAction6D(button, 5);
        } else if (actionString.equals("ScaleUp")) {
            this.setButtonAction6D(button, 6);
        } else if (actionString.equals("ScaleDown")) {
            this.setButtonAction6D(button, 7);
        } else if (actionString.equals("None")) {
            this.setButtonAction6D(button, 0);
        } else {
            throw new IllegalArgumentException("\nButtonAction6D must be GrabView, TranslateForward, TranslateBackward, RotateCCW, RotateCW, ScaleUp, ScaleDown, or None");
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setButtonAction6D(int button, int action) {
        if (action == 2 || action == 3 || action == 1 || action == 4 || action == 5 || action == 6 || action == 7 || action == 0) ** GOTO lbl5
        throw new IllegalArgumentException("\naction must be TRANSLATE_FORWARD, TRANSLATE_BACKWARD, GRAB_VIEW, ROTATE_CCW, ROTATE_CW, SCALE_UP, SCALE_DOWN, or NONE");
lbl-1000:
        // 1 sources

        {
            this.buttonActions6D.add(null);
lbl5:
            // 2 sources

            ** while (button >= this.buttonActions6D.size())
        }
lbl6:
        // 1 sources

        this.buttonActions6D.set(button, new Integer(action));
    }

    public int getButtonAction6D(int button) {
        if (button >= this.buttonActions6D.size()) {
            return 0;
        }
        Integer i = (Integer)this.buttonActions6D.get(button);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void ReadAction2D(Object[] action) {
        if (action.length != 1 || !(action[0] instanceof String)) {
            throw new IllegalArgumentException("\nReadAction2D must be a String");
        }
        String actionString = (String)action[0];
        if (actionString.equals("Rotation")) {
            this.setReadAction2D(10);
        } else if (actionString.equals("Translation")) {
            this.setReadAction2D(8);
        } else if (actionString.equals("Scale")) {
            this.setReadAction2D(9);
        } else if (actionString.equals("None")) {
            this.setReadAction2D(0);
        } else {
            throw new IllegalArgumentException("\nReadAction2D must be Rotation, Translation, Scale, or None");
        }
    }

    public void setReadAction2D(int action) {
        if (action != 10 && action != 8 && action != 9 && action != 0) {
            throw new IllegalArgumentException("\nReadAction2D must be ROTATION, TRANSLATION, SCALE, or NONE");
        }
        this.readAction2D = action;
    }

    public int getReadAction2D() {
        if (this.readAction2D == -1) {
            return 0;
        }
        return this.readAction2D;
    }

    public void ButtonAction2D(Object[] action) {
        if (action.length != 2 || !(action[0] instanceof Double) || !(action[1] instanceof String)) {
            throw new IllegalArgumentException("\nButtonAction2D must be a number and a string");
        }
        int button = ((Double)action[0]).intValue();
        String actionString = (String)action[1];
        if (actionString.equals("Rotation")) {
            this.setButtonAction2D(button, 10);
        } else if (actionString.equals("Translation")) {
            this.setButtonAction2D(button, 8);
        } else if (actionString.equals("Scale")) {
            this.setButtonAction2D(button, 9);
        } else if (actionString.equals("None")) {
            this.setButtonAction2D(button, 0);
        } else {
            throw new IllegalArgumentException("\nButtonAction2D must be Rotation, Translation, Scale or None");
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setButtonAction2D(int button, int action) {
        if (action == 10 || action == 8 || action == 9 || action == 0) ** GOTO lbl5
        throw new IllegalArgumentException("\naction must be ROTATION, TRANSLATION, SCALE, or NONE");
lbl-1000:
        // 1 sources

        {
            this.buttonActions2D.add(null);
lbl5:
            // 2 sources

            ** while (button >= this.buttonActions2D.size())
        }
lbl6:
        // 1 sources

        this.buttonActions2D.set(button, new Integer(action));
    }

    public int getButtonAction2D(int button) {
        if (button >= this.buttonActions2D.size()) {
            return 0;
        }
        Integer i = (Integer)this.buttonActions2D.get(button);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void ReadAction6D(Object[] action) {
        if (action.length != 1 || !(action[0] instanceof String)) {
            throw new IllegalArgumentException("\nReadAction6D must be a String");
        }
        String actionString = (String)action[0];
        if (actionString.equals("Echo")) {
            this.setReadAction6D(22);
        } else if (actionString.equals("None")) {
            this.setReadAction6D(0);
        } else {
            throw new IllegalArgumentException("\nReadAction6D must be Echo or None");
        }
    }

    public void setReadAction6D(int action) {
        if (action != 22 && action != 0) {
            throw new IllegalArgumentException("\naction must be ECHO or NONE");
        }
        this.readAction6D = action;
    }

    public int getReadAction6D() {
        if (this.readAction6D == -1) {
            return 0;
        }
        return this.readAction6D;
    }

    public void TranslationSpeed(Object[] speed) {
        int timeBase;
        int units;
        if (!(speed.length == 3 && speed[0] instanceof Double && speed[1] instanceof String && speed[2] instanceof String)) {
            throw new IllegalArgumentException("\nTranslationSpeed must be number, units, and time base");
        }
        double v = (Double)speed[0];
        String unitsString = (String)speed[1];
        String timeBaseString = (String)speed[2];
        if (unitsString.equals("PhysicalMeters")) {
            units = 14;
        } else if (unitsString.equals("VirtualUnits")) {
            units = 13;
        } else {
            throw new IllegalArgumentException("\nTranslationSpeed units must be PhysicalMeters or VirtualUnits");
        }
        if (timeBaseString.equals("PerFrame")) {
            timeBase = 11;
        } else if (timeBaseString.equals("PerSecond")) {
            timeBase = 12;
        } else {
            throw new IllegalArgumentException("\ntime base must be PerFrame or PerSecond");
        }
        this.setTranslationSpeed(v, units, timeBase);
    }

    public void setTranslationSpeed(double speed, int units, int timeBase) {
        this.translationSpeed = speed;
        if (units != 14 && units != 13) {
            throw new IllegalArgumentException("\ntranslation speed units must be PHYSICAL_METERS or VIRTUAL_UNITS");
        }
        this.translationUnits = units;
        if (timeBase != 11 && timeBase != 12) {
            throw new IllegalArgumentException("\ntranslation time base must be PER_FRAME or PER_SECOND");
        }
        this.translationTimeBase = timeBase;
    }

    public double getTranslationSpeed() {
        return this.translationSpeed;
    }

    public int getTranslationUnits() {
        return this.translationUnits;
    }

    public int getTranslationTimeBase() {
        return this.translationTimeBase;
    }

    public void AccelerationTime(Object[] time) {
        if (time.length != 1 || !(time[0] instanceof Double)) {
            throw new IllegalArgumentException("\nAccelerationTime must be a number");
        }
        this.setAccelerationTime((Double)time[0]);
    }

    public void setAccelerationTime(double time) {
        this.accelerationTime = time;
    }

    public double getAccelerationTime() {
        return this.accelerationTime;
    }

    public void ConstantSpeedTime(Object[] time) {
        if (time.length != 1 || !(time[0] instanceof Double)) {
            throw new IllegalArgumentException("\nConstantSpeedTime must be a number");
        }
        this.setConstantSpeedTime((Double)time[0]);
    }

    public void setConstantSpeedTime(double time) {
        this.constantSpeedTime = time;
    }

    public double getConstantSpeedTime() {
        return this.constantSpeedTime;
    }

    public void FastSpeedFactor(Object[] factor) {
        if (factor.length != 1 || !(factor[0] instanceof Double)) {
            throw new IllegalArgumentException("\nFastSpeedFactor must be a number");
        }
        this.setFastSpeedFactor((Double)factor[0]);
    }

    public void setFastSpeedFactor(double factor) {
        this.fastSpeedFactor = factor;
    }

    public double getFastSpeedFactor() {
        return this.fastSpeedFactor;
    }

    public void Threshold2D(Object[] threshold) {
        if (threshold.length != 1 || !(threshold[0] instanceof Double)) {
            throw new IllegalArgumentException("\nThreshold2D must be a number");
        }
        this.setThreshold2D((Double)threshold[0]);
    }

    public void setThreshold2D(double threshold) {
        this.threshold2D = threshold;
    }

    public double getThreshold2D() {
        return this.threshold2D;
    }

    public void MatrixIndices2D(Object[] indices) {
        if (indices.length != 2 || !(indices[0] instanceof Double) || !(indices[1] instanceof Double)) {
            throw new IllegalArgumentException("\nMatrixIndices2D must be a numbers");
        }
        this.setMatrixIndices2D(((Double)indices[0]).intValue(), ((Double)indices[1]).intValue());
    }

    public void setMatrixIndices2D(int xIndex, int yIndex) {
        this.x2D = xIndex;
        this.y2D = yIndex;
    }

    public int getMatrixXIndex2D() {
        return this.x2D;
    }

    public int getMatrixYIndex2D() {
        return this.y2D;
    }

    public void RotationSpeed(Object[] speed) {
        int timeBase;
        int units;
        if (!(speed.length == 3 && speed[0] instanceof Double && speed[1] instanceof String && speed[2] instanceof String)) {
            throw new IllegalArgumentException("\nRotationSpeed must be number, units, and time base");
        }
        double v = (Double)speed[0];
        String unitsString = (String)speed[1];
        String timeBaseString = (String)speed[2];
        if (unitsString.equals("Degrees")) {
            units = 16;
        } else if (unitsString.equals("Radians")) {
            units = 15;
        } else {
            throw new IllegalArgumentException("\nRotationSpeed units must be Degrees or Radians");
        }
        if (timeBaseString.equals("PerFrame")) {
            timeBase = 11;
        } else if (timeBaseString.equals("PerSecond")) {
            timeBase = 12;
        } else {
            throw new IllegalArgumentException("\nRotationSpeed time base must be PerFrame or PerSecond");
        }
        this.setRotationSpeed(v, units, timeBase);
    }

    public void setRotationSpeed(double speed, int units, int timeBase) {
        this.rotationSpeed = speed;
        if (units != 16 && units != 15) {
            throw new IllegalArgumentException("\nrotation speed units must be DEGREES or RADIANS");
        }
        this.rotationUnits = units;
        if (timeBase != 11 && timeBase != 12) {
            throw new IllegalArgumentException("\nrotation time base must be PER_FRAME or PER_SECOND");
        }
        this.rotationTimeBase = timeBase;
    }

    public double getRotationSpeed() {
        return this.rotationSpeed;
    }

    public int getRotationUnits() {
        return this.rotationUnits;
    }

    public int getRotationTimeBase() {
        return this.rotationTimeBase;
    }

    public void RotationCoords(Object[] coords) {
        if (coords.length != 1 || !(coords[0] instanceof String)) {
            throw new IllegalArgumentException("\nRotationCoords must be a String");
        }
        String coordsString = (String)coords[0];
        if (coordsString.equals("Sensor")) {
            this.setRotationCoords(19);
        } else if (coordsString.equals("ViewPlatform")) {
            this.setRotationCoords(17);
        } else if (coordsString.equals("Head")) {
            this.setRotationCoords(18);
        } else {
            throw new IllegalArgumentException("\nRotationCoords must be Sensor, ViewPlatform, or Head");
        }
    }

    public void setRotationCoords(int coords) {
        if (coords != 19 && coords != 17 && coords != 18) {
            throw new IllegalArgumentException("\nrotation coordinates be SENSOR, VIEW_PLATFORM, or HEAD");
        }
        this.rotationCoords = coords;
    }

    public int getRotationCoords() {
        return this.rotationCoords;
    }

    public void ScaleSpeed(Object[] speed) {
        int timeBase;
        if (speed.length != 2 || !(speed[0] instanceof Double) || !(speed[1] instanceof String)) {
            throw new IllegalArgumentException("\nScalingSpeed must be a number and a string");
        }
        double v = (Double)speed[0];
        String timeBaseString = (String)speed[2];
        if (timeBaseString.equals("PerFrame")) {
            timeBase = 11;
        } else if (timeBaseString.equals("PerSecond")) {
            timeBase = 12;
        } else {
            throw new IllegalArgumentException("\nScalingSpeed time base must be PerFrame or PerSecond");
        }
        this.setScaleSpeed(v, timeBase);
    }

    public void setScaleSpeed(double speed, int timeBase) {
        this.scaleSpeed = speed;
        if (timeBase != 11 && timeBase != 12) {
            throw new IllegalArgumentException("\nscaling time base must be PER_FRAME or PER_SECOND");
        }
        this.scaleTimeBase = timeBase;
    }

    public double getScaleSpeed() {
        return this.scaleSpeed;
    }

    public int getScaleTimeBase() {
        return this.scaleTimeBase;
    }

    public void TransformCenterSource(Object[] source) {
        if (source.length != 1 || !(source[0] instanceof String)) {
            throw new IllegalArgumentException("\nTransformCenterSource must be a String");
        }
        String sourceString = (String)source[0];
        if (sourceString.equals("Hotspot")) {
            this.setTransformCenterSource(21);
        } else if (sourceString.equals("VworldFixed")) {
            this.setTransformCenterSource(20);
        } else {
            throw new IllegalArgumentException("\nTransformCenterSource must be Hotspot or VworldFixed");
        }
    }

    public void setTransformCenterSource(int source) {
        if (source != 21 && source != 20) {
            throw new IllegalArgumentException("\nrotation/scale center source must be HOTSPOT or VWORLD_FIXED");
        }
        this.transformCenterSource = source;
    }

    public int getTransformCenterSource() {
        return this.transformCenterSource;
    }

    public void TransformCenter(Object[] center) {
        if (center.length != 1 || !(center[0] instanceof Point3d)) {
            throw new IllegalArgumentException("\nTransformCenter must be a Point3d");
        }
        this.setTransformCenter((Point3d)center[0]);
    }

    public void setTransformCenter(Point3d center) {
        this.transformCenter.set((Tuple3d)center);
    }

    public void getTransformCenter(Point3d center) {
        center.set((Tuple3d)this.transformCenter);
    }

    public void NominalSensorRotation(Object[] matrix) {
        if (matrix.length != 1 || !(matrix[0] instanceof Matrix3d) && !(matrix[0] instanceof Matrix4d)) {
            throw new IllegalArgumentException("\nNominalSensorRotation must be a Matrix3d or Matrix4d");
        }
        Transform3D t3d = new Transform3D();
        if (matrix[0] instanceof Matrix3d) {
            t3d.set((Matrix3d)matrix[0]);
        } else {
            t3d.set((Matrix4d)matrix[0]);
        }
        this.setNominalSensorRotation(t3d);
    }

    public void setNominalSensorRotation(Transform3D transform) {
        if (transform == null) {
            this.nominalSensorRotation = null;
            return;
        }
        if (this.nominalSensorRotation == null) {
            this.nominalSensorRotation = new Transform3D();
        }
        this.nominalSensorRotation.set(transform);
        this.nominalSensorRotation.setTranslation(new Vector3d());
    }

    public void getNominalSensorRotation(Transform3D t3d) {
        if (this.nominalSensorRotation != null) {
            t3d.set(this.nominalSensorRotation);
        } else {
            t3d.setIdentity();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ResetViewButtonCount6D(Object[] count) {
        if (count.length != 1 || !(count[0] instanceof Double) && !(count[0] instanceof String)) {
            throw new IllegalArgumentException("\nResetViewButtonCount6D must be a number or None");
        }
        if (count[0] instanceof String) {
            String s = (String)count[0];
            if (!s.equals("None")) throw new IllegalArgumentException("\nResetViewButtonCount6D string value must be None");
            this.setResetViewButtonCount6D(0);
            return;
        } else {
            this.setResetViewButtonCount6D(((Double)count[0]).intValue());
        }
    }

    public void setResetViewButtonCount6D(int count) {
        if (count != 0 && count <= 1) {
            throw new IllegalArgumentException("reset view button count must be > 1");
        }
        this.resetViewButtonCount6D = count;
    }

    public int getResetViewButtonCount6D() {
        return this.resetViewButtonCount6D;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ResetViewButtonCount2D(Object[] count) {
        if (count.length != 1 || !(count[0] instanceof Double) && !(count[0] instanceof String)) {
            throw new IllegalArgumentException("\nResetViewButtonCount2D must be a number or None");
        }
        if (count[0] instanceof String) {
            String s = (String)count[0];
            if (!s.equals("None")) throw new IllegalArgumentException("\nResetViewButtonCount2D string value must be None");
            this.setResetViewButtonCount2D(0);
            return;
        } else {
            this.setResetViewButtonCount2D(((Double)count[0]).intValue());
        }
    }

    public void setResetViewButtonCount2D(int count) {
        if (count != 0 && count <= 1) {
            throw new IllegalArgumentException("reset view button count must be > 1");
        }
        this.resetViewButtonCount2D = count;
    }

    public int getResetViewButtonCount2D() {
        return this.resetViewButtonCount2D;
    }

    public void EchoType(Object[] type) {
        if (type.length != 1 || !(type[0] instanceof String)) {
            throw new IllegalArgumentException("\nEchoType must be a String");
        }
        String typeString = (String)type[0];
        if (typeString.equals("Gnomon")) {
            this.setEchoType(23);
        } else if (typeString.equals("Beam")) {
            this.setEchoType(24);
        } else if (typeString.equals("None")) {
            this.setEchoType(0);
        } else {
            throw new IllegalArgumentException("\nEchoType must be Gnomon, Beam, or None");
        }
    }

    public void setEchoType(int type) {
        this.echoType = type;
    }

    public int getEchoType() {
        return this.echoType;
    }

    public void EchoSize(Object[] echoSize) {
        if (echoSize.length != 1 || !(echoSize[0] instanceof Double)) {
            throw new IllegalArgumentException("\nEchoSize must be a Double");
        }
        this.setEchoSize((Double)echoSize[0]);
    }

    public void setEchoSize(double echoSize) {
        this.echoSize = echoSize;
    }

    public double getEchoSize() {
        return this.echoSize;
    }

    public void EchoColor(Object[] color) {
        if (!(color.length == 3 && color[0] instanceof Double && color[1] instanceof Double && color[2] instanceof Double)) {
            throw new IllegalArgumentException("\nEchoColor must be 3 numbers for red, green, and blue");
        }
        this.setEchoColor(new Color3f(((Double)color[0]).floatValue(), ((Double)color[1]).floatValue(), ((Double)color[2]).floatValue()));
    }

    public void setEchoColor(Color3f color) {
        if (this.echoColor == null) {
            this.echoColor = new Color3f(color);
        } else {
            this.echoColor.set((Tuple3f)color);
        }
        if (this.echoGeometry != null) {
            Appearance a = this.echoGeometry.getAppearance();
            Material m = a.getMaterial();
            m.setDiffuseColor(this.echoColor);
        }
    }

    public void getEchoColor(Color3f color) {
        if (this.echoColor == null) {
            color.set(1.0f, 1.0f, 1.0f);
        } else {
            color.set((Tuple3f)this.echoColor);
        }
    }

    public void EchoTransparency(Object[] transparency) {
        if (transparency.length != 1 || !(transparency[0] instanceof Double)) {
            throw new IllegalArgumentException("\nEchoTransparency must be a number");
        }
        this.setEchoTransparency(((Double)transparency[0]).floatValue());
    }

    public void setEchoTransparency(float transparency) {
        this.echoTransparency = transparency;
        if (this.echoGeometry != null) {
            Appearance a = this.echoGeometry.getAppearance();
            TransparencyAttributes ta = a.getTransparencyAttributes();
            if (this.echoTransparency == 0.0f) {
                ta.setTransparencyMode(4);
                ta.setTransparency(0.0f);
            } else {
                ta.setTransparencyMode(2);
                ta.setTransparency(this.echoTransparency);
                if (this.echoGeometry instanceof SensorGnomonEcho) {
                    ta.setDstBlendFunction(1);
                }
            }
        }
    }

    public float getEchoTransparency() {
        return this.echoTransparency;
    }

    public void setEchoTransformGroup(TransformGroup echo) {
        echo.setCapability(18);
        echo.setCapability(12);
        echo.setCapability(13);
        echo.setCapability(14);
        this.echoTransformGroup = echo;
    }

    public TransformGroup getEchoTransformGroup() {
        return this.echoTransformGroup;
    }

    public Shape3D getEchoGeometry() {
        return this.echoGeometry;
    }

    public SensorEventAgent getSensorEventAgent() {
        return this.eventAgent;
    }

    public class EchoReadListener6D
    implements SensorReadListener {
        private Transform3D sensorToVworld = new Transform3D();

        @Override
        public void read(SensorEvent e) {
            Sensor s = e.getSensor();
            WandViewBehavior.this.view.getSensorToVworld(s, this.sensorToVworld);
            WandViewBehavior.this.updateEcho(s, this.sensorToVworld);
        }
    }

    public class GrabViewListener6D
    extends ListenerBase {
        private Transform3D t3d;
        private Transform3D initialVworldToSensor;

        public GrabViewListener6D() {
            this.t3d = new Transform3D();
            this.initialVworldToSensor = new Transform3D();
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(e.getSensor());
            this.initialVworldToSensor.invert(this.sensorToVworld);
        }

        @Override
        public void dragged(SensorEvent e) {
            Sensor s = e.getSensor();
            s.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            this.t3d.mul(this.sensorToVworld, this.initialVworldToSensor);
            this.t3d.invert();
            this.t3d.mul(this.viewPlatformToVworld);
            WandViewBehavior.this.targetTG.setTransform(this.t3d);
        }
    }

    public class ListenerBase
    extends SensorInputAdaptor {
        protected Transform3D viewPlatformToVworld = new Transform3D();
        protected Transform3D trackerToVworld = new Transform3D();
        protected Transform3D sensorToVworld = new Transform3D();
        protected Transform3D sensorToTracker = new Transform3D();
        private Transform3D trackerToSensor = new Transform3D();
        private boolean active = false;
        private double[] s3Tmp = new double[3];
        private double[] m16Tmp = new double[16];
        private Vector3d v3dTmp = new Vector3d();
        private Transform3D t3dTmp = new Transform3D();

        protected void initAction(Sensor s) {
            WandViewBehavior.this.targetTG.getTransform(this.viewPlatformToVworld);
            this.active = true;
            if (s == null) {
                return;
            }
            s.getRead(this.sensorToTracker);
            WandViewBehavior.this.view.getSensorToVworld(s, this.sensorToVworld);
            this.trackerToSensor.invert(this.sensorToTracker);
            this.trackerToVworld.mul(this.sensorToVworld, this.trackerToSensor);
        }

        protected void endAction(Sensor s) {
            this.active = false;
        }

        protected boolean isActive() {
            return this.active;
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(e.getSensor());
        }

        @Override
        public void released(SensorEvent e) {
            this.endAction(e.getSensor());
        }

        protected double getPhysicalToVirtualScale() {
            WandViewBehavior.this.view.getCanvas3D(0).getImagePlateToVworld(this.t3dTmp);
            this.t3dTmp.get(this.m16Tmp);
            return Math.sqrt(this.m16Tmp[0] * this.m16Tmp[0] + this.m16Tmp[1] * this.m16Tmp[1] + this.m16Tmp[2] * this.m16Tmp[2]);
        }

        protected double getPhysicalToViewPlatformScale() {
            WandViewBehavior.this.targetTG.getTransform(this.t3dTmp);
            this.t3dTmp.get(this.m16Tmp);
            double vpToVirtualScale = Math.sqrt(this.m16Tmp[0] * this.m16Tmp[0] + this.m16Tmp[1] * this.m16Tmp[1] + this.m16Tmp[2] * this.m16Tmp[2]);
            return this.getPhysicalToVirtualScale() / vpToVirtualScale;
        }

        protected void translateTransform(Transform3D transform, Vector3d translation) {
            transform.get(this.v3dTmp);
            this.v3dTmp.add((Tuple3d)translation);
            transform.setTranslation(this.v3dTmp);
        }

        protected void transformAboutCenter(Transform3D target, Point3d center, Transform3D transform) {
            target.get(this.v3dTmp);
            this.v3dTmp.sub((Tuple3d)center);
            target.setTranslation(this.v3dTmp);
            target.mul(transform, target);
            target.get(this.v3dTmp);
            this.v3dTmp.add((Tuple3d)center);
            target.setTranslation(this.v3dTmp);
        }

        protected void conditionViewScale(Transform3D viewPlatformToVworld) {
            viewPlatformToVworld.normalize();
            viewPlatformToVworld.get(this.m16Tmp);
            this.s3Tmp[0] = this.m16Tmp[0] * this.m16Tmp[0] + this.m16Tmp[4] * this.m16Tmp[4] + this.m16Tmp[8] * this.m16Tmp[8];
            this.s3Tmp[1] = this.m16Tmp[1] * this.m16Tmp[1] + this.m16Tmp[5] * this.m16Tmp[5] + this.m16Tmp[9] * this.m16Tmp[9];
            this.s3Tmp[2] = this.m16Tmp[2] * this.m16Tmp[2] + this.m16Tmp[6] * this.m16Tmp[6] + this.m16Tmp[10] * this.m16Tmp[10];
            if (this.s3Tmp[0] == this.s3Tmp[1] && this.s3Tmp[0] == this.s3Tmp[2]) {
                return;
            }
            this.s3Tmp[0] = Math.sqrt(this.s3Tmp[0]);
            this.s3Tmp[1] = Math.sqrt(this.s3Tmp[1]);
            this.s3Tmp[2] = Math.sqrt(this.s3Tmp[2]);
            int closestToOne = 0;
            if (Math.abs(this.s3Tmp[1] - 1.0) < Math.abs(this.s3Tmp[0] - 1.0)) {
                closestToOne = 1;
            }
            if (Math.abs(this.s3Tmp[2] - 1.0) < Math.abs(this.s3Tmp[closestToOne] - 1.0)) {
                closestToOne = 2;
            }
            int i = 0;
            while (i < 3) {
                if (i != closestToOne) {
                    double scale = this.s3Tmp[closestToOne] / this.s3Tmp[i];
                    int n = i + 0;
                    this.m16Tmp[n] = this.m16Tmp[n] * scale;
                    int n2 = i + 4;
                    this.m16Tmp[n2] = this.m16Tmp[n2] * scale;
                    int n3 = i + 8;
                    this.m16Tmp[n3] = this.m16Tmp[n3] * scale;
                }
                ++i;
            }
            viewPlatformToVworld.set(this.m16Tmp);
            if ((viewPlatformToVworld.getType() & 0x40) == 0) {
                WandViewBehavior.this.goHome();
            } else {
                WandViewBehavior.this.targetTG.setTransform(viewPlatformToVworld);
            }
        }
    }

    public class ResetViewListener
    extends SensorInputAdaptor {
        private int resetCount;
        private int[] buttonState = null;
        private boolean goHomeNextRead = false;

        public ResetViewListener(Sensor s, int count) {
            this.resetCount = count;
            this.buttonState = new int[s.getSensorButtonCount()];
        }

        @Override
        public void pressed(SensorEvent e) {
            int count = 0;
            e.getButtonState(this.buttonState);
            int i = 0;
            while (i < this.buttonState.length) {
                if (this.buttonState[i] == 1) {
                    ++count;
                }
                ++i;
            }
            if (count >= this.resetCount) {
                this.goHomeNextRead = true;
            }
        }

        @Override
        public void read(SensorEvent e) {
            if (this.goHomeNextRead) {
                WandViewBehavior.this.goHome();
                this.goHomeNextRead = false;
            }
        }
    }

    public class RotationListener2D
    extends ListenerBase {
        private Sensor sensor2D;
        private Sensor sensor6D;
        private double[] m = new double[16];
        private Vector3d axis = new Vector3d();
        private Point3d center = new Point3d();
        private Transform3D t3d = new Transform3D();
        private AxisAngle4d aa4d = new AxisAngle4d();
        private Transform3D sensor2DRead = new Transform3D();
        private Transform3D headToVworld = new Transform3D();
        private double speedScaled;

        @Override
        protected void initAction(Sensor s) {
            super.initAction(s);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(true);
            }
            if (s != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.removeSensorReadListener(s, WandViewBehavior.this.echoReadListener6D);
            }
        }

        @Override
        protected void endAction(Sensor s) {
            super.endAction(s);
            this.viewPlatformToVworld.normalize();
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(false);
            }
            if (s != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.addSensorReadListener(s, WandViewBehavior.this.echoReadListener6D);
            }
        }

        public RotationListener2D(Sensor sensor2D, Sensor sensor6D) {
            this.sensor2D = sensor2D;
            this.sensor6D = sensor6D;
            this.speedScaled = WandViewBehavior.this.rotationUnits == 16 ? WandViewBehavior.this.rotationSpeed * Math.PI / 180.0 : WandViewBehavior.this.rotationSpeed;
        }

        @Override
        public void read(SensorEvent e) {
            this.sensor2D.getRead(this.sensor2DRead);
            this.sensor2DRead.get(this.m);
            if (this.m[WandViewBehavior.this.x2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.x2D] < -WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] < -WandViewBehavior.this.threshold2D) {
                if (!this.isActive()) {
                    this.initAction(this.sensor6D);
                }
                double length = Math.sqrt(this.m[WandViewBehavior.this.x2D] * this.m[WandViewBehavior.this.x2D] + this.m[WandViewBehavior.this.y2D] * this.m[WandViewBehavior.this.y2D]);
                double iLength = 1.0 / length;
                this.axis.set(this.m[WandViewBehavior.this.y2D] * iLength, -this.m[WandViewBehavior.this.x2D] * iLength, 0.0);
                if (this.sensor6D != null) {
                    this.sensor6D.getRead(this.sensorToTracker);
                    this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
                }
                if (this.sensor6D != null && WandViewBehavior.this.rotationCoords == 19) {
                    if (WandViewBehavior.this.nominalSensorRotation != null) {
                        WandViewBehavior.this.nominalSensorRotation.transform(this.axis);
                    }
                    this.sensorToVworld.transform(this.axis);
                } else if (WandViewBehavior.this.rotationCoords == 18) {
                    WandViewBehavior.this.view.getUserHeadToVworld(this.headToVworld);
                    this.headToVworld.transform(this.axis);
                } else {
                    this.viewPlatformToVworld.transform(this.axis);
                }
                if (WandViewBehavior.this.transformCenterSource == 21 && this.sensor6D != null) {
                    this.sensor6D.getHotspot(this.center);
                    this.sensorToVworld.transform(this.center);
                } else {
                    this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
                }
                double frameTime = 1.0;
                if (WandViewBehavior.this.rotationTimeBase == 12) {
                    frameTime = (double)(e.getTime() - e.getLastTime()) / 1.0E9;
                }
                this.aa4d.set(this.axis, this.speedScaled * frameTime * length);
                this.t3d.set(this.aa4d);
                this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
                WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
                if (this.sensor6D != null) {
                    this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
                }
                if (this.sensor6D != null && WandViewBehavior.this.readAction6D == 22) {
                    this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                    WandViewBehavior.this.updateEcho(this.sensor6D, this.sensorToVworld);
                }
            } else if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(this.sensor6D);
        }

        @Override
        public void released(SensorEvent e) {
            if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        @Override
        public void dragged(SensorEvent e) {
            this.read(e);
        }
    }

    public class RotationListener6D
    extends ListenerBase {
        private boolean reverse;
        private long buttonDownTime;
        private Vector3d axis = new Vector3d();
        private Point3d center = new Point3d();
        private Transform3D t3d = new Transform3D();
        private AxisAngle4d aa4d = new AxisAngle4d();
        private Transform3D headToVworld = new Transform3D();
        private double speedScaled;

        @Override
        protected void initAction(Sensor s) {
            super.initAction(s);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(true);
            }
        }

        @Override
        protected void endAction(Sensor s) {
            super.endAction(s);
            this.viewPlatformToVworld.normalize();
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(false);
            }
        }

        public RotationListener6D(boolean reverse) {
            this.reverse = reverse;
            this.speedScaled = WandViewBehavior.this.rotationUnits == 16 ? WandViewBehavior.this.rotationSpeed * Math.PI / 180.0 : WandViewBehavior.this.rotationSpeed;
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(e.getSensor());
            this.buttonDownTime = e.getTime();
        }

        @Override
        public void dragged(SensorEvent e) {
            double transTime;
            long time = e.getTime();
            long lastTime = e.getLastTime();
            double frameTime = 1.0;
            if (WandViewBehavior.this.rotationTimeBase == 12) {
                frameTime = (double)(time - lastTime) / 1.0E9;
            }
            double currSpeed = (transTime = (double)(time - this.buttonDownTime) / 1.0E9) <= WandViewBehavior.this.accelerationTime ? transTime / WandViewBehavior.this.accelerationTime * this.speedScaled : this.speedScaled;
            if (this.reverse) {
                this.axis.set(0.0, -1.0, 0.0);
            } else {
                this.axis.set(0.0, 1.0, 0.0);
            }
            Sensor s = e.getSensor();
            s.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            if (WandViewBehavior.this.rotationCoords == 19) {
                if (WandViewBehavior.this.nominalSensorRotation != null) {
                    WandViewBehavior.this.nominalSensorRotation.transform(this.axis);
                }
                this.sensorToVworld.transform(this.axis);
            } else if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.getUserHeadToVworld(this.headToVworld);
                this.headToVworld.transform(this.axis);
            } else {
                this.viewPlatformToVworld.transform(this.axis);
            }
            if (WandViewBehavior.this.transformCenterSource == 21) {
                s.getHotspot(this.center);
                this.sensorToVworld.transform(this.center);
            } else {
                this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
            }
            this.aa4d.set(this.axis, currSpeed * frameTime);
            this.t3d.set(this.aa4d);
            this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
            if (WandViewBehavior.this.readAction6D == 22) {
                this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                WandViewBehavior.this.updateEcho(s, this.sensorToVworld);
            }
        }
    }

    public class ScaleListener2D
    extends ListenerBase {
        private Sensor sensor2D;
        private Sensor sensor6D;
        private double[] m = new double[16];
        private Point3d center = new Point3d();
        private Transform3D t3d = new Transform3D();
        private Transform3D sensor2DRead = new Transform3D();

        @Override
        protected void initAction(Sensor s) {
            super.initAction(s);
            if (s != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.removeSensorReadListener(s, WandViewBehavior.this.echoReadListener6D);
            }
        }

        @Override
        protected void endAction(Sensor s) {
            super.endAction(s);
            this.conditionViewScale(this.viewPlatformToVworld);
            if (s != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.addSensorReadListener(s, WandViewBehavior.this.echoReadListener6D);
            }
        }

        public ScaleListener2D(Sensor sensor2D, Sensor sensor6D) {
            this.sensor2D = sensor2D;
            this.sensor6D = sensor6D;
        }

        @Override
        public void read(SensorEvent e) {
            this.sensor2D.getRead(this.sensor2DRead);
            this.sensor2DRead.get(this.m);
            if (this.m[WandViewBehavior.this.y2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] < -WandViewBehavior.this.threshold2D) {
                if (!this.isActive()) {
                    this.initAction(this.sensor6D);
                }
                if (this.sensor6D != null) {
                    this.sensor6D.getRead(this.sensorToTracker);
                    this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
                }
                if (this.sensor6D != null && WandViewBehavior.this.transformCenterSource == 21) {
                    this.sensor6D.getHotspot(this.center);
                    this.sensorToVworld.transform(this.center);
                } else {
                    this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
                }
                double frameTime = 1.0;
                if (WandViewBehavior.this.scaleTimeBase == 12) {
                    frameTime = (double)(e.getTime() - e.getLastTime()) / 1.0E9;
                }
                double scale = Math.pow(WandViewBehavior.this.scaleSpeed, -this.m[WandViewBehavior.this.y2D] * frameTime);
                this.t3d.set(scale);
                this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
                try {
                    WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
                }
                catch (BadTransformException bt) {
                    this.conditionViewScale(this.viewPlatformToVworld);
                }
                if (this.sensor6D != null) {
                    this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
                }
                if (this.sensor6D != null && WandViewBehavior.this.readAction6D == 22) {
                    this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                    WandViewBehavior.this.updateEcho(this.sensor6D, this.sensorToVworld);
                }
            } else if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(this.sensor6D);
        }

        @Override
        public void released(SensorEvent e) {
            if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        @Override
        public void dragged(SensorEvent e) {
            this.read(e);
        }
    }

    public class ScaleListener6D
    extends ListenerBase {
        private double direction;
        private long buttonDownTime;
        private Point3d center = new Point3d();
        private Transform3D t3d = new Transform3D();

        @Override
        protected void endAction(Sensor s) {
            super.endAction(s);
            this.conditionViewScale(this.viewPlatformToVworld);
        }

        public ScaleListener6D(boolean reverse) {
            this.direction = reverse ? -1.0 : 1.0;
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(e.getSensor());
            this.buttonDownTime = e.getTime();
        }

        @Override
        public void dragged(SensorEvent e) {
            double transTime;
            long time = e.getTime();
            long lastTime = e.getLastTime();
            double frameTime = 1.0;
            if (WandViewBehavior.this.scaleTimeBase == 12) {
                frameTime = (double)(time - lastTime) / 1.0E9;
            }
            double exp = (transTime = (double)(time - this.buttonDownTime) / 1.0E9) <= WandViewBehavior.this.accelerationTime ? transTime / WandViewBehavior.this.accelerationTime * frameTime * this.direction : frameTime * this.direction;
            double scale = Math.pow(WandViewBehavior.this.scaleSpeed, exp);
            Sensor s = e.getSensor();
            s.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            if (WandViewBehavior.this.transformCenterSource == 21) {
                s.getHotspot(this.center);
                this.sensorToVworld.transform(this.center);
            } else {
                this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
            }
            this.t3d.set(scale);
            this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
            try {
                WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            }
            catch (BadTransformException bt) {
                this.conditionViewScale(this.viewPlatformToVworld);
            }
            this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
            if (WandViewBehavior.this.readAction6D == 22) {
                this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                WandViewBehavior.this.updateEcho(s, this.sensorToVworld);
            }
        }
    }

    public class TranslationListener2D
    extends ListenerBase {
        private Sensor sensor2D;
        private Sensor sensor6D;
        private double[] m = new double[16];
        private Vector3d v3d = new Vector3d();
        private Transform3D sensor2DRead = new Transform3D();
        private double speedScaled;

        @Override
        protected void initAction(Sensor s) {
            super.initAction(s);
            if (s != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.removeSensorReadListener(s, WandViewBehavior.this.echoReadListener6D);
            }
        }

        @Override
        protected void endAction(Sensor s) {
            super.endAction(s);
            if (s != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.addSensorReadListener(s, WandViewBehavior.this.echoReadListener6D);
            }
        }

        public TranslationListener2D(Sensor sensor2D, Sensor sensor6D) {
            this.sensor2D = sensor2D;
            this.sensor6D = sensor6D;
            this.speedScaled = WandViewBehavior.this.translationUnits == 13 ? WandViewBehavior.this.translationSpeed * WandViewBehavior.this.fastSpeedFactor / this.getPhysicalToVirtualScale() : WandViewBehavior.this.translationSpeed * WandViewBehavior.this.fastSpeedFactor;
            if (sensor6D == null) {
                this.speedScaled *= this.getPhysicalToViewPlatformScale();
            }
        }

        @Override
        public void read(SensorEvent e) {
            this.sensor2D.getRead(this.sensor2DRead);
            this.sensor2DRead.get(this.m);
            if (this.m[WandViewBehavior.this.x2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.x2D] < -WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] < -WandViewBehavior.this.threshold2D) {
                if (!this.isActive()) {
                    this.initAction(this.sensor6D);
                }
                double length = Math.sqrt(this.m[WandViewBehavior.this.x2D] * this.m[WandViewBehavior.this.x2D] + this.m[WandViewBehavior.this.y2D] * this.m[WandViewBehavior.this.y2D]);
                double iLength = 1.0 / length;
                this.v3d.set(this.m[WandViewBehavior.this.x2D] * iLength, 0.0, -this.m[WandViewBehavior.this.y2D] * iLength);
                if (this.sensor6D != null) {
                    if (WandViewBehavior.this.nominalSensorRotation != null) {
                        WandViewBehavior.this.nominalSensorRotation.transform(this.v3d);
                    }
                    this.sensor6D.getRead(this.sensorToTracker);
                    this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
                    this.sensorToVworld.transform(this.v3d);
                } else {
                    this.viewPlatformToVworld.transform(this.v3d);
                }
                double frameTime = 1.0;
                if (WandViewBehavior.this.translationTimeBase == 12) {
                    frameTime = (double)(e.getTime() - e.getLastTime()) / 1.0E9;
                }
                this.v3d.scale(frameTime * this.speedScaled * length);
                this.translateTransform(this.viewPlatformToVworld, this.v3d);
                WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
                if (this.sensor6D != null) {
                    this.translateTransform(this.trackerToVworld, this.v3d);
                }
                if (this.sensor6D != null && WandViewBehavior.this.readAction6D == 22) {
                    this.translateTransform(this.sensorToVworld, this.v3d);
                    WandViewBehavior.this.updateEcho(this.sensor6D, this.sensorToVworld);
                }
            } else if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(this.sensor6D);
        }

        @Override
        public void released(SensorEvent e) {
            if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        @Override
        public void dragged(SensorEvent e) {
            this.read(e);
        }
    }

    public class TranslationListener6D
    extends ListenerBase {
        private long buttonDownTime;
        private double speedScaled;
        private double interval0;
        private double interval1;
        private double interval2;
        private Vector3d v3d = new Vector3d();

        public TranslationListener6D(boolean reverse) {
            this.interval0 = WandViewBehavior.this.accelerationTime;
            this.interval1 = this.interval0 + WandViewBehavior.this.constantSpeedTime;
            this.interval2 = this.interval1 + WandViewBehavior.this.accelerationTime;
            this.speedScaled = WandViewBehavior.this.translationUnits == 13 ? WandViewBehavior.this.translationSpeed / this.getPhysicalToVirtualScale() : WandViewBehavior.this.translationSpeed;
            if (reverse) {
                this.speedScaled = -this.speedScaled;
            }
        }

        @Override
        public void pressed(SensorEvent e) {
            this.initAction(e.getSensor());
            this.buttonDownTime = e.getTime();
        }

        @Override
        public void dragged(SensorEvent e) {
            double transTime;
            long time = e.getTime();
            long lastTime = e.getLastTime();
            double frameTime = 1.0;
            if (WandViewBehavior.this.translationTimeBase == 12) {
                frameTime = (double)(time - lastTime) / 1.0E9;
            }
            double currSpeed = (transTime = (double)(time - this.buttonDownTime) / 1.0E9) <= this.interval0 ? transTime / WandViewBehavior.this.accelerationTime * this.speedScaled : (transTime > this.interval1 && transTime < this.interval2 ? ((transTime - this.interval1) / WandViewBehavior.this.accelerationTime * (WandViewBehavior.this.fastSpeedFactor - 1.0) + 1.0) * this.speedScaled : (transTime >= this.interval2 ? WandViewBehavior.this.fastSpeedFactor * this.speedScaled : this.speedScaled));
            this.v3d.set(0.0, 0.0, -1.0);
            if (WandViewBehavior.this.nominalSensorRotation != null) {
                WandViewBehavior.this.nominalSensorRotation.transform(this.v3d);
            }
            Sensor s = e.getSensor();
            s.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            this.sensorToVworld.transform(this.v3d);
            this.v3d.scale(frameTime * currSpeed);
            this.translateTransform(this.viewPlatformToVworld, this.v3d);
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            this.translateTransform(this.trackerToVworld, this.v3d);
            if (WandViewBehavior.this.readAction6D == 22) {
                this.translateTransform(this.sensorToVworld, this.v3d);
                WandViewBehavior.this.updateEcho(s, this.sensorToVworld);
            }
        }
    }
}

